/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SBorder;
import io.keikai.model.SBorderLine;
import io.keikai.model.SCellStyle;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SName;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.STableColumn;
import io.keikai.model.STableStyle;
import io.keikai.model.STableStyleElem;
import io.keikai.model.STableStyleInfo;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractFillAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.AbstractTableAdv;
import io.keikai.model.impl.AbstractTableColumnAdv;
import io.keikai.model.impl.AbstractTableStyleInfoAdv;
import io.keikai.model.impl.AutoFilterImpl;
import io.keikai.model.impl.BorderImpl;
import io.keikai.model.impl.CellStyleImpl;
import io.keikai.model.impl.LinkedModelObject;
import io.keikai.model.impl.ModelUpdateUtil;
import io.keikai.model.impl.TableColumnImpl;
import io.keikai.range.impl.NotifyChangeHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.zkoss.poi.ss.formula.ptg.TablePtg;

public class TableImpl
extends AbstractTableAdv
implements LinkedModelObject {
    private static final long serialVersionUID = 1L;
    AbstractBookAdv _book;
    SAutoFilter _filter;
    List<STableColumn> _columns;
    STableStyleInfo _tableStyleInfo;
    int _totalsRowCount;
    int _headerRowCount;
    SheetRegion _region;
    String _name;
    String _displayName;

    public TableImpl(AbstractBookAdv book, String name, String displayName, SheetRegion region, int headerRowCount, int totalsRowCount, STableStyleInfo info) {
        this._book = book;
        this._name = name;
        this._displayName = displayName;
        this._region = region;
        this._headerRowCount = headerRowCount;
        this._totalsRowCount = totalsRowCount;
        this._tableStyleInfo = info;
        this._columns = new ArrayList<STableColumn>();
    }

    @Override
    public SBook getBook() {
        return this._book;
    }

    @Override
    public List<STableColumn> getColumns() {
        return this._columns;
    }

    @Override
    public void addColumn(STableColumn column) {
        this._columns.add(column);
    }

    @Override
    public STableStyleInfo getTableStyleInfo() {
        return this._tableStyleInfo;
    }

    public void setTableStyle(STableStyleInfo style) {
        this._tableStyleInfo = style;
    }

    @Override
    public int getTotalsRowCount() {
        return this._totalsRowCount;
    }

    @Override
    public int getHeaderRowCount() {
        return this._headerRowCount;
    }

    @Override
    public SheetRegion getAllRegion() {
        return this._region;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setTotalsRowCount(int count) {
        if (this._totalsRowCount == count) {
            return;
        }
        int l = this._region.getColumn();
        int t = this._region.getRow();
        int r = this._region.getLastColumn();
        int b = this._region.getLastRow();
        this._region = new SheetRegion(this._region.getSheet(), new CellRegion(t, l, b + this._totalsRowCount - count, r));
        this._totalsRowCount = count;
    }

    @Override
    public void setHeaderRowCount(int count) {
        if (this._headerRowCount == count) {
            return;
        }
        int l = this._region.getColumn();
        int t = this._region.getRow();
        int r = this._region.getLastColumn();
        int b = this._region.getLastRow();
        if (count == 0) {
            this._filter = null;
        } else {
            int tc = this.getTotalsRowCount();
            this._filter = new AutoFilterImpl(new CellRegion(t + this._headerRowCount - count, l, b - tc, r));
        }
        this._region = new SheetRegion(this._region.getSheet(), new CellRegion(t + this._headerRowCount - count, l, b, r));
        this._headerRowCount = count;
    }

    @Override
    public void setName(String newname) {
        this.checkOrphan();
        this._name = newname;
    }

    @Override
    public String getDisplayName() {
        return this._displayName;
    }

    @Override
    public void setDisplayName(String name) {
        this._displayName = name;
    }

    @Override
    public SheetRegion getDataRegion() {
        int l = this._region.getColumn();
        int t = this._region.getRow();
        int r = this._region.getLastColumn();
        int b = this._region.getLastRow();
        return new SheetRegion(this._region.getSheet(), new CellRegion(t + this._headerRowCount, l, b - this._totalsRowCount, r));
    }

    @Override
    public SheetRegion getColumnsRegion(String columnName1, String columnName2) {
        if (columnName1 == null) {
            if (columnName2 == null) {
                return null;
            }
            columnName1 = columnName2;
            columnName2 = null;
        }
        int c1 = -1;
        int c2 = -1;
        int l = this._region.getColumn();
        SSheet sheet = this._region.getSheet();
        for (STableColumn tbCol : this._columns) {
            if (columnName1.equalsIgnoreCase(tbCol.getName())) {
                c1 = l;
                if (columnName2 == null || c2 >= 0) break;
            }
            if (tbCol.getName().equalsIgnoreCase(columnName2)) {
                c2 = l;
                if (c1 >= 0) break;
            }
            ++l;
        }
        if (c1 < 0 || columnName2 != null && c2 < 0) {
            return null;
        }
        if (c2 < 0) {
            c2 = c1;
        }
        int t = this._region.getRow();
        int b = this._region.getLastRow();
        if (c2 < c1) {
            int tmp = c1;
            c1 = c2;
            c2 = tmp;
        }
        return new SheetRegion(sheet, new CellRegion(t + this._headerRowCount, c1, b - this._totalsRowCount, c2));
    }

    @Override
    public SheetRegion getHeadersRegion() {
        if (this._headerRowCount == 0) {
            return null;
        }
        int l = this._region.getColumn();
        int t = this._region.getRow();
        int r = this._region.getLastColumn();
        return new SheetRegion(this._region.getSheet(), new CellRegion(t, l, t, r));
    }

    @Override
    public SheetRegion getTotalsRegion() {
        if (this._totalsRowCount == 0) {
            return null;
        }
        int l = this._region.getColumn();
        int r = this._region.getLastColumn();
        int b = this._region.getLastRow();
        return new SheetRegion(this._region.getSheet(), new CellRegion(b, l, b, r));
    }

    @Override
    public SheetRegion getThisRowRegion(int rowIdx) {
        int t = this._region.getRow() + this._headerRowCount;
        int b = this._region.getLastRow() - this._totalsRowCount;
        if (t > rowIdx || rowIdx > b) {
            throw new IndexOutOfBoundsException("expect rowIdx(" + rowIdx + ") is between " + t + " and " + b);
        }
        int l = this._region.getColumn();
        int r = this._region.getLastColumn();
        return new SheetRegion(this._region.getSheet(), new CellRegion(rowIdx, l, rowIdx, r));
    }

    @Override
    public SheetRegion getItemRegion(TablePtg.Item item, int rowIdx) {
        if (item == null) {
            return null;
        }
        switch (item) {
            case ALL: {
                return this.getAllRegion();
            }
            case DATA: {
                return this.getDataRegion();
            }
            case HEADERS: {
                return this.getHeadersRegion();
            }
            case TOTALS: {
                return this.getTotalsRegion();
            }
            case THIS_ROW: {
                return this.getThisRowRegion(rowIdx);
            }
        }
        return null;
    }

    @Override
    public void destroy() {
        this.checkOrphan();
        this._book = null;
    }

    @Override
    public void checkOrphan() {
        if (this._book == null) {
            throw new IllegalStateException("doesn't connect to parent");
        }
    }

    @Override
    public STableColumn getColumnAt(int colIdx) {
        CellRegion rgn = this._region.getRegion();
        int idx = colIdx - rgn.getColumn();
        return idx < 0 || idx >= this._columns.size() ? null : this._columns.get(idx);
    }

    private boolean isNextTotalsRow(SSheet sheet, int row, int lastRow) {
        if (this.getTotalsRowCount() == 0) {
            return false;
        }
        for (int j = row; j <= lastRow; ++j) {
            if (sheet.getRow(j).isHidden()) continue;
            return lastRow == j;
        }
        return false;
    }

    @Override
    public SCellStyle getCellStyle(int row, int col) {
        STableStyleElem result;
        STableStyleElem result2;
        boolean totalRow;
        CellStylePicker picker = new CellStylePicker();
        CellRegion all = this._region.getRegion();
        STableStyle tbStyle = this._tableStyleInfo.getTableStyle(this._book);
        boolean firstCol = col == all.getColumn();
        boolean lastCol = col == all.getLastColumn();
        boolean firstRow = row == all.getRow();
        boolean lastRow = row == all.getLastRow();
        boolean headerRow = firstRow && this.getHeaderRowCount() > 0;
        boolean bl = totalRow = lastRow && this.getTotalsRowCount() > 0;
        if (totalRow) {
            if (this._tableStyleInfo.isShowLastColumn() && lastCol && picker.pickDataStyle(result2 = tbStyle.getLastTotalCellStyle(), null)) {
                return picker.getCellStyle();
            }
            if (this._tableStyleInfo.isShowFirstColumn() && firstCol && picker.pickDataStyle(result2 = tbStyle.getFirstTotalCellStyle(), null)) {
                return picker.getCellStyle();
            }
            result2 = tbStyle.getTotalRowStyle();
            if (picker.pickDataStyle(result2, null)) {
                return picker.getCellStyle();
            }
        } else if (headerRow) {
            if (this._tableStyleInfo.isShowLastColumn() && lastCol && picker.pickDataStyle(result2 = this._tableStyleInfo.getTableStyle(this._book).getLastHeaderCellStyle(), null)) {
                return picker.getCellStyle();
            }
            if (this._tableStyleInfo.isShowFirstColumn() && firstCol && picker.pickDataStyle(result2 = tbStyle.getFirstHeaderCellStyle(), null)) {
                return picker.getCellStyle();
            }
            result2 = this._tableStyleInfo.getTableStyle(this._book).getHeaderRowStyle();
            if (picker.pickDataStyle(result2, null)) {
                return picker.getCellStyle();
            }
        }
        boolean nextTotalsRow = this.isNextTotalsRow(this._region.getSheet(), row, all.getLastRow() - this.getTotalsRowCount());
        if (this._tableStyleInfo.isShowFirstColumn() && firstCol && picker.pickDataStyle(result = this._tableStyleInfo.getTableStyle(this._book).getFirstColumnStyle(), nextTotalsRow ? tbStyle.getTotalRowStyle() : null)) {
            return picker.getCellStyle();
        }
        if (this._tableStyleInfo.isShowLastColumn() && lastCol && picker.pickDataStyle(result = this._tableStyleInfo.getTableStyle(this._book).getLastColumnStyle(), nextTotalsRow ? tbStyle.getTotalRowStyle() : null)) {
            return picker.getCellStyle();
        }
        if (!headerRow && !totalRow) {
            int rowStripe2Size;
            STableStyle nmTableStyle;
            int rowStripe1Size;
            int topDataRow;
            int rowStripeSize;
            STableStyleElem result3;
            if (this._tableStyleInfo.isShowRowStripes() && picker.pickDataStyle(result3 = (rowStripeSize = (row - (topDataRow = all.getRow() + this.getHeaderRowCount())) % ((rowStripe1Size = (nmTableStyle = this._tableStyleInfo.getTableStyle(this._book)).getRowStripe1Size()) + (rowStripe2Size = nmTableStyle.getRowStripe2Size()))) < rowStripe1Size ? nmTableStyle.getRowStripe1Style() : nmTableStyle.getRowStripe2Style(), nextTotalsRow ? tbStyle.getTotalRowStyle() : null)) {
                return picker.getCellStyle();
            }
            if (this._tableStyleInfo.isShowColumnStripes()) {
                STableStyle nmTableStyle2 = this._tableStyleInfo.getTableStyle(this._book);
                int colStripe1Size = nmTableStyle2.getColStripe1Size();
                int colStripe2Size = nmTableStyle2.getColStripe2Size();
                int colStripeSize = (col - all.getColumn()) % (colStripe1Size + colStripe2Size);
                STableStyleElem result4 = colStripeSize < colStripe1Size ? nmTableStyle2.getColStripe1Style() : nmTableStyle2.getColStripe2Style();
                if (picker.pickDataStyle(result4, nextTotalsRow ? tbStyle.getTotalRowStyle() : null)) {
                    return picker.getCellStyle();
                }
            }
        }
        result = this._tableStyleInfo.getTableStyle(this._book).getWholeTableStyle();
        picker.pickWholeTableStyle(result, nextTotalsRow ? tbStyle.getTotalRowStyle() : null, firstRow, firstCol, lastRow, lastCol);
        return picker.getCellStyle();
    }

    @Override
    public void deleteRows(int row1, int row2) {
        int bottom;
        SSheet sheet = this._region.getSheet();
        CellRegion rgn = this._region.getRegion();
        boolean containTotals = this.getTotalsRowCount() > 0 && row2 > rgn.getLastRow() - this.getTotalsRowCount();
        int diff = row2 - row1 + 1;
        int dataSize = rgn.getLastRow() - rgn.getRow() + 1 - this.getHeaderRowCount() - (containTotals ? 0 : this.getTotalsRowCount());
        int n = bottom = diff < dataSize ? rgn.getLastRow() - diff : rgn.getLastRow() - dataSize + 1;
        if (containTotals) {
            this._totalsRowCount = 0;
        }
        this.setRegionAndFilter(new SheetRegion(sheet, new CellRegion(rgn.getRow(), rgn.getColumn(), bottom, rgn.getLastColumn())));
    }

    @Override
    public void deleteCols(int col1, int col2) {
        int c02;
        SSheet sheet = this._region.getSheet();
        CellRegion rgn = this._region.getRegion();
        int diff = col2 - col1 + 1;
        int right = rgn.getLastColumn() - diff;
        int c1 = rgn.getColumn();
        int c01 = col1 - c1;
        for (int j = c02 = col2 - c1; j >= c01; --j) {
            this._columns.remove(j);
        }
        this.setRegionAndFilter(new SheetRegion(sheet, new CellRegion(rgn.getRow(), rgn.getColumn(), rgn.getLastRow(), right)));
    }

    @Override
    public boolean shiftCols(int diff) {
        SSheet sheet = this._region.getSheet();
        CellRegion rgn = this._region.getRegion();
        int left = rgn.getColumn() + diff;
        int right = rgn.getLastColumn() + diff;
        this.setRegionAndFilter(new SheetRegion(sheet, new CellRegion(rgn.getRow(), left, rgn.getLastRow(), right)));
        SBook book = sheet.getBook();
        if (book.getMaxColumnIndex() < left) {
            return false;
        }
        if (book.getMaxColumnIndex() < right) {
            this.deleteCols(book.getMaxColumnIndex() + 1, right);
        }
        return true;
    }

    @Override
    public boolean shiftRows(int diff) {
        SSheet sheet = this._region.getSheet();
        CellRegion rgn = this._region.getRegion();
        int top = rgn.getRow() + diff;
        int bottom = rgn.getLastRow() + diff;
        this.setRegionAndFilter(new SheetRegion(sheet, new CellRegion(top, rgn.getColumn(), bottom, rgn.getLastColumn())));
        SBook book = sheet.getBook();
        if (book.getMaxRowIndex() < top) {
            return false;
        }
        if (this.getHeaderRowCount() > 0 && top == book.getMaxRowIndex()) {
            return false;
        }
        if (book.getMaxRowIndex() < bottom) {
            this.deleteRows(book.getMaxRowIndex() + 1, bottom);
        }
        return true;
    }

    private void setRegionAndFilter(SheetRegion region) {
        this._region = region;
        if (this._filter != null) {
            this._filter = null;
            if (this.getHeaderRowCount() > 0) {
                this.enableAutoFilter(true);
            }
        }
    }

    @Override
    public void insertRows(int row1, int row2) {
        CellRegion rgn = this._region.getRegion();
        int r1 = rgn.getRow();
        int r2 = rgn.getLastRow();
        SSheet sheet = this._region.getSheet();
        int diff = row2 - row1 + 1;
        int top = r1;
        int bottom = r2 + diff;
        this.setRegionAndFilter(new SheetRegion(sheet, new CellRegion(top, rgn.getColumn(), bottom, rgn.getLastColumn())));
    }

    @Override
    public void insertCols(int col1, int col2, boolean insertLeft) {
        CellRegion rgn = this._region.getRegion();
        int c1 = rgn.getColumn();
        if (!(insertLeft || col2 == col1 && col2 == c1)) {
            insertLeft = true;
        }
        SSheet sheet = this._region.getSheet();
        int diff = col2 - col1 + 1;
        int left = c1;
        int right = rgn.getLastColumn() + diff;
        List<String> newNames = this.genNewColumnName(diff);
        if (insertLeft) {
            int c01 = col1 - c1;
            for (int j = 0; j < diff; ++j) {
                String name = newNames.get(j);
                this._columns.add(c01, new TableColumnImpl(name));
            }
        } else {
            int j = diff;
            while (--j >= 0) {
                String name = newNames.get(j);
                this._columns.add(new TableColumnImpl(name));
            }
        }
        this.setRegionAndFilter(new SheetRegion(sheet, new CellRegion(rgn.getRow(), left, rgn.getLastRow(), right)));
    }

    private List<String> genNewColumnName(int count) {
        List<STableColumn> tbCols = this.getColumns();
        HashSet<String> set = new HashSet<String>(tbCols.size() * 4 / 3);
        for (STableColumn tbCol : tbCols) {
            set.add(tbCol.getName().toUpperCase());
        }
        ArrayList<String> result = new ArrayList<String>(count);
        String newName0 = "Column";
        String newNameUpper = newName0.toUpperCase();
        for (int j = tbCols.size() + count; j > 0; --j) {
            if (set.contains(newNameUpper + j)) continue;
            result.add(newName0 + j);
            if (--count <= 0) break;
        }
        return result;
    }

    @Override
    public void enableAutoFilter(boolean enable) {
        if (this._filter != null == enable) {
            return;
        }
        if (enable) {
            if (this.getHeaderRowCount() == 0) {
                this.setHeaderRowCount(1);
            } else {
                int l = this._region.getColumn();
                int t = this._region.getRow();
                int r = this._region.getLastColumn();
                int b = this._region.getLastRow();
                int tc = this.getTotalsRowCount();
                this._filter = new AutoFilterImpl(new CellRegion(t, l, b - tc, r));
            }
        } else {
            this.deleteAutoFilter();
        }
    }

    @Override
    public SAutoFilter getAutoFilter() {
        return this._headerRowCount == 0 ? null : this._filter;
    }

    @Override
    public SAutoFilter createAutoFilter() {
        int l = this._region.getColumn();
        int t = this._region.getRow();
        int r = this._region.getLastColumn();
        int b = this._region.getLastRow();
        int tc = this.getTotalsRowCount();
        CellRegion region = new CellRegion(t, l, b - tc, r);
        this._filter = new AutoFilterImpl(region);
        return this._filter;
    }

    @Override
    public void deleteAutoFilter() {
        this._filter = null;
    }

    @Override
    public void refreshFilter() {
        SSheet sheet = this._region.getSheet();
        new NotifyChangeHelper().notifySheetAutoFilterChange(sheet, new DummyTable(this));
        if (((AbstractBookAdv)sheet.getBook()).getTable(this._name) != null && this._filter != null) {
            ModelUpdateUtil.addAutoFilterUpdate(sheet, this);
        }
    }

    @Override
    AbstractTableAdv cloneTable(SSheet sheet, SBook book) {
        SheetRegion region = new SheetRegion(sheet, this._region.getRow(), this._region.getColumn(), this._region.getLastRow(), this._region.getLastColumn());
        AbstractTableStyleInfoAdv info = this._tableStyleInfo == null ? null : ((AbstractTableStyleInfoAdv)this._tableStyleInfo).cloneTableStyleInfo(book);
        TableImpl dest = new TableImpl((AbstractBookAdv)sheet.getBook(), this._name, this._displayName, region, this._headerRowCount, this._totalsRowCount, info);
        for (STableColumn tbc : this._columns) {
            dest.addColumn(tbc == null ? null : ((AbstractTableColumnAdv)tbc).cloneTableColumn());
        }
        if (this._filter != null) {
            dest.createAutoFilter();
        }
        if (book != null) {
            SName namedRange = ((AbstractBookAdv)book).createTableName(dest);
            SheetRegion rgn = dest.getDataRegion();
            namedRange.setRefersToFormula(rgn.getReferenceString());
            ((AbstractBookAdv)book).addTable(dest);
        }
        return dest;
    }

    public static class DummyTable
    implements STable {
        final STable tb;

        public DummyTable(STable tb) {
            this.tb = tb;
        }

        @Override
        public SBook getBook() {
            return this.tb.getBook();
        }

        @Override
        public SAutoFilter getAutoFilter() {
            return this.tb.getAutoFilter();
        }

        @Override
        public void enableAutoFilter(boolean enable) {
            this.tb.enableAutoFilter(enable);
        }

        @Override
        public SAutoFilter createAutoFilter() {
            return this.tb.createAutoFilter();
        }

        @Override
        public void deleteAutoFilter() {
            this.tb.deleteAutoFilter();
        }

        @Override
        public void addColumn(STableColumn column) {
            this.tb.addColumn(column);
        }

        @Override
        public List<STableColumn> getColumns() {
            return this.tb.getColumns();
        }

        @Override
        public STableColumn getColumnAt(int colIdx) {
            return this.tb.getColumnAt(colIdx);
        }

        @Override
        public STableStyleInfo getTableStyleInfo() {
            return this.tb.getTableStyleInfo();
        }

        @Override
        public int getTotalsRowCount() {
            return this.tb.getTotalsRowCount();
        }

        @Override
        public void setTotalsRowCount(int count) {
            this.tb.setTotalsRowCount(count);
        }

        @Override
        public int getHeaderRowCount() {
            return this.tb.getHeaderRowCount();
        }

        @Override
        public void setHeaderRowCount(int count) {
            this.tb.setHeaderRowCount(count);
        }

        @Override
        public String getName() {
            return this.tb.getName();
        }

        @Override
        public void setName(String name) {
            this.tb.setName(name);
        }

        @Override
        public String getDisplayName() {
            return this.tb.getDisplayName();
        }

        @Override
        public void setDisplayName(String name) {
            this.tb.setDisplayName(name);
        }

        @Override
        public SheetRegion getAllRegion() {
            return this.tb.getAllRegion();
        }

        @Override
        public SheetRegion getDataRegion() {
            return this.tb.getDataRegion();
        }

        @Override
        public SheetRegion getColumnsRegion(String columnName1, String columnName2) {
            return this.tb.getColumnsRegion(columnName1, columnName2);
        }

        @Override
        public SheetRegion getHeadersRegion() {
            return this.tb.getHeadersRegion();
        }

        @Override
        public SheetRegion getTotalsRegion() {
            return this.tb.getTotalsRegion();
        }

        @Override
        public SheetRegion getThisRowRegion(int rowIdx) {
            return this.tb.getThisRowRegion(rowIdx);
        }

        @Override
        public SheetRegion getItemRegion(TablePtg.Item item, int rowIdx) {
            return this.tb.getItemRegion(item, rowIdx);
        }
    }

    private static class CellStylePicker {
        private SFill fill = null;
        private SFont font = null;
        private SBorderLine left = null;
        private SBorderLine top = null;
        private SBorderLine right = null;
        private SBorderLine bottom = null;

        private CellStylePicker() {
        }

        private boolean pickDataStyle(SCellStyle style, SCellStyle totalsRowStyle) {
            if (style != null) {
                SBorder nextBorder0 = totalsRowStyle != null ? totalsRowStyle.getBorder() : null;
                SBorderLine bottom02 = nextBorder0 != null ? nextBorder0.getTopLine() : null;
                SFont font0 = style.getFont();
                SFill fill0 = style.getFill();
                SBorder border0 = style.getBorder();
                if (border0 != null) {
                    SBorderLine left0 = border0.getLeftLine();
                    SBorderLine top0 = border0.getTopLine();
                    SBorderLine right0 = border0.getRightLine();
                    SBorderLine bottom0 = border0.getBottomLine();
                    return this.pickStyle(font0, fill0, left0, top0, right0, bottom02 != null ? bottom02 : bottom0);
                }
                return this.pickStyle(font0, fill0, null, null, null, bottom02);
            }
            return false;
        }

        private boolean pickWholeTableStyle(SCellStyle style, SCellStyle totalsRowStyle, boolean firstRow, boolean firstCol, boolean lastRow, boolean lastCol) {
            if (style != null) {
                SBorder nextBorder0 = totalsRowStyle != null ? totalsRowStyle.getBorder() : null;
                SBorderLine bottom02 = nextBorder0 != null ? nextBorder0.getTopLine() : null;
                SFont font0 = style.getFont();
                SFill fill0 = style.getFill();
                SBorder border0 = style.getBorder();
                if (border0 != null) {
                    SBorderLine top0;
                    SBorderLine left0 = firstCol ? border0.getLeftLine() : border0.getVerticalLine();
                    SBorderLine right0 = lastCol ? border0.getRightLine() : border0.getVerticalLine();
                    SBorderLine sBorderLine = top0 = firstRow ? border0.getTopLine() : border0.getHorizontalLine();
                    SBorderLine bottom0 = lastRow ? border0.getBottomLine() : (bottom02 != null ? bottom02 : border0.getHorizontalLine());
                    return this.pickStyle(font0, fill0, left0, top0, right0, bottom0);
                }
                return this.pickStyle(font0, fill0, null, null, null, null);
            }
            return true;
        }

        private boolean pickStyle(SFont font0, SFill fill0, SBorderLine left0, SBorderLine top0, SBorderLine right0, SBorderLine bottom0) {
            if (this.font == null) {
                this.font = font0;
            }
            if (this.fill == null) {
                this.fill = fill0;
            }
            if (this.left == null) {
                this.left = left0;
            }
            if (this.top == null) {
                this.top = top0;
            }
            if (this.right == null) {
                this.right = right0;
            }
            if (this.bottom == null) {
                this.bottom = bottom0;
            }
            return this.font != null && this.fill != null && this.left != null && this.top != null && this.right != null && this.bottom != null;
        }

        private SCellStyle getCellStyle() {
            BorderImpl border0 = this.left == null && this.top == null && this.right == null && this.bottom == null ? null : new BorderImpl(this.left, this.top, this.right, this.bottom, null, null, null);
            return this.font == null && this.fill == null && border0 == null ? null : new CellStyleImpl((AbstractFontAdv)this.font, (AbstractFillAdv)this.fill, border0);
        }
    }
}

