/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xwpf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFootnotes;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.FootnotesDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.openxml4j.exceptions.OpenXML4JException;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.xwpf.usermodel.XWPFDocument;
import org.zkoss.poi.xwpf.usermodel.XWPFFootnote;

public class XWPFFootnotes
extends POIXMLDocumentPart {
    private List<XWPFFootnote> listFootnote = new ArrayList<XWPFFootnote>();
    private CTFootnotes ctFootnotes;
    protected XWPFDocument document;

    public XWPFFootnotes(PackagePart part, PackageRelationship rel) throws IOException, OpenXML4JException {
        super(part, rel);
    }

    public XWPFFootnotes() {
    }

    @Override
    protected void onDocumentRead() throws IOException {
        try {
            InputStream is = this.getPackagePart().getInputStream();
            FootnotesDocument notesDoc = FootnotesDocument.Factory.parse((InputStream)is);
            this.ctFootnotes = notesDoc.getFootnotes();
        }
        catch (XmlException e) {
            throw new POIXMLException();
        }
        for (CTFtnEdn note : this.ctFootnotes.getFootnoteList()) {
            this.listFootnote.add(new XWPFFootnote(note, this));
        }
    }

    @Override
    protected void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(DEFAULT_XML_OPTIONS);
        xmlOptions.setSaveSyntheticDocumentElement(new QName(CTFootnotes.type.getName().getNamespaceURI(), "footnotes"));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        xmlOptions.setSaveSuggestedPrefixes(map);
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.ctFootnotes.save(out, xmlOptions);
        out.close();
    }

    public List<XWPFFootnote> getFootnotesList() {
        return this.listFootnote;
    }

    public XWPFFootnote getFootnoteById(int id) {
        for (XWPFFootnote note : this.listFootnote) {
            if (note.getCTFtnEdn().getId().intValue() != id) continue;
            return note;
        }
        return null;
    }

    public void setFootnotes(CTFootnotes footnotes) {
        this.ctFootnotes = footnotes;
    }

    public void addFootnote(XWPFFootnote footnote) {
        this.listFootnote.add(footnote);
        this.ctFootnotes.addNewFootnote().set((XmlObject)footnote.getCTFtnEdn());
    }

    public XWPFFootnote addFootnote(CTFtnEdn note) {
        CTFtnEdn newNote = this.ctFootnotes.addNewFootnote();
        newNote.set((XmlObject)note);
        XWPFFootnote xNote = new XWPFFootnote(newNote, this);
        this.listFootnote.add(xNote);
        return xNote;
    }

    public void setXWPFDocument(XWPFDocument doc) {
        this.document = doc;
    }

    public XWPFDocument getXWPFDocument() {
        if (this.document != null) {
            return this.document;
        }
        return (XWPFDocument)this.getParent();
    }
}

