/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.query.impl.getters.AbstractMultiValueGetter;
import com.hazelcast.query.impl.getters.Getter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class MethodGetter
extends AbstractMultiValueGetter {
    private final Method method;

    public MethodGetter(Getter parent, Method method, String modifier, Class elementType) {
        this(parent, method, modifier, method.getReturnType(), elementType);
    }

    public MethodGetter(Getter parent, Method method, String modifier, Class type, Class elementType) {
        super(parent, modifier, type, elementType);
        this.method = method;
    }

    @Override
    protected Object extractFrom(Object object) throws IllegalAccessException, InvocationTargetException {
        try {
            return this.method.invoke(object, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(MethodGetter.composeAttributeValueExtractionFailedMessage(this.method), e);
        }
    }

    @Override
    boolean isCacheable() {
        return true;
    }

    public String toString() {
        return "MethodGetter [parent=" + this.parent + ", method=" + this.method.getName() + ", modifier = " + this.getModifier() + "]";
    }
}

