/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.db.oracle.partition;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.db.partition.RangePartitionColumn;
import org.compiere.db.partition.RangePartitionInterval;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_TablePartition;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class TablePartitionService
implements ITablePartitionService {
    private boolean useAutomaticListPartition = true;
    private boolean useIntervalPartition = true;

    public boolean isPartitionedTable(MTable table, String trxName) {
        String sql = "\tSELECT 1 FROM USER_TAB_PARTITIONS\n\tWHERE TABLE_NAME = ?\n";
        return DB.getSQLValueEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()}) == 1;
    }

    public boolean createPartitionedTable(MTable table, String trxName, ProcessInfo processInfo) {
        String partitioningMethod;
        StringBuilder alterStmt = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" MODIFY PARTITION BY ");
        List partitionKeyColumns = table.getPartitionKeyColumns(false);
        MColumn partitionKeyColumn = (MColumn)partitionKeyColumns.get(0);
        MColumn subPartitionColumn = null;
        if (partitionKeyColumns.size() > 1) {
            subPartitionColumn = (MColumn)partitionKeyColumns.get(1);
        }
        if ((partitioningMethod = partitionKeyColumn.getPartitioningMethod()).equals("L")) {
            alterStmt.append("List");
        } else if (partitioningMethod.equals("R")) {
            alterStmt.append("Range");
        } else {
            throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{partitioningMethod}));
        }
        alterStmt.append(" (").append(partitionKeyColumn.getColumnName()).append(")");
        if (partitioningMethod.equals("L") && this.useAutomaticListPartition) {
            alterStmt.append(" AUTOMATIC ");
        } else if (this.useIntervalPartition) {
            alterStmt.append(" INTERVAL(");
            alterStmt.append(this.getIntervalExpression(partitionKeyColumn));
            alterStmt.append(") ");
        }
        if (subPartitionColumn != null) {
            alterStmt.append("SUBPARTITION BY ");
            if (subPartitionColumn.getPartitioningMethod().equals("L")) {
                alterStmt.append("List");
            } else if (subPartitionColumn.getPartitioningMethod().equals("R")) {
                alterStmt.append("Range");
            } else {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{subPartitionColumn.getPartitioningMethod()}));
            }
            alterStmt.append(" (").append(subPartitionColumn.getColumnName()).append(")");
        }
        alterStmt.append(" (PARTITION default_partition ");
        StringBuilder defaultExpression = new StringBuilder();
        if (partitioningMethod.equals("L")) {
            defaultExpression.append("VALUES (");
            if (partitioningMethod.equals("L") && this.useAutomaticListPartition) {
                defaultExpression.append("NULL");
            } else {
                defaultExpression.append("DEFAULT");
            }
            defaultExpression.append(")");
        } else {
            if (this.useIntervalPartition) {
                if (alterStmt.indexOf("NUMTOYMINTERVAL(") > 0) {
                    defaultExpression.append("VALUES LESS THAN (TO_DATE('1970-01-01','YYYY-MM-DD')");
                } else {
                    defaultExpression.append("VALUES LESS THAN (").append("0");
                }
            } else {
                defaultExpression.append("VALUES LESS THAN (");
                defaultExpression.append("MAXVALUE");
            }
            defaultExpression.append(")");
        }
        alterStmt.append(defaultExpression.toString());
        alterStmt.append(" ) ");
        int no = DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
        if (processInfo != null) {
            processInfo.addLog(0, null, null, no + " " + alterStmt.toString());
        }
        if (!partitioningMethod.equals("L") || !this.useAutomaticListPartition) {
            table.createTablePartition("default_partition", defaultExpression.toString(), trxName, partitionKeyColumn);
        }
        return true;
    }

    private String getIntervalExpression(MColumn partitionKeyColumn) {
        if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
            RangePartitionInterval.Interval interval = RangePartitionInterval.getInterval((MColumn)partitionKeyColumn);
            if (interval.years() > 0) {
                if (interval.months() == 0) {
                    return "NUMTOYMINTERVAL(" + interval.years() + ",'YEAR')";
                }
                int months = interval.months() + interval.years() * 12;
                return "NUMTOYMINTERVAL(" + months + ",'MONTH')";
            }
            return "NUMTOYMINTERVAL(" + interval.months() + ",'MONTH')";
        }
        if (DisplayType.isNumeric((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isID((int)partitionKeyColumn.getAD_Reference_ID())) {
            Pattern pattern = Pattern.compile("^[1-9]\\d*$");
            Matcher matcher = pattern.matcher(partitionKeyColumn.getRangePartitionInterval());
            if (!matcher.matches()) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"InvalidRangePartitionInterval") + " [" + String.valueOf(partitionKeyColumn) + "]");
            }
            BigDecimal interval = new BigDecimal(partitionKeyColumn.getRangePartitionInterval());
            return interval.toPlainString();
        }
        throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"RangePartitionKeyTypeNotSupported") + " [" + String.valueOf(partitionKeyColumn) + "]");
    }

    public boolean addPartitionAndMigrateData(MTable table, String trxName, ProcessInfo processInfo) {
        String partitioningMethod;
        boolean isUpdated = false;
        List partitionKeyColumns = table.getPartitionKeyColumns(false);
        if (partitionKeyColumns.size() == 0) {
            return false;
        }
        MColumn partitionKeyColumn = (MColumn)partitionKeyColumns.get(0);
        String sql = "SELECT Column_Name FROM User_Part_Key_Columns WHERE Name=? ORDER BY Column_Position";
        String partKeyColumn = DB.getSQLValueString((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        if (!partitionKeyColumn.getColumnName().equalsIgnoreCase(partKeyColumn)) {
            return false;
        }
        MColumn subPartitionColumn = null;
        if (partitionKeyColumns.size() > 1) {
            subPartitionColumn = (MColumn)partitionKeyColumns.get(1);
        }
        if ((partitioningMethod = partitionKeyColumn.getPartitioningMethod()).equals("L")) {
            if (this.isAutoList(table, trxName)) {
                this.syncAutoList(table, partitionKeyColumn, trxName, processInfo);
                this.syncPartition(table, trxName, processInfo, false);
            } else {
                isUpdated = this.addListPartition(table, partitionKeyColumn, trxName, processInfo, "default_partition", null, null);
            }
        } else if (partitioningMethod.equals("R")) {
            if (!this.isRangePartitionedTable(table, trxName)) {
                this.fromListToRange(table, trxName, processInfo, partitionKeyColumn);
                this.syncPartition(table, trxName, processInfo, true);
            } else {
                String interval = this.getInterval(table, trxName);
                if (!Util.isEmpty((String)interval, (boolean)true)) {
                    this.syncInterval(table, partitionKeyColumn, trxName, interval, processInfo);
                    this.syncPartition(table, trxName, processInfo, true);
                } else {
                    this.syncRange(table, partitionKeyColumn, trxName, interval, processInfo);
                    isUpdated = this.addRangePartition(table, partitionKeyColumn, trxName, processInfo, "default_partition", null, null);
                }
            }
        } else {
            throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{partitioningMethod}));
        }
        if (subPartitionColumn != null) {
            List<X_AD_TablePartition> primaryPartitions = this.getPrimaryPartitions(table, partitionKeyColumn, trxName);
            if (subPartitionColumn.getPartitioningMethod().equals("L")) {
                for (X_AD_TablePartition primaryPartition : primaryPartitions) {
                    String defaultSubPartition = this.getDefaultSubPartitionName(table, primaryPartition, false, trxName);
                    if (defaultSubPartition == null) continue;
                    isUpdated = this.addListPartition(table, subPartitionColumn, trxName, processInfo, defaultSubPartition, primaryPartition.getName(), primaryPartition);
                }
            } else if (subPartitionColumn.getPartitioningMethod().equals("R")) {
                for (X_AD_TablePartition primaryPartition : primaryPartitions) {
                    String defaultSubPartition = this.getDefaultSubPartitionName(table, primaryPartition, true, trxName);
                    if (defaultSubPartition == null) continue;
                    isUpdated = this.addRangePartition(table, subPartitionColumn, trxName, processInfo, defaultSubPartition, primaryPartition.getName(), primaryPartition);
                }
            } else {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PartitioningMethodNotSupported", (Object[])new Object[]{subPartitionColumn.getPartitioningMethod()}));
            }
        }
        return isUpdated;
    }

    private String getDefaultSubPartitionName(MTable table, X_AD_TablePartition primaryPartition, boolean range, String trxName) {
        String sql = "\tSELECT High_Value, SubPartition_Name\n\tFROM User_Tab_SubPartitions\n\tWHERE Table_Name=? AND Partition_Name=?\n";
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)sql, (String)trxName);){
                stmt.setString(1, table.getTableName().toUpperCase());
                stmt.setString(2, primaryPartition.getName().toUpperCase());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String expression = rs.getString(1);
                    if (!(range ? "MAXVALUE".equals(expression) : "DEFAULT".equals(expression))) continue;
                    return rs.getString(2);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        return null;
    }

    private List<X_AD_TablePartition> getPrimaryPartitions(MTable table, MColumn partitionKeyColumn, String trxName) {
        String whereClause = "AD_Table_ID=? AND AD_Column_ID=? And Name != 'DEFAULT_PARTITION' AND IsPartitionAttached='Y' AND IsActive='Y'";
        Query query = new Query(Env.getCtx(), MTable.get((Properties)Env.getCtx(), (int)200411), whereClause, trxName);
        return query.setParameters(new Object[]{table.getAD_Table_ID(), partitionKeyColumn.getAD_Column_ID()}).list();
    }

    private void fromListToRange(MTable table, String trxName, ProcessInfo processInfo, MColumn partitionKeyColumn) {
        DB.executeUpdateEx((String)"DELETE FROM AD_TablePartition WHERE AD_Table_ID=? AND Name=?", (Object[])new Object[]{table.getAD_Table_ID(), "DEFAULT_PARTITION"}, (String)trxName);
        StringBuilder alterStmt = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" MODIFY PARTITION BY RANGE ").append(" (").append(partitionKeyColumn.getColumnName()).append(")");
        if (this.useIntervalPartition) {
            alterStmt.append(" INTERVAL(");
            alterStmt.append(this.getIntervalExpression(partitionKeyColumn));
            alterStmt.append(") (PARTITION default_partition ");
        } else {
            alterStmt.append(" (PARTITION default_partition ");
        }
        StringBuilder defaultExpression = new StringBuilder();
        if (this.useIntervalPartition) {
            if (alterStmt.indexOf("NUMTOYMINTERVAL(") > 0) {
                defaultExpression.append("VALUES LESS THAN (TO_DATE('1970-01-01','YYYY-MM-DD')");
            } else {
                defaultExpression.append("VALUES LESS THAN (").append("0");
            }
        } else {
            defaultExpression.append("VALUES LESS THAN (");
            defaultExpression.append("MAXVALUE");
        }
        defaultExpression.append(")");
        alterStmt.append(defaultExpression.toString());
        alterStmt.append(" ) ");
        int no = DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
        if (processInfo != null) {
            processInfo.addLog(0, null, null, no + " " + alterStmt.toString());
        }
    }

    private void syncAutoList(MTable table, MColumn partitionKeyColumn, String trxName, ProcessInfo pi) {
        String keyColumn = partitionKeyColumn.getColumnName();
        String sql = "SELECT Column_Name FROM User_Part_Key_Columns WHERE Name=? ORDER BY Column_Position";
        List columnNames = DB.getSQLArrayObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        boolean notSync = false;
        if (columnNames.size() != 1) {
            notSync = true;
        } else if (!keyColumn.equalsIgnoreCase(((List)columnNames.get(0)).get(0).toString())) {
            notSync = true;
        }
        if (notSync) {
            StringBuilder alterStmt = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" MODIFY PARTITION BY List ");
            alterStmt.append(" (").append(keyColumn).append(")");
            alterStmt.append(" AUTOMATIC (PARTITION default_partition VALUES (");
            alterStmt.append("NULL");
            alterStmt.append("))");
            int no = DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, no + " " + alterStmt.toString());
            }
        }
    }

    private void syncInterval(MTable table, MColumn partitionKeyColumn, String trxName, String interval, ProcessInfo pi) {
        Object sql = "SELECT Column_Name FROM User_Part_Key_Columns WHERE Name=? ORDER BY Column_Position";
        String intervalColumn = DB.getSQLValueString((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        String expression = this.getIntervalExpression(partitionKeyColumn);
        if (partitionKeyColumn.getColumnName().toUpperCase().equals(intervalColumn)) {
            if (!interval.toUpperCase().equals(expression)) {
                sql = "ALTER TABLE " + table.getTableName() + " SET INTERVAL (" + expression + ")";
                int no = DB.executeUpdateEx((String)sql, (String)trxName);
                if (pi != null) {
                    pi.addLog(0, null, null, no + " " + (String)sql);
                }
            }
        } else {
            throw new AdempiereException("PartitionConfigurationChanged");
        }
    }

    private void syncRange(MTable table, MColumn partitionKeyColumn, String trxName, String interval, ProcessInfo pi) {
        String sql = "SELECT Column_Name FROM User_Part_Key_Columns WHERE Name=? ORDER BY Column_Position";
        List columnNames = DB.getSQLArrayObjectsEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        boolean notSync = false;
        if (columnNames.size() != 1) {
            notSync = true;
        } else if (!partitionKeyColumn.getColumnName().equalsIgnoreCase(((List)columnNames.get(0)).get(0).toString())) {
            notSync = true;
        }
        if (notSync) {
            StringBuilder alterStmt = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" MODIFY PARTITION BY Range ");
            alterStmt.append(" (").append(partitionKeyColumn.getColumnName()).append(")");
            alterStmt.append(" (PARTITION default_partition VALUES LESS THAN (");
            alterStmt.append("MAXVALUE");
            alterStmt.append("))");
            int no = DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, no + " " + alterStmt.toString());
            }
        }
    }

    private void syncPartition(MTable table, String trxName, ProcessInfo processInfo, boolean interval) {
        String sql = "\tSELECT Partition_Name, High_Value\n\tFROM User_Tab_Partitions\n\tWHERE Table_Name=?\n";
        Query query = new Query(Env.getCtx(), "AD_TablePartition", "AD_Table_ID=? AND Parent_TablePartition_ID IS NULL", trxName);
        List existingList = query.setParameters(new Object[]{table.getAD_Table_ID()}).list();
        ArrayList<Integer> matchedIds = new ArrayList<Integer>();
        List partitionKeyColumns = table.getPartitionKeyColumns(false);
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)sql, (String)trxName);){
                stmt.setString(1, table.getTableName().toUpperCase());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    String partitionName = rs.getString(1);
                    String values = rs.getString(2);
                    int id = DB.getSQLValueEx((String)trxName, (String)"SELECT AD_TablePartition_ID FROM AD_TablePartition WHERE AD_Table_ID=? AND Name=?", (Object[])new Object[]{table.getAD_Table_ID(), partitionName});
                    if (id > 0) {
                        matchedIds.add(id);
                        continue;
                    }
                    String expression = interval ? "VALUES LESS THAN " + values : "VALUES " + values;
                    table.createTablePartition(partitionName, expression, trxName, (MColumn)partitionKeyColumns.get(0));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        if (existingList.size() > 0) {
            for (X_AD_TablePartition tablePartition : existingList) {
                if (matchedIds.contains(tablePartition.getAD_TablePartition_ID())) continue;
                tablePartition.deleteEx(true);
            }
        }
    }

    private boolean isAutoList(MTable table, String trxName) {
        String sql = "\tSELECT AutoList\n\tFROM User_Part_Tables\n\tWHERE Table_Name = ?\n";
        String autoList = DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        return "YES".equals(autoList);
    }

    private String getInterval(MTable table, String trxName) {
        String sql = "\tSELECT Interval\n\tFROM User_Part_Tables\n\tWHERE Table_Name = ?\n";
        String interval = DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        return interval;
    }

    private boolean isRangePartitionedTable(MTable table, String trxName) {
        String sql = "\tSELECT Partitioning_Type\n\tFROM User_Part_Tables\n\tWHERE Table_Name = ?\n";
        String type = DB.getSQLValueStringEx((String)trxName, (String)sql, (Object[])new Object[]{table.getTableName().toUpperCase()});
        return "RANGE".equals(type);
    }

    private boolean addListPartition(MTable table, MColumn partitionKeyColumn, String trxName, ProcessInfo pi, String fromPartition, String partitionNamePrefix, X_AD_TablePartition parentPartition) {
        boolean isUpdated = false;
        ArrayList<X_AD_TablePartition> partitions = new ArrayList<X_AD_TablePartition>();
        boolean subPartition = parentPartition != null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT DISTINCT ").append(partitionKeyColumn.getColumnName());
        sql.append(" FROM ").append(table.getTableName()).append(" ").append(subPartition ? "SubPartition(" : "Partition(").append(fromPartition).append(") ");
        sql.append("ORDER BY ").append(partitionKeyColumn.getColumnName());
        try {
            Throwable throwable = null;
            Iterator iterator = null;
            try (CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), (String)trxName);){
                ResultSet rs = pstmt.executeQuery();
                while (rs.next()) {
                    StringBuilder name = new StringBuilder();
                    StringBuilder expression = new StringBuilder("VALUES (");
                    if (!Util.isEmpty((String)partitionNamePrefix, (boolean)true)) {
                        name.append(partitionNamePrefix).append("_");
                    }
                    String s = rs.getString(partitionKeyColumn.getColumnName());
                    name.append(s);
                    if (DisplayType.isText((int)partitionKeyColumn.getAD_Reference_ID()) || partitionKeyColumn.getAD_Reference_ID() == 20 || DisplayType.isList((int)partitionKeyColumn.getAD_Reference_ID()) || "EntityType".equals(partitionKeyColumn.getColumnName()) || "AD_Language".equals(partitionKeyColumn.getColumnName())) {
                        expression.append(DB.TO_STRING((String)s));
                    } else if (partitionKeyColumn.getAD_Reference_ID() == 15) {
                        expression.append(DB.TO_DATE((Timestamp)rs.getTimestamp(partitionKeyColumn.getColumnName())));
                    } else if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID())) {
                        expression.append(DB.TO_DATE((Timestamp)rs.getTimestamp(partitionKeyColumn.getColumnName()), (boolean)false));
                    } else if (DisplayType.isID((int)partitionKeyColumn.getAD_Reference_ID()) || 11 == partitionKeyColumn.getAD_Reference_ID()) {
                        expression.append(rs.getInt(partitionKeyColumn.getColumnName()));
                    } else if (DisplayType.isNumeric((int)partitionKeyColumn.getAD_Reference_ID())) {
                        expression.append(rs.getBigDecimal(partitionKeyColumn.getColumnName()).toPlainString());
                    }
                    expression.append(")");
                    if (Character.isDigit(name.charAt(0))) {
                        name.insert(0, "p");
                    }
                    X_AD_TablePartition partition = table.createTablePartition(name.toString(), expression.toString(), trxName, partitionKeyColumn, parentPartition);
                    partitions.add(partition);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBException((Exception)e);
        }
        for (X_AD_TablePartition partition : partitions) {
            StringBuilder alterStmt = new StringBuilder();
            alterStmt.append("ALTER TABLE ").append(table.getTableName()).append(" SPLIT ").append(subPartition ? "SubPartition " : "Partition ").append(fromPartition).append(" ");
            alterStmt.append(partition.getExpressionPartition());
            alterStmt.append(" INTO ( ").append(subPartition ? "SUBPARTITION " : "PARTITION ").append(partition.getName()).append(", ");
            alterStmt.append(subPartition ? "SubPartition " : "Partition ").append(fromPartition).append(" )");
            int no = DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, no + " " + alterStmt.toString());
            }
            isUpdated = true;
        }
        return isUpdated;
    }

    private boolean addRangePartition(MTable table, MColumn partitionKeyColumn, String trxName, ProcessInfo pi, String fromPartition, String partitionNamePrefix, X_AD_TablePartition parentPartition) {
        boolean isUpdated = false;
        X_AD_TablePartition partition = null;
        RangePartitionColumn rangePartitionColumn = null;
        boolean subPartition = parentPartition != null;
        String partitionKeyColumnName = partitionKeyColumn.getColumnName();
        String partitionKeyColumnRangeIntervalPattern = partitionKeyColumn.getRangePartitionInterval();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT MIN(").append(partitionKeyColumnName).append(") AS min_value, ");
        sql.append("MAX(").append(partitionKeyColumnName).append(") AS max_value ");
        sql.append("FROM ").append(table.getTableName()).append(" ").append(subPartition ? "SubPartition(" : "Partition(").append(fromPartition).append(")");
        List values = DB.getSQLValueObjectsEx((String)trxName, (String)sql.toString(), (Object[])new Object[0]);
        if (values.get(0) != null && values.get(1) != null) {
            rangePartitionColumn = new RangePartitionColumn(partitionKeyColumnName, partitionKeyColumnRangeIntervalPattern, values.get(0), values.get(1));
        }
        if (rangePartitionColumn == null) {
            return false;
        }
        List rangePartitionIntervals = RangePartitionInterval.createInterval((MTable)table, rangePartitionColumn, (String)trxName);
        List tablePartitionNames = table.getTablePartitionNames(trxName);
        for (RangePartitionInterval rangePartitionInterval : rangePartitionIntervals) {
            StringBuilder name = new StringBuilder();
            if (!Util.isEmpty((String)partitionNamePrefix, (boolean)true)) {
                name.append(partitionNamePrefix).append("_");
            }
            name.append(rangePartitionInterval.getName());
            StringBuilder countStmt = new StringBuilder("SELECT Count(*) FROM ").append(table.getTableName()).append(" ").append(subPartition ? "SubPartition(" : "Partition(").append(fromPartition).append(") ").append("WHERE ").append(" ").append(partitionKeyColumn.getColumnName()).append(" >= ");
            if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
                countStmt.append("TO_DATE(").append(rangePartitionInterval.getFrom()).append(",'YYYY-MM-DD') ");
            } else {
                countStmt.append(rangePartitionInterval.getFrom()).append(" ");
            }
            countStmt.append("AND ").append(partitionKeyColumn.getColumnName()).append(" < ");
            if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
                countStmt.append("TO_DATE(").append(rangePartitionInterval.getTo()).append(",'YYYY-MM-DD') ");
            } else {
                countStmt.append(rangePartitionInterval.getTo()).append(" ");
            }
            int recordCount = DB.getSQLValueEx((String)trxName, (String)countStmt.toString(), (Object[])new Object[0]);
            if (recordCount == 0) {
                Query query;
                X_AD_TablePartition toDelete;
                if (!tablePartitionNames.contains(name.toString()) || (toDelete = (X_AD_TablePartition)(query = new Query(Env.getCtx(), "AD_TablePartition", "AD_Table_ID=? AND Name=?", trxName)).setParameters(new Object[]{table.getAD_Table_ID(), name.toString()}).first()) == null) continue;
                toDelete.deleteEx(true);
                continue;
            }
            StringBuilder expression = new StringBuilder();
            expression.append("VALUES LESS THAN (");
            Object toValue = rangePartitionInterval.getTo();
            if (DisplayType.isDate((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isTimestampWithTimeZone((int)partitionKeyColumn.getAD_Reference_ID())) {
                expression.append("TO_Date(").append(toValue.toString()).append(",'YYYY-MM-DD')");
            } else if (DisplayType.isNumeric((int)partitionKeyColumn.getAD_Reference_ID()) || DisplayType.isID((int)partitionKeyColumn.getAD_Reference_ID())) {
                BigDecimal bd = new BigDecimal(toValue.toString());
                if (DisplayType.isID((int)partitionKeyColumn.getAD_Reference_ID()) || 11 == partitionKeyColumn.getAD_Reference_ID()) {
                    expression.append(bd.intValue());
                } else {
                    expression.append(bd.toPlainString());
                }
            }
            expression.append(")");
            if (Character.isDigit(name.charAt(0))) {
                name.insert(0, "p");
            }
            if (!tablePartitionNames.contains(name.toString())) {
                partition = table.createTablePartition(name.toString(), expression.toString(), trxName, partitionKeyColumn, parentPartition);
            }
            if (partition == null) continue;
            StringBuilder alterStmt = new StringBuilder();
            alterStmt.append("ALTER TABLE ").append(table.getTableName()).append(" SPLIT ").append(subPartition ? "SubPartition " : "Partition ").append(fromPartition);
            alterStmt.append(" INTO ( ").append(subPartition ? "SUBPARTITION " : "PARTITION ").append(partition.getName()).append(" ").append(partition.getExpressionPartition()).append(", ");
            alterStmt.append(subPartition ? "SubPartition " : "Partition ").append(fromPartition).append(" )");
            int no = DB.executeUpdateEx((String)alterStmt.toString(), (String)trxName);
            if (pi != null) {
                pi.addLog(0, null, null, no + " " + alterStmt.toString());
            }
            isUpdated = true;
        }
        return isUpdated;
    }

    public boolean runPostPartitionProcess(MTable table, String trxName, ProcessInfo processInfo) {
        String sql = "\t select index_name, partition_name, 'partition' ddl_type\n     from user_ind_partitions\n     where (index_name) in\n           ( select index_name\n             from   user_indexes\n             where table_name  = ?\n           )\n     and status = 'UNUSABLE'\n     union all\n     select index_name, subpartition_name, 'subpartition' ddl_type\n     from user_ind_subpartitions\n     where (index_name) in\n           ( select index_name\n             from   user_indexes\n             where table_name  = ?\n           )\n     and status = 'UNUSABLE'\n     union all\n     select index_name, null, null\n     from user_indexes\n     where table_name  = ?\n     and status = 'UNUSABLE'\n";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (CPreparedStatement stmt = DB.prepareStatement((String)sql, (String)trxName);){
                stmt.setString(1, table.getTableName().toUpperCase());
                stmt.setString(2, table.getTableName().toUpperCase());
                stmt.setString(3, table.getTableName().toUpperCase());
                ResultSet rs = stmt.executeQuery();
                while (rs.next()) {
                    StringBuilder alter = new StringBuilder("ALTER INDEX ").append(rs.getString(1)).append(" REBUILD ");
                    String ddlType = rs.getString(3);
                    if (!Util.isEmpty((String)ddlType, (boolean)true)) {
                        alter.append(ddlType).append(" ").append(rs.getString(2));
                    }
                    int no = DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                    if (processInfo == null) continue;
                    processInfo.addLog(0, null, null, no + " " + alter.toString());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            CLogger.getCLogger(this.getClass()).log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public String isValidConfiguration(MTable table) {
        String trxName = table.get_TrxName();
        if (!this.isPartitionedTable(table, trxName)) {
            return null;
        }
        if (!table.isPartition()) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged") + " [IsPartition]";
        }
        return null;
    }

    public String isValidConfiguration(MColumn column) {
        String error;
        String trxName = column.get_TrxName();
        MTable table = MTable.get((Properties)Env.getCtx(), (int)column.getAD_Table_ID(), (String)trxName);
        List partitionKeyColumns = table.getPartitionKeyColumns(true);
        if (column.isActive() && column.isPartitionKey()) {
            if (!partitionKeyColumns.contains(column)) {
                partitionKeyColumns.add(column);
            }
        } else if (partitionKeyColumns.contains(column)) {
            partitionKeyColumns.remove(column);
        }
        if (partitionKeyColumns.size() > 2) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"OnlyTwoPartitionKeyAllowed");
        }
        if (column.isActive() && column.isPartitionKey() && column.getPartitioningMethod().equals("R") && !Util.isEmpty((String)(error = RangePartitionInterval.validateIntervalPattern((MColumn)column)))) {
            return error;
        }
        if (!this.isPartitionedTable(table, trxName)) {
            return null;
        }
        if (!(column.isPartitionKey() && column.isActive() || !Boolean.TRUE.equals(column.get_ValueOld("IsPartitionKey")) || partitionKeyColumns.size() != 2 && (partitionKeyColumns.size() != 1 || column.isPartitionKey()) && !this.isRangePartitionedTable(table, trxName))) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged");
        }
        if (column.isActive() && column.isPartitionKey() && partitionKeyColumns.size() == 2) {
            if (column.is_ValueChanged("PartitioningMethod")) {
                return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged");
            }
            if (column.is_ValueChanged("SeqNoPartition")) {
                int otherSeq;
                int oldSeq = column.get_ValueOldAsInt("SeqNoPartition");
                int newSeq = column.getSeqNoPartition();
                int n = otherSeq = ((MColumn)partitionKeyColumns.get(0)).getAD_Column_ID() == column.getAD_Column_ID() ? ((MColumn)partitionKeyColumns.get(1)).getSeqNoPartition() : ((MColumn)partitionKeyColumns.get(0)).getSeqNoPartition();
                if (!(newSeq < otherSeq && oldSeq < otherSeq || oldSeq > otherSeq && newSeq > otherSeq)) {
                    return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged");
                }
            }
        }
        if (column.isActive() && column.isPartitionKey() && column.getPartitioningMethod().equals("L") && this.isRangePartitionedTable(table, trxName)) {
            return Msg.getMsg((Properties)Env.getCtx(), (String)"PartitionConfigurationChanged");
        }
        return null;
    }

    public void detachPartition(MTable table, X_AD_TablePartition partition, String trxName, ProcessInfo processInfo) {
        if (partition.isPartitionAttached()) {
            String defaultPartitionName = "default_partition";
            if (partition.getParent_TablePartition_ID() > 0) {
                X_AD_TablePartition parentPartition = new X_AD_TablePartition(Env.getCtx(), partition.getParent_TablePartition_ID(), trxName);
                MColumn partitionKeyColumn = MColumn.get((int)partition.getAD_Column_ID());
                defaultPartitionName = this.getDefaultSubPartitionName(table, parentPartition, "R".equals(partitionKeyColumn.getPartitioningMethod()), trxName);
            }
            if (!defaultPartitionName.equalsIgnoreCase(partition.getName())) {
                int no;
                StringBuilder exchangeTableName = new StringBuilder(table.getTableName()).append("_").append(partition.getName());
                StringBuilder alter = null;
                Query query = new Query(Env.getCtx(), "AD_TablePartition", "Parent_TablePartition_ID=? And IsActive='Y' AND IsPartitionAttached='Y'", trxName);
                List subPartitions = query.setParameters(new Object[]{partition.getAD_TablePartition_ID()}).setOrderBy("Name").list();
                if (subPartitions.size() > 0) {
                    alter = new StringBuilder("CREATE TABLE ").append((CharSequence)exchangeTableName).append(" AS SELECT * FROM ").append(table.getTableName()).append(" WHERE ROWNUM=-1 ");
                    no = DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                    if (processInfo != null) {
                        processInfo.addLog(0, null, null, no + " " + alter.toString());
                    }
                    alter = new StringBuilder("ALTER TABLE ").append((CharSequence)exchangeTableName).append(" MODIFY PARTITION BY ");
                    MColumn subKeyColumn = MColumn.get((int)((X_AD_TablePartition)subPartitions.get(0)).getAD_Column_ID());
                    if ("R".equals(subKeyColumn.getPartitioningMethod())) {
                        alter.append("RANGE (").append(subKeyColumn.getColumnName()).append(") ");
                    } else {
                        alter.append("LIST (").append(subKeyColumn.getColumnName()).append(") ");
                    }
                    alter.append("(");
                    for (X_AD_TablePartition subPartition : subPartitions) {
                        alter.append("PARTITION ").append(subPartition.getExpressionPartition()).append(",");
                    }
                    if ("R".equals(subKeyColumn.getPartitioningMethod())) {
                        alter.append("PARTITION VALUES LESS THAN (MAXVALUE))");
                    } else {
                        alter.append("PARTITION VALUES (DEFAULT))");
                    }
                    no = DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                    if (processInfo != null) {
                        processInfo.addLog(0, null, null, no + " " + alter.toString());
                    }
                } else {
                    alter = new StringBuilder("CREATE TABLE ").append((CharSequence)exchangeTableName).append(" FOR EXCHANGE WITH TABLE ").append(table.getTableName());
                    no = DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                    if (processInfo != null) {
                        processInfo.addLog(0, null, null, no + " " + alter.toString());
                    }
                }
                alter = new StringBuilder("ALTER TABLE ").append(table.getTableName());
                if (partition.getParent_TablePartition_ID() > 0) {
                    alter.append(" EXCHANGE SUBPARTITION ");
                } else {
                    alter.append(" EXCHANGE PARTITION ");
                }
                alter.append(partition.getName()).append(" WITH TABLE ").append((CharSequence)exchangeTableName);
                no = DB.executeUpdateEx((String)alter.toString(), (String)trxName);
                if (processInfo != null) {
                    processInfo.addLog(0, null, null, no + " " + alter.toString());
                }
                partition.setIsPartitionAttached(false);
                partition.saveEx();
            } else {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CantDetachReattachDefaultPartition"));
            }
        }
    }

    public void reattachPartition(MTable table, X_AD_TablePartition partition, String trxName, ProcessInfo processInfo) {
        if (!partition.isPartitionAttached()) {
            String defaultPartitionName = "default_partition";
            if (partition.getParent_TablePartition_ID() > 0) {
                X_AD_TablePartition parentPartition = new X_AD_TablePartition(Env.getCtx(), partition.getParent_TablePartition_ID(), trxName);
                MColumn partitionKeyColumn = MColumn.get((int)partition.getAD_Column_ID());
                defaultPartitionName = this.getDefaultSubPartitionName(table, parentPartition, "R".equals(partitionKeyColumn.getPartitioningMethod()), trxName);
            }
            if (!defaultPartitionName.equalsIgnoreCase(partition.getName())) {
                StringBuilder exchangeTableName = new StringBuilder(table.getTableName()).append("_").append(partition.getName());
                StringBuilder updateStmt = new StringBuilder();
                updateStmt.append("INSERT INTO ").append(table.getTableName()).append(" ");
                updateStmt.append("SELECT * FROM ").append((CharSequence)exchangeTableName);
                int no = DB.executeUpdateEx((String)updateStmt.toString(), (String)trxName);
                if (processInfo != null) {
                    processInfo.addLog(0, null, null, no + " " + updateStmt.toString());
                }
                updateStmt = new StringBuilder("DELETE FROM ").append((CharSequence)exchangeTableName);
                no = DB.executeUpdateEx((String)updateStmt.toString(), (String)trxName);
                if (processInfo != null) {
                    processInfo.addLog(0, null, null, no + " " + updateStmt.toString());
                }
                Query query = new Query(Env.getCtx(), "AD_TablePartition", "Parent_TablePartition_ID=?", trxName);
                List subPartitions = query.setParameters(new Object[]{partition.getAD_TablePartition_ID()}).list();
                for (X_AD_TablePartition subPartition : subPartitions) {
                    subPartition.deleteEx(true);
                }
                partition.deleteEx(true);
                table.getTablePartitions(true, trxName);
                this.addPartitionAndMigrateData(table, trxName, processInfo);
                updateStmt = new StringBuilder("DROP TABLE ").append((CharSequence)exchangeTableName);
                no = DB.executeUpdateEx((String)updateStmt.toString(), (String)trxName);
                if (processInfo != null) {
                    processInfo.addLog(0, null, null, no + " " + updateStmt.toString());
                }
            } else {
                throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"CantDetachReattachDefaultPartition"));
            }
        }
    }
}

