/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HexFormat;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.OracleDriver;
import org.adempiere.db.oracle.OracleBundleActivator;
import org.adempiere.db.oracle.partition.TablePartitionService;
import org.adempiere.exceptions.DBException;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.db.partition.ITablePartitionService;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_Oracle;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Trx;

public class DB_Oracle
implements AdempiereDatabase {
    private static final String POOL_PROPERTIES = "hikaricp.properties";
    private static OracleDriver s_driver = null;
    public static final String DRIVER = "oracle.jdbc.OracleDriver";
    public static final int DEFAULT_PORT = 1521;
    public static final int DEFAULT_CM_PORT = 1630;
    private volatile String m_connectionURL;
    private volatile HikariDataSource m_ds;
    private String m_userName = null;
    private Convert m_convert = new Convert_Oracle();
    private static final CLogger log = CLogger.getCLogger(DB_Oracle.class);
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final CountDownLatch initializedLatch = new CountDownLatch(1);

    public DB_Oracle() {
        try {
            System.setProperty("oracle.jdbc.V8Compatible", "true");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage());
        }
    }

    public String getName() {
        return Database.DB_ORACLE;
    }

    public String getDescription() {
        try {
            if (s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {}
        if (s_driver != null) {
            return s_driver.toString();
        }
        return "No Driver";
    }

    public int getStandardPort() {
        return 1521;
    }

    public synchronized Driver getDriver() throws SQLException {
        if (s_driver == null) {
            System.setProperty("oracle.jdbc.TcpNoDelay", "true");
            System.setProperty("oracle.jdbc.defaultNChar", "true");
            s_driver = new OracleDriver();
            DriverManager.registerDriver((Driver)s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return s_driver;
    }

    public String getConnectionURL(CConnection connection) {
        System.setProperty("oracle.jdbc.v$session.program", "iDempiere");
        StringBuilder sb = null;
        if (connection.isBequeath()) {
            sb = new StringBuilder("jdbc:oracle:oci8:@");
        } else {
            sb = new StringBuilder("jdbc:oracle:thin:@");
            if (connection.isViaFirewall()) {
                sb.append("(DESCRIPTION=(ADDRESS_LIST=").append("(SOURCE_ROUTE=YES)").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getFwHost()).append(")(PORT=").append(connection.getFwPort()).append("))").append("(ADDRESS=(PROTOCOL=TCP)(HOST=").append(connection.getDbHost()).append(")(PORT=").append(connection.getDbPort()).append(")))").append("(CONNECT_DATA=(SERVICE_NAME=").append(connection.getDbName()).append(")))");
            } else {
                sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName());
            }
        }
        this.m_connectionURL = sb.toString();
        this.m_userName = connection.getDbUid();
        return this.m_connectionURL;
    }

    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = "jdbc:oracle:thin:@//" + dbHost + ":" + dbPort + "/" + dbName;
        return this.m_connectionURL;
    }

    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    public String getCatalog() {
        return null;
    }

    public String getSchema() {
        if (this.m_userName != null) {
            return this.m_userName.toUpperCase();
        }
        log.severe("User Name not set (yet) - call getConnectionURL first");
        return null;
    }

    public boolean supportsBLOB() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DB_Oracle[");
        sb.append(this.m_connectionURL);
        try {
            StringBuilder logBuffer = new StringBuilder();
            HikariPoolMXBean mxBean = this.m_ds.getHikariPoolMXBean();
            logBuffer.append("# Connections: ").append(mxBean.getTotalConnections());
            logBuffer.append(" , # Busy Connections: ").append(mxBean.getActiveConnections());
            logBuffer.append(" , # Idle Connections: ").append(mxBean.getIdleConnections());
            logBuffer.append(" , # Threads waiting on connection: ").append(mxBean.getThreadsAwaitingConnection());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getStatus() {
        if (this.m_ds == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        try {
            HikariPoolMXBean mxBean = this.m_ds.getHikariPoolMXBean();
            sb.append("# Connections: ").append(mxBean.getTotalConnections());
            sb.append(" , # Busy Connections: ").append(mxBean.getActiveConnections());
            sb.append(" , # Idle Connections: ").append(mxBean.getIdleConnections());
            sb.append(" , # Threads waiting on connection: ").append(mxBean.getThreadsAwaitingConnection());
            sb.append(" , # Min Pool Size: ").append(this.m_ds.getMinimumIdle());
            sb.append(" , # Max Pool Size: ").append(this.m_ds.getMaximumPoolSize());
            sb.append(" , # Open Transactions: ").append(Trx.getOpenTransactions().length);
        }
        catch (Exception exception) {}
        return sb.toString();
    }

    public String convertStatement(String oraStatement) {
        Convert.logMigrationScript((String)oraStatement, null);
        if (SystemProperties.isDBDebug()) {
            String filterOrDebug = SystemProperties.getDBDebugFilter();
            boolean print = true;
            if (filterOrDebug != null) {
                print = oraStatement.matches(filterOrDebug);
            }
            if (print) {
                log.warning("Oracle -> " + oraStatement);
            }
        }
        return oraStatement;
    }

    public boolean isSupported(String sql) {
        return true;
    }

    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    public String getSystemUser() {
        String systemUser = SystemProperties.getAdempiereDBSystemUser();
        if (systemUser == null) {
            systemUser = "system";
        }
        return systemUser;
    }

    public String getSystemDatabase(String databaseName) {
        return databaseName;
    }

    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "TRUNC(getDate())";
            }
            return "getDate()";
        }
        StringBuilder dateString = new StringBuilder("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuilder retValue = new StringBuilder("TRIM(TO_CHAR(");
        retValue.append(columnName);
        if (DisplayType.isNumeric((int)displayType)) {
            if (displayType == 12) {
                retValue.append(",'999G999G999G990D00'");
            } else {
                retValue.append(",'TM9'");
            }
            if (!Language.isDecimalPoint((String)AD_Language)) {
                retValue.append(",'NLS_NUMERIC_CHARACTERS='',.'''");
            }
        } else if (DisplayType.isDate((int)displayType)) {
            retValue.append(",'").append(Language.getLanguage((String)AD_Language).getDBdatePattern()).append("'");
        }
        retValue.append("))");
        return retValue.toString();
    }

    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision((int)displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, RoundingMode.HALF_UP);
            }
            catch (Exception exception) {}
        }
        return result.toString();
    }

    public String getJSONCast() {
        return "?";
    }

    public String TO_JSON(String value) {
        return value;
    }

    public String[] getCommands(int cmdType) {
        if (cmdType == 0) {
            return new String[0];
        }
        if (1 == cmdType) {
            return new String[0];
        }
        if (2 == cmdType) {
            return new String[0];
        }
        return null;
    }

    private String getPoolPropertiesFile() {
        Object base = Ini.getAdempiereHome();
        if (base != null && !((String)base).endsWith(File.separator)) {
            base = (String)base + File.separator;
        }
        return (String)base + this.getName() + File.separator + POOL_PROPERTIES;
    }

    public DataSource getDataSource(CConnection connection) {
        this.ensureInitialized(connection);
        return this.m_ds;
    }

    public Connection getCachedConnection(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn = null;
        if (this.m_ds == null) {
            this.getDataSource(connection);
        }
        if ((conn = this.m_ds.getConnection()).getTransactionIsolation() != transactionIsolation) {
            conn.setTransactionIsolation(transactionIsolation);
        }
        if (conn.getAutoCommit() != autoCommit) {
            conn.setAutoCommit(autoCommit);
        }
        return conn;
    }

    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    private Properties getPoolProperties() {
        Throwable throwable;
        File userPropertyFile = new File(this.getPoolPropertiesFile());
        URL propertyFileURL = null;
        if (userPropertyFile.exists() && userPropertyFile.canRead()) {
            try {
                propertyFileURL = userPropertyFile.toURI().toURL();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (propertyFileURL == null) {
            propertyFileURL = OracleBundleActivator.bundleContext.getBundle().getEntry("META-INF/pool/server.default.properties");
        }
        Properties poolProperties = new Properties();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (InputStream propertyFileInputStream = propertyFileURL.openStream();){
                poolProperties.load(propertyFileInputStream);
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception e) {
            throw new DBException(e);
        }
        if (!userPropertyFile.exists()) {
            try {
                Path directory = userPropertyFile.toPath().getParent();
                Files.createDirectories(directory, new FileAttribute[0]);
                throwable = null;
                Object var6_12 = null;
                try (InputStream propertyFileInputStream = propertyFileURL.openStream();){
                    Files.copy(propertyFileInputStream, userPropertyFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return poolProperties;
    }

    private void ensureInitialized(CConnection connection) {
        if (!this.initialized.compareAndSet(false, true)) {
            try {
                this.initializedLatch.await();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        try {
            Properties poolProperties = this.getPoolProperties();
            if (!poolProperties.containsKey("jdbcUrl")) {
                poolProperties.put("jdbcUrl", this.getConnectionURL(connection));
            }
            if (!poolProperties.containsKey("username")) {
                poolProperties.put("username", connection.getDbUid());
            }
            if (!poolProperties.containsKey("password")) {
                poolProperties.put("password", connection.getDbPwd());
            }
            HikariConfig hikariConfig = new HikariConfig(poolProperties);
            hikariConfig.setDriverClassName(DRIVER);
            this.m_ds = new HikariDataSource(hikariConfig);
            this.m_connectionURL = this.m_ds.getJdbcUrl();
            this.initializedLatch.countDown();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialise Hikari Datasource", ex);
        }
    }

    public void close() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.toString());
        }
        try {
            this.m_ds.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cleanup() {
    }

    public String getDataType(String columnName, int displayType, int precision, boolean defaultValue) {
        return DisplayType.getSQLDataType((int)displayType, (String)columnName, (int)precision);
    }

    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    public Convert getConvert() {
        return this.m_convert;
    }

    public int getNextID(String name) {
        return this.getNextID(name, null);
    }

    public int getNextID(String name, String trxName) {
        int m_sequence_id = DB.getSQLValueEx((String)trxName, (String)("SELECT " + name.toUpperCase() + ".nextval FROM DUAL"), (Object[])new Object[0]);
        return m_sequence_id;
    }

    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no;
        int cnt = DB.getSQLValueEx((String)trxName, (String)"SELECT COUNT(*) FROM USER_SEQUENCES WHERE UPPER(sequence_name)=?", (Object[])new Object[]{name.toUpperCase()});
        if (start < minvalue) {
            start = minvalue;
        }
        if (cnt == 0) {
            no = DB.executeUpdate((String)("CREATE SEQUENCE " + name.toUpperCase() + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START WITH " + start + " INCREMENT BY " + increment + " CACHE 20"), (String)trxName);
        } else {
            no = DB.executeUpdate((String)("ALTER SEQUENCE " + name.toUpperCase() + " INCREMENT BY " + increment + " MAXVALUE " + maxvalue + " CACHE 20"), (String)trxName);
            while (DB.getSQLValue((String)trxName, (String)("SELECT " + name.toUpperCase() + ".NEXTVAL FROM DUAL")) < start) {
            }
        }
        return no != -1;
    }

    public boolean isQueryTimeoutSupported() {
        return true;
    }

    public String addPagingSQL(String sql, int start, int end) {
        StringBuilder newSql = new StringBuilder(sql);
        if (start > 1) {
            newSql.append(" OFFSET ").append(start - 1).append(" ROWS");
        }
        if (end > 0) {
            newSql.append(" FETCH FIRST ").append(end - start + 1).append(" ROWS ONLY");
        }
        return newSql.toString();
    }

    public boolean isPagingSupported() {
        return true;
    }

    public boolean forUpdate(PO po, int timeout) {
        if (po.get_TrxName() == null) {
            return false;
        }
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0 && !po.is_new()) {
            ResultSet rs;
            CPreparedStatement stmt;
            block12: {
                StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
                sqlBuffer.append(keyColumns[0]).append(" FROM ").append(po.get_TableName()).append(" WHERE ");
                int i = 0;
                while (i < keyColumns.length) {
                    if (i > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keyColumns[i]).append("=?");
                    ++i;
                }
                sqlBuffer.append(" FOR UPDATE WAIT ").append(timeout > 0 ? timeout : 60);
                Object[] parameters = new Object[keyColumns.length];
                int i2 = 0;
                while (i2 < keyColumns.length) {
                    Object parameter = po.get_Value(keyColumns[i2]);
                    if (parameter != null && parameter instanceof Boolean) {
                        parameter = (Boolean)parameter != false ? "Y" : "N";
                    }
                    parameters[i2] = parameter;
                    ++i2;
                }
                stmt = null;
                rs = null;
                try {
                    stmt = DB.prepareStatement((String)sqlBuffer.toString(), (int)1003, (int)1008, (String)po.get_TrxName());
                    int i3 = 0;
                    while (i3 < keyColumns.length) {
                        stmt.setObject(i3 + 1, parameters[i3]);
                        ++i3;
                    }
                    rs = stmt.executeQuery();
                    if (!rs.next()) break block12;
                }
                catch (Exception e) {
                    try {
                        if (log.isLoggable(Level.INFO)) {
                            log.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                        }
                        throw new DBException("Could not lock record for " + po.toString() + " caused by " + e.getLocalizedMessage(), e);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs, stmt);
                        throw throwable;
                    }
                }
                DB.close((ResultSet)rs, (Statement)stmt);
                return true;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            return false;
        }
        return false;
    }

    public String getNameOfUniqueConstraintError(Exception e) {
        String info = e.getMessage();
        int fromIndex = info.indexOf(".");
        if (fromIndex == -1) {
            return info;
        }
        int toIndex = info.indexOf(")", fromIndex + 1);
        if (toIndex == -1) {
            return info;
        }
        return info.substring(fromIndex + 1, toIndex);
    }

    public String getForeignKeyConstraint(Exception e) {
        return this.getNameOfUniqueConstraintError(e);
    }

    public String subsetClauseForCSV(String columnName, String csv) {
        StringBuilder builder = new StringBuilder();
        builder.append("toTableOfVarchar2(").append(columnName).append(")");
        builder.append(" submultiset of ").append("toTableOfVarchar2(").append(DB.TO_STRING((String)csv)).append(")");
        return builder.toString();
    }

    public String intersectClauseForCSV(String columnName, String csv) {
        return this.intersectClauseForCSV(columnName, csv, false);
    }

    public String intersectClauseForCSV(String columnName, String csv, boolean isNotClause) {
        StringBuilder builder = new StringBuilder();
        builder.append("toTableOfVarchar2(").append(columnName).append(")");
        builder.append(" MULTISET INTERSECT ").append("toTableOfVarchar2(").append(DB.TO_STRING((String)csv)).append(") IS ");
        if (!isNotClause) {
            builder.append("NOT ");
        }
        builder.append("EMPTY");
        return builder.toString();
    }

    public String getNumericDataType() {
        return "NUMBER";
    }

    public String getCharacterDataType() {
        return "CHAR";
    }

    public String getVarcharDataType() {
        return "VARCHAR2";
    }

    public String getVarcharLengthSuffix() {
        return " CHAR";
    }

    public String getBlobDataType() {
        return "BLOB";
    }

    public String getClobDataType() {
        return "CLOB";
    }

    public String getJsonDataType() {
        return this.getClobDataType();
    }

    public String getTimestampDataType() {
        return "DATE";
    }

    public String getTimestampWithTimezoneDataType() {
        return "TIMESTAMP WITH TIME ZONE";
    }

    public String getSQLDDL(MColumn column) {
        StringBuilder sql = new StringBuilder().append(column.getColumnName()).append(" ").append(column.getSQLDataType());
        String defaultValue = column.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID((int)column.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText((int)column.getAD_Reference_ID()) || DisplayType.isList((int)column.getAD_Reference_ID()) || column.getAD_Reference_ID() == 20 || column.getColumnName().equals("EntityType") || column.getColumnName().equals("AD_Language") || column.getAD_Reference_ID() == 28 && !column.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING((String)defaultValue);
            }
            sql.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!column.isMandatory()) {
                sql.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        if (column.getAD_Reference_ID() == 20) {
            sql.append(" CHECK (").append(column.getColumnName()).append(" IN ('Y','N'))");
        } else if (column.getAD_Reference_ID() == 200267) {
            sql.append(" CONSTRAINT ").append(column.getAD_Table().getTableName()).append("_").append(column.getColumnName()).append("_isjson CHECK (").append(column.getColumnName()).append(" IS JSON)");
        }
        if (column.isMandatory()) {
            sql.append(" NOT NULL");
        }
        return sql.toString();
    }

    public String getSQLAdd(MTable table, MColumn column) {
        StringBuilder sql = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" ADD ").append(column.getSQLDDL());
        String constraint = column.getConstraint(table.getTableName());
        if (constraint != null && constraint.length() > 0) {
            sql.append("; ").append("ALTER TABLE ").append(table.getTableName()).append(" ADD ").append(constraint);
        }
        return sql.toString();
    }

    public String getSQLModify(MTable table, MColumn column, boolean setNullOption) {
        String defaultValue;
        StringBuilder sql = new StringBuilder();
        StringBuilder sqlBase = new StringBuilder("ALTER TABLE ").append(table.getTableName()).append(" MODIFY ").append(column.getColumnName());
        StringBuilder sqlDefault = new StringBuilder(sqlBase).append(" ").append(column.getSQLDataType());
        String originalDefaultValue = defaultValue = column.getDefaultValue();
        if (!(defaultValue == null || defaultValue.length() <= 0 || defaultValue.indexOf(64) != -1 || DisplayType.isID((int)column.getAD_Reference_ID()) && defaultValue.equals("-1"))) {
            if ((DisplayType.isText((int)column.getAD_Reference_ID()) || DisplayType.isList((int)column.getAD_Reference_ID()) || column.getAD_Reference_ID() == 20 || column.getAD_Reference_ID() == 200012 || column.getColumnName().equals("EntityType") || column.getColumnName().equals("AD_Language") || column.getAD_Reference_ID() == 28 && !column.getColumnName().endsWith("_ID")) && !defaultValue.startsWith("'") && !defaultValue.endsWith("'")) {
                defaultValue = DB.TO_STRING((String)defaultValue);
            }
            sqlDefault.append(" DEFAULT ").append(defaultValue);
        } else {
            if (!column.isMandatory()) {
                sqlDefault.append(" DEFAULT NULL ");
            }
            defaultValue = null;
        }
        sql.append((CharSequence)sqlDefault);
        if (column.getAD_Reference_ID() == 200267) {
            sql.append(" CONSTRAINT ").append(column.getAD_Table().getTableName()).append("_").append(column.getColumnName()).append("_isjson CHECK (").append(column.getColumnName()).append(" IS JSON)");
        }
        if (column.isMandatory() && defaultValue != null && defaultValue.length() > 0) {
            if (!(DisplayType.isText((int)column.getAD_Reference_ID()) || DisplayType.isList((int)column.getAD_Reference_ID()) || column.getAD_Reference_ID() == 20 || column.getAD_Reference_ID() == 200012 || column.getColumnName().equals("EntityType") || column.getColumnName().equals("AD_Language") || column.getAD_Reference_ID() == 28 && !column.getColumnName().endsWith("_ID"))) {
                defaultValue = originalDefaultValue;
            }
            StringBuilder sqlSet = new StringBuilder("UPDATE ").append(table.getTableName()).append(" SET ").append(column.getColumnName()).append("=").append(defaultValue).append(" WHERE ").append(column.getColumnName()).append(" IS NULL");
            sql.append("; ").append((CharSequence)sqlSet);
        }
        if (setNullOption) {
            StringBuilder sqlNull = new StringBuilder(sqlBase);
            if (column.isMandatory()) {
                sqlNull.append(" NOT NULL");
            } else {
                sqlNull.append(" NULL");
            }
            sql.append("; ").append((CharSequence)sqlNull);
        }
        return sql.toString();
    }

    public boolean isQueryTimeout(SQLException ex) {
        return "72000".equals(ex.getSQLState()) && ex.getErrorCode() == 1013;
    }

    public ITablePartitionService getTablePartitionService() {
        return new TablePartitionService();
    }

    public String TO_Blob(byte[] blob) {
        return "HEXTORAW('" + HexFormat.of().formatHex(blob) + "')";
    }
}

