/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.factory;

import java.util.logging.Level;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.webui.factory.IFormFactory;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.util.ADClassNameMap;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;

public class DefaultFormFactory
implements IFormFactory {
    private static final CLogger log = CLogger.getCLogger(DefaultFormFactory.class);

    @Override
    public ADForm newFormInstance(String formName) {
        Object form;
        block19: {
            form = EquinoxExtensionLocator.instance().locate(Object.class, "org.adempiere.webui.Form", formName, null).getExtension();
            if (form == null) {
                String webClassName = ADClassNameMap.get(formName);
                if (webClassName == null || webClassName.trim().length() == 0) {
                    webClassName = DefaultFormFactory.translateFormClassName(formName);
                }
                if (webClassName == null) {
                    log.warning("Web UI form not implemented for the swing form " + formName);
                } else {
                    Class<?> clazz;
                    block18: {
                        ClassLoader loader;
                        block17: {
                            loader = Thread.currentThread().getContextClassLoader();
                            clazz = null;
                            if (loader != null) {
                                try {
                                    clazz = loader.loadClass(webClassName);
                                }
                                catch (Exception e) {
                                    if (!log.isLoggable(Level.INFO)) break block17;
                                    log.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        }
                        if (clazz == null) {
                            loader = this.getClass().getClassLoader();
                            try {
                                clazz = loader.loadClass(webClassName);
                            }
                            catch (Exception e) {
                                if (!log.isLoggable(Level.INFO)) break block18;
                                log.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                    if (clazz != null) {
                        try {
                            form = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            if (!log.isLoggable(Level.WARNING)) break block19;
                            log.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
        if (form != null) {
            if (form instanceof ADForm) {
                return (ADForm)form;
            }
            if (form instanceof IFormController) {
                IFormController controller = (IFormController)form;
                ADForm adForm = controller.getForm();
                adForm.setICustomForm(controller);
                return adForm;
            }
        }
        if (log.isLoggable(Level.INFO)) {
            log.info(formName + " not found at extension registry and classpath");
        }
        return null;
    }

    private static String translateFormClassName(String originalName) {
        Class<?> clazz;
        String className;
        Object zkName = null;
        String tail = null;
        if (originalName.startsWith("org.compiere.")) {
            tail = originalName.substring("org.compiere.".length());
        } else if (originalName.startsWith("org.adempiere.")) {
            tail = originalName.substring("org.adempiere.".length());
        }
        if (tail != null) {
            zkName = "org.adempiere.webui." + tail;
            try {
                Class<?> clazz2 = ADForm.class.getClassLoader().loadClass((String)zkName);
                if (!DefaultFormFactory.isZkFormClass(clazz2)) {
                    zkName = null;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zkName = null;
            }
            if (zkName == null) {
                Object packageName = "org.adempiere.webui.";
                int lastdot = tail.lastIndexOf(".");
                className = null;
                if (lastdot >= 0) {
                    if (lastdot > 0) {
                        packageName = (String)packageName + tail.substring(0, lastdot + 1);
                    }
                    className = tail.substring(lastdot + 1);
                } else {
                    className = tail;
                }
                if (className.startsWith("V")) {
                    zkName = (String)packageName + "W" + className.substring(1);
                    try {
                        clazz = ADForm.class.getClassLoader().loadClass((String)zkName);
                        if (!DefaultFormFactory.isZkFormClass(clazz)) {
                            zkName = null;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        zkName = null;
                    }
                }
                if (zkName == null) {
                    zkName = (String)packageName + "W" + className;
                    try {
                        clazz = ADForm.class.getClassLoader().loadClass((String)zkName);
                        if (!DefaultFormFactory.isZkFormClass(clazz)) {
                            zkName = null;
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        zkName = null;
                    }
                }
            }
        }
        if (zkName == null) {
            Class<?> clazz3;
            String zkClassName;
            int lastdot = originalName.lastIndexOf(".");
            String packageName = originalName.substring(0, lastdot);
            className = originalName.substring(lastdot + 1);
            if (className.startsWith("V")) {
                zkClassName = "W" + className.substring(1);
                zkName = packageName + "." + zkClassName;
                try {
                    clazz3 = ADForm.class.getClassLoader().loadClass((String)zkName);
                    if (!DefaultFormFactory.isZkFormClass(clazz3)) {
                        zkName = null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    zkName = null;
                }
            }
            if (zkName == null) {
                zkClassName = "W" + className;
                zkName = packageName + "." + zkClassName;
                try {
                    clazz3 = ADForm.class.getClassLoader().loadClass((String)zkName);
                    if (!DefaultFormFactory.isZkFormClass(clazz3)) {
                        zkName = null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    zkName = null;
                }
            }
            if (zkName == null) {
                zkName = originalName;
                try {
                    clazz = ADForm.class.getClassLoader().loadClass((String)zkName);
                    if (!DefaultFormFactory.isZkFormClass(clazz)) {
                        zkName = null;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    zkName = null;
                }
            }
        }
        return zkName;
    }

    private static boolean isZkFormClass(Class<?> clazz) {
        return IFormController.class.isAssignableFrom(clazz) || Component.class.isAssignableFrom(clazz);
    }
}

