/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.desktop;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.part.AbstractUIPart;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.MMenu;
import org.compiere.model.MPreference;
import org.compiere.model.MQuery;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public abstract class AbstractDesktop
extends AbstractUIPart
implements IDesktop {
    private transient ClientInfo clientInfo;
    private String predefinedContextVariables;
    private boolean menuIsSOTrx;
    private boolean isCloseTabWithShortcut = true;
    private static final CLogger logger = CLogger.getCLogger(AbstractDesktop.class);

    @Override
    public void onMenuSelected(int menuId) {
        block9: {
            MMenu menu = MMenu.get((int)menuId);
            try {
                this.setPredefinedContextVariables(menu.getPredefinedContextVariables());
                this.setMenuIsSOTrx(menu.isSOTrx());
                if (menu.getAction().equals("W")) {
                    this.openWindow(menu.getAD_Window_ID(), null);
                    break block9;
                }
                if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
                    this.openProcessDialog(menu.getAD_Process_ID(), menu.isSOTrx());
                    break block9;
                }
                if (menu.getAction().equals("X")) {
                    this.openForm(menu.getAD_Form_ID());
                    break block9;
                }
                if (menu.getAction().equals("I")) {
                    this.openInfo(menu.getAD_InfoWindow_ID());
                    break block9;
                }
                if (menu.getAction().equals("F")) {
                    this.openWorkflow(menu.getAD_Workflow_ID());
                    break block9;
                }
                if (menu.getAction().equals("T")) {
                    this.openTask(menu.getAD_Task_ID());
                    break block9;
                }
                throw new ApplicationException("Menu Action not yet implemented: " + menu.getAction());
            }
            finally {
                this.setPredefinedContextVariables(null);
            }
        }
        this.updateRecentMenuItem(menuId);
    }

    @Override
    public void onNewRecord(int menuId) {
        MMenu menu = new MMenu(Env.getCtx(), menuId, null);
        this.setPredefinedContextVariables(menu.getPredefinedContextVariables());
        MQuery query = new MQuery("");
        query.addRestriction("1=2");
        query.setRecordCount(0);
        SessionManager.getAppDesktop().openWindow(menu.getAD_Window_ID(), query, new Callback<ADWindow>(){

            public void onCallback(ADWindow result) {
                if (result == null) {
                    return;
                }
                result.getADWindowContent().onNew();
                ADTabpanel adtabpanel = (ADTabpanel)result.getADWindowContent().getADTab().getSelectedTabpanel();
                adtabpanel.focusToFirstEditor(false);
            }
        });
        this.updateRecentMenuItem(menuId);
    }

    protected void updateRecentMenuItem(int menuId) {
        Runnable runnable = () -> {
            int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
            int AD_Role_ID = Env.getAD_Role_ID((Properties)Env.getCtx());
            int AD_Org_ID = 0;
            String attribute = AD_Role_ID + "|RecentMenuItems";
            Query query = new Query(Env.getCtx(), "AD_Preference", "PreferenceFor=? AND Attribute=? AND AD_Org_ID=? AND AD_User_ID=? AND AD_Window_ID=?", null);
            MPreference preference = (MPreference)query.setClient_ID().setParameters(new Object[]{"W", attribute, AD_Org_ID, AD_User_ID, 105}).first();
            if (preference == null) {
                preference = new MPreference(Env.getCtx(), 0, null);
                preference.setAD_Org_ID(AD_Org_ID);
                preference.setPreferenceFor("W");
                preference.setAttribute(attribute);
                preference.setAD_User_ID(AD_User_ID);
                preference.setValue(Integer.toString(menuId));
                preference.setAD_Window_ID(105);
                preference.saveEx();
            } else {
                String recentItemValue = preference.getValue();
                ArrayList<String> itemList = new ArrayList<String>();
                String[] recentItemValues = recentItemValue.split("[,]");
                String menuIdValue = Integer.toString(menuId);
                itemList.add(menuIdValue);
                int i = 0;
                while (itemList.size() < 7 && i < recentItemValues.length) {
                    if (!recentItemValues[i].equals(menuIdValue)) {
                        itemList.add(recentItemValues[i]);
                    }
                    ++i;
                }
                recentItemValue = itemList.stream().collect(Collectors.joining(","));
                preference.setValue(recentItemValue);
                preference.saveEx();
            }
        };
        Executions.schedule((Desktop)this.getComponent().getDesktop(), e -> runnable.run(), (Event)new Event("onUpdateRecentMenuItem"));
    }

    @Override
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    @Override
    public void setClientInfo(ClientInfo clientInfo) {
        this.clientInfo = clientInfo;
    }

    @Override
    public int registerWindow(Object win) {
        List<Object> windows = this.getWindows();
        int retValue = windows.size();
        windows.add(win);
        return retValue;
    }

    @Override
    public void unregisterWindow(int WindowNo) {
        List<Object> windows = this.getWindows();
        if (windows != null && WindowNo < windows.size()) {
            windows.set(WindowNo, null);
        }
        Env.clearWinContext((int)WindowNo);
    }

    @Override
    public Object findWindow(int WindowNo) {
        List<Object> windows = this.getWindows();
        if (windows != null && WindowNo < windows.size()) {
            return windows.get(WindowNo);
        }
        return null;
    }

    @Override
    public int findWindowNo(Component component) {
        if (component == null) {
            return -1;
        }
        List<Object> windows = this.getWindows();
        if (windows != null) {
            if (windows.contains(component)) {
                return windows.indexOf(component);
            }
            Component parent = component.getParent();
            while (parent != null) {
                if (windows.contains(parent)) {
                    return windows.indexOf(parent);
                }
                parent = parent.getParent();
            }
        }
        return -1;
    }

    @Override
    public void showWindow(Window win) {
        String pos = win.getPosition();
        this.showWindow(win, pos);
    }

    @Override
    public void showWindow(final Window win, final String pos) {
        final Window.Mode windowMode = win.getModeAttribute();
        if (Window.Mode.MODAL == windowMode) {
            if (pos != null) {
                win.setPosition(pos);
            }
            this.showModal(win);
        } else if (Executions.getCurrent() != null) {
            this.showNonModalWindow(win, pos, windowMode);
        } else {
            Executions.schedule((Desktop)this.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractDesktop.this.showNonModalWindow(win, pos, windowMode);
                }
            }, (Event)new Event("onExecute"));
        }
    }

    private void showNonModalWindow(Window win, String pos, Window.Mode mode) {
        if (Window.Mode.POPUP == mode) {
            this.showPopup(win, pos);
        } else if (Window.Mode.OVERLAPPED == mode) {
            this.showOverlapped(win, pos);
        } else if (Window.Mode.EMBEDDED == mode) {
            this.showEmbedded(win);
        } else if (Window.Mode.HIGHLIGHTED == mode) {
            this.showHighlighted(win, pos);
        }
    }

    protected abstract void showEmbedded(Window var1);

    protected void showModal(final Window win) {
        if (AdempiereWebUI.isEventThreadEnabled()) {
            win.setPage(this.page);
            win.doModal();
            win.focus();
        } else {
            if (Executions.getCurrent() != null) {
                throw new RuntimeException("When event thread is disabled, you can only show modal window in background thread that doesn't update Desktop.");
            }
            final StringBuffer buffer = new StringBuffer();
            win.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    buffer.append("*");
                }
            });
            Executions.schedule((Desktop)this.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    AbstractDesktop.this.showHighlighted(win, null);
                    if (win.getPage() == null) {
                        buffer.append("*");
                    }
                }
            }, (Event)new Event("onExecute"));
            while (buffer.length() == 0) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                }
            }
        }
    }

    protected void showPopup(Window win, String position) {
        if (position == null) {
            win.setPosition("center");
        } else {
            win.setPosition(position);
        }
        win.setPage(this.page);
        win.doPopup();
        win.focus();
    }

    protected void showOverlapped(Window win, String position) {
        if (position == null) {
            win.setPosition("center");
        } else {
            win.setPosition(position);
        }
        win.setPage(this.page);
        win.doOverlapped();
        win.focus();
    }

    protected void showHighlighted(Window win, String position) {
        if (position == null) {
            win.setPosition("center");
        } else {
            win.setPosition(position);
        }
        win.setPage(this.page);
        win.doHighlighted();
        win.focus();
    }

    protected List<Object> getWindows() {
        if (this.getComponent() == null) {
            return null;
        }
        Desktop desktop = this.getComponent().getDesktop();
        if (desktop != null) {
            Session session = desktop.getSession();
            ArrayList list = (ArrayList)session.getAttribute("windows.list");
            if (list == null) {
                list = new ArrayList();
                session.setAttribute("windows.list", list);
            }
            return Collections.synchronizedList(list);
        }
        return null;
    }

    public void setPredefinedContextVariables(String predefinedVariables) {
        this.predefinedContextVariables = predefinedVariables;
    }

    protected String getPredefinedContextVariables() {
        return this.predefinedContextVariables;
    }

    public void setMenuIsSOTrx(boolean isSOTrx) {
        this.menuIsSOTrx = isSOTrx;
    }

    protected boolean isMenuSOTrx() {
        return this.menuIsSOTrx;
    }

    @Override
    public boolean isCloseTabWithShortcut() {
        return this.isCloseTabWithShortcut;
    }

    @Override
    public void setCloseTabWithShortcut(boolean isCloseTabWithShortcut) {
        this.isCloseTabWithShortcut = isCloseTabWithShortcut;
    }
}

