/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.IProcessUI;
import org.adempiere.webui.ISupportMask;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.session.SessionManager;
import org.compiere.apps.AbstractProcessCtl;
import org.compiere.apps.IProcessParameter;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Window;

public class WProcessCtl
extends AbstractProcessCtl {
    private static final CLogger log = CLogger.getCLogger(WProcessCtl.class);

    public static void process(int WindowNo, ProcessInfo pi, Trx trx) {
        WProcessCtl.process(WindowNo, pi, trx, null);
    }

    public static void process(int WindowNo, ProcessInfo pi, Trx trx, EventListener<Event> listener) {
        ProcessModalDialog para;
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + String.valueOf(pi));
        }
        if (pi.getAD_PInstance_ID() < 1) {
            MPInstance instance = null;
            try {
                instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getTable_ID(), pi.getRecord_ID(), pi.getRecord_UU());
            }
            catch (Exception e2) {
                if (Env.isReadOnlySession()) {
                    throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"ReadOnlySession"));
                }
                pi.setSummary(e2.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
            }
            catch (Error e3) {
                pi.setSummary(e3.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
            }
            if (!instance.save()) {
                pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
                pi.setError(true);
            }
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        }
        if ((para = new ProcessModalDialog(listener, WindowNo, pi, false)).isValid()) {
            para.setVisible(true);
            Object window = SessionManager.getAppDesktop().findWindow(WindowNo);
            if (window != null && window instanceof Component && window instanceof ISupportMask) {
                final ISupportMask parent = LayoutUtils.showWindowWithMask((Window)para, (Component)window, 3);
                para.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        parent.hideMask();
                    }
                });
            } else if (window != null && window instanceof Component) {
                final Mask mask = LayoutUtils.showWindowWithMask((Window)para, (Component)window, null);
                para.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        mask.hideMask();
                    }
                });
            } else {
                para.setPosition("center");
                para.setAttribute("mode", "highlighted");
                AEnv.showWindow(para);
            }
            Executions.schedule((Desktop)para.getDesktop(), e -> para.focus(), (Event)new Event("onPostShowProcessModalDialog"));
        }
    }

    public static void process(IProcessUI aProcessUI, int WindowNo, IProcessParameter parameter, ProcessInfo pi, Trx trx) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("WindowNo=" + WindowNo + " - " + String.valueOf(pi));
        }
        MPInstance instance = null;
        if (pi.getAD_PInstance_ID() < 1) {
            try {
                instance = new MPInstance(Env.getCtx(), pi.getAD_Process_ID(), pi.getTable_ID(), pi.getRecord_ID(), pi.getRecord_UU());
            }
            catch (Exception e) {
                if (Env.isReadOnlySession()) {
                    throw new AdempiereException(Msg.getMsg((Properties)Env.getCtx(), (String)"ReadOnlySession"));
                }
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return;
            }
            catch (Error e) {
                pi.setSummary(e.getLocalizedMessage());
                pi.setError(true);
                log.warning(pi.toString());
                return;
            }
            if (!instance.save()) {
                pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoInstance"));
                pi.setError(true);
                return;
            }
            pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        } else {
            instance = new MPInstance(Env.getCtx(), pi.getAD_PInstance_ID(), null);
        }
        if (parameter != null && !parameter.saveParameters()) {
            pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessCancelled"));
            pi.setError(true);
            return;
        }
        if (pi.getRecord_UUs() != null && pi.getRecord_UUs().size() > 0) {
            ArrayList<ValueNamePair> vnps = new ArrayList<ValueNamePair>();
            for (String uuid : pi.getRecord_UUs()) {
                vnps.add(new ValueNamePair(uuid, ""));
            }
            DB.createT_SelectionNewNP((int)pi.getAD_PInstance_ID(), vnps, null);
            MPInstancePara ip = instance.createParameter(-1, "*RecordUUs*", (Object)pi.getRecord_UUs().toString());
            ip.saveEx();
        } else if (pi.getRecord_IDs() != null && pi.getRecord_IDs().size() > 0) {
            DB.createT_Selection((int)pi.getAD_PInstance_ID(), (Collection)pi.getRecord_IDs(), null);
            MPInstancePara ip = instance.createParameter(-1, "*RecordIDs*", (Object)pi.getRecord_IDs().toString());
            ip.saveEx();
        }
        WProcessCtl worker = new WProcessCtl(aProcessUI, WindowNo, pi, trx);
        worker.run();
    }

    public WProcessCtl(IProcessUI aProcessUI, int WindowNo, ProcessInfo pi, Trx trx) {
        super(aProcessUI, WindowNo, pi, trx);
    }

    protected void updateProgressWindowTimerEstimate(int estSeconds) {
    }

    protected void updateProgressWindowTitle(String title) {
    }

    protected void lock() {
        if (this.getProcessMonitor() != null) {
            this.getProcessMonitor().lockUI(this.getProcessInfo());
        }
    }

    protected void unlock() {
        if (this.getProcessMonitor() != null) {
            this.getProcessMonitor().unlockUI(this.getProcessInfo());
        }
    }
}

