/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.Properties;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.panel.ADForm;
import org.compiere.model.MPInstancePara;
import org.compiere.model.Query;
import org.compiere.model.X_AD_PInstance_Log;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Timer;
import org.zkoss.zul.Window;

@Form
public class AddAuthorizationForm
extends ADForm {
    private static final long serialVersionUID = -293618692686586645L;
    private Label labelTitle;
    private Label msgLabel;
    private Textbox msgBox;
    private ConfirmPanel confirmPanel;
    private Timer timer;
    private int pInstanceId;

    @Override
    protected void initForm() {
        this.setClosable(true);
        this.setSizable(true);
        Grid grid = GridFactory.newGridLayout();
        grid.setHeight("100%");
        grid.setWidth("100%");
        this.appendChild((Component)grid);
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        column.setWidth("5%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("30%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("60%");
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth("10%");
        columns.appendChild((Component)column);
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        row = rows.newRow();
        this.labelTitle = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Authorization_Grant_Access"));
        this.labelTitle.setStyle("font-weight: 600");
        row.appendCellChild((Component)this.labelTitle, 4);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        this.msgLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Authorization_Message"));
        this.msgLabel.setMultiline(true);
        row = rows.newRow();
        row.appendCellChild((Component)this.msgLabel, 4);
        row.getLastCell().setRowspan(7);
        this.msgLabel.setHflex("1");
        this.msgLabel.setHeight("150px");
        this.msgBox = new Textbox();
        this.msgBox.addEventListener("onChange", evt -> this.onMsgBoxChanged());
        this.msgBox.setVisible(false);
        row = rows.newRow();
        row.appendCellChild((Component)this.msgBox);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        row = rows.newRow();
        row.appendCellChild((Component)new Separator(), 4);
        row = rows.newRow();
        this.confirmPanel = new ConfirmPanel(true);
        row.appendCellChild((Component)new Space());
        row.appendCellChild((Component)this.confirmPanel, 3);
        this.confirmPanel.addActionListener("onClick", evt -> this.onConfirmPanelAction(evt));
        this.timer = new Timer();
        this.timer.setRepeats(true);
        this.timer.setDelay(100);
        this.timer.setRunning(false);
        this.appendChild((Component)this.timer);
        this.setHeight("300px");
        this.setWidth("350px");
        this.setVflex("min");
    }

    @Override
    public Window.Mode getWindowMode() {
        return Window.Mode.HIGHLIGHTED;
    }

    private void onMsgBoxChanged() {
        Clients.clearBusy();
        MPInstancePara pip = (MPInstancePara)new Query(Env.getCtx(), "AD_PInstance_Para", "AD_PInstance_ID=? AND ParameterName=?", null).setParameters(new Object[]{this.pInstanceId, "Auth_CallbackAnswer"}).first();
        X_AD_PInstance_Log pil = (X_AD_PInstance_Log)new Query(Env.getCtx(), "AD_PInstance_Log", "AD_PInstance_ID=? AND AD_Table_ID=?", null).setParameters(new Object[]{this.pInstanceId, 200272}).first();
        StringBuilder msg = new StringBuilder();
        if (!(pip != null && pip.getP_String() != null || pil != null && pil.getP_Msg() != null)) {
            if (this.msgBox.getText().startsWith("! ")) {
                msg.append(this.msgBox.getText().substring(2));
            } else {
                msg.append(this.msgBox.getText());
            }
        }
        if (pip != null && pip.getP_String() != null) {
            msg.append("\n\n").append(pip.getP_String());
        }
        if (pil != null && pil.getP_Msg() != null) {
            msg.append("\n\n").append(pil.getP_Msg());
        }
        this.msgLabel.setText(msg.toString());
        this.labelTitle.setVisible(false);
        this.confirmPanel.getButton("Ok").setEnabled(false);
        this.confirmPanel.getButton("Ok").setVisible(false);
    }

    private void onConfirmPanelAction(Event evt) {
        if (evt.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.detach();
        } else if (evt.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.confirmPanel.getButton("Ok").setEnabled(false);
            Clients.showBusy(null);
        }
    }

    public void buildClientPopupAndListener(String authURL, int pInstanceId) {
        this.pInstanceId = pInstanceId;
        StringBuilder authScript = new StringBuilder().append("(function(){let x = window.outerWidth / 2 + window.screenX - (800 / 2);\n").append("let y = window.outerHeight / 2 + window.screenY - (600 / 2);\n").append("let authWindow = window.open('").append(authURL).append("','_blank','width=800, height=600, top='+y+', left='+x);\n").append("let timer = zk.Widget.$('#").append(this.timer.getUuid()).append("');\n").append("timer.windowRef = authWindow; timer.play();").append("})()");
        this.confirmPanel.getButton("Ok").setWidgetListener("onClick", authScript.toString());
        String msgError = Msg.getMsg((Properties)Env.getCtx(), (String)"Error");
        String msgFailure = Msg.getMsg((Properties)Env.getCtx(), (String)"OAuthPopup_Failure");
        StringBuilder timerScript = new StringBuilder().append("function sleep (time) {return new Promise((resolve) => setTimeout(resolve, time));}\n").append("try {\n").append("  let t = zk.Widget.$('#").append(this.msgBox.getUuid()).append("');\n").append("  let authWindow = this.windowRef;\n").append("  if (authWindow && authWindow.closed) {\n").append("    t.setValue('! ").append(msgError).append(msgFailure).append("'); t.fireOnChange(); \n").append("    this.stop();\n").append("    return;\n").append("  }\n").append("  if (authWindow && authWindow.location) {\n").append("    if (authWindow.location.href.indexOf('/callback.jsp') >= 0) {\n").append("      this.stop();\n").append("      let url = new URL(authWindow.location.href);\n").append("      let error = url.searchParams.get('error');\n").append("      let msg = url.searchParams.get('msg');\n").append("      if (error) {\n").append("        let msg = '").append(msgError).append("'+error;\n").append("        t.setValue(msg, false); t.fireOnChange();\n").append("      } else if (msg) {\n").append("        t.setValue(msg, false); t.fireOnChange();\n").append("      }\n").append("      sleep(1500).then(() => {\n").append("        authWindow.close();\n").append("      });\n").append("    }\n").append("  } else {\n").append("    t.setValue('! ").append(msgError).append(msgFailure).append("'); t.fireOnChange(); \n").append("    this.stop();\n").append("  }\n").append("} catch(err){}\n");
        this.timer.setWidgetListener("onTimer", timerScript.toString());
    }
}

