/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MMessage;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSearchDefinition;
import org.compiere.model.MStyle;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MWindow;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.Style;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.A;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Vlayout;

public class DocumentSearchController
implements EventListener<Event> {
    private static final String WINDOW_NAME_CONTEXT_VARIABLE = "WindowName";
    private static final String ROW_NO_CONTEXT_VARIABLE = "Row";
    private static final String HEADER_OPENING_TAG = "<#header>";
    private static final String HEADER_CLOSING_TAG = "</#header>";
    private static final String FOOTER_OPENING_TAG = "<#footer>";
    private static final String FOOTER_CLOSING_TAG = "</#footer>";
    private static final String MESSAGE_LABEL_STYLE = "color: rgba(0,0,0,0.34)";
    private static final String SEARCH_RESULT = "search.result";
    private static final String ON_SEARCH_DOCUMENTS_EVENT = "onSearchDocuments";
    private int MAX_RESULTS_PER_SEARCH_IN_DOCUMENT_CONTROLLER = MSysConfig.getIntValue((String)"MAX_RESULTS_PER_SEARCH_IN_DOCUMENT_CONTROLLER", (int)3, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private Vlayout layout;
    private ArrayList<SearchResult> list;
    private int selected = -1;
    private boolean showingGuide = false;

    public void create(Component parent) {
        this.layout = new Vlayout();
        this.layout.setStyle("padding: 3px; overflow:auto;");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.layout, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.layout, "true");
        parent.appendChild((Component)this.layout);
        this.layout.addEventListener(ON_SEARCH_DOCUMENTS_EVENT, (EventListener)this);
    }

    public void search(String value) {
        if (Util.isEmpty((String)value) || value.startsWith("/") && value.indexOf(" ") < 0) {
            if (!this.showingGuide) {
                this.layout.getChildren().clear();
            }
        } else {
            this.layout.getChildren().clear();
        }
        Events.echoEvent((String)ON_SEARCH_DOCUMENTS_EVENT, (Component)this.layout, (String)value);
    }

    private void onSearchDocuments(String searchString) {
        this.list = new ArrayList();
        if (Util.isEmpty((String)searchString) || searchString.startsWith("/") && searchString.indexOf(" ") < 0) {
            if (!this.showingGuide) {
                Query query = new Query(Env.getCtx(), "AD_SearchDefinition", "TransactionCode IS NOT NULL", null);
                List definitions = query.setOnlyActiveRecords(true).setOrderBy("TransactionCode").list();
                for (MSearchDefinition definition : definitions) {
                    Label label = new Label("/" + definition.getTransactionCode() + " " + definition.getName());
                    label.setStyle(MESSAGE_LABEL_STYLE);
                    this.layout.appendChild((Component)label);
                }
                this.showingGuide = true;
            }
            return;
        }
        this.showingGuide = false;
        List<SearchResult> list = this.doSearch(searchString);
        if (list.size() == 1 && list.get(0).getRecordId() == -1) {
            Label label = new Label(list.get(0).getLabel());
            label.setStyle(MESSAGE_LABEL_STYLE);
            this.layout.appendChild((Component)label);
        } else if (list.size() > 0) {
            Collections.sort(list, new Comparator<SearchResult>(){

                @Override
                public int compare(SearchResult o1, SearchResult o2) {
                    int r = o1.getWindowName().compareTo(o2.getWindowName());
                    if (r == 0) {
                        r = o1.getAD_Message_ID() > 0 && o2.getAD_Message_ID() > 0 ? o1.getAD_Message_ID() - o2.getAD_Message_ID() : o1.getLabel().compareTo(o2.getLabel());
                    }
                    return r;
                }
            });
            String matchString = searchString.toLowerCase();
            if (searchString != null && searchString.startsWith("/") && searchString.indexOf(" ") > 1) {
                matchString = searchString.substring(searchString.indexOf(" ") + 1).toLowerCase();
            }
            String windowName = null;
            int currentMessageId = 0;
            int currentMessageCount = 0;
            StringBuilder bufferedContent = new StringBuilder();
            HashMap<Integer, Boolean> markDownMessageMap = new HashMap<Integer, Boolean>();
            HashMap<Integer, String> messageHeaderMap = new HashMap<Integer, String>();
            HashMap<Integer, String> messageFooterMap = new HashMap<Integer, String>();
            HashMap<Integer, String> messageContentMap = new HashMap<Integer, String>();
            int currentStyleId = 0;
            SearchResult previousResult = null;
            for (SearchResult result : list) {
                if (result.getAD_Message_ID() > 0) {
                    if (result.getAD_Message_ID() != currentMessageId) {
                        if (currentMessageId > 0 && bufferedContent.length() > 0) {
                            this.renderBufferedContent(bufferedContent, currentStyleId, (Boolean)markDownMessageMap.get(currentMessageId), (String)messageFooterMap.get(currentMessageId), previousResult, matchString);
                            bufferedContent = new StringBuilder();
                        }
                        this.loadMessage(result.getAD_Message_ID(), messageHeaderMap, messageFooterMap, messageContentMap, markDownMessageMap);
                        currentMessageCount = 1;
                        currentMessageId = result.getAD_Message_ID();
                        currentStyleId = result.getAD_Style_ID();
                    } else {
                        ++currentMessageCount;
                    }
                    result.setRow(currentMessageCount);
                    windowName = this.renderFormattedResult(matchString, windowName, result, currentMessageCount, bufferedContent, markDownMessageMap, messageHeaderMap, messageContentMap, messageFooterMap);
                } else {
                    windowName = this.renderSearchResult(matchString, windowName, result);
                    currentMessageId = 0;
                    currentMessageCount = 0;
                }
                previousResult = result;
            }
            if (bufferedContent.length() > 0) {
                this.renderBufferedContent(bufferedContent, currentStyleId, (Boolean)markDownMessageMap.get(currentMessageId), (String)messageFooterMap.get(currentMessageId), previousResult, matchString);
            }
            this.layout.invalidate();
        }
    }

    private void loadMessage(int AD_Message_ID, Map<Integer, String> messageHeaderMap, Map<Integer, String> messageFooterMap, Map<Integer, String> messageContentMap, Map<Integer, Boolean> markDownMessageMap) {
        int end;
        int start;
        MMessage msg = MMessage.get((Properties)Env.getCtx(), (int)AD_Message_ID);
        String msgText = Msg.getMsg((String)Env.getAD_Language((Properties)Env.getCtx()), (String)msg.getValue());
        String trimText = msgText.trim();
        boolean isMarkDown = trimText.startsWith("<#md>") && trimText.endsWith("</#md>");
        markDownMessageMap.put(AD_Message_ID, isMarkDown);
        if (isMarkDown) {
            msgText = msgText.replace("<#md>", "").replace("</#md>", "").trim();
        }
        if (msgText.indexOf(HEADER_OPENING_TAG) >= 0 && msgText.indexOf(HEADER_CLOSING_TAG) > 0) {
            start = msgText.indexOf(HEADER_OPENING_TAG);
            end = msgText.indexOf(HEADER_CLOSING_TAG, start);
            String header = msgText.substring(start + HEADER_OPENING_TAG.length(), end).trim();
            msgText = msgText.substring(end + HEADER_CLOSING_TAG.length()).trim();
            messageHeaderMap.put(AD_Message_ID, header);
        }
        if (msgText.indexOf(FOOTER_OPENING_TAG) >= 0 && msgText.indexOf(FOOTER_CLOSING_TAG) > 0) {
            start = msgText.indexOf(FOOTER_OPENING_TAG);
            end = msgText.indexOf(FOOTER_CLOSING_TAG, start);
            String footer = msgText.substring(start + FOOTER_OPENING_TAG.length(), end).trim();
            msgText = msgText.substring(0, start);
            messageFooterMap.put(AD_Message_ID, footer);
        }
        messageContentMap.put(AD_Message_ID, msgText.trim());
    }

    private String renderFormattedResult(String matchString, String windowName, SearchResult result, int currentMessageCount, StringBuilder bufferedContent, Map<Integer, Boolean> markDownMessageMap, Map<Integer, String> messageHeaderMap, Map<Integer, String> messageContentMap, Map<Integer, String> messageFooterMap) {
        String header;
        StringBuilder msgText = new StringBuilder();
        if (currentMessageCount == 1 && !Util.isEmpty((String)(header = messageHeaderMap.get(result.getAD_Message_ID())), (boolean)true)) {
            msgText.append(header).append("\n");
        }
        msgText.append(messageContentMap.get(result.getAD_Message_ID()));
        if (windowName == null || !windowName.equals(result.getWindowName())) {
            windowName = result.getWindowName();
            if (!msgText.toString().contains("@WindowName@")) {
                Label label = new Label(windowName);
                LayoutUtils.addSclass("window-name", (HtmlBasedComponent)label);
                this.layout.appendChild((Component)label);
            }
        }
        boolean isMarkdownMessage = markDownMessageMap.get(result.getAD_Message_ID());
        String formattedContent = this.parseMessageFormat(matchString, result, msgText.toString(), isMarkdownMessage);
        if (!Util.isEmpty((String)formattedContent, (boolean)true)) {
            boolean buffer;
            boolean bl = buffer = isMarkdownMessage || messageHeaderMap.containsKey(result.getAD_Message_ID()) || messageFooterMap.containsKey(result.getAD_Message_ID());
            if (!buffer) {
                this.addHtmlResult(result, formattedContent);
            } else {
                if (bufferedContent.length() > 0) {
                    bufferedContent.append("\n");
                }
                bufferedContent.append(formattedContent);
            }
        }
        return windowName;
    }

    private String parseMessageFormat(String matchString, SearchResult result, String msgText, boolean isMarkdownMessage) {
        int secondAt;
        String formattedContent = null;
        int firstAt = msgText.indexOf("@");
        int n = secondAt = firstAt >= 0 && firstAt < msgText.length() ? msgText.indexOf("@", firstAt + 1) : -1;
        if (firstAt >= 0 && secondAt > firstAt) {
            DefaultEvaluatee evaluatee = new DefaultEvaluatee((DefaultEvaluatee.DataProvider)new SearchResultDataProvider(result));
            if (!Util.isEmpty((String)matchString, (boolean)true)) {
                for (String key : result.getValueMap().keySet()) {
                    StringBuilder sb;
                    String input;
                    Object value = result.getValueMap().get(key);
                    if (value == null) {
                        result.getValueMap().put(key, "");
                        continue;
                    }
                    if (!(value instanceof String) || !this.addHighlightSpan(matchString, input = (String)value, sb = new StringBuilder())) continue;
                    result.getValueMap().put(key, sb.toString());
                }
            }
            msgText = Env.parseVariable((String)msgText, (DefaultEvaluatee)evaluatee, (boolean)false, (boolean)false);
        }
        MessageFormat mf = null;
        try {
            mf = new MessageFormat(msgText, Env.getLanguage((Properties)Env.getCtx()).getLocale());
        }
        catch (Exception e) {
            String msgValue = MMessage.get((Properties)Env.getCtx(), (int)result.getAD_Message_ID()).getValue();
            CLogger.getCLogger(this.getClass()).log(Level.SEVERE, msgValue + "=" + Msg.getMsg((String)Env.getAD_Language((Properties)Env.getCtx()), (String)msgValue), (Throwable)e);
        }
        if (mf != null) {
            Format[] fmts = mf.getFormatsByArgumentIndex();
            Object[] arguments = new Object[fmts.length];
            if (result.getValues() != null && result.getValues().length >= arguments.length) {
                int i = 0;
                while (i < arguments.length) {
                    arguments[i] = result.getValues()[i] != null ? result.getValues()[i] : "";
                    ++i;
                }
            }
            if (!Util.isEmpty((String)matchString, (boolean)true)) {
                int i = 0;
                while (i < arguments.length) {
                    StringBuilder sb;
                    String value;
                    Object object = arguments[i];
                    if (object instanceof String && this.addHighlightSpan(matchString, value = (String)object, sb = new StringBuilder())) {
                        arguments[i] = sb.toString();
                    }
                    ++i;
                }
            }
            formattedContent = mf.format(arguments);
            if (!isMarkdownMessage && formattedContent.indexOf("<#md>") >= 0 && formattedContent.indexOf("</#md>") > 0) {
                formattedContent = this.parseMarkdownInHtmlBlock(formattedContent);
            }
        }
        return formattedContent;
    }

    private boolean addHighlightSpan(String matchString, String inputString, StringBuilder sb) {
        int match = inputString.toLowerCase().indexOf(matchString);
        boolean hasMatch = false;
        while (match >= 0) {
            hasMatch = true;
            if (match > 0) {
                sb.append(inputString.substring(0, match));
                sb.append("<span class='highlight'>");
                sb.append(inputString.substring(match, match + matchString.length()));
                sb.append("</span>");
                inputString = inputString.substring(match + matchString.length());
            } else {
                sb.append("<span class='highlight'>");
                sb.append(inputString.substring(0, matchString.length()));
                sb.append("</span>");
                inputString = inputString.substring(matchString.length());
            }
            match = inputString.toLowerCase().indexOf(matchString);
        }
        if (inputString.length() > 0) {
            sb.append(inputString);
        }
        return hasMatch;
    }

    private String parseMarkdownInHtmlBlock(String content) {
        return Core.getMarkdownRenderer().renderToHtml(content);
    }

    private void addHtmlResult(SearchResult result, String content) {
        MStyle style;
        String css;
        Html resultHtml = new Html();
        resultHtml.setContent(content);
        ZkCssHelper.appendStyle((HtmlBasedComponent)resultHtml, "display:inline-block");
        Div div = new Div();
        div.setSclass("search-result-box");
        if (result != null) {
            resultHtml.setAttribute(SEARCH_RESULT, (Object)result);
            resultHtml.addEventListener("onClick", (EventListener)this);
        }
        if (result != null && result.getAD_Style_ID() > 0 && !Util.isEmpty((String)(css = (style = MStyle.get((int)result.getAD_Style_ID())).buildStyle(ThemeManager.getTheme(), (Evaluatee)new DefaultEvaluatee(), false)), (boolean)true)) {
            Style htmlStyle = new Style();
            htmlStyle.setContent("@scope {\n" + css + "\n}\n");
            div.appendChild((Component)htmlStyle);
        }
        div.appendChild((Component)resultHtml);
        this.layout.appendChild((Component)div);
    }

    private void renderBufferedContent(StringBuilder bufferedContent, int currentStyleId, Boolean markdown, String footer, SearchResult result, String matchString) {
        boolean isMarkdownMessage;
        boolean bl = isMarkdownMessage = markdown != null && markdown != false;
        if (!Util.isEmpty((String)footer, (boolean)true)) {
            String formattedContent = this.parseMessageFormat(matchString, result, footer, isMarkdownMessage);
            if (bufferedContent.length() > 0) {
                bufferedContent.append("\n");
            }
            bufferedContent.append(formattedContent);
        }
        if (isMarkdownMessage) {
            String html = Core.getMarkdownRenderer().renderToHtml(bufferedContent.toString());
            this.addBufferedHtmlResult(html, currentStyleId);
        } else {
            this.addBufferedHtmlResult(bufferedContent.toString(), currentStyleId);
        }
    }

    private void addBufferedHtmlResult(String content, int AD_Style_ID) {
        MStyle style;
        String css;
        Html resultHtml = new Html();
        resultHtml.setContent(content);
        Div div = new Div();
        div.setSclass("search-result-box");
        if (AD_Style_ID > 0 && !Util.isEmpty((String)(css = (style = MStyle.get((int)AD_Style_ID)).buildStyle(ThemeManager.getTheme(), (Evaluatee)new DefaultEvaluatee(), false)), (boolean)true)) {
            Style htmlStyle = new Style();
            htmlStyle.setContent("@scope {\n" + css + "\n}\n");
            div.appendChild((Component)htmlStyle);
        }
        div.appendChild((Component)resultHtml);
        this.layout.appendChild((Component)div);
    }

    protected String renderSearchResult(String matchString, String windowName, SearchResult result) {
        if (windowName == null || !windowName.equals(result.getWindowName())) {
            windowName = result.getWindowName();
            Label label = new Label(windowName);
            LayoutUtils.addSclass("window-name", (HtmlBasedComponent)label);
            this.layout.appendChild((Component)label);
        }
        A a2 = new A();
        a2.setAttribute(SEARCH_RESULT, (Object)result);
        this.layout.appendChild((Component)a2);
        LayoutUtils.addSclass("search-result", (HtmlBasedComponent)a2);
        a2.addEventListener("onClick", (EventListener)this);
        String label = result.getLabel();
        if (!Util.isEmpty((String)matchString, (boolean)true)) {
            int match = label.toLowerCase().indexOf(matchString);
            while (match >= 0) {
                if (match > 0) {
                    a2.appendChild((Component)new Label(label.substring(0, match)));
                    l = new Label(label.substring(match, match + matchString.length()));
                    LayoutUtils.addSclass("highlight", (HtmlBasedComponent)l);
                    a2.appendChild((Component)l);
                    label = label.substring(match + matchString.length());
                } else {
                    l = new Label(label.substring(0, matchString.length()));
                    LayoutUtils.addSclass("highlight", (HtmlBasedComponent)l);
                    a2.appendChild((Component)l);
                    label = label.substring(matchString.length());
                }
                match = label.toLowerCase().indexOf(matchString);
            }
        }
        if (label.length() > 0) {
            a2.appendChild((Component)new Label(label));
        }
        return windowName;
    }

    private List<SearchResult> doSearch(String searchString) {
        MRole role = MRole.get((Properties)Env.getCtx(), (int)Env.getAD_Role_ID((Properties)Env.getCtx()), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (boolean)true);
        this.selected = -1;
        StringBuilder whereClause = new StringBuilder();
        String transactionCode = null;
        if (searchString != null && searchString.startsWith("/") && searchString.indexOf(" ") > 1) {
            transactionCode = searchString.substring(1, searchString.indexOf(" "));
            searchString = searchString.substring(searchString.indexOf(" ") + 1);
            whereClause.append("Upper(TransactionCode) = ?");
        } else {
            whereClause.append("TransactionCode IS NULL");
        }
        Query query = new Query(Env.getCtx(), "AD_SearchDefinition", whereClause.toString(), null);
        if (transactionCode != null) {
            query.setParameters(new Object[]{transactionCode.toUpperCase()});
        }
        List definitions = query.setOnlyActiveRecords(true).list();
        for (MSearchDefinition msd : definitions) {
            ArrayList<Object> params;
            MWindow powindow;
            MWindow window;
            StringBuilder sql;
            MTable table2;
            block25: {
                block23: {
                    block24: {
                        table2 = new MTable(Env.getCtx(), msd.getAD_Table_ID(), null);
                        sql = null;
                        window = msd.getAD_Window_ID() > 0 && role.getWindowAccess(msd.getAD_Window_ID()) != null ? MWindow.get((Properties)Env.getCtx(), (int)msd.getAD_Window_ID()) : null;
                        MWindow mWindow = powindow = msd.getPO_Window_ID() > 0 && role.getWindowAccess(msd.getPO_Window_ID()) != null ? MWindow.get((Properties)Env.getCtx(), (int)msd.getPO_Window_ID()) : null;
                        if (window == null && powindow == null) continue;
                        params = new ArrayList<Object>();
                        if (!msd.getSearchType().equals("T")) break block23;
                        MColumn column = MColumn.get((Properties)Env.getCtx(), (int)msd.getAD_Column_ID());
                        sql = new StringBuilder("SELECT ").append(table2.getTableName()).append("_ID, ").append(column.getColumnName());
                        sql.append(" FROM ").append(table2.getTableName()).append(" ");
                        if (msd.getDataType().equals("I")) {
                            sql.append("WHERE ").append(column.getColumnName()).append("=?");
                        } else {
                            sql.append("WHERE UPPER(").append(column.getColumnName()).append(") LIKE UPPER(?)");
                        }
                        sql.append(" AND AD_Client_ID=@#AD_Client_ID@  ");
                        if (!msd.getDataType().equals("I")) break block24;
                        params.add(Integer.valueOf(searchString.replaceAll("\\D", "")));
                        break block25;
                    }
                    if (!msd.getDataType().equals("S")) break block25;
                    if (searchString.endsWith("%")) {
                        params.add(searchString);
                    } else {
                        params.add(searchString + "%");
                    }
                    break block25;
                }
                if (msd.getSearchType().equals("Q")) {
                    sql = new StringBuilder().append(msd.getQuery());
                    int count = 1;
                    char[] cArray = sql.toString().toCharArray();
                    int n = cArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (c == '?') {
                            ++count;
                        }
                        ++n2;
                    }
                    int i = 1;
                    while (i < count) {
                        if (msd.getDataType().equals("I")) {
                            params.add(Integer.valueOf(searchString.replaceAll("\\D", "")));
                        } else if (msd.getDataType().equals("S")) {
                            if (searchString.endsWith("%")) {
                                params.add(searchString);
                            } else {
                                params.add(searchString + "%");
                            }
                        }
                        ++i;
                    }
                }
            }
            MLookupInfo lookupInfo = MLookupFactory.getLookupInfo((Properties)Env.getCtx(), (int)-1, (int)-1, (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)(table2.getTableName() + "_ID"), (int)0, (boolean)false, null);
            MLookup lookup = new MLookup(lookupInfo, -1);
            if (sql == null) continue;
            if (powindow != null) {
                String whereCol = null;
                if (table2.columnExistsInDictionary("IsSOTrx")) {
                    whereCol = " AND IsSOTrx=";
                } else if ("C_Payment".equals(table2.getTableName())) {
                    whereCol = " AND IsReceipt=";
                }
                if (whereCol == null) {
                    this.doRetrieval(msd, sql, params, lookup, powindow, table2.getTableName(), null, this.list);
                    continue;
                }
                if (window != null) {
                    String soWhereTrx = whereCol + "'Y' ";
                    this.doRetrieval(msd, sql, params, lookup, window, table2.getTableName(), soWhereTrx, this.list);
                }
                String poWhereTrx = whereCol + "'N' ";
                this.doRetrieval(msd, sql, params, lookup, powindow, table2.getTableName(), poWhereTrx, this.list);
                continue;
            }
            if (window == null) continue;
            this.doRetrieval(msd, sql, params, lookup, window, table2.getTableName(), null, this.list);
        }
        return this.list;
    }

    private void doRetrieval(MSearchDefinition msd, StringBuilder builder, List<Object> params, MLookup lookup, MWindow window, String tableName, String extraWhereClase, List<SearchResult> list) {
        block18: {
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    boolean hasFullTextOperator;
                    Object sql = builder.toString();
                    if (!Util.isEmpty((String)extraWhereClase)) {
                        sql = (String)sql + extraWhereClase;
                    }
                    boolean bl = hasFullTextOperator = ((String)sql).indexOf("@@") >= 0;
                    if (hasFullTextOperator) {
                        sql = ((String)sql).replace("@@", "~!#$*");
                    }
                    sql = Env.parseContext((Properties)Env.getCtx(), (int)-1, (String)sql, (boolean)false, (boolean)true);
                    if (hasFullTextOperator) {
                        sql = ((String)sql).replace("~!#$*", "@@");
                    }
                    pstmt = DB.prepareStatement((String)sql, null);
                    if (params.size() > 0) {
                        DB.setParameters((PreparedStatement)pstmt, params);
                    }
                    pstmt.setQueryTimeout(1);
                    rs = pstmt.executeQuery();
                    int count = 0;
                    ResultSetMetaData metaData = null;
                    while (rs.next() && count < this.MAX_RESULTS_PER_SEARCH_IN_DOCUMENT_CONTROLLER) {
                        ++count;
                        if (metaData == null) {
                            metaData = rs.getMetaData();
                        }
                        int id = rs.getInt(1);
                        SearchResult result = new SearchResult();
                        result.setLabel(lookup.getDisplay((Object)id));
                        result.setRecordId(id);
                        result.setWindowName(window.get_Translation("Name"));
                        result.setWindowId(window.getAD_Window_ID());
                        result.setTableName(tableName);
                        if (rs.getMetaData().getColumnCount() > 1) {
                            result.setName(rs.getString(2));
                        }
                        HashMap<String, Object> valueMap = new HashMap<String, Object>();
                        valueMap.put(metaData.getColumnName(1), id);
                        ArrayList<Object> values = new ArrayList<Object>();
                        values.add(id);
                        if (metaData.getColumnCount() > 1) {
                            int i = 2;
                            while (i <= metaData.getColumnCount()) {
                                Object value = rs.getObject(i);
                                values.add(value);
                                valueMap.put(metaData.getColumnName(i), value);
                                ++i;
                            }
                        }
                        result.setValues(values.toArray());
                        result.setValueMap(valueMap);
                        if (msd.getSearchType().equals("Q") && msd.getAD_Message_ID() > 0) {
                            result.setAD_Message_ID(msd.getAD_Message_ID());
                            if (msd.getAD_Style_ID() > 0) {
                                result.setAD_Style_ID(msd.getAD_Style_ID());
                            }
                        }
                        list.add(result);
                    }
                }
                catch (SQLException e) {
                    SearchResult result = new SearchResult();
                    result.setRecordId(-1);
                    if (DB.getDatabase().isQueryTimeout(e)) {
                        result.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Timeout"));
                    } else {
                        result.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"DBExecuteError"));
                        e.printStackTrace();
                    }
                    list.add(result);
                    DB.close(rs, pstmt);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            Object object;
            if (event.getTarget().getAttribute(SEARCH_RESULT) != null && (object = event.getTarget().getAttribute(SEARCH_RESULT)) instanceof SearchResult) {
                SearchResult result = (SearchResult)object;
                this.doZoom(result);
            }
        } else if (event.getName().equals(ON_SEARCH_DOCUMENTS_EVENT)) {
            this.onSearchDocuments((String)event.getData());
        }
    }

    private void doZoom(SearchResult result) {
        MQuery query = new MQuery();
        query.addRestriction(result.getTableName() + "_ID", "=", result.getRecordId());
        AEnv.zoom(result.getWindowId(), query);
    }

    public boolean onOk(Textbox textbox) {
        String text = textbox.getText();
        if (Util.isEmpty((String)text)) {
            return false;
        }
        text = text.toLowerCase();
        int size = this.layout.getChildren().size();
        A firstStart = null;
        A exact = null;
        int i = 0;
        while (i < size) {
            if (this.layout.getChildren().get(i) instanceof A) {
                A a2 = (A)this.layout.getChildren().get(i);
                SearchResult result = (SearchResult)a2.getAttribute(SEARCH_RESULT);
                if (result.getLabel().equalsIgnoreCase(text)) {
                    exact = a2;
                    break;
                }
                if (text.equalsIgnoreCase(result.getName())) {
                    exact = a2;
                    break;
                }
                if (firstStart == null && result.getLabel().toLowerCase().startsWith(text) && text.length() >= 3) {
                    firstStart = a2;
                }
            }
            ++i;
        }
        SearchResult result = null;
        if (exact != null) {
            result = (SearchResult)exact.getAttribute(SEARCH_RESULT);
        } else if (firstStart != null) {
            result = (SearchResult)firstStart.getAttribute(SEARCH_RESULT);
        }
        if (result != null) {
            this.doZoom(result);
            return true;
        }
        return false;
    }

    public SearchResult selectPrior() {
        if (this.selected > 0) {
            --this.selected;
            SearchResult result = this.list.get(this.selected);
            List links = this.layout.getChildren();
            for (Component link : links) {
                if (!(link instanceof A)) continue;
                A a2 = (A)link;
                if (result.getLabel().equals(a2.getLabel())) {
                    a2.setSclass("document-search-current-link");
                    continue;
                }
                if (!"document-search-current-link".equals(a2.getSclass())) continue;
                a2.setSclass(null);
            }
            return result;
        }
        return null;
    }

    public SearchResult selectNext() {
        if (this.selected < this.list.size() - 1) {
            ++this.selected;
            SearchResult result = this.list.get(this.selected);
            List links = this.layout.getChildren();
            for (Component link : links) {
                if (!(link instanceof A)) continue;
                A a2 = (A)link;
                if (result.getLabel().equals(a2.getLabel())) {
                    a2.setSclass("document-search-current-link");
                    continue;
                }
                if (!"document-search-current-link".equals(a2.getSclass())) continue;
                a2.setSclass(null);
            }
            return result;
        }
        return null;
    }

    public static class SearchResult {
        private String windowName;
        private int windowId;
        private String tableName;
        private int recordId;
        private String label;
        private String name;
        private Object[] valus;
        private Map<String, Object> valueMap = null;
        private int AD_Message_ID = 0;
        private int AD_Style_ID = 0;
        private int row = -1;

        public int getWindowId() {
            return this.windowId;
        }

        public void setWindowId(int windowId) {
            this.windowId = windowId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getWindowName() {
            return this.windowName;
        }

        public void setWindowName(String windowName) {
            this.windowName = windowName;
        }

        public int getRecordId() {
            return this.recordId;
        }

        public void setRecordId(int recordId) {
            this.recordId = recordId;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValues(Object[] values) {
            this.valus = values;
        }

        public Object[] getValues() {
            return this.valus;
        }

        public void setValueMap(Map<String, Object> valueMap) {
            this.valueMap = valueMap;
        }

        public Map<String, Object> getValueMap() {
            return this.valueMap;
        }

        public void setAD_Message_ID(int AD_Message_ID) {
            this.AD_Message_ID = AD_Message_ID;
        }

        public int getAD_Message_ID() {
            return this.AD_Message_ID;
        }

        public void setAD_Style_ID(int AD_Style_ID) {
            this.AD_Style_ID = AD_Style_ID;
        }

        public int getAD_Style_ID() {
            return this.AD_Style_ID;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public int getRow() {
            return this.row;
        }
    }

    private static class SearchResultDataProvider
    implements DefaultEvaluatee.DataProvider {
        private SearchResult searchResult;

        private SearchResultDataProvider(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        public Object getValue(String columnName) {
            if (DocumentSearchController.ROW_NO_CONTEXT_VARIABLE.equals(columnName)) {
                return this.searchResult.row;
            }
            if (DocumentSearchController.WINDOW_NAME_CONTEXT_VARIABLE.equals(columnName)) {
                return this.searchResult.getWindowName();
            }
            if (this.searchResult.getValueMap().containsKey(columnName)) {
                return this.searchResult.getValueMap().get(columnName);
            }
            return null;
        }

        public Object getProperty(String propertyName) {
            return null;
        }

        public MColumn getColumn(String columnName) {
            MTable table2;
            if (this.searchResult.getValueMap().containsKey(columnName) && this.searchResult.getTableName() != null && (table2 = MTable.get((Properties)Env.getCtx(), (String)this.searchResult.getTableName())) != null) {
                return table2.getColumn(columnName);
            }
            return null;
        }

        public String getTrxName() {
            return null;
        }
    }
}

