/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.Properties;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.panel.TreeSearchPanel;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MTree_Base;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Tree;

public class ADTreePanel
extends Panel
implements EventListener<Event> {
    private static final long serialVersionUID = 2718257463734592729L;
    private static final String ON_EXPAND_MENU_EVENT = "onExpandMenu";
    private TreeSearchPanel pnlSearch;
    private Tree tree;
    private ToolBarButton expandToggle;
    private int m_windowno = -1;
    private int m_tabno = -1;
    private int AD_Tree_ID = -1;

    public ADTreePanel() {
        this.init();
    }

    public ADTreePanel(int windowno, int tabno) {
        this.m_windowno = windowno;
        this.m_tabno = tabno;
        this.init();
    }

    public boolean initTree(int AD_Tree_ID, int windowNo) {
        return this.initTree(AD_Tree_ID, windowNo, null, 0);
    }

    public boolean initTree(int AD_Tree_ID, int windowNo, String linkColName, int linkID) {
        if (this.AD_Tree_ID != AD_Tree_ID) {
            this.AD_Tree_ID = AD_Tree_ID;
            SimpleTreeModel.initADTree(this.tree, AD_Tree_ID, windowNo, linkColName, linkID);
            MTree_Base tb = MTree_Base.get((Properties)Env.getCtx(), (int)AD_Tree_ID, null);
            if (tb.isLoadAllNodesImmediately()) {
                TreeUtils.collapseTree((Component)this.tree, true);
            }
            this.pnlSearch.initialise();
            return true;
        }
        return false;
    }

    private void init() {
        this.setClientAttribute("instanceName", "treepanel");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        this.tree = new Tree();
        this.tree.setMultiple(false);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tree, "100%");
        ZKUpdateUtil.setVflex(this.tree, true);
        this.tree.setPageSize(-1);
        this.tree.setStyle("border: none");
        this.pnlSearch = new TreeSearchPanel(this.tree, "onSelect", this.m_windowno, this.m_tabno);
        Toolbar toolbar = new Toolbar();
        toolbar.setMold("panel");
        toolbar.appendChild((Component)this.pnlSearch);
        this.appendChild((Component)toolbar);
        Panelchildren pc = new Panelchildren();
        this.appendChild((Component)pc);
        pc.appendChild((Component)this.tree);
        toolbar = new Toolbar();
        toolbar.setMold("panel");
        this.expandToggle = new ToolBarButton();
        this.expandToggle.setMode("toggle");
        this.expandToggle.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"ExpandTree")));
        this.expandToggle.addEventListener("onCheck", this);
        toolbar.appendChild((Component)this.expandToggle);
        this.appendChild((Component)toolbar);
        this.addEventListener(ON_EXPAND_MENU_EVENT, this);
    }

    public void onEvent(Event event) {
        String eventName = event.getName();
        if (eventName.equals("onCheck") && event.getTarget() == this.expandToggle) {
            Clients.showBusy(null);
            Events.echoEvent((String)ON_EXPAND_MENU_EVENT, (Component)this, null);
        } else if (eventName.equals(ON_EXPAND_MENU_EVENT)) {
            this.expandOnCheck();
            Clients.clearBusy();
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public void expandAll() {
        if (!this.expandToggle.isChecked()) {
            this.expandToggle.setChecked(true);
        }
        TreeUtils.expandAll(this.tree);
    }

    public void collapseAll() {
        if (this.expandToggle.isChecked()) {
            this.expandToggle.setChecked(false);
        }
        TreeUtils.collapseAll(this.tree);
    }

    private void expandOnCheck() {
        if (this.expandToggle.isChecked()) {
            this.expandAll();
        } else {
            this.collapseAll();
        }
    }

    public void prepareForRefresh() {
        this.AD_Tree_ID = -1;
    }
}

