/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.ui.zk.media;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import org.adempiere.base.upload.IUploadHandler;
import org.adempiere.base.upload.IUploadService;
import org.adempiere.base.upload.UploadMedia;
import org.adempiere.base.upload.UploadResponse;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.report.LinkWindow;
import org.adempiere.webui.util.ReaderInputStream;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MAuthorizationAccount;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Vlayout;

public class WMediaOptions
extends Window {
    private static final long serialVersionUID = 1642315087176748005L;

    public WMediaOptions(AMedia media, Runnable preview, Map<MAuthorizationAccount, IUploadService> uploadServicesMap) {
        this.setClosable(true);
        this.setTitle(media.getName());
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 400);
        this.setPosition("center,center");
        Vlayout vlayout = new Vlayout();
        vlayout.setHflex("1");
        this.appendChild((Component)vlayout);
        Button btn = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveFile"));
        btn.setHflex("1");
        btn.setStyle("padding: 4px 8px");
        btn.addEventListener("onClick", evt -> {
            this.detach();
            Filedownload.save((Media)media);
        });
        vlayout.appendChild((Component)btn);
        this.setSclass("popup-dialog");
        vlayout.setSclass("dialog-content");
        if (preview != null) {
            btn = new Button(Msg.getMsg((Properties)Env.getCtx(), (String)"Preview"));
            btn.setHflex("1");
            btn.setStyle("padding: 4px 8px");
            btn.addEventListener("onClick", evt -> {
                this.detach();
                preview.run();
            });
            vlayout.appendChild((Component)btn);
        }
        if (uploadServicesMap != null && !uploadServicesMap.isEmpty()) {
            for (MAuthorizationAccount account : uploadServicesMap.keySet()) {
                IUploadService uploadService = uploadServicesMap.get(account);
                IUploadHandler[] handlers = uploadService.getUploadHandlers(media.getContentType());
                if (handlers == null || handlers.length <= 0) continue;
                IUploadHandler[] iUploadHandlerArray = handlers;
                int n = handlers.length;
                int n2 = 0;
                while (n2 < n) {
                    IUploadHandler handler = iUploadHandlerArray[n2];
                    btn = new Button(handler.getLabel());
                    btn.setHflex("1");
                    btn.setStyle("padding: 4px 8px");
                    btn.addEventListener("onClick", evt -> {
                        Page page = this.getPage();
                        Clients.showBusy((Component)this, (String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                        Executions.schedule((Desktop)this.getDesktop(), e -> {
                            this.uploadMedia(media, account, handler, page);
                            Clients.clearBusy((Component)this);
                            this.detach();
                        }, (Event)new Event("onUploadMedia"));
                    });
                    vlayout.appendChild((Component)btn);
                    ++n2;
                }
            }
        }
    }

    private void uploadMedia(AMedia media, MAuthorizationAccount account, IUploadHandler handler, Page page) {
        UploadResponse response = handler.uploadMedia(new UploadMedia(media.getName(), media.getContentType(), media.isBinary() ? media.getStreamData() : new ReaderInputStream(media.getReaderData(), StandardCharsets.UTF_8.name()), (long)(media.isBinary() ? media.getByteData().length : 0)), account);
        if (response != null && response.getLink() != null) {
            LinkWindow linkWindow = new LinkWindow(response.getLink(), response.getLinkLabel());
            linkWindow.setPage(page);
            linkWindow.doHighlighted();
        }
    }
}

