/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.adempiere.webui.ValuePreference;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuEvent;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;

public class WDateEditor
extends WEditor
implements ContextMenuListener {
    private static final String[] LISTENER_EVENTS = new String[]{"onChange", "onOK"};
    private static final CLogger logger = CLogger.getCLogger(WDateEditor.class);
    private Timestamp oldValue = new Timestamp(0L);

    public WDateEditor(GridField gridField) {
        this(gridField, false, null);
    }

    public WDateEditor(GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        super((Component)new Datebox(), gridField, tableEditor, editorConfiguration);
        this.init();
    }

    public WDateEditor(String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        super((Component)new Datebox(), label, description, mandatory, readonly, updateable);
        this.setColumnName("Date");
        this.init();
    }

    public WDateEditor() {
        this("Date", "Date", false, false, true);
    }

    public WDateEditor(String columnName, boolean mandatory, boolean readonly, boolean updateable, String title) {
        super((Component)new Datebox(), columnName, title, null, mandatory, readonly, updateable);
    }

    private void init() {
        this.popupMenu = new WEditorPopupMenu(false, false, this.isShowPreference());
        this.popupMenu.addMenuListener(this);
        this.addChangeLogMenu(this.popupMenu);
        if (this.gridField != null) {
            this.getComponent().setPlaceholder(this.gridField.getPlaceholder());
        }
    }

    public void onEvent(Event event) {
        if ("onChange".equalsIgnoreCase(event.getName()) || "onOK".equalsIgnoreCase(event.getName())) {
            Date date = this.getComponent().getValue();
            Timestamp newValue = null;
            if (date != null) {
                newValue = Timestamp.valueOf(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
            }
            if (this.oldValue != null && newValue != null && this.oldValue.equals(newValue)) {
                return;
            }
            if (this.oldValue == null && newValue == null) {
                return;
            }
            ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), this.oldValue, newValue);
            super.fireValueChange(changeEvent);
            this.oldValue = newValue;
        }
    }

    @Override
    public String getDisplay() {
        return this.getComponent().getText();
    }

    @Override
    public Timestamp getValue() {
        if (this.getComponent().getValue() == null) {
            return null;
        }
        return Timestamp.valueOf(this.getComponent().getValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value.toString().trim().length() == 0) {
            Timestamp currentValue = this.oldValue;
            this.oldValue = null;
            this.getComponent().setValue(null);
            if (currentValue != null) {
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, null);
                super.fireValueChange(changeEvent);
            }
        } else if (value instanceof Timestamp) {
            Timestamp currentValue = this.oldValue;
            LocalDateTime localDateTime = ((Timestamp)value).toLocalDateTime();
            this.getComponent().setValueInLocalDateTime(localDateTime);
            this.oldValue = Timestamp.valueOf(localDateTime);
            if (!Objects.equals(currentValue, this.oldValue)) {
                ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, this.oldValue);
                super.fireValueChange(changeEvent);
            }
        } else {
            try {
                Timestamp currentValue = this.oldValue;
                this.getComponent().setText(value.toString());
                this.oldValue = this.getComponent().getValue() != null ? Timestamp.valueOf(this.getComponent().getValue().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()) : null;
                if (!Objects.equals(currentValue, this.oldValue)) {
                    ValueChangeEvent changeEvent = new ValueChangeEvent(this, this.getColumnName(), currentValue, this.oldValue);
                    super.fireValueChange(changeEvent);
                }
            }
            catch (Exception exception) {}
        }
    }

    public Datebox getComponent() {
        return (Datebox)this.component;
    }

    @Override
    public boolean isReadWrite() {
        return this.getComponent().isEnabled();
    }

    @Override
    public void setReadWrite(boolean readWrite) {
        this.getComponent().setEnabled(readWrite);
    }

    @Override
    public String[] getEvents() {
        return LISTENER_EVENTS;
    }

    @Override
    public void onMenu(ContextMenuEvent evt) {
        if ("CHANGE_LOG".equals(evt.getContextEvent())) {
            WFieldRecordInfo.start(this.gridField);
        } else if ("VALUE_PREFERENCE".equals(evt.getContextEvent()) && this.gridField != null) {
            if (this.isShowPreference()) {
                ValuePreference.start((Component)this.getComponent(), this.getGridField(), this.getValue());
            }
            return;
        }
    }
}

