/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.adempiere.webui.util.SortComparator;
import org.compiere.model.GridField;
import org.compiere.model.GridTable;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListitemComparator;
import org.zkoss.zul.ext.Sortable;

public class GridTableListModel
extends AbstractListModel<Object>
implements TableModelListener,
Sortable<Object> {
    private static final long serialVersionUID = 698185856751242764L;
    private GridTable tableModel;
    private GridField[] gridField;
    private int windowNo;
    private int pageSize = -1;
    private int pageNo = 0;
    private boolean editing = false;

    public GridTableListModel(GridTable tableModel, int windowNo) {
        this.tableModel = tableModel;
        this.windowNo = windowNo;
        this.gridField = tableModel.getFields();
        tableModel.addTableModelListener((TableModelListener)this);
    }

    public Object getElementAt(int rowIndex) {
        int columnCount = this.tableModel.getColumnCount();
        Object[] values = new Object[columnCount];
        if (this.pageSize > 0) {
            rowIndex = this.pageNo * this.pageSize + rowIndex;
        }
        if (rowIndex < this.tableModel.getRowCount()) {
            int i = 0;
            while (i < columnCount) {
                values[i] = this.tableModel.getValueAt(rowIndex, i);
                ++i;
            }
        }
        return values;
    }

    public void setPage(int pg) {
        if (this.pageNo != pg) {
            int start;
            if (pg > 0 && (start = pg * this.pageSize) >= this.tableModel.getRowCount()) {
                return;
            }
            this.pageNo = pg;
            this.fireEvent(0, -1, -1);
        }
    }

    public int getPage() {
        return this.pageNo;
    }

    public void setPageSize(int pgSize) {
        this.pageSize = pgSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getSize() {
        int total = this.tableModel.getRowCount();
        if (this.pageSize <= 0) {
            return total;
        }
        if (total - this.pageNo * this.pageSize < 0) {
            this.pageNo = 0;
            return this.pageSize > total ? total : this.pageSize;
        }
        int end = (this.pageNo + 1) * this.pageSize;
        if (end > total) {
            return total - this.pageNo * this.pageSize;
        }
        return this.pageSize;
    }

    public void updateComponent(int row) {
        this.updateComponent(row, row);
    }

    public void updateComponent(int fromRow, int toRow) {
        if (Executions.getCurrent() != null) {
            this.fireEvent(0, fromRow, toRow);
        }
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        if (cmpr instanceof ListitemComparator) {
            ListitemComparator lic = (ListitemComparator)cmpr;
            this.tableModel.sort(lic.getListheader().getColumnIndex(), ascending);
        } else if (cmpr instanceof SortComparator) {
            SortComparator sc = (SortComparator)cmpr;
            this.tableModel.sort(sc.getColumnIndex(), ascending);
        }
        this.fireEvent(0, -1, -1);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (Executions.getCurrent() != null) {
            if (e.getType() == -1) {
                if (this.pageSize > 0) {
                    int pgIndex = e.getFirstRow() % this.pageSize;
                    this.fireEvent(0, pgIndex, this.getSize());
                } else {
                    this.fireEvent(2, e.getFirstRow(), e.getLastRow());
                }
            } else if (e.getType() == 1) {
                if (this.pageSize > 0) {
                    int pgIndex = e.getFirstRow() % this.pageSize;
                    this.fireEvent(0, pgIndex, this.getSize());
                } else {
                    this.fireEvent(1, e.getFirstRow(), e.getLastRow());
                }
            } else if (e.getLastRow() == Integer.MAX_VALUE) {
                this.fireEvent(0, -1, -1);
            } else if (!this.editing) {
                this.fireEvent(0, e.getFirstRow(), e.getLastRow());
            }
        }
    }

    public void setEditing(boolean b) {
        this.editing = b;
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        return "natural";
    }
}

