/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Function;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.form.MySimpleTreeNode;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.form.TreeBOM;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Center;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.West;

@Form(name="org.compiere.apps.form.VTreeBOM")
public class WTreeBOM
extends TreeBOM<MySimpleTreeNode>
implements IFormController,
EventListener<Event> {
    private int m_WindowNo = 0;
    private CustomForm m_frame = new CustomForm();
    private Tree m_tree = new Tree();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel northPanel = new Panel();
    private Panel southPanel = new Panel();
    private Label labelProduct = new Label();
    private WSearchEditor fieldProduct;
    private West west = new West();
    private Checkbox implosion = new Checkbox();
    private Label treeInfo = new Label();
    private Panel dataPane = new Panel();
    private Panel treePane = new Panel();
    private MySimpleTreeNode m_selectedNode;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private WListbox tableBOM = ListboxFactory.newDataTable();
    private Hlayout northLayout = new Hlayout();
    private Hlayout southLayout = new Hlayout();
    private MySimpleTreeNode m_root = null;
    private Checkbox treeExpand = new Checkbox();
    private Function<TreeBOM.NewNodeArguments<MySimpleTreeNode>, MySimpleTreeNode> createNewNodeFunction = a2 -> {
        MySimpleTreeNode child = a2.isLeafNode() ? new MySimpleTreeNode(a2.dataLine()) : new MySimpleTreeNode(a2.dataLine(), new ArrayList<TreeNode<Object>>());
        ((MySimpleTreeNode)((Object)((Object)a2.parentNode()))).add((TreeNode)child);
        return child;
    };

    public WTreeBOM() {
        try {
            this.m_WindowNo = this.m_frame.getWindowNo();
            this.preInit();
            this.layoutForm();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VTreeBOM.init", (Throwable)e);
        }
    }

    private void loadTableBOM() {
        Vector columnNames = this.getColumnNames();
        this.tableBOM.clear();
        ListModelTable model = new ListModelTable(this.dataBOM);
        this.tableBOM.setData(model, columnNames);
        this.setColumnClass(this.tableBOM);
    }

    private void preInit() throws Exception {
        Properties ctx = Env.getCtx();
        Language language = Language.getLoginLanguage();
        MLookup m_fieldProduct = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)MColumn.getColumn_ID((String)"M_Product", (String)"M_Product_ID"), (int)30, (Language)language, (String)"M_Product_ID", (int)0, (boolean)false, (String)" M_Product.IsSummary = 'N'");
        this.fieldProduct = new WSearchEditor("M_Product_ID", true, false, true, (Lookup)m_fieldProduct){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                this.fireValueChange(new ValueChangeEvent(this, this.getColumnName(), this.getValue(), value));
                WTreeBOM.this.confirmPanel.getButton("Refresh").setFocus(true);
            }
        };
        this.implosion.addActionListener(this);
        this.treeExpand.addActionListener(this);
    }

    private void layoutForm() {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.m_frame, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.m_frame, "100%");
        this.m_frame.setStyle("position: absolute; padding: 0; margin: 0");
        this.m_frame.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mainLayout, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        this.northPanel.appendChild((Component)this.northLayout);
        this.southPanel.appendChild((Component)this.southLayout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.southPanel, "min");
        this.labelProduct.setText(Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID"));
        this.implosion.setText(Msg.getElement((Properties)Env.getCtx(), (String)"Implosion"));
        this.treeInfo.setText(Msg.getElement((Properties)Env.getCtx(), (String)"Sel_Product_ID") + ": ");
        North north = new North();
        north.appendChild((Component)this.northPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.northPanel, "100%");
        this.mainLayout.appendChild((Component)north);
        this.northLayout.setValign("middle");
        this.northLayout.setStyle("padding: 4px;");
        this.northLayout.appendChild(this.labelProduct.rightAlign());
        if (ClientInfo.maxWidth(499)) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fieldProduct.getComponent(), "150px");
        } else if (ClientInfo.maxWidth(699)) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fieldProduct.getComponent(), "200px");
        } else if (ClientInfo.minWidth(1000)) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fieldProduct.getComponent(), "400px");
        } else {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fieldProduct.getComponent(), "300px");
        }
        this.northLayout.appendChild((Component)this.fieldProduct.getComponent());
        this.northLayout.appendChild((Component)new Space());
        this.northLayout.appendChild((Component)this.implosion);
        this.northLayout.appendChild((Component)new Space());
        this.northLayout.appendChild((Component)this.treeInfo);
        if (ClientInfo.maxWidth(699)) {
            this.treeInfo.setVisible(false);
        }
        this.treeExpand.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ExpandTree"));
        South south = new South();
        south.appendChild((Component)this.southPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)south, "min");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.southPanel, "100%");
        this.mainLayout.appendChild((Component)south);
        this.southLayout.setValign("middle");
        this.southLayout.setStyle("padding: 4px");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.southLayout, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.southLayout, "min");
        this.southLayout.appendChild((Component)this.treeExpand);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.treeExpand, "1");
        this.treeExpand.setStyle("float: left;");
        this.southLayout.appendChild((Component)this.confirmPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.confirmPanel, "1");
        this.confirmPanel.setStyle("float: right;");
        this.confirmPanel.getOKButton().setVisible(false);
        this.confirmPanel.addComponentsBeforeRight(this.confirmPanel.createButton("Refresh"));
        this.confirmPanel.addActionListener(this);
        this.mainLayout.appendChild((Component)this.west);
        this.west.setSplittable(true);
        this.west.appendChild((Component)this.treePane);
        this.treePane.appendChild((Component)this.m_tree);
        this.m_tree.setStyle("border: none;");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.west, "33%");
        this.west.setAutoscroll(true);
        this.m_tree.addEventListener("onSelect", (EventListener)this);
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.dataPane);
        this.dataPane.appendChild((Component)this.tableBOM);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.dataPane, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.dataPane, "1");
        center.setAutoscroll(true);
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Refresh") && this.getM_Product_ID() > 0) {
            this.action_loadBOM();
        }
        if (event.getTarget().getId().equals("Cancel")) {
            this.dispose();
        }
        if (event.getTarget().equals((Object)this.treeExpand)) {
            this.expandOrCollapse();
        }
        if (event.getTarget() instanceof Tree) {
            Treeitem ti = this.m_tree.getSelectedItem();
            if (ti == null) {
                log.log(Level.WARNING, "WTreeBOM.onEvent treeItem=null");
            } else {
                MySimpleTreeNode tn = (MySimpleTreeNode)((Object)ti.getValue());
                this.setSelectedNode(tn);
            }
        }
    }

    private void expandOrCollapse() {
        if (this.treeExpand.isChecked()) {
            if (this.m_tree.getTreechildren() != null) {
                TreeUtils.expandAll(this.m_tree);
            }
        } else if (this.m_tree.getTreechildren() != null) {
            TreeUtils.collapseAll(this.m_tree);
        }
    }

    private void setSelectedNode(MySimpleTreeNode nd) throws Exception {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Node = " + String.valueOf((Object)nd));
        }
        this.m_selectedNode = nd;
        if (this.m_selectedNode == null) {
            return;
        }
        Vector nodeInfo = (Vector)this.m_selectedNode.getData();
        this.m_selectedId = ((KeyNamePair)nodeInfo.elementAt(2)).getKey();
        if (this.m_selectedId > 0) {
            this.action_reloadBOM();
        }
    }

    private void action_loadBOM() throws Exception {
        int M_Product_ID = this.getM_Product_ID();
        if (M_Product_ID == 0) {
            return;
        }
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)M_Product_ID);
        this.treeInfo.setText(Msg.getElement((Properties)Env.getCtx(), (String)"Sel_Product_ID") + ": " + product.getValue());
        Vector line = this.newProductLine(product, 0, Env.ONE);
        MySimpleTreeNode parent = new MySimpleTreeNode("Root", new ArrayList<TreeNode<Object>>());
        this.m_root = new MySimpleTreeNode(line, new ArrayList<TreeNode<Object>>());
        parent.add((TreeNode)this.m_root);
        if (this.isImplosion()) {
            try {
                this.m_tree.setModel(null);
            }
            catch (Exception exception) {}
            if (this.m_tree.getTreecols() != null) {
                this.m_tree.getTreecols().detach();
            }
            if (this.m_tree.getTreefoot() != null) {
                this.m_tree.getTreefoot().detach();
            }
            if (this.m_tree.getTreechildren() != null) {
                this.m_tree.getTreechildren().detach();
            }
            this.loadBOM(product, (Object)this.m_root, this.createNewNodeFunction, true, false);
            Treecols treeCols = new Treecols();
            this.m_tree.appendChild((Component)treeCols);
            Treecol treeCol = new Treecol();
            treeCols.appendChild((Component)treeCol);
            SimpleTreeModel model = new SimpleTreeModel(parent);
            this.m_tree.setPageSize(-1);
            this.m_tree.setItemRenderer((TreeitemRenderer)model);
            this.m_tree.setModel((TreeModel)model);
        } else {
            try {
                this.m_tree.setModel(null);
            }
            catch (Exception exception) {}
            if (this.m_tree.getTreecols() != null) {
                this.m_tree.getTreecols().detach();
            }
            if (this.m_tree.getTreefoot() != null) {
                this.m_tree.getTreefoot().detach();
            }
            if (this.m_tree.getTreechildren() != null) {
                this.m_tree.getTreechildren().detach();
            }
            this.loadBOM(product, (Object)this.m_root, this.createNewNodeFunction, false, false);
            Treecols treeCols = new Treecols();
            this.m_tree.appendChild((Component)treeCols);
            Treecol treeCol = new Treecol();
            treeCols.appendChild((Component)treeCol);
            SimpleTreeModel model = new SimpleTreeModel(parent);
            this.m_tree.setPageSize(-1);
            this.m_tree.setItemRenderer((TreeitemRenderer)model);
            this.m_tree.setModel((TreeModel)model);
        }
        this.loadTableBOM();
        this.treeExpand.setChecked(false);
    }

    private void action_reloadBOM() throws Exception {
        int M_Product_ID = this.m_selectedId;
        if (M_Product_ID == 0) {
            return;
        }
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)M_Product_ID);
        this.treeInfo.setText(Msg.getElement((Properties)Env.getCtx(), (String)"Sel_Product_ID") + ": " + product.getValue());
        if (this.isImplosion()) {
            this.loadBOM(product, (Object)this.m_selectedNode, this.createNewNodeFunction, true, true);
        } else {
            this.loadBOM(product, (Object)this.m_selectedNode, this.createNewNodeFunction, false, true);
        }
        this.loadTableBOM();
    }

    private int getM_Product_ID() {
        Integer Product = (Integer)this.fieldProduct.getValue();
        if (Product == null) {
            return 0;
        }
        return Product;
    }

    private boolean isImplosion() {
        return this.implosion.isSelected();
    }

    @Override
    public ADForm getForm() {
        return this.m_frame;
    }
}

