/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.LogAuthFailure;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.BrowserToken;
import org.adempiere.webui.util.UserPreference;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.LoginWindow;
import org.compiere.Adempiere;
import org.compiere.model.MClient;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebUtil;
import org.zkoss.lang.Strings;
import org.zkoss.util.Locales;
import org.zkoss.zhtml.Div;
import org.zkoss.zhtml.Form;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuFocus;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Checkbox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Image;

public class LoginPanel
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -7859522563172088496L;
    public static final String ROLE_TYPES_WEBUI = "NULL,ZK,SS";
    private static LogAuthFailure logAuthFailure = new LogAuthFailure();
    private static final String ON_LOAD_TOKEN = "onLoadToken";
    private static final CLogger logger = CLogger.getCLogger(LoginPanel.class);
    protected Properties ctx;
    protected Label lblUserId;
    protected Label lblPassword;
    protected Label lblLanguage;
    protected Label lblLogin;
    protected Textbox txtUserId;
    protected Textbox txtPassword;
    protected Combobox lstLanguage;
    protected LoginWindow wndLogin;
    protected Checkbox chkRememberMe;
    protected Checkbox chkSelectRole;
    protected A btnResetPassword;
    protected ConfirmPanel pnlButtons;
    protected boolean email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
    protected String validLstLanguage = null;
    private int failures = 0;

    public LoginPanel(Properties ctx, LoginWindow loginWindow) {
        this.ctx = ctx;
        this.wndLogin = loginWindow;
        this.initComponents();
        this.init();
        this.setId("loginPanel");
        this.setSclass("login-box");
        this.txtUserId.setEnabled(false);
        this.txtPassword.setEnabled(false);
        this.lstLanguage.setEnabled(false);
        Events.echoEvent((String)ON_LOAD_TOKEN, (Component)this, null);
        this.addEventListener(ON_LOAD_TOKEN, this);
    }

    private void init() {
        this.createUI();
        this.txtUserId.addEventListener("onUserToken", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                block7: {
                    String[] data = (String[])event.getData();
                    try {
                        MSession session;
                        int AD_Session_ID = Integer.parseInt(data[0]);
                        int cnt = DB.getSQLValueEx(null, (String)"SELECT COUNT(*) FROM AD_Session WHERE AD_Session_ID=?", (Object[])new Object[]{AD_Session_ID});
                        if (cnt == 1 && (session = new MSession(Env.getCtx(), AD_Session_ID, null)).get_ID() == AD_Session_ID) {
                            String token;
                            int AD_User_ID = session.getCreatedBy();
                            MUser user = MUser.get((Properties)Env.getCtx(), (int)AD_User_ID);
                            if (user != null && user.get_ID() == AD_User_ID && BrowserToken.validateToken(session, user, token = data[1])) {
                                LoginPanel.this.onUserIdChange(AD_User_ID);
                                if (MSystem.isZKRememberUserAllowed()) {
                                    MClient client;
                                    Object fillUser = null;
                                    fillUser = LoginPanel.this.email_login ? user.getEMail() : (user.getLDAPUser() != null && user.getLDAPUser().length() > 0 ? user.getLDAPUser() : user.getName());
                                    if (MSystem.isUseLoginPrefix() && !Util.isEmpty((String)(client = MClient.get((int)session.getAD_Client_ID())).getLoginPrefix())) {
                                        String separator = MSysConfig.getValue((String)"LOGIN_PREFIX_SEPARATOR", (String)"/");
                                        fillUser = client.getLoginPrefix() + separator + (String)fillUser;
                                    }
                                    LoginPanel.this.txtUserId.setValue((String)fillUser);
                                    LoginPanel.this.chkRememberMe.setChecked(true);
                                }
                                if (MSystem.isZKRememberPasswordAllowed()) {
                                    LoginPanel.this.txtPassword.setValue(token);
                                    LoginPanel.this.txtPassword.setAttribute("user.token.hash", token);
                                    LoginPanel.this.txtPassword.setAttribute("user.token.sid", AD_Session_ID);
                                }
                                LoginPanel.this.chkSelectRole.setChecked(false);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.INFO)) break block7;
                        logger.log(Level.INFO, e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        });
        List<String> browserLanguages = this.browserLanguages(Executions.getCurrent().getHeader("accept-language"));
        String defaultSystemLanguage = MClient.get((Properties)this.ctx, (int)0).getAD_Language();
        if (!browserLanguages.contains(defaultSystemLanguage)) {
            browserLanguages.add(defaultSystemLanguage);
        }
        boolean found = false;
        for (String browserLanguage : browserLanguages) {
            int i = 0;
            while (i < this.lstLanguage.getItemCount()) {
                Comboitem li = this.lstLanguage.getItemAtIndex(i);
                String lang = (String)li.getValue();
                if (lang.startsWith(browserLanguage)) {
                    this.lstLanguage.setSelectedIndex(i);
                    this.languageChanged(li.getLabel());
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) break;
        }
        this.txtUserId.removeEventListener("onFocus", this.txtUserId);
        this.txtPassword.removeEventListener("onFocus", this.txtPassword);
    }

    protected void createUI() {
        Form form = new Form();
        Div div = new Div();
        div.setSclass("login-box-header");
        this.lblLogin = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"LoginHeader"));
        this.lblLogin.setSclass("login-box-header-txt");
        div.appendChild((Component)this.lblLogin);
        form.appendChild((Component)div);
        Table table = new Table();
        table.setId("grdLogin");
        table.setDynamicProperty("cellpadding", (Object)"0");
        table.setDynamicProperty("cellspacing", (Object)"5");
        table.setSclass("login-box-body");
        form.appendChild((Component)table);
        Tr tr = new Tr();
        table.appendChild((Component)tr);
        Td td = new Td();
        td.setSclass("login-box-header-logo");
        tr.appendChild((Component)td);
        td.setDynamicProperty("colspan", (Object)"2");
        Image image = new Image();
        image.setSrc(ThemeManager.getLargeLogo());
        td.appendChild((Component)image);
        tr = new Tr();
        tr.setId("rowUser");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblUserId);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtUserId);
        tr = new Tr();
        tr.setId("rowPassword");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblPassword);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtPassword);
        tr = new Tr();
        tr.setId("rowLanguage");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblLanguage);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstLanguage);
        tr = new Tr();
        tr.setId("rowSelectRole");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)new Label(""));
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.chkSelectRole);
        if (MSystem.isZKRememberUserAllowed()) {
            tr = new Tr();
            tr.setId("rowRememberMe");
            table.appendChild((Component)tr);
            td = new Td();
            tr.appendChild((Component)td);
            td.setSclass("login-label");
            td.appendChild((Component)new Label(""));
            td = new Td();
            td.setSclass("login-field");
            tr.appendChild((Component)td);
            td.appendChild((Component)this.chkRememberMe);
        }
        if (MSysConfig.getBooleanValue((String)"LOGIN_SHOW_RESETPASSWORD", (boolean)true)) {
            tr = new Tr();
            tr.setId("rowResetPassword");
            table.appendChild((Component)tr);
            td = new Td();
            tr.appendChild((Component)td);
            td.setSclass("login-label");
            td.appendChild((Component)new Label(""));
            td = new Td();
            td.setSclass("login-field");
            tr.appendChild((Component)td);
            td.appendChild((Component)this.btnResetPassword);
            this.btnResetPassword.addEventListener("onClick", (EventListener)this);
        }
        div = new Div();
        div.setSclass("login-box-footer");
        this.pnlButtons = new ConfirmPanel(false, false, false, false, false, false, true);
        this.pnlButtons.addActionListener(this);
        Button okBtn = this.pnlButtons.getButton("Ok");
        okBtn.setWidgetListener("onClick", "zAu.cmd0.showBusy(null)");
        okBtn.addCallback("afterPageDetached", (Callback & Serializable)t -> {
            String string = ((AbstractComponent)t).setWidgetListener("onClick", null);
        });
        Button helpButton = this.pnlButtons.createButton("Help");
        helpButton.addEventListener("onClick", this);
        helpButton.addSclass("login-btn");
        this.pnlButtons.addComponentsRight(helpButton);
        LayoutUtils.addSclass("login-box-footer-pnl", (HtmlBasedComponent)this.pnlButtons);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.pnlButtons, null);
        this.pnlButtons.getButton("Ok").addSclass("login-btn");
        div.appendChild((Component)this.pnlButtons);
        form.appendChild((Component)div);
        this.appendChild((Component)form);
    }

    private void initComponents() {
        String[] availableLanguages;
        this.lblUserId = new Label();
        this.lblUserId.setId("lblUserId");
        this.lblUserId.setValue("User ID");
        this.lblPassword = new Label();
        this.lblPassword.setId("lblPassword");
        this.lblPassword.setValue("Password");
        this.lblLanguage = new Label();
        this.lblLanguage.setId("lblLanguage");
        this.lblLanguage.setValue("Language");
        this.txtUserId = new Textbox();
        this.txtUserId.setId("txtUserId");
        this.txtUserId.setCols(25);
        this.txtUserId.setMaxlength(40);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtUserId, "220px");
        this.txtUserId.setClientAttribute("autocomplete", "username");
        this.txtPassword = new Textbox();
        this.txtPassword.setId("txtPassword");
        this.txtPassword.setType("password");
        this.txtPassword.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtPassword, "220px");
        if (MSysConfig.getBooleanValue((String)"ZK_LOGIN_ALLOW_CHROME_SAVE_PASSWORD", (boolean)true)) {
            this.txtPassword.setClientAttribute("autocomplete", "current-password");
        }
        this.lstLanguage = new Combobox();
        this.lstLanguage.setAutocomplete(true);
        this.lstLanguage.setAutodrop(true);
        this.lstLanguage.setId("lstLanguage");
        this.lstLanguage.addEventListener("onSelect", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstLanguage, "220px");
        this.lstLanguage.getItems().clear();
        ArrayList supported = Env.getLoginLanguages();
        String[] stringArray = availableLanguages = Language.getNames();
        int n = availableLanguages.length;
        int n2 = 0;
        while (n2 < n) {
            String langName = stringArray[n2];
            Language language = Language.getLanguage((String)langName);
            if (supported.contains(language.getAD_Language())) {
                this.lstLanguage.appendItem(langName, language.getAD_Language());
            }
            ++n2;
        }
        this.chkRememberMe = new Checkbox(Msg.getMsg((String)Language.getBaseAD_Language(), (String)"RememberMe"));
        this.chkRememberMe.setId("chkRememberMe");
        this.chkSelectRole = new Checkbox(Msg.getMsg((String)Language.getBaseAD_Language(), (String)"SelectRole"));
        this.chkSelectRole.setId("chkSelectRole");
        this.btnResetPassword = new A(Msg.getMsg((String)Language.getBaseAD_Language(), (String)"ForgotMyPassword"));
        this.btnResetPassword.setId("btnResetPassword");
        if (this.lstLanguage.getItems().size() > 0) {
            this.validLstLanguage = ((Comboitem)this.lstLanguage.getItems().get(0)).getLabel();
        }
    }

    public void onEvent(Event event) {
        Component eventComp = event.getTarget();
        if (event.getTarget().getId().equals("Ok")) {
            this.validateLogin();
        } else if (event.getTarget().getId().equals("Help")) {
            this.openLoginHelp();
        } else if (event.getName().equals("onSelect")) {
            if (eventComp.getId().equals(this.lstLanguage.getId())) {
                if (this.lstLanguage.getSelectedItem() == null) {
                    this.lstLanguage.setValue(this.validLstLanguage);
                } else {
                    this.validLstLanguage = this.lstLanguage.getSelectedItem().getLabel();
                }
                this.languageChanged(this.validLstLanguage);
            }
        } else if (event.getTarget() == this.btnResetPassword) {
            this.btnResetPasswordClicked();
        } else if (event.getName().equals(ON_LOAD_TOKEN)) {
            BrowserToken.load((Component)this.txtUserId);
            this.txtUserId.setEnabled(true);
            this.txtPassword.setEnabled(true);
            this.lstLanguage.setEnabled(true);
            AuFocus auf = new AuFocus((Component)this.txtUserId);
            Clients.response((AuResponse)auf);
        }
    }

    private void openLoginHelp() {
        String lang = (String)this.lstLanguage.getSelectedItem().getValue();
        lang = lang.substring(0, 2);
        String helpURL = MSysConfig.getValue((String)"LOGIN_HELP_URL", (String)"https://wiki.idempiere.org/{lang}/Login_Help");
        if (helpURL.contains("{lang}")) {
            String rawURL = helpURL;
            helpURL = Util.replace((String)rawURL, (String)"{lang}", (String)lang);
            if (!"en".equals(lang) && !WebUtil.isUrlOk((String)helpURL)) {
                helpURL = Util.replace((String)rawURL, (String)"{lang}", (String)"en");
            }
        }
        try {
            Executions.getCurrent().sendRedirect(helpURL, "_blank");
        }
        catch (Exception e) {
            String message = e.getMessage();
            Dialog.warn(0, "URLnotValid", message, null);
        }
    }

    private void onUserIdChange(int AD_User_ID) {
        String userName = this.txtUserId.getValue();
        if (userName != null && userName.length() > 0 && AD_User_ID < 0) {
            String column = this.email_login ? "EMail" : "COALESCE(LDAPUser,Name)";
            List users = new Query(Env.getCtx(), "AD_User", "Password IS NOT NULL AND IsActive='Y' AND " + column + "=?", null).setParameters(new Object[]{userName}).list();
            if (users.size() == 1) {
                AD_User_ID = ((MUser)users.get(0)).getAD_User_ID();
            }
        }
        if (AD_User_ID >= 0) {
            UserPreference userPreference = SessionManager.getSessionApplication().loadUserPreference(AD_User_ID);
            String initDefault = userPreference.getProperty("Language");
            int i = 0;
            while (i < this.lstLanguage.getItemCount()) {
                Comboitem li = this.lstLanguage.getItemAtIndex(i);
                if (li.getLabel().equals(initDefault) || li.getValue().equals(initDefault)) {
                    this.lstLanguage.setSelectedIndex(i);
                    this.languageChanged(li.getLabel());
                    break;
                }
                ++i;
            }
        }
    }

    private void languageChanged(String langName) {
        Language language = this.findLanguage(langName);
        if (this.email_login) {
            this.lblUserId.setValue(Msg.getMsg((Language)language, (String)"EMail"));
        } else {
            this.lblUserId.setValue(Msg.getMsg((Language)language, (String)"User"));
        }
        this.lblPassword.setValue(Msg.getMsg((Language)language, (String)"Password"));
        this.lblLanguage.setValue(Msg.getMsg((Language)language, (String)"Language"));
        this.chkRememberMe.setLabel(Msg.getMsg((Language)language, (String)"RememberMe"));
        this.chkSelectRole.setLabel(Msg.getMsg((Language)language, (String)"SelectRole"));
        this.btnResetPassword.setLabel(Msg.getMsg((Language)language, (String)"ForgotMyPassword"));
        this.lblLogin.setValue(Msg.getMsg((Language)language, (String)"LoginHeader"));
        this.pnlButtons.getButton("Ok").setLabel(Util.cleanAmp((String)Msg.getMsg((Language)language, (String)"Ok")));
        this.pnlButtons.getButton("Help").setLabel(Util.cleanAmp((String)Msg.getMsg((Language)language, (String)"Help")));
    }

    private Language findLanguage(String langName) {
        Language tmp = Language.getLanguage((String)langName);
        Language language = new Language(tmp.getName(), tmp.getAD_Language(), tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        Env.verifyLanguage((Properties)this.ctx, (Language)language);
        Env.setContext((Properties)this.ctx, (String)"#AD_Language", (String)language.getAD_Language());
        Env.setContext((Properties)this.ctx, (String)"#Locale", (String)language.getLocale().toString());
        Locale locale = language.getLocale();
        try {
            Clients.reloadMessages((Locale)locale);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
        Locales.setThreadLocal((Locale)locale);
        return language;
    }

    public void validateLogin() {
        MUser user;
        Login login = new Login(this.ctx);
        String userId = this.txtUserId.getValue();
        String userPassword = this.txtPassword.getValue();
        String token = (String)this.txtPassword.getAttribute("user.token.hash");
        if (token != null && token.equals(userPassword)) {
            userPassword = "";
            int AD_Session_ID = (Integer)this.txtPassword.getAttribute("user.token.sid");
            MSession session = new MSession(Env.getCtx(), AD_Session_ID, null);
            if (session.get_ID() == AD_Session_ID && BrowserToken.validateToken(session, user = MUser.get((Properties)Env.getCtx(), (int)session.getCreatedBy()), token)) {
                userPassword = user.getPassword();
            }
        }
        Session currSess = Executions.getCurrent().getDesktop().getSession();
        KeyNamePair[] clientsKNPairs = login.getClients(userId, userPassword, ROLE_TYPES_WEBUI);
        if (clientsKNPairs == null || clientsKNPairs.length == 0) {
            String x_Forward_IP;
            String loginErrMsg = login.getLoginErrMsg();
            if (Util.isEmpty((String)loginErrMsg)) {
                loginErrMsg = Msg.getMsg((Properties)this.ctx, (String)"FailedLogin", (boolean)true);
            }
            if ((x_Forward_IP = Executions.getCurrent().getHeader("X-Forwarded-For")) == null) {
                x_Forward_IP = Executions.getCurrent().getRemoteAddr();
            }
            logAuthFailure.log(x_Forward_IP, "/webui", userId, loginErrMsg);
            try {
                Thread.sleep(this.failures * 2000);
            }
            catch (InterruptedException interruptedException) {}
            ++this.failures;
            Clients.clearBusy();
            throw new WrongValueException(loginErrMsg);
        }
        if (clientsKNPairs.length == 1) {
            Env.setContext((Properties)Env.getCtx(), (String)"#AD_Client_ID", (String)clientsKNPairs[0].getID());
            user = MUser.get((Properties)Env.getCtx(), (String)Login.getAppUser((String)userId));
            if (user != null) {
                Env.setContext((Properties)Env.getCtx(), (String)"#AD_User_ID", (int)user.getAD_User_ID());
            }
        }
        String langName = null;
        langName = this.lstLanguage.getSelectedItem() != null ? this.lstLanguage.getSelectedItem().getLabel() : Language.getBaseLanguage().getName();
        Language language = this.findLanguage(langName);
        Env.setContext((Properties)this.ctx, (String)"#LanguageName", (String)language.getName());
        if (login.isPasswordExpired()) {
            this.wndLogin.changePassword(userId, userPassword, this.chkSelectRole.isChecked(), clientsKNPairs);
        } else {
            this.wndLogin.loginOk(userId, this.chkSelectRole.isChecked(), clientsKNPairs);
        }
        Locale locale = language.getLocale();
        currSess.setAttribute("org.zkoss.web.preferred.locale", (Object)locale);
        try {
            Clients.reloadMessages((Locale)locale);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
        }
        Locales.setThreadLocal((Locale)locale);
        String timeoutText = this.getUpdateTimeoutTextScript();
        if (!Strings.isEmpty((String)timeoutText)) {
            Clients.response((String)"browserTimeoutScript", (AuResponse)new AuScript(null, timeoutText));
        }
        currSess.setAttribute("Check_AD_User_ID", (Object)Env.getAD_User_ID((Properties)this.ctx));
        String version = DB.getSQLValueString(null, (String)"SELECT Version FROM AD_System", (Object[])new Object[0]);
        if (!Adempiere.DB_VERSION.equals(version)) {
            String AD_Message = "DatabaseVersionError";
            String msg = Msg.getMsg((Properties)this.ctx, (String)AD_Message, (Object[])new Object[]{Adempiere.DB_VERSION, version});
            throw new ApplicationException(msg);
        }
    }

    private String getUpdateTimeoutTextScript() {
        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"SessionTimeoutText").trim();
        String continueNsg = Msg.getMsg((Properties)Env.getCtx(), (String)"continue").trim();
        if (msg == null || msg.equals("SessionTimeoutText")) {
            return null;
        }
        msg = Strings.escape((String)msg, (String)"\"");
        String s = "adempiere.set(\"zkTimeoutText\", \"" + msg + "\");";
        s = s + " adempiere.set(\"zkContinueText\", \"" + continueNsg + "\");";
        return s;
    }

    private void btnResetPasswordClicked() {
        List users;
        String userId = Login.getAppUser((String)this.txtUserId.getValue());
        if (Util.isEmpty((String)userId)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.ctx, (String)"FillMandatory") + " " + this.lblUserId.getValue());
        }
        boolean email_login = MSysConfig.getBooleanValue((String)"USE_EMAIL_FOR_LOGIN", (boolean)false);
        StringBuilder whereClause = new StringBuilder("Password IS NOT NULL AND ");
        if (email_login) {
            whereClause.append("EMail=?");
        } else {
            whereClause.append("COALESCE(LDAPUser,Name)=?");
        }
        whereClause.append(" AND").append(" EXISTS (SELECT * FROM AD_User_Roles ur").append("         INNER JOIN AD_Role r ON (ur.AD_Role_ID=r.AD_Role_ID)").append("         WHERE ur.AD_User_ID=AD_User.AD_User_ID AND ur.IsActive='Y' AND r.IsActive='Y') AND ").append(" EXISTS (SELECT * FROM AD_Client c").append("         WHERE c.AD_Client_ID=AD_User.AD_Client_ID").append("         AND c.IsActive='Y') AND ").append(" AD_User.IsActive='Y'").append(" AND AD_User.SecurityQuestion IS NOT NULL").append(" AND AD_User.Answer IS NOT NULL");
        try {
            PO.setCrossTenantSafe();
            users = new Query(this.ctx, "AD_User", whereClause.toString(), null).setParameters(new Object[]{userId}).setOrderBy("AD_User_ID").list();
        }
        finally {
            PO.clearCrossTenantSafe();
        }
        this.wndLogin.resetPassword(userId, users.size() == 0);
    }

    private List<String> browserLanguages(String header) {
        ArrayList<String> arrstr = new ArrayList<String>();
        if (header == null) {
            return arrstr;
        }
        String[] stringArray = header.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] arr;
            String str = stringArray[n2];
            String[] stringArray2 = arr = str.trim().replace("-", "_").split(";");
            int n3 = arr.length;
            int n4 = 0;
            while (n4 < n3) {
                String s = stringArray2[n4];
                if (!(s = s.trim()).startsWith("q=")) {
                    if (s.contains("_") && s.length() == 5) {
                        String baselang = s.substring(0, 2).toLowerCase();
                        StringBuffer lang = new StringBuffer(baselang).append("_").append(s.substring(3).toUpperCase());
                        if (!arrstr.contains(lang.toString())) {
                            arrstr.add(lang.toString());
                        }
                        if (!arrstr.contains(baselang)) {
                            arrstr.add(baselang);
                        }
                    } else if (s.length() == 2 && !arrstr.contains(s.toLowerCase())) {
                        arrstr.add(s.toLowerCase());
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return arrstr;
    }
}

