/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.report.jasper;

import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.HtmlExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.ooxml.JRXlsxExporter;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFiller;
import net.sf.jasperreports.engine.fill.JRSwapFileVirtualizer;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSwapFile;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.ReportExportConfiguration;
import net.sf.jasperreports.export.SimpleCsvExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterConfiguration;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleHtmlExporterOutput;
import net.sf.jasperreports.export.SimpleHtmlReportConfiguration;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.export.SimpleTextExporterConfiguration;
import net.sf.jasperreports.export.SimpleWriterExporterOutput;
import net.sf.jasperreports.export.SimpleXlsReportConfiguration;
import net.sf.jasperreports.export.SimpleXlsxReportConfiguration;
import net.sf.jasperreports.export.SimpleXmlExporterOutput;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.report.jasper.AttachmentResourceLoader;
import org.adempiere.report.jasper.BundleResourceLoader;
import org.adempiere.report.jasper.ClassResourceLoader;
import org.adempiere.report.jasper.ColumnLookup;
import org.adempiere.report.jasper.FileResourceLoader;
import org.adempiere.report.jasper.JREventManage;
import org.adempiere.report.jasper.JRViewerProvider;
import org.adempiere.report.jasper.JRViewerProviderList;
import org.adempiere.report.jasper.MsgResourceBundle;
import org.adempiere.report.jasper.WebResourceLoader;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MLanguage;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.model.SystemProperties;
import org.compiere.print.MPrintFormat;
import org.compiere.print.PrintUtil;
import org.compiere.process.ClientProcess;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.tools.FileUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;

public class ReportStarter
implements ProcessCall,
ClientProcess {
    public static final String IDEMPIERE_REPORT_TYPE = "IDEMPIERE_REPORT_TYPE";
    private static final String SUBREPORT_DIR = "SUBREPORT_DIR";
    private static final String COLUMN_LOOKUP = "COLUMN_LOOKUP";
    private static final String CURRENT_LANG = "CURRENT_LANG";
    private static final String RESOURCE_DIR = "RESOURCE_DIR";
    private static final int DEFAULT_SWAP_MAX_PAGES = 100;
    private static final CLogger log = CLogger.getCLogger(ReportStarter.class);
    private static File REPORT_HOME = null;
    private static final JasperReportsContext jasperReportContext;
    private ProcessInfo processInfo;
    private IProcessUI m_processUI;
    private WebResourceLoader webResourceLoader;
    private AttachmentResourceLoader attachmentResourceLoader;
    private ClassResourceLoader classResourceLoader;
    private FileResourceLoader fileResourceLoader;
    private BundleResourceLoader bundleResourceLoader;
    private static IServiceReferenceHolder<JRViewerProviderList> s_viewerProviderListReference;
    private static IServiceReferenceHolder<JRViewerProvider> s_viewerProviderReference;

    static {
        String reportPath = SystemProperties.getReportPath();
        REPORT_HOME = reportPath == null ? new File(Ini.getAdempiereHome() + File.separator + "reports") : new File(reportPath);
        jasperReportContext = new SimpleJasperReportsContext();
        jasperReportContext.setProperty("org.eclipse.jdt.core.compiler.source", "1.5");
        JRPropertiesUtil.getInstance((JasperReportsContext)jasperReportContext).setProperty("net.sf.jasperreports.awt.ignore.missing.font", "true");
        s_viewerProviderListReference = null;
        s_viewerProviderReference = null;
    }

    protected Connection getConnection() {
        return DB.getReportingConnectionRO();
    }

    public boolean startProcess(Properties ctx, ProcessInfo pi, Trx trx) {
        ClassLoader cl1 = Thread.currentThread().getContextClassLoader();
        ClassLoader cl2 = JasperReport.class.getClassLoader();
        try {
            if (!cl1.equals(cl2)) {
                Thread.currentThread().setContextClassLoader(cl2);
            }
            boolean bl = this.startProcess0(ctx, pi, trx);
            return bl;
        }
        finally {
            if (!cl1.equals(Thread.currentThread().getContextClassLoader())) {
                Thread.currentThread().setContextClassLoader(cl1);
            }
        }
    }

    private boolean startProcess0(Properties ctx, ProcessInfo pi, Trx trx) {
        String[] reportPathList;
        this.processInfo = pi;
        Object recordCounts = null;
        int AD_PInstance_ID = pi.getAD_PInstance_ID();
        int Record_ID = pi.getRecord_ID();
        if (log.isLoggable(Level.INFO)) {
            log.info("Name=" + pi.getTitle() + "  AD_PInstance_ID=" + AD_PInstance_ID + " Record_ID=" + Record_ID);
        }
        String trxName = trx != null ? trx.getTrxName() : null;
        ReportInfo reportInfo = this.getReportInfo(pi, trxName);
        ArrayList<JasperPrint> jasperPrintList = new ArrayList<JasperPrint>();
        ArrayList<File> batchPDFExportList = new ArrayList<File>();
        ArrayList<File> exportFileList = new ArrayList<File>();
        PrintInfo printInfo = null;
        String reportFilePath = reportInfo.getReportFilePath();
        String[] stringArray = reportPathList = reportFilePath.split(";");
        int n = reportPathList.length;
        int n2 = 0;
        while (n2 < n) {
            String localaddr;
            String reportPath = stringArray[n2];
            if (Util.isEmpty((String)reportPath, (boolean)true)) {
                throw new AdempiereException("Invalid report file path: " + reportFilePath);
            }
            if (reportPath.startsWith("@#LocalHttpAddr@") && !Util.isEmpty((String)(localaddr = Env.getContext((Properties)Env.getCtx(), (String)"#LocalHttpAddr")))) {
                reportPath = reportPath.replace("@#LocalHttpAddr@", localaddr);
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (AD_PInstance_ID > 0) {
                this.addProcessParameters(AD_PInstance_ID, params, trxName);
            }
            this.addProcessInfoParameters(params, pi.getParameter());
            File reportFile = null;
            URL reportURL = null;
            Object reportObject = this.getReport(reportPath, (String)params.get("ReportType"));
            if (reportObject == null) {
                log.warning("No report file found for given type, falling back to " + reportPath);
                reportObject = this.getReport(reportPath);
            }
            if (reportObject != null && reportObject instanceof File) {
                reportFile = (File)reportObject;
                if (!reportFile.exists()) {
                    reportFile = null;
                }
            } else if (reportObject != null && reportObject instanceof URL) {
                reportURL = (URL)reportObject;
            }
            if (reportFile == null && reportURL == null) {
                throw new AdempiereException("Can not load report from path: " + reportPath);
            }
            JasperInfo jasperInfo = reportFile != null ? this.getJasperInfo(reportFile) : this.getJasperInfo(reportURL);
            JasperReport jasperReport = jasperInfo.getJasperReport();
            String jasperName = jasperInfo.getJasperName();
            File reportDir = jasperInfo.getReportDir();
            Object fileResourcePath = null;
            if (reportDir != null) {
                fileResourcePath = reportDir.getAbsolutePath();
                if (((String)fileResourcePath).endsWith("/") || !((String)fileResourcePath).endsWith("\\")) {
                    // empty if block
                }
                fileResourcePath = (String)fileResourcePath + File.separator;
            }
            if (WebResourceLoader.isWebResourcePath(reportPath)) {
                String webPath = reportPath.substring(0, reportPath.lastIndexOf("/") + 1);
                params.put(SUBREPORT_DIR, webPath);
                params.put(RESOURCE_DIR, webPath);
            } else if (ClassResourceLoader.isClassResourcePath(reportPath)) {
                params.put(SUBREPORT_DIR, this.getClassResourceLoader().getRelatedResourcesPath());
                params.put(RESOURCE_DIR, this.getClassResourceLoader().getRelatedResourcesPath());
            } else if (BundleResourceLoader.isBundleResourcePath(reportPath)) {
                params.put(SUBREPORT_DIR, this.getBundleResourceLoader().getRelatedResourcesPath());
                params.put(RESOURCE_DIR, this.getBundleResourceLoader().getRelatedResourcesPath());
            } else {
                params.put(SUBREPORT_DIR, fileResourcePath);
                params.put(RESOURCE_DIR, fileResourcePath);
            }
            if (pi.getTable_ID() > 0 && Record_ID <= 0 && pi.getRecord_IDs() != null && pi.getRecord_IDs().size() > 0) {
                jasperReport = this.processRecordIds(ctx, pi, trxName, jasperInfo, jasperReport);
            }
            File[] subreports = null;
            subreports = WebResourceLoader.isWebResourcePath(reportPath) ? new File[]{} : (ClassResourceLoader.isClassResourcePath(reportPath) ? this.getClassResourceLoader().getSubreports(reportPath) : (BundleResourceLoader.isBundleResourcePath(reportPath) ? this.getBundleResourceLoader().getSubreports(reportPath) : (AttachmentResourceLoader.isAttachmentResourcePath(reportPath) ? this.getAttachmentResourceLoader().getSubreports(reportPath) : this.getFileResourceLoader().getSubreports(reportFile, reportDir))));
            int i = 0;
            while (i < subreports.length) {
                JasperInfo subInfo;
                if ((subreports[i].getName().toLowerCase().endsWith(".jasper") || subreports[i].getName().toLowerCase().endsWith(".jrxml")) && (subInfo = this.getJasperInfo(subreports[i])).getJasperReport() != null) {
                    params.put(subInfo.getJasperName(), subInfo.getJasperFile().getAbsolutePath());
                }
                ++i;
            }
            if (Record_ID > 0) {
                params.put("RECORD_ID", Record_ID);
            }
            params.put("AD_PINSTANCE_ID", AD_PInstance_ID);
            params.put("AD_CLIENT_ID", Env.getAD_Client_ID((Properties)Env.getCtx()));
            params.put("AD_ROLE_ID", Env.getAD_Role_ID((Properties)Env.getCtx()));
            params.put("AD_USER_ID", Env.getAD_User_ID((Properties)Env.getCtx()));
            params.put("AD_CLIENT_NAME", Env.getContext((Properties)Env.getCtx(), (String)"#AD_Client_Name"));
            params.put("AD_ROLE_NAME", Env.getContext((Properties)Env.getCtx(), (String)"#AD_Role_Name"));
            params.put("AD_USER_NAME", Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"));
            params.put("AD_ORG_NAME", Env.getContext((Properties)Env.getCtx(), (String)"#AD_Org_Name"));
            params.put("BASE_DIR", REPORT_HOME.getAbsolutePath());
            Language currLang = Env.getLanguage((Properties)Env.getCtx());
            if (params.containsKey("AD_Language") && params.get("AD_Language") != null || params.containsKey(CURRENT_LANG) && params.get(CURRENT_LANG) != null) {
                String langInfo = params.get("AD_Language") != null ? params.get("AD_Language").toString() : params.get(CURRENT_LANG).toString();
                currLang = Language.getLanguage((String)langInfo);
            }
            String printerName = null;
            MPrintFormat printFormat = null;
            ProcessInfoParameter[] pip = pi.getParameter();
            if (pip != null) {
                int i2 = 0;
                while (i2 < pip.length) {
                    if ("PRINT_FORMAT".equalsIgnoreCase(pip[i2].getParameterName())) {
                        printFormat = (MPrintFormat)pip[i2].getParameter();
                    }
                    if ("PRINT_INFO".equalsIgnoreCase(pip[i2].getParameterName())) {
                        printInfo = (PrintInfo)pip[i2].getParameter();
                    }
                    if ("PRINTER_NAME".equalsIgnoreCase(pip[i2].getParameterName())) {
                        printerName = (String)pip[i2].getParameter();
                    }
                    ++i2;
                }
            }
            if (printFormat != null) {
                if (printInfo != null && printInfo.isDocument()) {
                    currLang = printFormat.getLanguage();
                }
                if (printerName == null) {
                    printerName = printFormat.getPrinterName();
                }
            }
            if (pi.getAD_Process_ID() > 0) {
                MProcess process = new MProcess(Env.getCtx(), this.processInfo.getAD_Process_ID(), this.processInfo.getTransactionName());
                String processFileNamePattern = null;
                if (printFormat != null) {
                    Language language = printFormat.getLanguage();
                    processFileNamePattern = printFormat.get_Translation("FileNamePattern", language.getAD_Language());
                }
                if (processFileNamePattern == null && process.getFileNamePattern() != null) {
                    processFileNamePattern = process.getFileNamePattern();
                }
                if (process != null && !Util.isEmpty(processFileNamePattern)) {
                    String filename = FileUtil.parseTitle((Properties)Env.getCtx(), (String)processFileNamePattern, (int)pi.getTable_ID(), (int)Record_ID, (int)0, (String)trxName);
                    pi.setTitle(filename);
                }
            }
            params.put(CURRENT_LANG, currLang.getAD_Language());
            params.put("REPORT_LOCALE", currLang.getLocale());
            params.put(COLUMN_LOOKUP, new ColumnLookup(currLang));
            if (AD_PInstance_ID > 0 && currLang != null) {
                MPInstance pInstance = new MPInstance(ctx, AD_PInstance_ID, null);
                pInstance.setAD_Language_ID(MLanguage.get((Properties)ctx, (String)currLang.getAD_Language()).getAD_Language_ID());
                pInstance.saveEx();
            }
            Serializable resourceBundleObject = null;
            String bundleName = jasperReport.getResourceBundle();
            if (bundleName == null) {
                bundleName = jasperName;
            }
            resourceBundleObject = AttachmentResourceLoader.isAttachmentResourcePath(reportPath) ? this.getAttachmentResourceLoader().getResourceBundle(bundleName, currLang) : (ClassResourceLoader.isClassResourcePath(reportPath) ? this.getClassResourceLoader().getResourceBundle(bundleName, currLang) : (BundleResourceLoader.isBundleResourcePath(reportPath) ? this.getBundleResourceLoader().getResourceBundle(bundleName, currLang) : (WebResourceLoader.isWebResourcePath(reportPath) ? this.getWebResourceLoader().getResourceBundle(reportPath, bundleName, currLang) : this.getFileResourceLoader().getResourceBundle((String)fileResourcePath, bundleName, currLang))));
            PropertyResourceBundle propertyResourceBundle = null;
            if (resourceBundleObject != null) {
                try {
                    propertyResourceBundle = resourceBundleObject instanceof File ? new PropertyResourceBundle(new FileInputStream((File)resourceBundleObject)) : new PropertyResourceBundle(((URL)resourceBundleObject).openStream());
                    params.put("RESOURCE", propertyResourceBundle);
                }
                catch (IOException iOException) {}
            }
            params.put("REPORT_RESOURCE_BUNDLE", new MsgResourceBundle(propertyResourceBundle, currLang.getLocale(), currLang.getAD_Language(), Env.isSOTrx((Properties)Env.getCtx())));
            Connection conn = null;
            int maxPages = MSysConfig.getIntValue((String)"JASPER_SWAP_MAX_PAGES", (int)100);
            try {
                try {
                    conn = trx != null ? trx.getConnection() : this.getConnection();
                    String swapPath = System.getProperty("java.io.tmpdir");
                    JRSwapFile swapFile = new JRSwapFile(swapPath, 1024, 1024);
                    JRSwapFileVirtualizer virtualizer = new JRSwapFileVirtualizer(maxPages, swapFile, true);
                    params.put("REPORT_VIRTUALIZER", virtualizer);
                    JRBaseFiller filler = JRFiller.createFiller((JasperReportsContext)jasperReportContext, (JasperReport)jasperReport);
                    JasperPrint jasperPrint = filler.fill(params, conn);
                    jasperPrint.setName(pi.getTitle());
                    recordCounts = filler.getVariableValue("REPORT_COUNT");
                    if (!this.processInfo.isExport()) {
                        if (reportInfo.isDirectPrint() || this.processInfo.isBatch()) {
                            if (!this.processInfo.isBatch()) {
                                this.doDirectPrint(pi, printerName, printFormat, printInfo, jasperPrint);
                            } else {
                                this.doBatchExport(jasperPrint, batchPDFExportList);
                            }
                        } else {
                            if (printInfo == null) {
                                printInfo = new PrintInfo(pi);
                            }
                            jasperPrintList.add(jasperPrint);
                        }
                    } else {
                        this.doExport(pi, jasperPrint, exportFileList);
                    }
                }
                catch (JRException e) {
                    throw new AdempiereException(e.getLocalizedMessage() + (String)(e.getCause() != null ? " -> " + e.getCause().getLocalizedMessage() : ""));
                }
            }
            catch (Throwable throwable) {
                if (trx == null && conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (trx == null && conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
            ++n2;
        }
        if (batchPDFExportList.size() > 0) {
            if (batchPDFExportList.size() == 1) {
                this.processInfo.setPDFReport((File)batchPDFExportList.get(0));
            } else {
                try {
                    File pdfFile = File.createTempFile(FileUtil.makePrefix((String)this.processInfo.getTitle()), ".pdf");
                    Util.mergePdf(batchPDFExportList, (File)pdfFile);
                    this.processInfo.setPDFReport(pdfFile);
                }
                catch (Exception e) {
                    throw new AdempiereException(e.getMessage(), (Throwable)e);
                }
            }
        } else if (exportFileList.size() > 0) {
            if (exportFileList.size() == 1) {
                this.processInfo.setExportFile((File)exportFileList.get(0));
            } else {
                try {
                    this.processInfo.setExportFile(this.createMultiFileArchive(exportFileList));
                }
                catch (Exception e) {
                    throw new AdempiereException(e.getMessage(), (Throwable)e);
                }
            }
        } else if (!this.processInfo.isExport()) {
            Object viewerLauncher;
            if (jasperPrintList.size() == 1) {
                viewerLauncher = ReportStarter.getViewerProvider();
                JasperPrint jasperPrint = (JasperPrint)jasperPrintList.get(0);
                if (!Util.isEmpty((String)this.processInfo.getReportType())) {
                    jasperPrint.setProperty(IDEMPIERE_REPORT_TYPE, this.processInfo.getReportType());
                }
                try {
                    viewerLauncher.openViewer(jasperPrint, pi.getTitle(), printInfo);
                }
                catch (JRException e) {
                    throw new AdempiereException(e.getLocalizedMessage() + (String)(e.getCause() != null ? " -> " + e.getCause().getLocalizedMessage() : ""), (Throwable)e);
                }
            }
            viewerLauncher = ReportStarter.getViewerProviderList();
            if (viewerLauncher == null) {
                throw new AdempiereException("Can not find a viewer provider for multiple jasper reports");
            }
            try {
                viewerLauncher.openViewer(jasperPrintList, pi.getTitle(), printInfo);
            }
            catch (JRException e) {
                throw new AdempiereException(e.getLocalizedMessage() + (String)(e.getCause() != null ? " -> " + e.getCause().getLocalizedMessage() : ""), (Throwable)e);
            }
        }
        if (recordCounts != null && recordCounts instanceof Integer) {
            this.processInfo.setRowCount(((Integer)recordCounts).intValue());
        }
        pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"Success"), false);
        return true;
    }

    private File createMultiFileArchive(List<File> exportFileList) throws Exception {
        File archiveFile = File.createTempFile(FileUtil.makePrefix((String)this.processInfo.getTitle()), ".zip");
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(archiveFile);){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ZipOutputStream zip = new ZipOutputStream(out);){
                zip.setMethod(8);
                zip.setLevel(9);
                for (File file : exportFileList) {
                    try {
                        ZipEntry entry = new ZipEntry(file.getName());
                        entry.setTime(System.currentTimeMillis());
                        entry.setMethod(8);
                        zip.putNextEntry(entry);
                        Throwable throwable3 = null;
                        Object var13_19 = null;
                        try (FileInputStream in = new FileInputStream(file);){
                            byte[] buf = new byte[1024];
                            int s = 0;
                            while ((s = ((InputStream)in).read(buf, 0, 1024)) > 0) {
                                zip.write(buf, 0, s);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                        zip.closeEntry();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        return archiveFile;
    }

    private void doBatchExport(JasperPrint jasperPrint, List<File> batchExportList) throws JRException {
        try {
            File pdfFile = null;
            pdfFile = this.processInfo.getPDFFileName() != null ? FileUtil.createFile((String)this.processInfo.getPDFFileName()) : File.createTempFile(FileUtil.makePrefix((String)jasperPrint.getName()), ".pdf");
            JRPdfExporter exporter = new JRPdfExporter(jasperReportContext);
            exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
            exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(pdfFile.getAbsolutePath()));
            exporter.exportReport();
            batchExportList.add(pdfFile);
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "ReportStarter.startProcess: Can not make PDF File - " + e.getMessage(), (Throwable)e);
        }
    }

    private JasperReport processRecordIds(Properties ctx, ProcessInfo pi, String trxName, JasperInfo jasperData, JasperReport jasperReport) {
        try {
            String originalQueryText;
            JRQuery originalQuery = jasperReport.getQuery();
            if (originalQuery != null && (originalQueryText = originalQuery.getText()) != null) {
                int index2;
                MTable table = new MTable(ctx, pi.getTable_ID(), trxName);
                String tableName = table.getTableName();
                String originalQueryTemp = originalQueryText.toUpperCase();
                int index1 = originalQueryTemp.indexOf(" " + tableName.toUpperCase());
                if (index1 != -1 && (index2 = originalQueryTemp.substring(index1).indexOf(",")) != -1) {
                    String tableVariable = originalQueryTemp.substring(index1 + tableName.length() + 1, index1 + index2);
                    if ((tableVariable = tableVariable.trim()).length() == 0) {
                        tableVariable = tableName;
                    }
                    MQuery query = new MQuery(tableName);
                    Iterator iterator = pi.getRecord_IDs().iterator();
                    while (iterator.hasNext()) {
                        int recordId = (Integer)iterator.next();
                        query.addRestriction(tableVariable + "." + query.getTableName() + "_ID=" + recordId, false, 0);
                    }
                    String newQueryText = null;
                    int index3 = originalQueryTemp.indexOf("WHERE");
                    newQueryText = index3 != -1 ? originalQueryText + " AND " + query.toString() : originalQueryText + " WHERE " + query.toString();
                    File jrxmlFile = File.createTempFile(FileUtil.makePrefix((String)jasperReport.getName()), ".jrxml");
                    JRXmlWriter.writeReport((JRReport)jasperReport, (OutputStream)new FileOutputStream(jrxmlFile), (String)"UTF-8");
                    JasperDesign jasperDesign = JRXmlLoader.load((File)jrxmlFile);
                    JRDesignQuery newQuery = new JRDesignQuery();
                    newQuery.setText(newQueryText);
                    jasperDesign.setQuery(newQuery);
                    JasperCompileManager manager = JasperCompileManager.getInstance((JasperReportsContext)jasperReportContext);
                    JasperReport newJasperReport = manager.compile(jasperDesign);
                    if (newJasperReport != null) {
                        jasperData.jasperReport = newJasperReport;
                        jasperReport = newJasperReport;
                    }
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Failed to modify the report query", (Throwable)e);
        }
        return jasperReport;
    }

    private void doDirectPrint(ProcessInfo pi, String printerName, MPrintFormat printFormat, PrintInfo printInfo, JasperPrint jasperPrint) throws JRException {
        PrinterJob printerJob = PrintUtil.getPrinterJob((String)printerName);
        HashPrintRequestAttributeSet prats = new HashPrintRequestAttributeSet();
        if (printInfo == null || printInfo.isDocumentCopy() || printInfo.getCopies() < 1) {
            prats.add(new Copies(1));
        } else {
            prats.add(new Copies(printInfo.getCopies()));
        }
        Locale locale = Language.getLoginLanguage().getLocale();
        String printFormat_name = printFormat == null ? "" : printFormat.getName();
        int numCopies = printInfo == null ? 0 : printInfo.getCopies();
        prats.add(new JobName(printFormat_name + "_" + pi.getRecord_ID(), locale));
        prats.add(PrintUtil.getJobPriority((int)jasperPrint.getPages().size(), (int)numCopies, (boolean)true));
        JRPrintServiceExporter exporter = new JRPrintServiceExporter();
        exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
        SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
        configuration.setPrintService(printerJob.getPrintService());
        configuration.setPrintServiceAttributeSet(printerJob.getPrintService().getAttributes());
        configuration.setPrintRequestAttributeSet((PrintRequestAttributeSet)prats);
        configuration.setDisplayPageDialog(Boolean.valueOf(false));
        configuration.setDisplayPrintDialog(Boolean.valueOf(false));
        exporter.setConfiguration((ExporterConfiguration)configuration);
        exporter.exportReport();
    }

    private void doExport(ProcessInfo pi, JasperPrint jasperPrint, List<File> exportFileList) throws JRException {
        String ext = pi.getExportFileExtension();
        if ("JasperPrint".equalsIgnoreCase(ext)) {
            pi.setInternalReportObject((Serializable)jasperPrint);
            return;
        }
        if (ext == null) {
            ext = "pdf";
        }
        try {
            File exportFile = File.createTempFile(FileUtil.makePrefix((String)jasperPrint.getName()), "." + ext);
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream outputStream = new FileOutputStream(exportFile);){
                JRPdfExporter exporter = null;
                if (ext.equals("pdf")) {
                    JRPdfExporter export = new JRPdfExporter(jasperReportContext);
                    SimplePdfExporterConfiguration config = new SimplePdfExporterConfiguration();
                    export.setConfiguration((ExporterConfiguration)config);
                    export.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    exporter = export;
                    JREventManage.sentPdfExporterConfigurationEvent(export, (SimpleExporterConfiguration)config, pi);
                } else if (ext.equals("ps")) {
                    JRPrintServiceExporter export = new JRPrintServiceExporter(jasperReportContext);
                    SimplePrintServiceExporterConfiguration config = new SimplePrintServiceExporterConfiguration();
                    export.setConfiguration((ExporterConfiguration)config);
                    export.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    exporter = export;
                } else if (ext.equals("xml")) {
                    JRXmlExporter export = new JRXmlExporter(jasperReportContext);
                    SimpleExporterConfiguration config = new SimpleExporterConfiguration();
                    export.setConfiguration((ExporterConfiguration)config);
                    export.setExporterOutput((ExporterOutput)new SimpleXmlExporterOutput((OutputStream)outputStream));
                    exporter = export;
                } else if (ext.equals("csv") || ext.equals("ssv")) {
                    JRCsvExporter export = new JRCsvExporter(jasperReportContext);
                    SimpleCsvExporterConfiguration config = new SimpleCsvExporterConfiguration();
                    if (ext.equals("ssv")) {
                        config.setFieldDelimiter(";");
                    }
                    export.setConfiguration((ExporterConfiguration)config);
                    export.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)outputStream));
                    exporter = export;
                } else if (ext.equals("txt")) {
                    JRTextExporter export = new JRTextExporter(jasperReportContext);
                    SimpleTextExporterConfiguration config = new SimpleTextExporterConfiguration();
                    export.setConfiguration((ExporterConfiguration)config);
                    export.setExporterOutput((ExporterOutput)new SimpleWriterExporterOutput((OutputStream)outputStream));
                    exporter = export;
                } else if (ext.equals("html") || ext.equals("htm")) {
                    HtmlExporter exporterHTML = new HtmlExporter();
                    SimpleHtmlReportConfiguration htmlConfig = new SimpleHtmlReportConfiguration();
                    htmlConfig.setEmbedImage(Boolean.valueOf(true));
                    htmlConfig.setAccessibleHtml(Boolean.valueOf(true));
                    exporterHTML.setExporterOutput((ExporterOutput)new SimpleHtmlExporterOutput((OutputStream)outputStream));
                    exporterHTML.setConfiguration((ReportExportConfiguration)htmlConfig);
                    exporter = exporterHTML;
                } else if (ext.equals("xls")) {
                    JRXlsExporter exporterXLS = new JRXlsExporter(jasperReportContext);
                    SimpleXlsReportConfiguration xlsConfig = new SimpleXlsReportConfiguration();
                    xlsConfig.setOnePagePerSheet(Boolean.valueOf(false));
                    exporterXLS.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    exporterXLS.setConfiguration((ReportExportConfiguration)xlsConfig);
                    exporter = exporterXLS;
                } else if (ext.equals("xlsx")) {
                    JRXlsxExporter exporterXLSX = new JRXlsxExporter(jasperReportContext);
                    SimpleXlsxReportConfiguration xlsxConfig = new SimpleXlsxReportConfiguration();
                    xlsxConfig.setOnePagePerSheet(Boolean.valueOf(false));
                    exporterXLSX.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput((OutputStream)outputStream));
                    exporterXLSX.setConfiguration((ReportExportConfiguration)xlsxConfig);
                    exporter = exporterXLSX;
                } else {
                    log.warning("FileInvalidExtension=" + ext);
                }
                if (exporter == null) {
                    exporter = new JRPdfExporter(jasperReportContext);
                }
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(jasperPrint));
                exporter.exportReport();
                exportFileList.add(exportFile);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, "Can not export " + ext + " File - " + e.getMessage(), (Throwable)e);
        }
    }

    public static synchronized JRViewerProviderList getViewerProviderList() {
        JRViewerProviderList viewerLauncher = null;
        if (s_viewerProviderListReference != null && (viewerLauncher = (JRViewerProviderList)s_viewerProviderListReference.getService()) != null) {
            return viewerLauncher;
        }
        IServiceReferenceHolder viewerReference = Service.locator().locate(JRViewerProviderList.class).getServiceReference();
        if (viewerReference != null) {
            viewerLauncher = (JRViewerProviderList)viewerReference.getService();
            s_viewerProviderListReference = viewerReference;
        }
        return viewerLauncher;
    }

    public static synchronized JRViewerProvider getViewerProvider() {
        JRViewerProvider viewerLauncher = null;
        if (s_viewerProviderReference != null && (viewerLauncher = (JRViewerProvider)s_viewerProviderReference.getService()) != null) {
            return viewerLauncher;
        }
        IServiceReferenceHolder viewerReference = Service.locator().locate(JRViewerProvider.class).getServiceReference();
        if (viewerReference != null) {
            viewerLauncher = (JRViewerProvider)viewerReference.getService();
            s_viewerProviderReference = viewerReference;
        }
        return viewerLauncher;
    }

    private WebResourceLoader getWebResourceLoader() {
        if (this.webResourceLoader == null) {
            this.webResourceLoader = new WebResourceLoader(this.getLocalDownloadFolder());
        }
        return this.webResourceLoader;
    }

    private AttachmentResourceLoader getAttachmentResourceLoader() {
        if (this.attachmentResourceLoader == null) {
            this.attachmentResourceLoader = new AttachmentResourceLoader(this.getLocalDownloadFolder());
        }
        return this.attachmentResourceLoader;
    }

    private ClassResourceLoader getClassResourceLoader() {
        if (this.classResourceLoader == null) {
            this.classResourceLoader = new ClassResourceLoader(this.getLocalDownloadFolder());
        }
        return this.classResourceLoader;
    }

    private FileResourceLoader getFileResourceLoader() {
        if (this.fileResourceLoader == null) {
            this.fileResourceLoader = new FileResourceLoader();
        }
        return this.fileResourceLoader;
    }

    private BundleResourceLoader getBundleResourceLoader() {
        if (this.bundleResourceLoader == null) {
            this.bundleResourceLoader = new BundleResourceLoader(this.getLocalDownloadFolder());
        }
        return this.bundleResourceLoader;
    }

    protected Object getReport(String reportPath, String reportType) {
        if (reportType != null) {
            int cpos = ((String)reportPath).lastIndexOf(46);
            reportPath = ((String)reportPath).substring(0, cpos) + "_" + reportType + ((String)reportPath).substring(cpos, ((String)reportPath).length());
        }
        return this.getReport((String)reportPath);
    }

    protected Object getReport(String reportPath) {
        Object report = null;
        report = WebResourceLoader.isWebResourcePath(reportPath) ? this.getWebResourceLoader().getReportFile(reportPath) : (AttachmentResourceLoader.isAttachmentResourcePath(reportPath) ? this.getAttachmentResourceLoader().getReportFile(this.processInfo, reportPath) : (reportPath.startsWith("/") ? new File(reportPath) : (FileResourceLoader.isFileResourcePath(reportPath) ? this.getFileResourceLoader().getReportFile(reportPath) : (ClassResourceLoader.isClassResourcePath(reportPath) ? this.getClassResourceLoader().getResource(reportPath) : (BundleResourceLoader.isBundleResourcePath(reportPath) ? this.getBundleResourceLoader().getResource(reportPath) : new File(REPORT_HOME, reportPath))))));
        return report;
    }

    private String getLocalDownloadFolder() {
        String path = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "jasperreport_" + this.processInfo.getAD_Process_ID() + System.getProperty("file.separator");
        Path p = Path.of(path, new String[0]);
        try {
            if (!Files.exists(p, new LinkOption[0])) {
                Files.createDirectory(p, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    protected JasperInfo getJasperInfo(File reportFile) {
        if (log.isLoggable(Level.INFO)) {
            log.info("reportFile.getAbsolutePath() = " + reportFile.getAbsolutePath());
        }
        JasperReport jasperReport = null;
        String extension = null;
        String jasperName = reportFile.getName();
        int pos = jasperName.lastIndexOf(46);
        if (pos != -1) {
            extension = jasperName.substring(pos);
            jasperName = jasperName.substring(0, pos);
        }
        File reportDir = reportFile.getParentFile();
        File jasperFile = null;
        if (extension == null || !extension.equals(".jasper")) {
            jasperFile = new File(reportDir.getAbsolutePath(), jasperName + ".jasper");
            if (jasperFile.exists()) {
                if (reportFile.lastModified() == jasperFile.lastModified()) {
                    if (log.isLoggable(Level.INFO)) {
                        log.info(" no need to compile use " + jasperFile.getAbsolutePath());
                    }
                    try {
                        jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)jasperFile.getAbsolutePath());
                    }
                    catch (JRException e) {
                        jasperReport = null;
                        log.log(Level.SEVERE, "Can not load report - " + e.getMessage(), (Throwable)e);
                    }
                } else {
                    jasperReport = this.compileReport(reportFile, jasperFile);
                }
            } else {
                jasperReport = this.compileReport(reportFile, jasperFile);
            }
        } else {
            jasperFile = reportFile;
            try {
                jasperReport = (JasperReport)JRLoader.loadObjectFromFile((String)jasperFile.getAbsolutePath());
            }
            catch (JRException e) {
                jasperReport = null;
                log.log(Level.SEVERE, "Can not load report - " + e.getMessage(), (Throwable)e);
            }
        }
        return new JasperInfo(jasperReport, reportDir, jasperName, jasperFile);
    }

    protected JasperInfo getJasperInfo(URL reportURL) {
        try {
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((URL)reportURL);
            return new JasperInfo(jasperReport, null, jasperReport.getName(), null);
        }
        catch (JRException e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void addProcessParameters(int AD_PInstance_ID, Map<String, Object> params, String trxName) {
        StringBuilder sql = new StringBuilder("SELECT ").append(" ").append("ParameterName").append(",").append("P_String").append(",").append("P_String_To").append(",").append("P_Number").append(",").append("P_Number_To").append(",").append("P_Date").append(",").append("P_Date_To").append(",").append("Info").append(",").append("Info_To").append(",").append("IsNotClause").append(" FROM ").append("AD_PInstance_Para").append(" WHERE ").append("AD_PInstance_ID=?");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql.toString(), (int)1003, (int)1007, (String)trxName);
                pstmt.setInt(1, AD_PInstance_ID);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String name = rs.getString(1);
                    String pStr = rs.getString(2);
                    String pStrTo = rs.getString(3);
                    BigDecimal pNum = rs.getBigDecimal(4);
                    BigDecimal pNumTo = rs.getBigDecimal(5);
                    Timestamp pDate = rs.getTimestamp(6);
                    Timestamp pDateTo = rs.getTimestamp(7);
                    if (pStr != null) {
                        if (pStrTo != null) {
                            params.put(name + "1", pStr);
                            params.put(name + "2", pStrTo);
                        } else {
                            params.put(name, pStr);
                        }
                    } else if (pDate != null) {
                        if (pDateTo != null) {
                            params.put(name + "1", pDate);
                            params.put(name + "2", pDateTo);
                        } else {
                            params.put(name, pDate);
                        }
                    } else if (pNum != null) {
                        if (name.endsWith("_ID")) {
                            if (pNumTo != null) {
                                params.put(name + "1", pNum.intValue());
                                params.put(name + "2", pNumTo.intValue());
                            } else {
                                params.put(name, pNum.intValue());
                            }
                        } else if (pNumTo != null) {
                            params.put(name + "1", pNum);
                            params.put(name + "2", pNumTo);
                        } else {
                            params.put(name, pNum);
                        }
                    }
                    String info = rs.getString(8);
                    String infoTo = rs.getString(9);
                    String isNotClause = rs.getString(10);
                    params.put(name + "_Info1", info != null ? info : "");
                    params.put(name + "_Info2", infoTo != null ? infoTo : "");
                    params.put(name + "_NOT", isNotClause);
                }
            }
            catch (SQLException e) {
                throw new DBException(e, sql.toString());
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
    }

    private void addProcessInfoParameters(Map<String, Object> params, ProcessInfoParameter[] para) {
        if (para != null) {
            int i = 0;
            while (i < para.length) {
                if (para[i].getParameter_To() == null) {
                    if (para[i].getParameterName().endsWith("_ID") && para[i].getParameter() instanceof BigDecimal) {
                        params.put(para[i].getParameterName(), ((BigDecimal)para[i].getParameter()).intValue());
                    } else {
                        params.put(para[i].getParameterName(), para[i].getParameter());
                    }
                } else {
                    if (para[i].getParameterName().endsWith("_ID") && para[i].getParameter() != null && para[i].getParameter() instanceof BigDecimal) {
                        params.put(para[i].getParameterName() + "1", ((BigDecimal)para[i].getParameter()).intValue());
                    } else {
                        params.put(para[i].getParameterName() + "1", para[i].getParameter());
                    }
                    if (para[i].getParameterName().endsWith("_ID") && para[i].getParameter_To() instanceof BigDecimal) {
                        params.put(para[i].getParameterName() + "2", ((BigDecimal)para[i].getParameter_To()).intValue());
                    } else {
                        params.put(para[i].getParameterName() + "2", para[i].getParameter_To());
                    }
                }
                ++i;
            }
        }
    }

    private JasperReport compileReport(File reportFile, File jasperFile) {
        JasperReport compiledJasperReport = null;
        try {
            JasperCompileManager manager = JasperCompileManager.getInstance((JasperReportsContext)jasperReportContext);
            manager.compileToFile(reportFile.getAbsolutePath(), jasperFile.getAbsolutePath());
            jasperFile.setLastModified(reportFile.lastModified());
            compiledJasperReport = (JasperReport)JRLoader.loadObject((File)jasperFile);
        }
        catch (JRException e) {
            throw new AdempiereException((Throwable)e);
        }
        return compiledJasperReport;
    }

    private ReportInfo getReportInfo(ProcessInfo pi, String trxName) {
        MProcess process = MProcess.get((int)pi.getAD_Process_ID());
        String path = process.getJasperReport();
        boolean isPrintPreview = pi.isPrintPreview();
        boolean directPrint = process.isDirectPrint() && !Ini.isPropertyBool((String)"PrintPreview") && !isPrintPreview;
        return new ReportInfo(path, directPrint);
    }

    public void setProcessUI(IProcessUI processUI) {
        this.m_processUI = processUI;
    }

    private static class JasperInfo
    implements Serializable {
        private static final long serialVersionUID = -1208951101124159422L;
        private JasperReport jasperReport;
        private File reportDir;
        private String jasperName;
        private File jasperFile;

        public JasperInfo(JasperReport jasperReport, File reportDir, String jasperName, File jasperFile) {
            this.jasperReport = jasperReport;
            this.reportDir = reportDir;
            this.jasperName = jasperName;
            this.jasperFile = jasperFile;
        }

        public JasperReport getJasperReport() {
            return this.jasperReport;
        }

        public File getReportDir() {
            return this.reportDir;
        }

        public String getJasperName() {
            return this.jasperName;
        }

        public File getJasperFile() {
            return this.jasperFile;
        }
    }

    private static class ReportInfo {
        private String reportFilePath;
        private boolean directPrint;

        public ReportInfo(String reportFilePath, boolean directPrint) {
            this.reportFilePath = reportFilePath;
            this.directPrint = directPrint;
        }

        public String getReportFilePath() {
            return this.reportFilePath;
        }

        public boolean isDirectPrint() {
            return this.directPrint;
        }
    }
}

