/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.adempiere.base.IGridTabExporter;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutDocument;
import org.adempiere.pipo2.PackoutItem;
import org.compiere.Adempiere;
import org.compiere.model.GridTab;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class GridTab2PackExporter
implements IGridTabExporter {
    private static final CLogger logger = CLogger.getCLogger(GridTab2PackExporter.class);

    public void export(GridTab gridTab, List<GridTab> childs, boolean currentRowOnly, File file, int indxDetailSelected) {
        String tableName = gridTab.getTableName();
        PackOut packOut = new PackOut();
        packOut.setCtx(Env.getCtx());
        packOut.setExportDictionaryEntity(false);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.putAll(Env.getCtx());
        ArrayList<PackoutItem> packoutItems = new ArrayList<PackoutItem>();
        if (packOut.getHandler(tableName) == null) {
            properties.put("AD_Table_ID", gridTab.getAD_Table_ID());
            StringBuilder sql = new StringBuilder("SELECT * FROM ");
            sql.append(tableName);
            if (currentRowOnly) {
                sql.append(" WHERE ").append(gridTab.getTableModel().getWhereClause(gridTab.getCurrentRow()));
            } else {
                int i = 0;
                while (i < gridTab.getRowCount()) {
                    if (i == 0) {
                        sql.append(" WHERE ((");
                    } else {
                        sql.append(") OR (");
                    }
                    gridTab.navigate(i);
                    sql.append(gridTab.getTableModel().getWhereClause(gridTab.getCurrentRow()));
                    ++i;
                }
                sql.append("))");
            }
            for (GridTab child : childs) {
                if (child.getTableName().toLowerCase().endsWith("_trl")) continue;
                if (child.getTabLevel() > gridTab.getTabLevel() + 1) {
                    int level = child.getTabLevel() - gridTab.getTabLevel() - 1;
                    Object sep = ">";
                    int i = 1;
                    while (i < level) {
                        sep = (String)sep + "+";
                        ++i;
                    }
                    sql = sql.append((String)sep).append(child.getTableName());
                    continue;
                }
                sql = sql.append(";").append(child.getTableName());
            }
            properties.put("SQLStatement", sql.toString());
            PackoutItem packoutItem = new PackoutItem("table.genericHandler", gridTab.getRecord_ID(), properties);
            packoutItems.add(packoutItem);
        } else if (currentRowOnly) {
            UUID uuidObj;
            int recordID = gridTab.getRecord_ID();
            String uuid = null;
            if (recordID == -1 && (uuidObj = gridTab.getTableModel().getUUID(gridTab.getCurrentRow())) != null) {
                uuid = uuidObj.toString();
            }
            PackoutItem packoutItem = new PackoutItem(tableName, recordID, uuid, properties);
            packoutItems.add(packoutItem);
        } else {
            int i = 0;
            while (i < gridTab.getRowCount()) {
                UUID uuidObj;
                int recordID = gridTab.getKeyID(i);
                String uuid = null;
                if (recordID == -1 && (uuidObj = gridTab.getTableModel().getUUID(i)) != null) {
                    uuid = uuidObj.toString();
                }
                PackoutItem packoutItem = new PackoutItem(tableName, recordID, uuid, properties);
                packoutItems.add(packoutItem);
                ++i;
            }
        }
        MUser user = MUser.get((Properties)Env.getCtx());
        PackoutDocument packoutDocument = new PackoutDocument(tableName, "1.0.0", Adempiere.getVersion(), Adempiere.DB_VERSION, "", "", user.getName(), user.getEMail(), new Date(), new Date());
        if (file == null) {
            try {
                file = File.createTempFile(tableName + "_", ".zip");
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            packOut.export(this.getPackoutDirectory(), file != null ? file.getAbsolutePath() : null, packoutDocument, packoutItems, null);
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private String getPackoutDirectory() {
        boolean success;
        String packageDirectory = Adempiere.getAdempiereHome();
        String result = packageDirectory + File.separator + "packages";
        File docDir = new File(result + File.separator + "doc");
        if (!docDir.exists() && !(success = docDir.mkdirs())) {
            logger.info("Target directory creation failed");
        }
        return result + File.separator;
    }

    public String getFileExtension() {
        return "zip";
    }

    public String getFileExtensionLabel() {
        return Msg.getMsg((Properties)Env.getCtx(), (String)"File2PackZip");
    }

    public String getContentType() {
        return "application/zip";
    }

    public String getSuggestedFileName(GridTab gridTab) {
        return gridTab.getName() + "." + this.getFileExtension();
    }

    public boolean isExportableTab(GridTab gridTab) {
        return !gridTab.getTableName().toLowerCase().endsWith("_trl");
    }
}

