/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.install.IDBConfigMonitor;
import org.adempiere.install.IDatabaseConfig;
import org.compiere.Adempiere;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.install.Config;
import org.compiere.install.ConfigAppServer;
import org.compiere.install.ConfigVM;
import org.compiere.install.ConfigurationPanel;
import org.compiere.install.KeyStoreMgt;
import org.compiere.model.MSystem;
import org.compiere.model.SystemProperties;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.EMailAuthenticator;
import org.compiere.util.Ini;
import org.compiere.util.Util;
import org.eclipse.jetty.util.security.Password;

public class ConfigurationData {
    protected ConfigurationPanel p_panel = null;
    protected Properties p_properties = new Properties();
    private File m_adempiereHome;
    protected static final CLogger log = CLogger.getCLogger(ConfigurationData.class);
    public static final String IDEMPIERE_ENV_FILE = "idempiereEnv.properties";
    public static final String IDEMPIERE_HOME = "IDEMPIERE_HOME";
    public static final String JAVA_HOME = "JAVA_HOME";
    public static final String IDEMPIERE_JAVA_OPTIONS = "IDEMPIERE_JAVA_OPTIONS";
    public static final String KEYSTORE_PASSWORD = "myPassword";
    public static final String ADEMPIERE_APPS_TYPE = "ADEMPIERE_APPS_TYPE";
    public static final String ADEMPIERE_APPS_SERVER = "ADEMPIERE_APPS_SERVER";
    public static final String ADEMPIERE_APPS_DEPLOY = "ADEMPIERE_APPS_DEPLOY";
    public static final String ADEMPIERE_JNP_PORT = "ADEMPIERE_JNP_PORT";
    public static final String ADEMPIERE_WEB_PORT = "ADEMPIERE_WEB_PORT";
    public static final String ADEMPIERE_SSL_PORT = "ADEMPIERE_SSL_PORT";
    public static final String ADEMPIERE_WEB_ALIAS = "ADEMPIERE_WEB_ALIAS";
    public static final String ADEMPIERE_KEYSTORE = "ADEMPIERE_KEYSTORE";
    public static final String ADEMPIERE_KEYSTOREPASS = "ADEMPIERE_KEYSTOREPASS";
    public static final String ADEMPIERE_KEYSTORECODEALIAS = "ADEMPIERE_KEYSTORECODEALIAS";
    public static final String ADEMPIERE_KEYSTOREWEBALIAS = "ADEMPIERE_KEYSTOREWEBALIAS";
    public static final String ADEMPIERE_CERT_CN = "ADEMPIERE_CERT_CN";
    public static final String ADEMPIERE_CERT_ORG = "ADEMPIERE_CERT_ORG";
    public static final String ADEMPIERE_CERT_ORG_UNIT = "ADEMPIERE_CERT_ORG_UNIT";
    public static final String ADEMPIERE_CERT_LOCATION = "ADEMPIERE_CERT_LOCATION";
    public static final String ADEMPIERE_CERT_STATE = "ADEMPIERE_CERT_STATE";
    public static final String ADEMPIERE_CERT_COUNTRY = "ADEMPIERE_CERT_COUNTRY";
    public static final String ADEMPIERE_DB_TYPE = "ADEMPIERE_DB_TYPE";
    public static final String ADEMPIERE_DB_PATH = "ADEMPIERE_DB_PATH";
    public static final String ADEMPIERE_DB_SERVER = "ADEMPIERE_DB_SERVER";
    public static final String ADEMPIERE_DB_PORT = "ADEMPIERE_DB_PORT";
    public static final String ADEMPIERE_DB_NAME = "ADEMPIERE_DB_NAME";
    public static final String ADEMPIERE_DB_URL = "ADEMPIERE_DB_URL";
    public static final String ADEMPIERE_DB_USER = "ADEMPIERE_DB_USER";
    public static final String ADEMPIERE_DB_PASSWORD = "ADEMPIERE_DB_PASSWORD";
    public static final String ADEMPIERE_DB_SYSTEM = "ADEMPIERE_DB_SYSTEM";
    public static final String ADEMPIERE_DB_EXISTS = "ADEMPIERE_DB_EXISTS";
    public static final String ADEMPIERE_MAIL_SERVER = "ADEMPIERE_MAIL_SERVER";
    public static final String ADEMPIERE_MAIL_USER = "ADEMPIERE_MAIL_USER";
    public static final String ADEMPIERE_MAIL_PASSWORD = "ADEMPIERE_MAIL_PASSWORD";
    public static final String ADEMPIERE_ADMIN_EMAIL = "ADEMPIERE_ADMIN_EMAIL";
    public static final String ADEMPIERE_MAIL_UPDATED = "ADEMPIERE_MAIL_UPDATED";
    public static final String ADEMPIERE_FTP_SERVER = "ADEMPIERE_FTP_SERVER";
    public static final String ADEMPIERE_FTP_USER = "ADEMPIERE_FTP_USER";
    public static final String ADEMPIERE_FTP_PASSWORD = "ADEMPIERE_FTP_PASSWORD";
    public static final String ADEMPIERE_FTP_PREFIX = "ADEMPIERE_FTP_PREFIX";
    public static final String ADEMPIERE_WEBSTORES = "ADEMPIERE_WEBSTORES";
    public static final List<String> secretVars = Arrays.asList("ADEMPIERE_DB_PASSWORD", "ADEMPIERE_DB_SYSTEM", "ADEMPIERE_MAIL_PASSWORD");
    private static String JAVATYPE_SUN = "sun";
    private static String JAVATYPE_MAC = "mac";
    private static String JAVATYPE_OPENJDK = "OpenJDK";
    public static String[] JAVATYPE = new String[]{JAVATYPE_SUN, JAVATYPE_OPENJDK, JAVATYPE_MAC};
    private Config m_javaConfig = new ConfigVM(this);
    private ConfigAppServer m_appsConfig = new ConfigAppServer(this);
    public static String[] DBTYPE = null;
    private IDatabaseConfig[] m_databaseConfig = null;

    public ConfigurationData(ConfigurationPanel panel) {
        this.p_panel = panel;
        this.initDatabaseConfig();
    }

    private void initDatabaseConfig() {
        List configList = EquinoxExtensionLocator.instance().list(IDatabaseConfig.class).getExtensions();
        this.m_databaseConfig = new IDatabaseConfig[configList.size()];
        DBTYPE = new String[this.m_databaseConfig.length];
        int i = 0;
        while (i < configList.size()) {
            this.m_databaseConfig[i] = (IDatabaseConfig)configList.get(i);
            ConfigurationData.DBTYPE[i] = this.m_databaseConfig[i].getName();
            ++i;
        }
    }

    public void updateProperty(String property, String value) {
        String currentValue;
        if (value == null) {
            value = "";
        }
        if ((currentValue = (String)this.p_properties.get(property)) == null) {
            this.p_properties.put(property, value);
        } else if (!currentValue.equals(value)) {
            this.p_properties.put(property, value);
        }
    }

    public String getProperty(String property) {
        return this.p_properties.getProperty(property);
    }

    public boolean load() {
        String adempiereHome = SystemProperties.getIdempiereHome();
        if (adempiereHome == null || adempiereHome.length() == 0) {
            adempiereHome = System.getProperty("user.dir");
        }
        boolean envLoaded = false;
        String fileName = adempiereHome + File.separator + IDEMPIERE_ENV_FILE;
        File env = new File(fileName);
        if (env.exists()) {
            String obfKeystorePass;
            try {
                FileInputStream fis = new FileInputStream(env);
                this.p_properties.load(fis);
                fis.close();
            }
            catch (Exception e) {
                log.warning(e.toString());
            }
            if (log.isLoggable(Level.INFO)) {
                log.info(env.toString());
            }
            if (this.p_properties.size() > 5) {
                envLoaded = true;
            }
            if (MSystem.isSecureProps()) {
                for (String secretVar : secretVars) {
                    if (this.p_properties.containsKey(secretVar)) continue;
                    String val = Ini.getVar((String)secretVar);
                    this.p_properties.put(secretVar, val);
                }
            }
            if ((obfKeystorePass = this.p_properties.getProperty(ADEMPIERE_KEYSTOREPASS)).startsWith("OBF:")) {
                String keystorePass = Password.deobfuscate((String)obfKeystorePass);
                this.p_properties.put(ADEMPIERE_KEYSTOREPASS, keystorePass);
            }
            Properties loaded = new Properties();
            loaded.putAll((Map<?, ?>)this.p_properties);
            this.initJava();
            if (loaded.containsKey(JAVA_HOME)) {
                this.setJavaHome((String)loaded.get(JAVA_HOME));
            }
            if (loaded.containsKey(IDEMPIERE_JAVA_OPTIONS)) {
                this.setJavaOptions((String)loaded.get(IDEMPIERE_JAVA_OPTIONS));
            }
            this.setAdempiereHome((String)this.p_properties.get(IDEMPIERE_HOME));
            String s = (String)this.p_properties.get(ADEMPIERE_KEYSTOREPASS);
            if (s == null || s.length() == 0) {
                s = KEYSTORE_PASSWORD;
                this.p_properties.put(ADEMPIERE_KEYSTOREPASS, s);
            }
            this.setKeyStore(s);
            if (loaded.containsKey(ADEMPIERE_APPS_SERVER)) {
                this.setAppsServer((String)loaded.get(ADEMPIERE_APPS_SERVER));
            }
            if (loaded.containsKey(ADEMPIERE_WEB_PORT)) {
                this.setAppsServerWebPort((String)loaded.get(ADEMPIERE_WEB_PORT));
            }
            if (loaded.containsKey(ADEMPIERE_SSL_PORT)) {
                this.setAppsServerSSLPort((String)loaded.get(ADEMPIERE_SSL_PORT));
            }
            int dbTypeIndex = this.setDatabaseType((String)this.p_properties.get(ADEMPIERE_DB_TYPE));
            this.initDatabase((String)this.p_properties.get(ADEMPIERE_DB_NAME), dbTypeIndex);
            if (loaded.containsKey(ADEMPIERE_DB_NAME)) {
                this.setDatabaseDiscovered((String)loaded.get(ADEMPIERE_DB_NAME));
            }
            if (loaded.containsKey(ADEMPIERE_DB_SERVER)) {
                this.setDatabaseServer((String)loaded.get(ADEMPIERE_DB_SERVER));
            }
            if (loaded.containsKey(ADEMPIERE_DB_PORT)) {
                this.setDatabasePort((String)loaded.get(ADEMPIERE_DB_PORT));
            }
            if (loaded.containsKey(ADEMPIERE_DB_NAME)) {
                this.setDatabaseName((String)loaded.get(ADEMPIERE_DB_NAME));
            }
            if (loaded.containsKey(ADEMPIERE_DB_USER)) {
                this.setDatabaseUser((String)loaded.get(ADEMPIERE_DB_USER));
            }
            if (loaded.containsKey(ADEMPIERE_DB_PASSWORD)) {
                this.setDatabasePassword((String)loaded.get(ADEMPIERE_DB_PASSWORD));
            }
            if (loaded.containsKey(ADEMPIERE_DB_SYSTEM)) {
                this.setDatabaseSystemPassword((String)loaded.get(ADEMPIERE_DB_SYSTEM));
            }
            if (loaded.containsKey(ADEMPIERE_DB_EXISTS)) {
                this.setDatabaseExists((String)loaded.get(ADEMPIERE_DB_EXISTS));
            }
            if (this.p_panel != null) {
                this.p_panel.fMailServer.setText((String)this.p_properties.get(ADEMPIERE_MAIL_SERVER));
                this.p_panel.fMailUser.setText((String)this.p_properties.get(ADEMPIERE_MAIL_USER));
                this.p_panel.fMailPassword.setText((String)this.p_properties.get(ADEMPIERE_MAIL_PASSWORD));
                this.p_panel.fAdminEMail.setText((String)this.p_properties.get(ADEMPIERE_ADMIN_EMAIL));
            }
        } else {
            this.setDatabaseType(Database.DB_POSTGRESQL);
        }
        InetAddress localhost = null;
        try {
            localhost = InetAddress.getLocalHost();
            localhost.getHostName();
        }
        catch (Exception exception) {
            log.severe("Cannot get local host name");
        }
        if (!envLoaded) {
            log.info("Defaults");
            this.initJava();
            this.setAdempiereHome(adempiereHome);
            this.setKeyStore(KEYSTORE_PASSWORD);
            this.initAppsServer();
            this.setAppsServer("0.0.0.0");
            this.initDatabase(Database.DB_POSTGRESQL);
            String connectionName = this.getDatabaseDiscovered();
            if (connectionName != null && connectionName.trim().length() > 0) {
                this.setDatabaseName(this.resolveDatabaseName(connectionName));
            }
            this.setDatabaseSystemPassword("");
            this.setDatabaseServer("localhost");
            this.setDatabaseUser("adempiere");
            this.setDatabasePassword("adempiere");
            this.setMailServer("localhost");
            this.setMailUser("");
            this.setMailPassword("");
            this.setAdminEMail("");
        }
        if (!this.p_properties.containsKey(ADEMPIERE_FTP_SERVER)) {
            this.p_properties.setProperty(ADEMPIERE_FTP_SERVER, "localhost");
            this.p_properties.setProperty(ADEMPIERE_FTP_USER, "anonymous");
            this.p_properties.setProperty(ADEMPIERE_FTP_PASSWORD, "user@host.com");
            this.p_properties.setProperty(ADEMPIERE_FTP_PREFIX, "my");
        }
        if (!this.p_properties.containsKey(IDEMPIERE_JAVA_OPTIONS)) {
            this.p_properties.setProperty(IDEMPIERE_JAVA_OPTIONS, "-Xms64M -Xmx512M");
        }
        if (!this.p_properties.containsKey(ADEMPIERE_WEB_ALIAS) && localhost != null) {
            this.p_properties.setProperty(ADEMPIERE_WEB_ALIAS, localhost.getCanonicalHostName());
        }
        if (!this.p_properties.containsKey(ADEMPIERE_KEYSTORECODEALIAS)) {
            this.p_properties.setProperty(ADEMPIERE_KEYSTORECODEALIAS, "idempiere");
        }
        if (!this.p_properties.containsKey(ADEMPIERE_KEYSTOREWEBALIAS)) {
            this.p_properties.setProperty(ADEMPIERE_KEYSTOREWEBALIAS, "idempiere");
        }
        return true;
    }

    public String resolveDatabaseName(String connectionName) {
        int index = this.p_panel.fDatabaseType.getSelectedIndex();
        if (index < 0 || index >= DBTYPE.length) {
            log.warning("DatabaseType Index invalid: " + index);
        } else if (this.m_databaseConfig[index] == null) {
            log.warning("DatabaseType Config missing: " + DBTYPE[index]);
        } else {
            return this.m_databaseConfig[index].getDatabaseName(connectionName);
        }
        return connectionName;
    }

    public boolean test(IDBConfigMonitor monitor) {
        String error = this.testJava();
        if (error != null) {
            log.severe(error);
            return false;
        }
        error = this.testAdempiere();
        if (error != null) {
            log.warning(error);
            return false;
        }
        if (this.p_panel != null) {
            this.p_panel.setStatusBar(this.p_panel.lAppsServer.getText());
        }
        if ((error = this.testAppsServer()) != null) {
            log.warning(error);
            return false;
        }
        if (this.p_panel != null) {
            this.p_panel.setStatusBar(this.p_panel.lDatabaseServer.getText());
        }
        if ((error = this.testDatabase(monitor)) != null) {
            log.warning(error);
            return false;
        }
        if (this.p_panel != null) {
            this.p_panel.setStatusBar(this.p_panel.lMailServer.getText());
        }
        if ((error = this.testMail()) != null) {
            log.warning(error);
            return false;
        }
        return true;
    }

    public String testAdempiere() {
        this.m_adempiereHome = new File(this.getAdempiereHome());
        boolean pass = this.m_adempiereHome.exists();
        Object error = "Not found: AdempiereHome = " + String.valueOf(this.m_adempiereHome);
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okAdempiereHome, "ErrorAdempiereHome", pass, true, (String)error);
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: AdempiereHome = " + String.valueOf(this.m_adempiereHome));
        }
        this.p_properties.setProperty(IDEMPIERE_HOME, this.m_adempiereHome.getAbsolutePath());
        System.setProperty(IDEMPIERE_HOME, this.m_adempiereHome.getAbsolutePath());
        String fileName = KeyStoreMgt.getKeystoreFileName(this.m_adempiereHome.getAbsolutePath());
        this.p_properties.setProperty(ADEMPIERE_KEYSTORE, fileName);
        String pw = this.p_panel != null ? new String(this.p_panel.fKeyStore.getPassword()) : (String)this.p_properties.get(ADEMPIERE_KEYSTOREPASS);
        pass = pw != null && pw.length() > 0;
        error = "Invalid Key Store Password = " + pw;
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okKeyStore, "KeyStorePassword", pass, true, (String)error);
        }
        if (!pass) {
            return error;
        }
        this.p_properties.setProperty(ADEMPIERE_KEYSTOREPASS, pw);
        KeyStoreMgt ks = this.p_panel != null ? new KeyStoreMgt(fileName, this.p_panel.fKeyStore.getPassword()) : new KeyStoreMgt(fileName, pw.toCharArray());
        ks.setCommonName(this.p_properties.getProperty(ADEMPIERE_CERT_CN));
        ks.setOrganization(this.p_properties.getProperty(ADEMPIERE_CERT_ORG));
        ks.setOrganizationUnit(this.p_properties.getProperty(ADEMPIERE_CERT_ORG_UNIT));
        ks.setLocation(this.p_properties.getProperty(ADEMPIERE_CERT_LOCATION));
        ks.setState(this.p_properties.getProperty(ADEMPIERE_CERT_STATE));
        ks.setCountry(this.p_properties.getProperty(ADEMPIERE_CERT_COUNTRY));
        error = this.p_panel != null ? ks.verify((JFrame)SwingUtilities.getWindowAncestor(this.p_panel), this.p_properties.getProperty(ADEMPIERE_KEYSTOREWEBALIAS)) : ks.verify(null, this.p_properties.getProperty(ADEMPIERE_KEYSTOREWEBALIAS));
        boolean bl = pass = error == null;
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okKeyStore, "KeyStorePassword", pass, true, (String)error);
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: KeyStore = " + fileName);
        }
        return null;
    }

    public String testMail() {
        String server = this.p_panel != null ? this.p_panel.fMailServer.getText() : (String)this.p_properties.get(ADEMPIERE_MAIL_SERVER);
        boolean pass = server != null && server.length() > 0;
        String error = "Error Mail Server = " + server;
        InetAddress mailServer = null;
        try {
            if (pass) {
                mailServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        if (this.p_panel != null) {
            this.p_panel.signalOK(this.p_panel.okMailServer, "ErrorMailServer", pass, true, error);
        }
        if (!pass) {
            this.p_properties.setProperty(ADEMPIERE_MAIL_SERVER, "");
            return error;
        }
        this.p_properties.setProperty(ADEMPIERE_MAIL_SERVER, mailServer.getHostName());
        String mailUser = this.p_panel != null ? this.p_panel.fMailUser.getText() : (String)this.p_properties.get(ADEMPIERE_MAIL_USER);
        String mailPassword = this.p_panel != null ? new String(this.p_panel.fMailPassword.getPassword()) : (String)this.p_properties.get(ADEMPIERE_MAIL_PASSWORD);
        String adminEMailString = this.p_panel != null ? this.p_panel.fAdminEMail.getText() : (String)this.p_properties.get(ADEMPIERE_ADMIN_EMAIL);
        InternetAddress adminEMail = null;
        if (adminEMailString != null && adminEMailString.length() > 0) {
            try {
                adminEMail = new InternetAddress(adminEMailString);
            }
            catch (Exception e) {
                error = "Not valid: " + adminEMailString + " - " + e.getMessage();
                pass = false;
            }
            if (pass) {
                error = "Not verified EMail = " + String.valueOf(adminEMail);
                pass = this.testMailServer(mailServer, adminEMail, mailUser, mailPassword);
            }
            if (this.p_panel != null) {
                this.p_panel.signalOK(this.p_panel.okMailUser, "ErrorMail", pass, false, error);
            }
        } else {
            pass = false;
        }
        if (pass) {
            if (log.isLoggable(Level.INFO)) {
                log.info("OK: EMail = " + String.valueOf(adminEMail));
            }
            this.p_properties.setProperty(ADEMPIERE_ADMIN_EMAIL, adminEMail.toString());
            this.p_properties.setProperty(ADEMPIERE_MAIL_USER, mailUser);
            this.p_properties.setProperty(ADEMPIERE_MAIL_PASSWORD, mailPassword);
            this.p_properties.setProperty(ADEMPIERE_MAIL_UPDATED, "No");
        } else {
            if (adminEMailString != null && adminEMailString.length() > 0) {
                log.warning(error);
            } else if (log.isLoggable(Level.INFO)) {
                log.info("OK: EMail not configured");
            }
            this.p_properties.setProperty(ADEMPIERE_ADMIN_EMAIL, "");
            this.p_properties.setProperty(ADEMPIERE_MAIL_USER, "");
            this.p_properties.setProperty(ADEMPIERE_MAIL_PASSWORD, "");
            this.p_properties.setProperty(ADEMPIERE_MAIL_UPDATED, "");
        }
        return null;
    }

    private boolean testMailServer(InetAddress mailServer, InternetAddress adminEMail, String mailUser, String mailPassword) {
        boolean isGmail = mailServer.getHostName().equalsIgnoreCase("smtp.gmail.com");
        boolean smtpOK = false;
        boolean imapOK = false;
        if (this.testPort(mailServer, isGmail ? 587 : 25, true)) {
            log.config("OK: SMTP Server contacted");
            smtpOK = true;
        } else {
            log.info("SMTP Server NOT available");
        }
        if (this.testPort(mailServer, isGmail ? 995 : 110, true)) {
            log.config("OK: POP3 Server contacted");
        } else {
            log.info("POP3 Server NOT available");
        }
        if (this.testPort(mailServer, isGmail ? 993 : 143, true)) {
            log.config("OK: IMAP4 Server contacted");
            imapOK = true;
        } else {
            log.info("IMAP4 Server NOT available");
        }
        if (!smtpOK) {
            String error = "No active Mail Server";
            if (this.p_panel != null) {
                this.p_panel.signalOK(this.p_panel.okMailServer, "ErrorMailServer", false, false, error);
            }
            log.warning(error);
            return false;
        }
        try {
            String admail = adminEMail.toString();
            StringBuilder msg = new StringBuilder("Test: \n");
            this.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = k.toString();
                String value = v.toString();
                msg.append(key).append("=");
                if (secretVars.contains(key)) {
                    msg.append("********");
                } else {
                    msg.append(value);
                }
                msg.append("\n");
            }));
            EMail email = new EMail(new Properties(), mailServer.getHostName(), admail, admail, "iDempiere Server Setup Test", msg.toString());
            email.createAuthenticator(mailUser, mailPassword);
            if ("OK".equals(email.send())) {
                if (log.isLoggable(Level.INFO)) {
                    log.info("OK: Send Test Email to " + String.valueOf(adminEMail));
                }
            } else {
                log.warning("Could NOT send Email to " + String.valueOf(adminEMail));
            }
        }
        catch (Exception ex) {
            log.severe(ex.getLocalizedMessage());
            return false;
        }
        if (!imapOK) {
            return false;
        }
        Properties props = new Properties();
        props.put("mail.store.protocol", "smtp");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.host", mailServer.getHostName());
        props.put("mail.user", mailUser);
        props.put("mail.smtp.auth", "true");
        if (isGmail) {
            props.put("mail.imaps.port", "993");
            props.put("mail.store.protocol", "imaps");
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Connecting to " + mailServer.getHostName());
        }
        Session session = null;
        Store store = null;
        try {
            EMailAuthenticator auth = new EMailAuthenticator(mailUser, mailPassword);
            session = Session.getDefaultInstance((Properties)props, (Authenticator)auth);
            session.setDebug(CLogMgt.isLevelFinest());
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Session=" + String.valueOf(session));
            }
            store = session.getStore(isGmail ? "imaps" : "imap");
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Store=" + String.valueOf(store));
            }
        }
        catch (NoSuchProviderException nsp) {
            log.warning("Mail IMAP Provider - " + nsp.getMessage());
            return false;
        }
        catch (Exception e) {
            log.warning("Mail IMAP - " + e.getMessage());
            return false;
        }
        try {
            store.connect(mailServer.getHostName(), mailUser, mailPassword);
            log.config("Store - connected");
            Folder folder = store.getDefaultFolder();
            Folder inbox = folder.getFolder("INBOX");
            if (log.isLoggable(Level.INFO)) {
                log.info("OK: Mail Connect to " + inbox.getFullName() + " #Msg=" + inbox.getMessageCount());
            }
            store.close();
        }
        catch (MessagingException mex) {
            log.severe("Mail Connect " + mex.getMessage());
            return false;
        }
        return true;
    }

    public boolean testPort(String protocol, String server, int port, String file) {
        System.out.println("testPort[" + protocol + "," + server + ", " + port + ", " + file + "]");
        URL url = null;
        try {
            url = new URL(protocol, server, port, file);
        }
        catch (MalformedURLException ex) {
            log.severe("No URL for Protocol=" + protocol + ", Server=" + server + ": " + ex.getMessage());
            return false;
        }
        try {
            URLConnection c = url.openConnection();
            Object o = c.getContent();
            if (o == null) {
                log.warning("In use=" + String.valueOf(url));
            } else {
                log.warning("In Use=" + String.valueOf(url));
            }
        }
        catch (Exception exception) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Not used=" + String.valueOf(url));
            }
            return false;
        }
        return true;
    }

    protected boolean testServerPort(int port) {
        System.out.println("testServerPort: " + port);
        try {
            ServerSocket ss = new ServerSocket(port);
            if (log.isLoggable(Level.FINE)) {
                log.fine(String.valueOf(ss.getInetAddress()) + ":" + ss.getLocalPort() + " - created");
            }
            ss.close();
        }
        catch (Exception ex) {
            log.warning("Port " + port + ": " + ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean testPort(InetAddress host, int port, boolean shouldBeUsed) {
        System.out.println("testPort[" + host.getHostAddress() + ", " + port + "]");
        Socket pingSocket = null;
        try {
            try {
                pingSocket = new Socket(host, port);
            }
            catch (Exception e) {
                if (shouldBeUsed) {
                    log.warning("Open Socket " + String.valueOf(host) + ":" + port + " - " + e.getMessage());
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine(String.valueOf(host) + ":" + port + " - " + e.getMessage());
                }
                if (pingSocket != null) {
                    try {
                        pingSocket.close();
                    }
                    catch (IOException iOException) {}
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            if (pingSocket != null) {
                try {
                    pingSocket.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (pingSocket != null) {
            try {
                pingSocket.close();
            }
            catch (IOException iOException) {}
        }
        if (!shouldBeUsed) {
            log.warning("Open Socket " + String.valueOf(host) + ":" + port + " - " + String.valueOf(pingSocket));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.valueOf(host) + ":" + port + " - " + String.valueOf(pingSocket));
        }
        try {
            pingSocket.close();
        }
        catch (IOException e) {
            log.warning("close socket=" + e.toString());
        }
        return true;
    }

    public boolean save() {
        String fileName;
        block34: {
            this.p_properties.setProperty("ADEMPIERE_MAIN_VERSION", Adempiere.MAIN_VERSION);
            this.p_properties.setProperty("ADEMPIERE_DATE_VERSION", Adempiere.DATE_VERSION);
            this.p_properties.setProperty("ADEMPIERE_DB_VERSION", Adempiere.DB_VERSION);
            if (log.isLoggable(Level.FINEST)) {
                log.finest(this.p_properties.toString());
            }
            Ini.setClient((boolean)false);
            fileName = this.m_adempiereHome.getAbsolutePath() + File.separator + "idempiere.properties";
            Ini.loadProperties((String)fileName);
            fileName = this.m_adempiereHome.getAbsolutePath() + File.separator + IDEMPIERE_ENV_FILE;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(new File(fileName));
                Properties secretProperties = new Properties();
                if (MSystem.isSecureProps()) {
                    for (String secretVar : secretVars) {
                        String secretValue = this.p_properties.getProperty(secretVar);
                        if (secretValue != null) {
                            secretProperties.put(secretVar, secretValue);
                            Ini.setVar((String)secretVar, (String)secretValue);
                        }
                        this.p_properties.remove(secretVar);
                    }
                }
                String keystorePass = this.p_properties.getProperty(ADEMPIERE_KEYSTOREPASS);
                String obfKeystorePass = Password.obfuscate((String)keystorePass);
                this.p_properties.put(ADEMPIERE_KEYSTOREPASS, obfKeystorePass);
                this.p_properties.store(fos, IDEMPIERE_ENV_FILE);
                this.p_properties.put(ADEMPIERE_KEYSTOREPASS, keystorePass);
                if (MSystem.isSecureProps()) {
                    this.p_properties.putAll((Map<?, ?>)secretProperties);
                }
                fos.flush();
            }
            catch (Exception e) {
                log.severe("Cannot save Properties to " + fileName + " - " + e.toString());
                if (this.p_panel != null) {
                    JOptionPane.showConfirmDialog(this.p_panel, ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
                } else {
                    System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        log.severe("Cannot close file " + fileName);
                        if (this.p_panel != null) {
                            JOptionPane.showConfirmDialog(this.p_panel, ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
                        } else {
                            System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
                        }
                        return false;
                    }
                }
                return false;
            }
            catch (Throwable t) {
                block33: {
                    try {
                        log.severe("Cannot save Properties to " + fileName + " - " + t.toString());
                        if (this.p_panel != null) {
                            JOptionPane.showConfirmDialog(this.p_panel, ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
                        } else {
                            System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
                        }
                        if (fos == null) break block33;
                    }
                    catch (Throwable throwable) {
                        if (fos != null) {
                            try {
                                fos.close();
                            }
                            catch (IOException iOException) {
                                log.severe("Cannot close file " + fileName);
                                if (this.p_panel != null) {
                                    JOptionPane.showConfirmDialog(this.p_panel, ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
                                } else {
                                    System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
                                }
                                return false;
                            }
                        }
                        throw throwable;
                    }
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {
                        log.severe("Cannot close file " + fileName);
                        if (this.p_panel != null) {
                            JOptionPane.showConfirmDialog(this.p_panel, ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
                        } else {
                            System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
                        }
                        return false;
                    }
                }
                return false;
            }
            if (fos == null) break block34;
            try {
                fos.close();
            }
            catch (IOException iOException) {
                log.severe("Cannot close file " + fileName);
                if (this.p_panel != null) {
                    JOptionPane.showConfirmDialog(this.p_panel, ConfigurationPanel.res.getString("ErrorSave"), ConfigurationPanel.res.getString("AdempiereServerSetup"), -1, 0);
                } else {
                    System.err.println(ConfigurationPanel.res.getString("ErrorSave"));
                }
                return false;
            }
        }
        log.info(fileName);
        return this.saveIni();
    }

    private boolean saveIni() {
        Ini.setAdempiereHome((String)this.m_adempiereHome.getAbsolutePath());
        String ccType = Database.DB_ORACLE;
        if (this.getDatabaseType() != null && !this.getDatabaseType().equals(Database.DB_ORACLE)) {
            ccType = this.getDatabaseType();
        }
        CConnection cc = null;
        try {
            cc = CConnection.get((String)ccType, (String)this.getDatabaseServer(), (int)this.getDatabasePort(), (String)this.getDatabaseName(), (String)this.getDatabaseUser(), (String)this.getDatabasePassword());
            cc.setAppsHost(this.getAppsServer());
            cc.setWebPort(this.getAppsServerWebPort());
            cc.setSSLPort(this.getAppsServerSSLPort());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "connection", (Throwable)e);
            return false;
        }
        if (MSystem.isSecureProps()) {
            Ini.setProperty((String)"Connection", (String)cc.toStringLong(false));
        } else {
            Ini.setProperty((String)"Connection", (String)cc.toStringLong(true));
        }
        Arrays.asList("org.eclipse.jetty.ee8.annotations.AnnotationParser.TraceLevel", "org.eclipse.jetty.ee8.osgi.annotations.AnnotationParser.TraceLevel").forEach(p -> {
            if (Util.isEmpty((String)Ini.getProperty((String)p), (boolean)true)) {
                Ini.setProperty((String)p, (String)"SEVERE");
            }
        });
        Ini.saveProperties((boolean)false);
        return true;
    }

    Properties getProperties() {
        return this.p_properties;
    }

    public String getAdempiereHome() {
        return this.p_panel != null ? this.p_panel.fAdempiereHome.getText() : (String)this.p_properties.get(IDEMPIERE_HOME);
    }

    public void setAdempiereHome(String adempiereHome) {
        if (this.p_panel != null) {
            this.p_panel.fAdempiereHome.setText(adempiereHome);
        } else {
            this.updateProperty(IDEMPIERE_HOME, adempiereHome);
        }
    }

    public String getKeyStore() {
        if (this.p_panel != null) {
            char[] pw = this.p_panel.fKeyStore.getPassword();
            if (pw != null) {
                return new String(pw);
            }
        } else {
            String pw = this.getProperty(ADEMPIERE_KEYSTOREPASS);
            if (pw != null) {
                return pw;
            }
        }
        return "";
    }

    public void setKeyStore(String password) {
        if (this.p_panel != null) {
            this.p_panel.fKeyStore.setText(password);
        } else {
            this.updateProperty(ADEMPIERE_KEYSTOREPASS, password);
        }
    }

    public void initJava() {
        this.m_javaConfig.init();
    }

    public String testJava() {
        return this.m_javaConfig.test();
    }

    public String getJavaHome() {
        if (this.p_panel != null) {
            return this.p_panel.fJavaHome.getText();
        }
        return (String)this.p_properties.get(JAVA_HOME);
    }

    public void setJavaHome(String javaHome) {
        if (this.p_panel != null) {
            this.p_panel.fJavaHome.setText(javaHome);
        } else {
            this.updateProperty(JAVA_HOME, javaHome);
        }
    }

    public String getJavaOptions() {
        if (this.p_panel != null) {
            return this.p_panel.fJavaOptions.getText();
        }
        return (String)this.p_properties.get(IDEMPIERE_JAVA_OPTIONS);
    }

    public void setJavaOptions(String javaOptions) {
        if (this.p_panel != null) {
            this.p_panel.fJavaOptions.setText(javaOptions);
        } else {
            this.updateProperty(IDEMPIERE_JAVA_OPTIONS, javaOptions);
        }
    }

    public void initAppsServer() {
        this.m_appsConfig.init();
    }

    public String testAppsServer() {
        return this.m_appsConfig.test();
    }

    public String getAppsServer() {
        return this.p_panel != null ? this.p_panel.fAppsServer.getText() : (String)this.p_properties.get(ADEMPIERE_APPS_SERVER);
    }

    public void setAppsServer(String appsServer) {
        if (this.p_panel != null) {
            this.p_panel.fAppsServer.setText(appsServer);
        } else {
            this.updateProperty(ADEMPIERE_APPS_SERVER, appsServer);
        }
    }

    public int getAppsServerSSLPort() {
        String port = this.p_panel != null ? this.p_panel.fSSLPort.getText() : (String)this.p_properties.get(ADEMPIERE_SSL_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception exception) {
            this.setAppsServerSSLPort("0");
            return 0;
        }
    }

    public void setAppsServerSSLPort(String appsServerSSLPort) {
        if (this.p_panel != null) {
            this.p_panel.fSSLPort.setText(appsServerSSLPort);
        } else {
            this.updateProperty(ADEMPIERE_SSL_PORT, appsServerSSLPort);
        }
    }

    public void setAppsServerSSLPort(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fSSLPort.setEnabled(enable);
        }
    }

    public int getAppsServerWebPort() {
        String port = this.p_panel != null ? this.p_panel.fWebPort.getText() : (String)this.p_properties.get(ADEMPIERE_WEB_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception exception) {
            this.setAppsServerWebPort("0");
            return 0;
        }
    }

    public void setAppsServerWebPort(String appsServerWebPort) {
        if (this.p_panel != null) {
            this.p_panel.fWebPort.setText(appsServerWebPort);
        } else {
            this.updateProperty(ADEMPIERE_WEB_PORT, appsServerWebPort);
        }
    }

    public void setAppsServerWebPort(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fWebPort.setEnabled(enable);
        }
    }

    public void initDatabase(String selected) {
        int index;
        int n = index = this.p_panel != null ? this.p_panel.fDatabaseType.getSelectedIndex() : -1;
        if (index < 0) {
            int i = 0;
            while (i < DBTYPE.length) {
                if (DBTYPE[i].equals(selected)) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index < 0) {
                index = 0;
            }
        }
        this.initDatabase(selected, index);
    }

    private void initDatabase(String selected, int index) {
        if (index < 0 || index >= DBTYPE.length) {
            log.warning("DatabaseType Index invalid: " + index);
        } else if (this.m_databaseConfig[index] == null) {
            log.warning("DatabaseType Config missing: " + DBTYPE[index]);
            if (this.p_panel != null) {
                this.p_panel.fDatabaseType.setSelectedIndex(0);
            }
        } else {
            if (!this.p_properties.containsKey(ADEMPIERE_DB_NAME) && !this.p_properties.containsKey(ADEMPIERE_DB_PORT)) {
                this.m_databaseConfig[index].init(this);
            }
            if (this.p_panel != null) {
                String[] databases = this.m_databaseConfig[index].discoverDatabases(selected);
                DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(databases);
                this.p_panel.fDatabaseDiscovered.setModel(model);
                this.p_panel.fDatabaseDiscovered.setEnabled(databases.length != 0);
                if (databases.length > 0) {
                    this.p_panel.fDatabaseName.setText(databases[0]);
                }
            }
        }
    }

    public String testDatabase(IDBConfigMonitor monitor) {
        int index;
        int n = index = this.p_panel != null ? this.p_panel.fDatabaseType.getSelectedIndex() : this.setDatabaseType((String)this.p_properties.get(ADEMPIERE_DB_TYPE));
        if (index < 0 || index >= DBTYPE.length) {
            return "DatabaseType Index invalid: " + index;
        }
        if (this.m_databaseConfig[index] == null) {
            return "DatabaseType Config class missing: " + index;
        }
        return this.m_databaseConfig[index].test(monitor, this);
    }

    public int setDatabaseType(String databaseType) {
        int index = -1;
        int i = 0;
        while (i < DBTYPE.length) {
            if (DBTYPE[i].equals(databaseType)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            index = 0;
            log.warning("Invalid DatabaseType=" + databaseType);
        }
        if (this.p_panel != null) {
            this.p_panel.fDatabaseType.setSelectedIndex(index);
        } else {
            this.updateProperty(ADEMPIERE_DB_TYPE, databaseType);
        }
        return index;
    }

    public String getDatabaseType() {
        return this.p_panel != null ? (String)this.p_panel.fDatabaseType.getSelectedItem() : (String)this.p_properties.get(ADEMPIERE_DB_TYPE);
    }

    public String getDatabaseDiscovered() {
        return this.p_panel != null ? (String)this.p_panel.fDatabaseDiscovered.getSelectedItem() : "";
    }

    public void setDatabaseDiscovered(String databaseDiscovered) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseDiscovered.setSelectedItem(databaseDiscovered);
        }
    }

    public String getDatabaseName() {
        return this.p_panel != null ? this.p_panel.fDatabaseName.getText() : (String)this.p_properties.get(ADEMPIERE_DB_NAME);
    }

    public void setDatabaseName(String databaseName) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseName.setText(databaseName);
        } else {
            this.updateProperty(ADEMPIERE_DB_NAME, databaseName);
        }
    }

    public String getDatabasePassword() {
        if (this.p_panel != null) {
            char[] pw = this.p_panel.fDatabasePassword.getPassword();
            if (pw != null) {
                return new String(pw);
            }
            return "";
        }
        String pw = (String)this.p_properties.get(ADEMPIERE_DB_PASSWORD);
        return pw != null ? pw : "";
    }

    public void setDatabasePassword(String databasePassword) {
        if (this.p_panel != null) {
            this.p_panel.fDatabasePassword.setText(databasePassword);
        } else {
            this.updateProperty(ADEMPIERE_DB_PASSWORD, databasePassword);
        }
    }

    public int getDatabasePort() {
        String port = this.p_panel != null ? this.p_panel.fDatabasePort.getText() : (String)this.p_properties.get(ADEMPIERE_DB_PORT);
        try {
            return Integer.parseInt(port);
        }
        catch (Exception exception) {
            this.setDatabasePort("0");
            return 0;
        }
    }

    public void setDatabasePort(String databasePort) {
        if (this.p_panel != null) {
            this.p_panel.fDatabasePort.setText(databasePort);
        } else {
            this.updateProperty(ADEMPIERE_DB_PORT, databasePort);
        }
    }

    public String getDatabaseServer() {
        return this.p_panel != null ? this.p_panel.fDatabaseServer.getText() : (String)this.p_properties.get(ADEMPIERE_DB_SERVER);
    }

    public void setDatabaseServer(String databaseServer) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseServer.setText(databaseServer);
        } else {
            this.updateProperty(ADEMPIERE_DB_SERVER, databaseServer);
        }
    }

    public String getDatabaseSystemPassword() {
        if (this.p_panel != null) {
            char[] pw = this.p_panel.fSystemPassword.getPassword();
            if (pw != null) {
                return new String(pw);
            }
            return "";
        }
        String pw = (String)this.p_properties.get(ADEMPIERE_DB_SYSTEM);
        return pw != null ? pw : "";
    }

    public void setDatabaseSystemPassword(String databaseSystemPassword) {
        if (this.p_panel != null) {
            this.p_panel.fSystemPassword.setText(databaseSystemPassword);
        } else {
            this.updateProperty(ADEMPIERE_DB_SYSTEM, databaseSystemPassword);
        }
    }

    public void setDatabaseSystemPassword(boolean enable) {
        if (this.p_panel != null) {
            this.p_panel.fSystemPassword.setEnabled(enable);
        }
    }

    public void setDatabaseExists(String dbExists) {
        if (this.p_panel != null) {
            this.p_panel.okdbExists.setSelected("Y".equalsIgnoreCase(dbExists));
        } else {
            this.updateProperty(ADEMPIERE_DB_EXISTS, dbExists);
        }
    }

    public boolean getDatabaseExists() {
        Object dbExists = this.p_properties.get(ADEMPIERE_DB_EXISTS);
        dbExists = dbExists == null ? "N" : dbExists.toString();
        return this.p_panel != null ? this.p_panel.okdbExists.isSelected() : "Y".equalsIgnoreCase((String)dbExists);
    }

    public String getDatabaseUser() {
        return this.p_panel != null ? this.p_panel.fDatabaseUser.getText() : (String)this.p_properties.get(ADEMPIERE_DB_USER);
    }

    public void setDatabaseUser(String databaseUser) {
        if (this.p_panel != null) {
            this.p_panel.fDatabaseUser.setText(databaseUser);
        } else {
            this.updateProperty(ADEMPIERE_DB_USER, databaseUser);
        }
    }

    public String getMailServer() {
        return this.p_panel != null ? this.p_panel.fMailServer.getText() : (String)this.p_properties.get(ADEMPIERE_MAIL_SERVER);
    }

    public void setMailServer(String mailServer) {
        if (this.p_panel != null) {
            this.p_panel.fMailServer.setText(mailServer);
        } else {
            this.updateProperty(ADEMPIERE_MAIL_SERVER, mailServer);
        }
    }

    public String getMailUser() {
        return this.p_panel != null ? this.p_panel.fMailUser.getText() : (String)this.p_properties.get(ADEMPIERE_MAIL_USER);
    }

    public void setMailUser(String mailUser) {
        if (this.p_panel != null) {
            this.p_panel.fMailUser.setText(mailUser);
        } else {
            this.updateProperty(ADEMPIERE_MAIL_USER, mailUser);
        }
    }

    public String getMailPassword() {
        if (this.p_panel != null) {
            char[] pw = this.p_panel.fMailPassword.getPassword();
            if (pw != null) {
                return new String(pw);
            }
            return "";
        }
        String pw = (String)this.p_properties.get(ADEMPIERE_MAIL_PASSWORD);
        return pw != null ? pw : "";
    }

    public void setMailPassword(String mailPassword) {
        if (this.p_panel != null) {
            this.p_panel.fMailPassword.setText(mailPassword);
        } else {
            this.updateProperty(ADEMPIERE_MAIL_PASSWORD, mailPassword);
        }
    }

    public String getAdminEMail() {
        return this.p_panel != null ? this.p_panel.fAdminEMail.getText() : (String)this.p_properties.get(ADEMPIERE_ADMIN_EMAIL);
    }

    public void setAdminEMail(String adminEMail) {
        if (this.p_panel != null) {
            this.p_panel.fAdminEMail.setText(adminEMail);
        } else {
            this.updateProperty(ADEMPIERE_ADMIN_EMAIL, adminEMail);
        }
    }

    public String getWebStores(Connection con) {
        StringBuilder result;
        block7: {
            String sql = "SELECT WebContext FROM W_Store WHERE IsActive='Y'";
            Statement stmt = null;
            ResultSet rs = null;
            result = new StringBuilder();
            try {
                try {
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        if (result.length() > 0) {
                            result.append(",");
                        }
                        result.append(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    log.severe(e.toString());
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
        }
        return result.toString();
    }

    public void setProperty(String key, String value) {
        this.p_properties.setProperty(key, value);
    }

    public void dbChanged() {
        this.p_properties.remove(ADEMPIERE_DB_NAME);
        this.p_properties.remove(ADEMPIERE_DB_PORT);
    }
}

