/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.util.Env;

public class Doc_GLJournal
extends Doc {
    protected String m_PostingType = null;
    protected int m_C_AcctSchema_ID = 0;

    public Doc_GLJournal(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MJournal.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MJournal journal = (MJournal)this.getPO();
        this.m_PostingType = journal.getPostingType();
        this.m_C_AcctSchema_ID = journal.getC_AcctSchema_ID();
        this.p_lines = this.loadLines(journal);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    protected DocLine[] loadLines(MJournal journal) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MJournalLine[] lines = journal.getLines(false);
        int i2 = 0;
        while (i2 < lines.length) {
            MJournalLine line = lines[i2];
            DocLine docLine = new DocLine(line, this);
            docLine.setQty(line.getQty(), false);
            docLine.setAmount(line.getAmtSourceDr(), line.getAmtSourceCr());
            docLine.setConvertedAmt(this.m_C_AcctSchema_ID, line.getAmtAcctDr(), line.getAmtAcctCr());
            MAccount account = line.getAccount_Combi();
            docLine.setAccount(account);
            list.add(docLine);
            if (docLine.getC_Currency_ID() != this.getC_Currency_ID()) {
                this.setIsMultiCurrency(true);
            }
            ++i2;
        }
        int size = list.size();
        DocLine[] dls = new DocLine[size];
        list.toArray(dls);
        return dls;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        int i2 = 0;
        while (i2 < this.p_lines.length) {
            retValue = retValue.add(this.p_lines[i2].getAmtSource());
            sb.append("+").append(this.p_lines[i2].getAmtSource());
            ++i2;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(this.toString() + " Balance=" + String.valueOf(retValue) + sb.toString());
        }
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (as.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            return facts;
        }
        Fact fact = new Fact(this, as, this.m_PostingType);
        if (this.getDocumentType().equals("GLJ")) {
            int i2 = 0;
            while (i2 < this.p_lines.length) {
                if (this.p_lines[i2].getC_AcctSchema_ID() == as.getC_AcctSchema_ID()) {
                    fact.createLine(this.p_lines[i2], this.p_lines[i2].getAccount(), this.p_lines[i2].getC_Currency_ID(), this.p_lines[i2].getAmtSourceDr(), this.p_lines[i2].getAmtSourceCr());
                }
                ++i2;
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        facts.add(fact);
        return facts;
    }
}

