/******************************************************************************
 * Product: iDempiere ERP & CRM Smart Business Solution                       *
 * Copyright (C) 1999-2012 ComPiere, Inc. All Rights Reserved.                *
 * This program is free software, you can redistribute it and/or modify it    *
 * under the terms version 2 of the GNU General Public License as published   *
 * by the Free Software Foundation. This program is distributed in the hope   *
 * that it will be useful, but WITHOUT ANY WARRANTY, without even the implied *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.           *
 * See the GNU General Public License for more details.                       *
 * You should have received a copy of the GNU General Public License along    *
 * with this program, if not, write to the Free Software Foundation, Inc.,    *
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.                     *
 * For the text or an alternative of this public license, you may reach us    *
 * ComPiere, Inc., 2620 Augustine Dr. #245, Santa Clara, CA 95054, USA        *
 * or via info@compiere.org or http://www.compiere.org/license.html           *
 *****************************************************************************/
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.compiere.util.KeyNamePair;

/** Generated Interface for R_Status
 *  @author iDempiere (generated) 
 *  @version Release 12
 */
public interface I_R_Status 
{

    /** TableName=R_Status */
    public static final String Table_Name = "R_Status";

    /** AD_Table_ID=776 */
    public static final int Table_ID = 776;

    KeyNamePair Model = new KeyNamePair(Table_ID, Table_Name);

    /** AccessLevel = 6 - System - Client 
     */
    BigDecimal accessLevel = BigDecimal.valueOf(6);

    /** Load Meta Data */

    /** Column name AD_Client_ID */
    public static final String COLUMNNAME_AD_Client_ID = "AD_Client_ID";

	/** Get Tenant.
	  * Tenant for this installation.
	  */
	public int getAD_Client_ID();

    /** Column name AD_Org_ID */
    public static final String COLUMNNAME_AD_Org_ID = "AD_Org_ID";

	/** Set Organization.
	  * Organizational entity within tenant
	  */
	public void setAD_Org_ID (int AD_Org_ID);

	/** Get Organization.
	  * Organizational entity within tenant
	  */
	public int getAD_Org_ID();

    /** Column name Created */
    public static final String COLUMNNAME_Created = "Created";

	/** Get Created.
	  * Date this record was created
	  */
	public Timestamp getCreated();

    /** Column name CreatedBy */
    public static final String COLUMNNAME_CreatedBy = "CreatedBy";

	/** Get Created By.
	  * User who created this records
	  */
	public int getCreatedBy();

    /** Column name Description */
    public static final String COLUMNNAME_Description = "Description";

	/** Set Description.
	  * Optional short description of the record
	  */
	public void setDescription (String Description);

	/** Get Description.
	  * Optional short description of the record
	  */
	public String getDescription();

    /** Column name Help */
    public static final String COLUMNNAME_Help = "Help";

	/** Set Comment/Help.
	  * Comment or Hint
	  */
	public void setHelp (String Help);

	/** Get Comment/Help.
	  * Comment or Hint
	  */
	public String getHelp();

    /** Column name IsActive */
    public static final String COLUMNNAME_IsActive = "IsActive";

	/** Set Active.
	  * The record is active in the system
	  */
	public void setIsActive (boolean IsActive);

	/** Get Active.
	  * The record is active in the system
	  */
	public boolean isActive();

    /** Column name IsClosed */
    public static final String COLUMNNAME_IsClosed = "IsClosed";

	/** Set Closed Status.
	  * The status is closed
	  */
	public void setIsClosed (boolean IsClosed);

	/** Get Closed Status.
	  * The status is closed
	  */
	public boolean isClosed();

    /** Column name IsDefault */
    public static final String COLUMNNAME_IsDefault = "IsDefault";

	/** Set Default.
	  * Default value
	  */
	public void setIsDefault (boolean IsDefault);

	/** Get Default.
	  * Default value
	  */
	public boolean isDefault();

    /** Column name IsFinalClose */
    public static final String COLUMNNAME_IsFinalClose = "IsFinalClose";

	/** Set Final Close.
	  * Entries with Final Close cannot be re-opened
	  */
	public void setIsFinalClose (boolean IsFinalClose);

	/** Get Final Close.
	  * Entries with Final Close cannot be re-opened
	  */
	public boolean isFinalClose();

    /** Column name IsOpen */
    public static final String COLUMNNAME_IsOpen = "IsOpen";

	/** Set Open Status.
	  * The status is closed
	  */
	public void setIsOpen (boolean IsOpen);

	/** Get Open Status.
	  * The status is closed
	  */
	public boolean isOpen();

    /** Column name IsWebCanUpdate */
    public static final String COLUMNNAME_IsWebCanUpdate = "IsWebCanUpdate";

	/** Set Web Can Update.
	  * Entry can be updated from the Web
	  */
	public void setIsWebCanUpdate (boolean IsWebCanUpdate);

	/** Get Web Can Update.
	  * Entry can be updated from the Web
	  */
	public boolean isWebCanUpdate();

    /** Column name Name */
    public static final String COLUMNNAME_Name = "Name";

	/** Set Name.
	  * Alphanumeric identifier of the entity
	  */
	public void setName (String Name);

	/** Get Name.
	  * Alphanumeric identifier of the entity
	  */
	public String getName();

    /** Column name Next_Status_ID */
    public static final String COLUMNNAME_Next_Status_ID = "Next_Status_ID";

	/** Set Next Status.
	  * Move to next status automatically after timeout
	  */
	public void setNext_Status_ID (int Next_Status_ID);

	/** Get Next Status.
	  * Move to next status automatically after timeout
	  */
	public int getNext_Status_ID();

	public org.compiere.model.I_R_Status getNext_Status() throws RuntimeException;

    /** Column name R_StatusCategory_ID */
    public static final String COLUMNNAME_R_StatusCategory_ID = "R_StatusCategory_ID";

	/** Set Status Category.
	  * Request Status Category
	  */
	public void setR_StatusCategory_ID (int R_StatusCategory_ID);

	/** Get Status Category.
	  * Request Status Category
	  */
	public int getR_StatusCategory_ID();

	public org.compiere.model.I_R_StatusCategory getR_StatusCategory() throws RuntimeException;

    /** Column name R_Status_ID */
    public static final String COLUMNNAME_R_Status_ID = "R_Status_ID";

	/** Set Status.
	  * Request Status
	  */
	public void setR_Status_ID (int R_Status_ID);

	/** Get Status.
	  * Request Status
	  */
	public int getR_Status_ID();

    /** Column name R_Status_UU */
    public static final String COLUMNNAME_R_Status_UU = "R_Status_UU";

	/** Set R_Status_UU	  */
	public void setR_Status_UU (String R_Status_UU);

	/** Get R_Status_UU	  */
	public String getR_Status_UU();

    /** Column name SeqNo */
    public static final String COLUMNNAME_SeqNo = "SeqNo";

	/** Set Sequence.
	  * Method of ordering records;
 lowest number comes first
	  */
	public void setSeqNo (int SeqNo);

	/** Get Sequence.
	  * Method of ordering records;
 lowest number comes first
	  */
	public int getSeqNo();

    /** Column name TimeoutDays */
    public static final String COLUMNNAME_TimeoutDays = "TimeoutDays";

	/** Set Timeout in Days.
	  * Timeout in Days to change Status automatically
	  */
	public void setTimeoutDays (int TimeoutDays);

	/** Get Timeout in Days.
	  * Timeout in Days to change Status automatically
	  */
	public int getTimeoutDays();

    /** Column name Update_Status_ID */
    public static final String COLUMNNAME_Update_Status_ID = "Update_Status_ID";

	/** Set Update Status.
	  * Automatically change the status after entry from web
	  */
	public void setUpdate_Status_ID (int Update_Status_ID);

	/** Get Update Status.
	  * Automatically change the status after entry from web
	  */
	public int getUpdate_Status_ID();

	public org.compiere.model.I_R_Status getUpdate_Status() throws RuntimeException;

    /** Column name Updated */
    public static final String COLUMNNAME_Updated = "Updated";

	/** Get Updated.
	  * Date this record was updated
	  */
	public Timestamp getUpdated();

    /** Column name UpdatedBy */
    public static final String COLUMNNAME_UpdatedBy = "UpdatedBy";

	/** Get Updated By.
	  * User who updated this records
	  */
	public int getUpdatedBy();

    /** Column name Value */
    public static final String COLUMNNAME_Value = "Value";

	/** Set Search Key.
	  * Search key for the record in the format required - must be unique
	  */
	public void setValue (String Value);

	/** Get Search Key.
	  * Search key for the record in the format required - must be unique
	  */
	public String getValue();
}
