/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MDunningLevel;
import org.compiere.model.MDunningRun;
import org.compiere.model.MDunningRunEntry;
import org.compiere.model.MMailText;
import org.compiere.model.MProcessPara;
import org.compiere.model.MQuery;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.EMail;
import org.compiere.util.Language;
import org.compiere.util.Util;

@Process
public class DunningPrint
extends SvrProcess {
    private boolean p_EMailPDF = false;
    private int p_R_MailText_ID = 0;
    private int p_C_DunningRun_ID = 0;
    private boolean p_IsOnlyIfBPBalance = true;
    private boolean p_PrintUnprocessedOnly = true;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("EMailPDF")) {
                    this.p_EMailPDF = "Y".equals(para[i].getParameter());
                } else if (name.equals("R_MailText_ID")) {
                    this.p_R_MailText_ID = para[i].getParameterAsInt();
                } else if (name.equals("C_DunningRun_ID")) {
                    this.p_C_DunningRun_ID = para[i].getParameterAsInt();
                } else if (name.equals("IsOnlyIfBPBalance")) {
                    this.p_IsOnlyIfBPBalance = "Y".equals(para[i].getParameter());
                } else if (name.equals("PrintUnprocessedOnly")) {
                    this.p_PrintUnprocessedOnly = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MDunningRun run;
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("C_DunningRun_ID=" + this.p_C_DunningRun_ID + ",R_MailText_ID=" + this.p_R_MailText_ID + ", EmailPDF=" + this.p_EMailPDF + ",IsOnlyIfBPBalance=" + this.p_IsOnlyIfBPBalance + ",PrintUnprocessedOnly=" + this.p_PrintUnprocessedOnly);
        }
        if (this.p_EMailPDF && this.p_R_MailText_ID == 0) {
            throw new AdempiereUserError("@NotFound@: @R_MailText_ID@");
        }
        MMailText mText = null;
        if (this.p_EMailPDF) {
            mText = new MMailText(this.getCtx(), this.p_R_MailText_ID, this.get_TrxName());
            if (this.p_EMailPDF && mText.get_ID() == 0) {
                throw new AdempiereUserError("@NotFound@: @R_MailText_ID@ - " + this.p_R_MailText_ID);
            }
        }
        if ((run = new MDunningRun(this.getCtx(), this.p_C_DunningRun_ID, this.get_TrxName())).get_ID() == 0) {
            throw new AdempiereUserError("@NotFound@: @C_DunningRun_ID@ - " + this.p_C_DunningRun_ID);
        }
        MClient client = MClient.get((Properties)this.getCtx());
        int count = 0;
        int errors = 0;
        MDunningRunEntry[] entries = run.getEntries(false);
        int i = 0;
        while (i < entries.length) {
            block19: {
                boolean printed;
                MDunningRunEntry entry;
                block25: {
                    ReportEngine re;
                    block23: {
                        EMail email;
                        MUser to;
                        MBPartner bp;
                        block24: {
                            MPrintFormat format;
                            block21: {
                                StringBuilder msglog;
                                block22: {
                                    block20: {
                                        entry = entries[i];
                                        MDunningLevel level = new MDunningLevel(this.getCtx(), entry.getC_DunningLevel_ID(), this.get_TrxName());
                                        format = null;
                                        if (level.getDunning_PrintFormat_ID() > 0) {
                                            format = MPrintFormat.get((Properties)this.getCtx(), (int)level.getDunning_PrintFormat_ID(), (boolean)false);
                                        }
                                        if (this.p_IsOnlyIfBPBalance && entry.getAmt().signum() <= 0 || this.p_PrintUnprocessedOnly && entry.isProcessed()) break block19;
                                        bp = new MBPartner(this.getCtx(), entry.getC_BPartner_ID(), this.get_TrxName());
                                        if (bp.get_ID() != 0) break block20;
                                        StringBuilder msglog2 = new StringBuilder("@NotFound@: @C_BPartner_ID@ ").append(entry.getC_BPartner_ID());
                                        this.addLog(entry.get_ID(), null, null, msglog2.toString());
                                        ++errors;
                                        break block19;
                                    }
                                    to = new MUser(this.getCtx(), entry.getAD_User_ID(), this.get_TrxName());
                                    if (!this.p_EMailPDF) break block21;
                                    if (to.get_ID() != 0) break block22;
                                    msglog = new StringBuilder("@NotFound@: @AD_User_ID@ - ").append(bp.getName());
                                    this.addLog(entry.get_ID(), null, null, msglog.toString());
                                    ++errors;
                                    break block19;
                                }
                                if (to.getEMail() != null && to.getEMail().length() != 0) break block21;
                                msglog = new StringBuilder("@NotFound@: @EMail@ - ").append(to.getName());
                                this.addLog(entry.get_ID(), null, null, msglog.toString());
                                ++errors;
                                break block19;
                            }
                            MQuery query = new MQuery("C_Dunning_Header_v");
                            query.addRestriction("C_DunningRunEntry_ID", "=", (Object)entry.getC_DunningRunEntry_ID());
                            PrintInfo info = new PrintInfo(bp.getName(), 527, entry.getC_DunningRunEntry_ID(), entry.getC_BPartner_ID());
                            StringBuilder msginfo = new StringBuilder().append(bp.getName()).append(", Amt=").append(entry.getAmt());
                            info.setDescription(msginfo.toString());
                            re = null;
                            if (format != null) {
                                Language lang = client.getLanguage();
                                if (!Util.isEmpty((String)bp.getAD_Language())) {
                                    lang = Language.getLanguage((String)bp.getAD_Language());
                                }
                                format.setLanguage(lang);
                                re = new ReportEngine(this.getCtx(), format, query, info);
                            }
                            printed = false;
                            if (!this.p_EMailPDF) break block23;
                            email = client.createEMail(to.getEMail(), null, null);
                            if (email.isValid()) break block24;
                            StringBuilder msglog = new StringBuilder("@RequestActionEMailError@ Invalid EMail: ").append(to);
                            this.addLog(entry.get_ID(), null, null, msglog.toString());
                            ++errors;
                            break block19;
                        }
                        mText.setUser(to);
                        mText.setBPartner(bp);
                        mText.setPO((PO)entry);
                        String message = mText.getMailText(true);
                        if (mText.isHtml()) {
                            email.setMessageHTML(mText.getMailHeader(), message);
                        } else {
                            email.setSubject(mText.getMailHeader());
                            email.setMessageText(message);
                        }
                        if (re != null) {
                            File attachment = re.getPDF(File.createTempFile("Dunning", ".pdf"));
                            StringBuilder msglog = new StringBuilder().append(to.toString()).append(" - ").append(attachment);
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.fine(msglog.toString());
                            }
                            email.addAttachment(attachment);
                        }
                        String msg = email.send();
                        MUserMail um = new MUserMail(mText, entry.getAD_User_ID(), email);
                        um.saveEx();
                        if (msg.equals("OK")) {
                            msglog = new StringBuilder().append(bp.getName()).append(" @RequestActionEMailOK@");
                            this.addLog(entry.get_ID(), null, null, msglog.toString());
                            ++count;
                            printed = true;
                        } else {
                            msglog = new StringBuilder().append(bp.getName()).append(" @RequestActionEMailError@ ").append(msg);
                            this.addLog(entry.get_ID(), null, null, msglog.toString());
                            ++errors;
                        }
                        break block25;
                    }
                    if (re != null) {
                        re.print();
                        ++count;
                        printed = true;
                    }
                }
                if (printed) {
                    entry.setProcessed(true);
                    entry.saveEx();
                }
            }
            ++i;
        }
        if (errors == 0) {
            run.setProcessed(true);
            run.saveEx();
        }
        if (this.p_EMailPDF) {
            StringBuilder msgreturn = new StringBuilder("@Sent@=").append(count).append(" - @Errors@=").append(errors);
            return msgreturn.toString();
        }
        StringBuilder msgreturn = new StringBuilder("@Printed@=").append(count);
        return msgreturn.toString();
    }
}

