/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.math.BigDecimal;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.MTree_Base;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

@Process
public class CleanOrphanCascade
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("");
        }
        ValueNamePair[] treeTables = new ValueNamePair[]{new ValueNamePair("AD_TreeBar", "AD_Menu"), new ValueNamePair("AD_TreeNodeBP", "C_BPartner"), new ValueNamePair("AD_TreeNodeCMC", "CM_Container"), new ValueNamePair("AD_TreeNodeCMM", "CM_Media"), new ValueNamePair("AD_TreeNodeCMS", "CM_CStage"), new ValueNamePair("AD_TreeNodeCMT", "CM_Template"), new ValueNamePair("AD_TreeNodeMM", "AD_Menu"), new ValueNamePair("AD_TreeNodePR", "M_Product"), new ValueNamePair("AD_TreeNodeU1", "C_ElementValue"), new ValueNamePair("AD_TreeNodeU2", "C_ElementValue"), new ValueNamePair("AD_TreeNodeU3", "C_ElementValue"), new ValueNamePair("AD_TreeNodeU4", "C_ElementValue")};
        ValueNamePair[] valueNamePairArray = treeTables;
        int n = treeTables.length;
        int n2 = 0;
        while (n2 < n) {
            ValueNamePair vnp = valueNamePairArray[n2];
            String treeTable = vnp.getValue();
            String foreignTable = vnp.getName();
            this.delTree(treeTable, foreignTable, "Node_ID", 0);
            if (!"AD_TreeBar".equalsIgnoreCase(treeTable)) {
                this.delTree(treeTable, foreignTable, "Parent_ID", 0);
            }
            ++n2;
        }
        this.delTree("AD_Tree_Favorite_Node", "AD_Tree_Favorite_Node", "Parent_ID", 0);
        List trees = new Query(this.getCtx(), "AD_Tree", null, this.get_TrxName()).list();
        String treeTable = "AD_TreeNode";
        for (MTree_Base tree : trees) {
            String foreignTable = tree.getSourceTableName(true);
            this.delTree(treeTable, foreignTable, "Parent_ID", tree.getAD_Tree_ID());
        }
        String whereTables = "    IsView = 'N' AND EXISTS (SELECT 1             FROM   AD_Column ct             WHERE  ct.IsActive='Y' AND ct.AD_Table_ID = AD_Table.AD_Table_ID                    AND ct.ColumnName = 'AD_Table_ID') AND EXISTS (SELECT 1             FROM   AD_Column cr             WHERE  cr.IsActive='Y' AND cr.AD_Table_ID = AD_Table.AD_Table_ID                    AND (cr.ColumnName = 'Record_ID' OR cr.ColumnName = 'Record_UU'))";
        List tables = new Query(this.getCtx(), "AD_Table", whereTables, this.get_TrxName()).setOnlyActiveRecords(true).setOrderBy("TableName").list();
        for (MTable table : tables) {
            String tableName = table.getTableName();
            if (tableName.startsWith("T_")) continue;
            MColumn colRecordID = MColumn.get((Properties)this.getCtx(), (String)tableName, (String)"Record_ID", (String)this.get_TrxName());
            MColumn colRecordUU = MColumn.get((Properties)this.getCtx(), (String)tableName, (String)"Record_UU", (String)this.get_TrxName());
            StringBuilder sqlRef = new StringBuilder();
            sqlRef.append("SELECT DISTINCT t.AD_Table_ID, ");
            sqlRef.append("                t.TableName ");
            sqlRef.append("FROM   ").append(tableName).append(" r ");
            sqlRef.append("       JOIN AD_Table t ON ( r.AD_Table_ID = t.AD_Table_ID ) ");
            sqlRef.append("ORDER  BY t.Tablename");
            List rowTables = DB.getSQLArrayObjectsEx((String)this.get_TrxName(), (String)sqlRef.toString(), (Object[])new Object[0]);
            if (rowTables == null) continue;
            for (List row : rowTables) {
                List poList;
                int noIgnored;
                int noSetNull;
                int noDeleted;
                StringBuilder whereClause;
                int refTableID = ((BigDecimal)row.get(0)).intValue();
                String refTableName = row.get(1).toString();
                MTable refTable = MTable.get((Properties)this.getCtx(), (int)refTableID);
                String colRef = refTable.getKeyColumns()[0];
                String colRefUU = PO.getUUIDColumnName((String)refTableName);
                if (colRecordID != null && refTable.isIDKeyTable()) {
                    whereClause = new StringBuilder("AD_Table_ID=").append(refTableID).append(" AND Record_ID>0").append(" AND NOT EXISTS (SELECT ").append(colRef).append("                FROM   ").append(refTableName).append(" ").append("                WHERE  ").append(refTableName).append(".").append(colRef).append(" = ").append(tableName).append(".Record_ID)");
                    noDeleted = 0;
                    noSetNull = 0;
                    noIgnored = 0;
                    poList = new Query(this.getCtx(), tableName, whereClause.toString(), this.get_TrxName()).list();
                    for (PO po : poList) {
                        if ("M".equals(colRecordID.getFKConstraintType())) {
                            po.deleteEx(true, this.get_TrxName());
                            ++noDeleted;
                            continue;
                        }
                        if ("T".equals(colRecordID.getFKConstraintType())) {
                            if (colRecordID.isMandatory()) {
                                po.set_ValueOfColumn("Record_ID", (Object)0);
                            } else {
                                po.set_ValueOfColumn("Record_ID", null);
                            }
                            po.saveEx(this.get_TrxName());
                            ++noSetNull;
                            continue;
                        }
                        ++noIgnored;
                    }
                    if (noDeleted > 0 || noSetNull > 0 || noIgnored > 0) {
                        this.addLog(Msg.parseTranslation((Properties)this.getCtx(), (String)(tableName + ".Record_ID: " + noIgnored + " @Ignored@ / " + noDeleted + " @Deleted@ / " + noSetNull + " @Reset@ -> " + refTableName)));
                    }
                }
                if (colRecordUU == null) continue;
                whereClause = new StringBuilder("AD_Table_ID=").append(refTableID).append(" AND Record_UU IS NOT NULL").append(" AND NOT EXISTS (SELECT ").append(colRefUU).append("                FROM   ").append(refTableName).append(" ").append("                WHERE  ").append(refTableName).append(".").append(colRefUU).append(" = ").append(tableName).append(".Record_UU)");
                noDeleted = 0;
                noSetNull = 0;
                noIgnored = 0;
                poList = new Query(this.getCtx(), tableName, whereClause.toString(), this.get_TrxName()).list();
                for (PO po : poList) {
                    if ("M".equals(colRecordUU.getFKConstraintType())) {
                        po.deleteEx(true, this.get_TrxName());
                        ++noDeleted;
                        continue;
                    }
                    if ("T".equals(colRecordUU.getFKConstraintType())) {
                        if (colRecordUU.isMandatory()) {
                            po.set_ValueOfColumn("Record_UU", (Object)"");
                        } else {
                            po.set_ValueOfColumn("Record_UU", null);
                        }
                        po.saveEx(this.get_TrxName());
                        ++noSetNull;
                        continue;
                    }
                    ++noIgnored;
                }
                if (noDeleted <= 0 && noSetNull <= 0 && noIgnored <= 0) continue;
                this.addLog(Msg.parseTranslation((Properties)this.getCtx(), (String)(tableName + ".Record_UU: " + noIgnored + " @Ignored@ / " + noDeleted + " @Deleted@ / " + noSetNull + " @Reset@ -> " + refTableName)));
            }
        }
        return "@OK@";
    }

    private void delTree(String treeTable, String foreignTable, String columnName, int treeId) {
        String whereClause = columnName + ">0 AND  " + columnName + " NOT IN (SELECT " + foreignTable + "_ID FROM " + foreignTable + ")";
        if (treeId > 0) {
            whereClause = whereClause + " AND AD_Tree_ID=" + treeId;
        }
        List poList = new Query(this.getCtx(), treeTable, whereClause, this.get_TrxName()).list();
        int noDel = 0;
        for (PO po : poList) {
            po.deleteEx(true, this.get_TrxName());
            ++noDel;
        }
        if (noDel > 0) {
            this.addLog(Msg.parseTranslation((Properties)this.getCtx(), (String)(treeTable + ": " + noDel + " @Deleted@ -> " + foreignTable + (String)(treeId > 0 ? " Tree=" + treeId : ""))));
        }
    }
}

