/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base.callout;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.base.IColumnCallout;
import org.adempiere.base.annotation.Callout;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MCost;
import org.compiere.model.MInventory;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Callout(tableName={"M_InventoryLine"}, columnName={"M_AttributeSetInstance_ID"})
public class CostAdjustmentLineASI
implements IColumnCallout {
    public String start(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value, Object oldValue) {
        MInventory inventory;
        GridTable gt;
        String trxName = null;
        if (mTab != null && mTab.getTableModel() != null && (gt = mTab.getTableModel()).isImporting()) {
            trxName = gt.get_TrxName();
        }
        if ("CA".equals((inventory = new MInventory(ctx, ((Integer)mTab.getValue("M_Inventory_ID")).intValue(), trxName)).getC_DocType().getDocSubTypeInv())) {
            MCost cost;
            String costingMethod = inventory.getCostingMethod();
            Object productValue = mTab.getValue("M_Product_ID");
            if (productValue == null || (Integer)productValue == 0) {
                return null;
            }
            MProduct product = MProduct.get((Properties)ctx, (int)((Integer)productValue));
            int M_ASI_ID = value != null ? (Integer)value : 0;
            int AD_Org_ID = inventory.getAD_Org_ID();
            int C_Currency_ID = inventory.getC_Currency_ID();
            MClient client = MClient.get((Properties)ctx);
            MAcctSchema as = client.getAcctSchema();
            if (as.getC_Currency_ID() != C_Currency_ID) {
                MAcctSchema[] ass = MAcctSchema.getClientAcctSchema((Properties)ctx, (int)client.get_ID());
                int i = 0;
                while (i < ass.length) {
                    MAcctSchema a = ass[i];
                    if (a.getC_Currency_ID() == C_Currency_ID) {
                        as = a;
                    }
                    ++i;
                }
            }
            if ((cost = product.getCostingRecord(as, AD_Org_ID, M_ASI_ID, costingMethod)) == null && !"S".equals(costingMethod)) {
                mTab.setValue(mField, null);
                return Msg.getMsg((Properties)Env.getCtx(), (String)"NoCostingRecord");
            }
            if (cost != null) {
                BigDecimal currentCost = (BigDecimal)mTab.getValue("CurrentCostPrice");
                if (currentCost == null || currentCost.compareTo(cost.getCurrentCostPrice()) == 0) {
                    return null;
                }
                mTab.setValue("CurrentCostPrice", (Object)cost.getCurrentCostPrice());
                mTab.setValue("NewCostPrice", (Object)cost.getCurrentCostPrice());
            }
        }
        return null;
    }
}

