/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Messagebox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.LoginWindow;
import org.compiere.model.MPasswordRule;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.zkoss.zhtml.Div;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Image;

public class ChangePasswordPanel
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = -4117126419866788951L;
    private static final CLogger logger = CLogger.getCLogger(ChangePasswordPanel.class);
    protected LoginWindow wndLogin;
    protected Properties m_ctx;
    protected String m_userName;
    protected String m_userPassword;
    protected KeyNamePair[] m_clientKNPairs;
    protected boolean m_show = true;
    protected Label lblOldPassword;
    protected Label lblNewPassword;
    protected Label lblRetypeNewPassword;
    protected Label lblSecurityQuestion;
    protected Label lblAnswer;
    protected Combobox lstSecurityQuestion;
    protected Textbox txtOldPassword;
    protected Textbox txtNewPassword;
    protected Textbox txtRetypeNewPassword;
    protected Textbox txtAnswer;

    public ChangePasswordPanel(Properties ctx, LoginWindow loginWindow, String userName, String userPassword, boolean show, KeyNamePair[] clientsKNPairs) {
        this.wndLogin = loginWindow;
        this.m_ctx = ctx;
        this.m_userName = userName;
        this.m_userPassword = userPassword;
        this.m_show = show;
        this.m_clientKNPairs = clientsKNPairs;
        this.initComponents();
        this.init();
        this.setId("changePasswordPanel");
        this.setSclass("login-box");
    }

    private void init() {
        this.createUI();
    }

    protected void createUI() {
        Div div = new Div();
        div.setSclass("login-box-header");
        Label label = new Label(Msg.getMsg((Properties)this.m_ctx, (String)"ChangePassword"));
        label.setSclass("login-box-header-txt");
        div.appendChild((Component)label);
        this.appendChild((Component)div);
        Table table = new Table();
        table.setId("grdChangePassword");
        table.setDynamicProperty("cellpadding", (Object)"0");
        table.setDynamicProperty("cellspacing", (Object)"5");
        table.setSclass("login-box-body");
        this.appendChild((Component)table);
        Tr tr = new Tr();
        table.appendChild((Component)tr);
        Td td = new Td();
        td.setSclass("login-box-header-logo");
        tr.appendChild((Component)td);
        td.setDynamicProperty("colspan", (Object)"2");
        Image image = new Image();
        image.setSrc(ThemeManager.getLargeLogo());
        td.appendChild((Component)image);
        tr = new Tr();
        tr.setId("rowOldPassword");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblOldPassword);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtOldPassword);
        tr = new Tr();
        tr.setId("rowNewPassword");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblNewPassword);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtNewPassword);
        tr = new Tr();
        tr.setId("rowRetypeNewPassword");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblRetypeNewPassword);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtRetypeNewPassword);
        tr = new Tr();
        tr.setId("rowSecurityQuestion");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblSecurityQuestion);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.lstSecurityQuestion);
        tr = new Tr();
        tr.setId("rowAnswer");
        table.appendChild((Component)tr);
        td = new Td();
        tr.appendChild((Component)td);
        td.setSclass("login-label");
        td.appendChild((Component)this.lblAnswer);
        td = new Td();
        td.setSclass("login-field");
        tr.appendChild((Component)td);
        td.appendChild((Component)this.txtAnswer);
        div = new Div();
        div.setSclass("login-box-footer");
        ConfirmPanel pnlButtons = new ConfirmPanel(true);
        pnlButtons.addActionListener(this);
        LayoutUtils.addSclass("login-box-footer-pnl", (HtmlBasedComponent)pnlButtons);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlButtons, null);
        pnlButtons.getButton("Ok").setSclass("login-btn");
        pnlButtons.getButton("Cancel").setSclass("login-btn");
        div.appendChild((Component)pnlButtons);
        this.appendChild((Component)div);
    }

    private void initComponents() {
        this.lblOldPassword = new Label();
        this.lblOldPassword.setId("lblOldPassword");
        this.lblOldPassword.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"Old Password"));
        this.lblNewPassword = new Label();
        this.lblNewPassword.setId("lblNewPassword");
        this.lblNewPassword.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"New Password"));
        this.lblRetypeNewPassword = new Label();
        this.lblRetypeNewPassword.setId("lblRetypeNewPassword");
        this.lblRetypeNewPassword.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"New Password Confirm"));
        this.lblSecurityQuestion = new Label();
        this.lblSecurityQuestion.setId("lblSecurityQuestion");
        this.lblSecurityQuestion.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"SecurityQuestion"));
        this.lblAnswer = new Label();
        this.lblAnswer.setId("lblAnswer");
        this.lblAnswer.setValue(Msg.getMsg((Properties)this.m_ctx, (String)"Answer"));
        this.lstSecurityQuestion = new Combobox();
        this.lstSecurityQuestion.setAutocomplete(true);
        this.lstSecurityQuestion.setAutodrop(true);
        this.lstSecurityQuestion.setId("lstSecurityQuestion");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.lstSecurityQuestion, "220px");
        this.lstSecurityQuestion.getItems().clear();
        int i = 1;
        while (i <= 5) {
            this.lstSecurityQuestion.appendItem(Msg.getMsg((Properties)this.m_ctx, (String)("SecurityQuestion_" + i)), "SecurityQuestion_" + i);
            ++i;
        }
        this.txtOldPassword = new Textbox();
        this.txtOldPassword.setId("txtOldPassword");
        this.txtOldPassword.setType("password");
        this.txtOldPassword.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtOldPassword, "220px");
        this.txtNewPassword = new Textbox();
        this.txtNewPassword.setId("txtNewPassword");
        this.txtNewPassword.setType("password");
        this.txtNewPassword.setCols(25);
        this.txtNewPassword.addEventListener("onBlur", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtNewPassword, "220px");
        this.txtRetypeNewPassword = new Textbox();
        this.txtRetypeNewPassword.setId("txtRetypeNewPassword");
        this.txtRetypeNewPassword.setType("password");
        this.txtRetypeNewPassword.setCols(25);
        this.txtRetypeNewPassword.addEventListener("onBlur", this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtRetypeNewPassword, "220px");
        this.txtAnswer = new Textbox();
        this.txtAnswer.setId("txtAnswer");
        this.txtAnswer.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtAnswer, "220px");
    }

    public void onEvent(Event event) {
        if (event.getTarget().getId().equals("Ok")) {
            this.validateChangePassword();
        } else if (event.getTarget().getId().equals("Cancel")) {
            SessionManager.logoutSession();
        } else if (event.getTarget() == this.txtNewPassword) {
            MPasswordRule pwdrule = MPasswordRule.getRules((Properties)Env.getCtx(), null);
            if (pwdrule != null) {
                try {
                    pwdrule.validate(Login.getAppUser((String)this.m_userName), this.txtNewPassword.getValue(), new ArrayList());
                }
                catch (Exception e) {
                    throw new WrongValueException((Component)this.txtNewPassword, e.getMessage());
                }
            }
        } else if (event.getTarget() == this.txtRetypeNewPassword && !this.txtNewPassword.getValue().equals(this.txtRetypeNewPassword.getValue())) {
            throw new WrongValueException((Component)this.txtRetypeNewPassword, Msg.getMsg((Properties)this.m_ctx, (String)"PasswordNotMatch"));
        }
    }

    public void validateChangePassword() {
        Clients.clearBusy();
        String oldPassword = this.txtOldPassword.getValue();
        String newPassword = this.txtNewPassword.getValue();
        String retypeNewPassword = this.txtRetypeNewPassword.getValue();
        String securityQuestion = null;
        if (this.lstSecurityQuestion.getSelectedItem() != null) {
            securityQuestion = this.lstSecurityQuestion.getSelectedItem().getLabel();
        }
        String answer = this.txtAnswer.getValue();
        if (Util.isEmpty((String)oldPassword)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"OldPasswordMandatory"));
        }
        if (Util.isEmpty((String)retypeNewPassword)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"NewPasswordConfirmMandatory"));
        }
        if (!newPassword.equals(retypeNewPassword)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"PasswordNotMatch"));
        }
        if (Util.isEmpty((String)securityQuestion)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"SecurityQuestionMandatory"));
        }
        if (Util.isEmpty((String)answer)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"AnswerMandatory"));
        }
        if (!oldPassword.equals(this.m_userPassword)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"OldPasswordNoMatch"));
        }
        if (MSysConfig.getBooleanValue((String)"CHANGE_PASSWORD_MUST_DIFFER", (boolean)true) && oldPassword.equals(newPassword)) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)this.m_ctx, (String)"NewPasswordMustDiffer"));
        }
        StringBuilder tenantsChanged = new StringBuilder();
        try (Trx trx = null;){
            try {
                String trxName = Trx.createTrxName((String)"ChangePasswordTrx");
                trx = Trx.get((String)trxName, (boolean)true);
                trx.setDisplayName(this.getClass().getName() + "_validateChangePassword");
                KeyNamePair[] keyNamePairArray = this.m_clientKNPairs;
                int n = this.m_clientKNPairs.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyNamePair clientKNPair = keyNamePairArray[n2];
                    int clientId = clientKNPair.getKey();
                    Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (int)clientId);
                    MUser user = MUser.get((Properties)this.m_ctx, (String)Login.getAppUser((String)this.m_userName));
                    if (user == null) {
                        trx.rollback();
                        logger.severe("Could not find user '" + this.m_userName + "'");
                        throw new AdempiereException("Could not find user");
                    }
                    user.set_ValueOfColumn("Password", (Object)newPassword);
                    user.setIsExpired(false);
                    user.setSecurityQuestion(securityQuestion);
                    user.setAnswer(answer);
                    user.saveCrossTenantSafeEx(trx.getTrxName());
                    if (tenantsChanged.length() > 0) {
                        tenantsChanged.append(", ");
                    }
                    tenantsChanged.append(clientKNPair.getName());
                    ++n2;
                }
                trx.commit();
            }
            catch (AdempiereException e) {
                if (trx != null) {
                    trx.rollback();
                }
                throw e;
            }
        }
        String msg = Msg.getMsg((Properties)this.m_ctx, (String)"NewPasswordValidForAllTenants", (Object[])new Object[]{tenantsChanged});
        Messagebox.showDialog(msg, AEnv.getDialogHeader(Env.getCtx(), 0), 1, "~./zul/img/msgbox/info-btn.png", new Callback<Integer>(){

            public void onCallback(Integer result) {
                ChangePasswordPanel.this.wndLogin.loginOk(ChangePasswordPanel.this.m_userName, ChangePasswordPanel.this.m_show, ChangePasswordPanel.this.m_clientKNPairs);
            }
        });
    }
}

