/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.math.BigDecimal;
import java.util.Properties;
import org.compiere.apps.form.Match;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.MBPartner;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.MStorageReservation;
import org.compiere.model.MWarehouse;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.Env;
import org.compiere.util.Trx;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MatchPOTest
extends AbstractTestCase {
    @Test
    public void testOrderInvoiceReceiptMatching() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(new BigDecimal("3"));
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("3"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInOut receipt = new MInOut(invoice, DictionaryIDs.C_DocType.MM_RECEIPT.id, invoice.getDateInvoiced(), this.getM_Warehouse_ID());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setInvoiceLine(invoiceLine, M_Locator_ID, new BigDecimal("3"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("3"));
        receiptLine.saveEx();
        invoiceLine.load(this.getTrxName(), new String[0]);
        invoiceLine.setM_InOutLine_ID(receiptLine.getM_InOutLine_ID());
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MMatchPO[] matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchPOs[0].getC_InvoiceLine_ID());
        Assertions.assertTrue((matchPOs[0].getQty().compareTo(new BigDecimal("3")) == 0 ? 1 : 0) != 0);
        this.rollback();
    }

    @Test
    public void testOrderReceiptInvoiceMatching() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(new BigDecimal("3"));
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, new BigDecimal("3"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("3"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setShipLine(receiptLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("3"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MMatchPO[] matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchPOs[0].getC_InvoiceLine_ID());
        Assertions.assertTrue((matchPOs[0].getQty().compareTo(new BigDecimal("3")) == 0 ? 1 : 0) != 0);
        this.rollback();
    }

    @Test
    public void testOrderMultiInvoiceReceiptMatching() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(new BigDecimal("10"));
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("3"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MInOut receipt = new MInOut(invoice, DictionaryIDs.C_DocType.MM_RECEIPT.id, invoice.getDateInvoiced(), this.getM_Warehouse_ID());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setInvoiceLine(invoiceLine, M_Locator_ID, new BigDecimal("3"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("3"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MMatchPO[] matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchPOs[0].getC_InvoiceLine_ID());
        Assertions.assertTrue((matchPOs[0].getQty().compareTo(new BigDecimal("3")) == 0 ? 1 : 0) != 0);
        invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("7"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        invoice.getDocsPostProcess().clear();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"RE", (Object)invoice.getDocStatus());
        invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("7"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        receipt = new MInOut(invoice, DictionaryIDs.C_DocType.MM_RECEIPT.id, invoice.getDateInvoiced(), this.getM_Warehouse_ID());
        receipt.saveEx();
        receiptLine = new MInOutLine(receipt);
        receiptLine.setInvoiceLine(invoiceLine, M_Locator_ID, new BigDecimal("3"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("3"));
        receiptLine.saveEx();
        invoiceLine.load(this.getTrxName(), new String[0]);
        invoiceLine.setM_InOutLine_ID(receiptLine.getM_InOutLine_ID());
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchPOs[0].getC_InvoiceLine_ID());
        Assertions.assertTrue((matchPOs[0].getQty().compareTo(new BigDecimal("3")) == 0 ? 1 : 0) != 0, (String)("Expected 3 but got " + String.valueOf(matchPOs[0].getQty())));
        matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)invoiceLine.getC_OrderLine_ID(), (int)invoiceLine.getC_InvoiceLine_ID(), (String)this.getTrxName());
        receipt = new MInOut(invoice, DictionaryIDs.C_DocType.MM_RECEIPT.id, invoice.getDateInvoiced(), this.getM_Warehouse_ID());
        receipt.saveEx();
        receiptLine = new MInOutLine(receipt);
        receiptLine.setInvoiceLine(invoiceLine, M_Locator_ID, new BigDecimal("4"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("4"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchPOs[0].getC_InvoiceLine_ID());
        Assertions.assertTrue((matchPOs[0].getQty().compareTo(new BigDecimal("4")) == 0 ? 1 : 0) != 0, (String)("Expected 4 but got " + String.valueOf(matchPOs[0].getQty())));
        this.rollback();
    }

    @Test
    public void testOrderMultiReceiptInvoiceMatching() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(new BigDecimal("10"));
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, new BigDecimal("3"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("3"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setShipLine(receiptLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("3"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MMatchPO[] matchPOs = MMatchPO.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)matchPOs[0].getC_OrderLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchPOs[0].getM_InOutLine_ID());
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchPOs[0].getC_InvoiceLine_ID());
        Assertions.assertTrue((matchPOs[0].getQty().compareTo(new BigDecimal("3")) == 0 ? 1 : 0) != 0);
        receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, new BigDecimal("7"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("7"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setShipLine(receiptLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("3"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        MMatchInv[] matchInvoices = MMatchInv.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (int)invoiceLine.getC_InvoiceLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchInvoices.length);
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchInvoices[0].getC_InvoiceLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchInvoices[0].getM_InOutLine_ID());
        Assertions.assertTrue((matchInvoices[0].getQty().compareTo(new BigDecimal("3")) == 0 ? 1 : 0) != 0, (String)("Expected 3, get " + String.valueOf(matchInvoices[0].getQty())));
        invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setShipLine(receiptLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(new BigDecimal("4"));
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        matchInvoices = MMatchInv.get((Properties)Env.getCtx(), (int)receiptLine.getM_InOutLine_ID(), (int)invoiceLine.getC_InvoiceLine_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchInvoices.length);
        Assertions.assertEquals((int)invoiceLine.getC_InvoiceLine_ID(), (int)matchInvoices[0].getC_InvoiceLine_ID());
        Assertions.assertEquals((int)receiptLine.getM_InOutLine_ID(), (int)matchInvoices[0].getM_InOutLine_ID());
        Assertions.assertTrue((matchInvoices[0].getQty().compareTo(new BigDecimal("4")) == 0 ? 1 : 0) != 0, (String)("Expected 4, get " + String.valueOf(matchInvoices[0].getQty())));
        this.rollback();
    }

    @Test
    public void testReverseFullyMatchPO() {
        int qty;
        int matched;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        int initialOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        int initialOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        int newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 1), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, orderQty);
        receiptLine.setLine(10);
        receiptLine.setQty(orderQty);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)initialOnOrdered, (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        int newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
        MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        int matchedPOReverse = 200016;
        info = new ProcessInfo("MatchPOReverse", matchedPOReverse, 473, matchPOs[0].get_ID());
        ServerProcessCtl.process((ProcessInfo)info, (Trx)this.getTrx(), (boolean)false);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)receiptLine.getC_OrderLine_ID(), (String)"Unexpected order line ID value for receipt line");
        matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)2, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 1), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
        Match match = new Match();
        match.setTrxName(this.getTrxName());
        ColumnInfo[] layout = match.getColumnLayout();
        MiniTableImpl fromTable = new MiniTableImpl(layout);
        MiniTableImpl toTable = new MiniTableImpl(layout);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(2), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Material Receipt: " + fromTable.getRowCount()));
        int selectedRow = -1;
        int i = 0;
        while (i < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                int matched2 = ((Number)fromTable.getValueAt(i, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched2, (String)"Unexpected matched qty for Material Receipt line");
                int qty2 = ((Number)fromTable.getValueAt(i, 6)).intValue();
                Assertions.assertEquals((int)receiptLine.getMovementQty().intValue(), (int)qty2, (String)"Unexpected qty for Material Receipt line");
                selectedRow = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched Material Receipt line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(2), 1, true, true, false, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Order Line: " + fromTable.getRowCount()));
        int selectedOrderRow = -1;
        int i2 = 0;
        while (i2 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i2, 1);
            if (order.getDocumentNo().equals(docNo)) {
                int matched3 = ((Number)toTable.getValueAt(i2, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched3, (String)"Unexpected matched qty for PO line");
                int qty3 = ((Number)toTable.getValueAt(i2, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty3, (String)"Unexpected qty for PO line");
                selectedOrderRow = i2;
                break;
            }
            ++i2;
        }
        Assertions.assertTrue((selectedOrderRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched PO line");
        MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(orderQty);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)invoiceLine.getQtyInvoiced().intValue(), (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced");
        matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)3, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        fromTable.prepareTable(layout, null, null, false, null);
        toTable.prepareTable(layout, null, null, false, null);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(2), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Material Receipt: " + fromTable.getRowCount()));
        selectedRow = -1;
        int i3 = 0;
        while (i3 < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i3, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                matched = ((Number)fromTable.getValueAt(i3, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for Material Receipt line");
                qty = ((Number)fromTable.getValueAt(i3, 6)).intValue();
                Assertions.assertEquals((int)receiptLine.getMovementQty().intValue(), (int)qty, (String)"Unexpected qty for Material Receipt line");
                selectedRow = i3;
                break;
            }
            ++i3;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched Material Receipt line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(2), 1, true, true, false, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Order Line: " + fromTable.getRowCount()));
        selectedOrderRow = -1;
        i3 = 0;
        while (i3 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i3, 1);
            if (order.getDocumentNo().equals(docNo)) {
                matched = ((Number)toTable.getValueAt(i3, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for PO line");
                qty = ((Number)toTable.getValueAt(i3, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for PO line");
                selectedOrderRow = i3;
                break;
            }
            ++i3;
        }
        Assertions.assertTrue((selectedOrderRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched PO line");
        IDColumn idColumn = (IDColumn)toTable.getValueAt(selectedOrderRow, 0);
        idColumn.setSelected(true);
        match.cmd_process((IMiniTable)fromTable, (IMiniTable)toTable, 0, 1, match.getMatchTypeText(2), new BigDecimal(1));
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)receiptLine.getC_OrderLine_ID(), (String)"Unexpected order line ID value for receipt line");
        matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)3, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)initialOnOrdered, (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
    }

    @Test
    public void testReversePartialMatchPO() {
        int qty;
        int matched;
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        int initialOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        int initialOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("2");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)2, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        int newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 2), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        BigDecimal receiptQty = new BigDecimal("1");
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, receiptQty);
        receiptLine.setLine(10);
        receiptLine.setQty(receiptQty);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 1), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        int newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
        MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        int matchedPOReverse = 200016;
        info = new ProcessInfo("MatchPOReverse", matchedPOReverse, 473, matchPOs[0].get_ID());
        ServerProcessCtl.process((ProcessInfo)info, (Trx)this.getTrx(), (boolean)false);
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)2, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)receiptLine.getC_OrderLine_ID(), (String)"Unexpected order line ID value for receipt line");
        matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)2, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 2), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
        Match match = new Match();
        match.setTrxName(this.getTrxName());
        ColumnInfo[] layout = match.getColumnLayout();
        MiniTableImpl fromTable = new MiniTableImpl(layout);
        MiniTableImpl toTable = new MiniTableImpl(layout);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(2), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Material Receipt: " + fromTable.getRowCount()));
        int selectedRow = -1;
        int i = 0;
        while (i < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                int matched2 = ((Number)fromTable.getValueAt(i, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched2, (String)"Unexpected matched qty for Material Receipt line");
                int qty2 = ((Number)fromTable.getValueAt(i, 6)).intValue();
                Assertions.assertEquals((int)receiptLine.getMovementQty().intValue(), (int)qty2, (String)"Unexpected qty for Material Receipt line");
                selectedRow = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched Material Receipt line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(2), 1, true, true, false, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Order Line: " + fromTable.getRowCount()));
        int selectedOrderRow = -1;
        int i2 = 0;
        while (i2 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i2, 1);
            if (order.getDocumentNo().equals(docNo)) {
                int matched3 = ((Number)toTable.getValueAt(i2, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched3, (String)"Unexpected matched qty for PO line");
                int qty3 = ((Number)toTable.getValueAt(i2, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty3, (String)"Unexpected qty for PO line");
                selectedOrderRow = i2;
                break;
            }
            ++i2;
        }
        Assertions.assertTrue((selectedOrderRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched PO line");
        MInvoice invoice = new MInvoice(order, MDocType.getOfDocBaseType((Properties)Env.getCtx(), (String)"API")[0].getC_DocType_ID(), order.getDateAcct());
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
        invoiceLine.setOrderLine(orderLine);
        invoiceLine.setLine(10);
        invoiceLine.setProduct(product);
        invoiceLine.setQty(orderQty);
        invoiceLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        invoice.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)invoiceLine.getQtyInvoiced().intValue(), (int)orderLine.getQtyInvoiced().intValue(), (String)"Unexpected order line qty invoiced");
        fromTable.prepareTable(layout, null, null, false, null);
        toTable.prepareTable(layout, null, null, false, null);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(2), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Material Receipt: " + fromTable.getRowCount()));
        selectedRow = -1;
        int i3 = 0;
        while (i3 < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i3, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                matched = ((Number)fromTable.getValueAt(i3, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for Material Receipt line");
                qty = ((Number)fromTable.getValueAt(i3, 6)).intValue();
                Assertions.assertEquals((int)receiptLine.getMovementQty().intValue(), (int)qty, (String)"Unexpected qty for Material Receipt line");
                selectedRow = i3;
                break;
            }
            ++i3;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched Material Receipt line");
        fromTable.setSelectedRow(selectedRow);
        match.cmd_searchTo((IMiniTable)fromTable, (IMiniTable)toTable, match.getMatchTypeText(2), 1, true, true, false, false);
        Assertions.assertTrue((toTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Order Line: " + fromTable.getRowCount()));
        selectedOrderRow = -1;
        i3 = 0;
        while (i3 < toTable.getRowCount()) {
            String docNo = (String)toTable.getValueAt(i3, 1);
            if (order.getDocumentNo().equals(docNo)) {
                matched = ((Number)toTable.getValueAt(i3, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for PO line");
                qty = ((Number)toTable.getValueAt(i3, 6)).intValue();
                Assertions.assertEquals((int)orderLine.getQtyOrdered().intValue(), (int)qty, (String)"Unexpected qty for PO line");
                selectedOrderRow = i3;
                break;
            }
            ++i3;
        }
        Assertions.assertTrue((selectedOrderRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched PO line");
        IDColumn idColumn = (IDColumn)toTable.getValueAt(selectedOrderRow, 0);
        idColumn.setSelected(true);
        match.cmd_process((IMiniTable)fromTable, (IMiniTable)toTable, 0, 1, match.getMatchTypeText(2), new BigDecimal(1));
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)orderLine.getC_OrderLine_ID(), (int)receiptLine.getC_OrderLine_ID(), (String)"Unexpected order line ID value for receipt line");
        matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)4, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 1), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
    }

    @Test
    public void testVoidMatchOrder() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.ELM.id);
        int initialOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        int initialOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        BigDecimal orderQty = new BigDecimal("1");
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(orderQty);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        int newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnOrdered + 1), (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        BigDecimal receiptQty = new BigDecimal("1");
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, receiptQty);
        receiptLine.setLine(10);
        receiptLine.setQty(receiptQty);
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected order line qty ordered value");
        Assertions.assertEquals((int)1, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected order line qty delivered value");
        newOnOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)initialOnOrdered, (int)newOnOrdered, (String)"Unexpected qty on ordered value");
        int newOnHand = MStorageOnHand.getQtyOnHand((int)product.get_ID(), (int)this.getM_Warehouse_ID(), (int)0, (String)this.getTrxName()).intValue();
        Assertions.assertEquals((int)(initialOnHand + 1), (int)newOnHand, (String)"Unexpected qty on hand value");
        MMatchPO[] matchPOs = MMatchPO.getOrderLine((Properties)Env.getCtx(), (int)orderLine.get_ID(), (String)this.getTrxName());
        Assertions.assertEquals((int)1, (int)matchPOs.length, (String)"Unexpected number of MatchPO for order line");
        order.setDocAction("VO");
        order.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"VO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"VO", (Object)order.getDocStatus());
        Match match = new Match();
        match.setTrxName(this.getTrxName());
        ColumnInfo[] layout = match.getColumnLayout();
        MiniTableImpl fromTable = new MiniTableImpl(layout);
        match.cmd_search((IMiniTable)fromTable, 1, match.getMatchTypeText(2), Integer.valueOf(product.get_ID()), Integer.valueOf(bpartner.get_ID()), null, null, false);
        Assertions.assertTrue((fromTable.getRowCount() > 0 ? 1 : 0) != 0, (String)("Unexpected number of records for not matched Material Receipt: " + fromTable.getRowCount()));
        int selectedRow = -1;
        int i = 0;
        while (i < fromTable.getRowCount()) {
            String docNo = (String)fromTable.getValueAt(i, 1);
            if (receipt.getDocumentNo().equals(docNo)) {
                int matched = ((Number)fromTable.getValueAt(i, 7)).intValue();
                Assertions.assertEquals((int)0, (int)matched, (String)"Unexpected matched qty for Material Receipt line");
                int qty = ((Number)fromTable.getValueAt(i, 6)).intValue();
                Assertions.assertEquals((int)receiptLine.getMovementQty().intValue(), (int)qty, (String)"Unexpected qty for Material Receipt line");
                selectedRow = i;
                break;
            }
            ++i;
        }
        Assertions.assertTrue((selectedRow >= 0 ? 1 : 0) != 0, (String)"Can't find not matched Material Receipt line");
        receiptLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)receiptLine.getC_OrderLine_ID(), (String)"Material receipt line: order line not clear after void of purchase order");
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)receipt.getC_Order_ID(), (String)"Material receipt: order not clear after void of purchase order");
    }

    @Test
    public void testReverseReceiptAfterClosePO() {
        MBPartner bpartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.TREE_FARM.id);
        MProduct product = MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.MULCH.id);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(bpartner);
        order.setIsSOTrx(false);
        order.setC_DocTypeTarget_ID();
        order.setDocStatus("DR");
        order.setDocAction("CO");
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(product);
        orderLine.setQty(new BigDecimal("4"));
        orderLine.saveEx();
        BigDecimal qtyOrdered = MStorageReservation.getQty((int)product.get_ID(), (int)order.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName());
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        BigDecimal qtyOrdered1 = MStorageReservation.getQty((int)product.get_ID(), (int)order.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName());
        Assertions.assertEquals((int)4, (int)qtyOrdered1.subtract(qtyOrdered).intValue(), (String)"QtyOrdered not increase as expected");
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.saveEx();
        MWarehouse wh = MWarehouse.get((Properties)Env.getCtx(), (int)receipt.getM_Warehouse_ID());
        int M_Locator_ID = wh.getDefaultLocator().getM_Locator_ID();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, M_Locator_ID, new BigDecimal("2"));
        receiptLine.setLine(10);
        receiptLine.setQty(new BigDecimal("2"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        qtyOrdered1 = MStorageReservation.getQty((int)product.get_ID(), (int)order.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName());
        Assertions.assertEquals((int)(qtyOrdered.intValue() + 2), (int)qtyOrdered1.intValue(), (String)"QtyOrdered not release as expected");
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)2, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected QtyDelivered");
        Assertions.assertEquals((int)2, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected QtyReserved");
        order.load(this.getTrxName(), new String[0]);
        info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CL");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CL", (Object)order.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)4, (int)orderLine.getQtyEntered().intValue(), (String)"Unexpected QtyEntered");
        Assertions.assertEquals((int)2, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected QtyDelivered");
        Assertions.assertEquals((int)2, (int)orderLine.getQtyOrdered().intValue(), (String)"Unexpected QtyOrdered");
        Assertions.assertEquals((int)2, (int)orderLine.getQtyLostSales().intValue(), (String)"Unexpected QtyLostSales");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected QtyReserved");
        qtyOrdered1 = MStorageReservation.getQty((int)product.get_ID(), (int)order.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName());
        Assertions.assertEquals((int)qtyOrdered.intValue(), (int)qtyOrdered1.intValue(), (String)"Unexpected change in QtyOrdered");
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"RA");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"RE", (Object)receipt.getDocStatus());
        orderLine.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)4, (int)orderLine.getQtyEntered().intValue(), (String)"Unexpected QtyEntered");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyDelivered().intValue(), (String)"Unexpected QtyDelivered");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyOrdered().intValue(), (String)"Unexpected QtyOrdered");
        Assertions.assertEquals((int)4, (int)orderLine.getQtyLostSales().intValue(), (String)"Unexpected QtyLostSales");
        Assertions.assertEquals((int)0, (int)orderLine.getQtyReserved().intValue(), (String)"Unexpected QtyReserved");
        qtyOrdered1 = MStorageReservation.getQty((int)product.get_ID(), (int)order.getM_Warehouse_ID(), (int)0, (boolean)false, (String)this.getTrxName());
        Assertions.assertEquals((int)qtyOrdered.intValue(), (int)qtyOrdered1.intValue(), (String)"Unexpected change in QtyOrdered");
    }
}

