/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.event;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.base.Core;
import org.adempiere.base.event.EventManager;
import org.adempiere.base.event.EventProperty;
import org.adempiere.base.event.FactsEventData;
import org.adempiere.base.event.annotations.AfterLogin;
import org.adempiere.base.event.annotations.BaseEventHandler;
import org.adempiere.base.event.annotations.EventDelegate;
import org.adempiere.base.event.annotations.ModelEventDelegate;
import org.adempiere.base.event.annotations.ModelEventHandler;
import org.adempiere.base.event.annotations.SimpleEventHandler;
import org.adempiere.base.event.annotations.doc.BeforeComplete;
import org.adempiere.base.event.annotations.doc.FactsValidateDelegate;
import org.adempiere.base.event.annotations.imp.AfterImport;
import org.adempiere.base.event.annotations.imp.ImportEventDelegate;
import org.adempiere.base.event.annotations.imp.ImportEventHandler;
import org.adempiere.base.event.annotations.po.BeforeNew;
import org.adempiere.base.event.annotations.process.AfterProcess;
import org.adempiere.base.event.annotations.process.ProcessEventDelegate;
import org.adempiere.base.event.annotations.process.ProcessEventHandler;
import org.adempiere.process.ImportProcess;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MLocation;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MSysConfig;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.X_I_BPartner;
import org.compiere.model.X_I_Product;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ImportBPartner;
import org.compiere.process.ImportProduct;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.CacheMgt;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.event.MyComponent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class EventHandlerTest
extends AbstractTestCase {
    private static final int BP_JOE_BLOCK = 118;
    private static final int PRODUCT_PLANTING_SERVICE = 126;

    @Test
    @Order(value=1)
    public void testModelEventHandler() {
        ModelEventHandler handler = new ModelEventHandler(MBPartner.class, MyBPBeforeNewDelegate.class, (bp, event) -> new MyBPBeforeNewDelegate((MBPartner)bp, (Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        MBPartner bpartner = new MBPartner(Env.getCtx(), 0, this.getTrxName());
        String name = "BP_" + System.currentTimeMillis();
        bpartner.setName(name);
        bpartner.setC_BP_Group_ID(103);
        bpartner.saveEx();
        String test = Env.getContext((Properties)Env.getCtx(), (String)MyBPBeforeNewDelegate.class.getName());
        Assertions.assertTrue((boolean)bpartner.getName().equals(test), (String)"MyBPBeforeNewDelegate not called");
        bpartner.setDescription("");
        bpartner.saveEx();
        test = Env.getContext((Properties)Env.getCtx(), (String)MyComponent.MyBpBeforeChangeDelegate.class.getName());
        Assertions.assertTrue((boolean)bpartner.toString().equals(test), (String)"MyComponent.MyBpBeforeChangeDelegate not called");
    }

    @Test
    @Order(value=2)
    public void testDocumentEventHandler() {
        ModelEventHandler handler = new ModelEventHandler(MOrder.class, MyOrderBeforeCompleteDelegate.class, (po, event) -> new MyOrderBeforeCompleteDelegate((MOrder)po, (Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)118));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.setDescription(null);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)126));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        Core.getEventManager().unregister((EventHandler)handler);
        String test = Env.getContext((Properties)Env.getCtx(), (String)MyOrderBeforeCompleteDelegate.class.getName());
        Assertions.assertEquals((Object)order.toString(), (Object)test, (String)"MyOrderBeforeCompleteDelegate not called");
    }

    @Test
    @Order(value=3)
    public void testDocumentEventHandlerException() {
        ModelEventHandler handler = new ModelEventHandler(MOrder.class, MyOrderBeforeCompleteDelegate.class, (po, event) -> new MyOrderBeforeCompleteDelegate((MOrder)po, (Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)118));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.setDescription(MyOrderBeforeCompleteDelegate.class.getName());
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)126));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertTrue((boolean)info.isError(), (String)"DocAction Complete doesn't fail as expected");
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"IN", (Object)order.getDocStatus(), (String)("DocStatus Expected=Invalid. DocStatus Actual=" + order.getDocStatus()));
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        Assertions.assertTrue((info.getSummary() != null && info.getSummary().contains("Test Runtime Exception") ? 1 : 0) != 0, (String)("Error message not as expected=" + info.getSummary()));
    }

    @Test
    @Order(value=4)
    public void testAfterLogin() {
        SimpleEventHandler handler = new SimpleEventHandler(MyAfterLoginDelegate.class, event -> new MyAfterLoginDelegate((Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        KeyNamePair org = new KeyNamePair(this.getAD_Org_ID(), MOrg.get((int)this.getAD_Org_ID()).getName());
        Login login = new Login(Env.getCtx());
        login.validateLogin(org);
        Assertions.assertTrue((boolean)"y".equalsIgnoreCase(Env.getContext((Properties)Env.getCtx(), (String)MyAfterLoginDelegate.class.getName())), (String)("MyAfterLoginDelegate not call. context=" + Env.getContext((Properties)Env.getCtx(), (String)MyAfterLoginDelegate.class.getName())));
    }

    @Test
    @Order(value=5)
    public void testAfterProcess() {
        int Verify_BOM = 136;
        int Patio_Chair = 133;
        ProcessEventHandler handler = new ProcessEventHandler(MyAfterProcessDelegate.class, MProcess.get((int)Verify_BOM).getAD_Process_UU(), event -> new MyAfterProcessDelegate((Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)Verify_BOM);
        ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setRecord_ID(Patio_Chair);
        pi.setTransactionName(this.getTrxName());
        if (process.getAD_PrintFormat_ID() > 0) {
            pi.setTransientObject((Object)process.getAD_PrintFormat());
        }
        ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx());
        if (pi.isError()) {
            Assertions.fail((String)("Error running Verify BOM process" + (String)(Util.isEmpty((String)pi.getSummary()) ? "" : " : " + pi.getSummary())));
            return;
        }
        Assertions.assertTrue((pi.getTitle() != null && pi.getTitle().contains(MyAfterProcessDelegate.class.getName()) ? 1 : 0) != 0, (String)("MyAfterProcessDelegate not call. Title=" + pi.getTitle()));
    }

    @Test
    @Order(value=6)
    public void testFactValidate() {
        ModelEventHandler handler = new ModelEventHandler(MInOut.class, MyFactValidateDelegate.class, (po, event) -> new MyFactValidateDelegate((MInOut)po, (Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)118));
        order.setC_DocTypeTarget_ID("SO");
        order.setDeliveryRule("O");
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine line1 = new MOrderLine(order);
        line1.setLine(10);
        line1.setProduct(MProduct.get((Properties)Env.getCtx(), (int)126));
        line1.setQty(new BigDecimal("1"));
        line1.setDatePromised(today);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)1, (int)line1.getQtyReserved().intValue());
        MInOut shipment = new MInOut(order, 120, order.getDateOrdered());
        shipment.setDocStatus("DR");
        shipment.setDocAction("CO");
        shipment.saveEx();
        MInOutLine shipmentLine = new MInOutLine(shipment);
        shipmentLine.setOrderLine(line1, 0, new BigDecimal("1"));
        shipmentLine.setQty(new BigDecimal("1"));
        shipmentLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)shipment, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        shipment.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)shipment.getDocStatus());
        line1.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((int)0, (int)line1.getQtyReserved().intValue());
        if (!shipment.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)shipment.getAD_Client_ID(), (int)319, (int)shipment.get_ID(), (boolean)false, (String)this.getTrxName());
            Assertions.assertTrue((error == null ? 1 : 0) != 0, (String)error);
        }
        Assertions.assertTrue((boolean)"y".equalsIgnoreCase(Env.getContext((Properties)Env.getCtx(), (String)MyFactValidateDelegate.class.getName())), (String)("MyFactValidateDelegate not call. context=" + Env.getContext((Properties)Env.getCtx(), (String)MyFactValidateDelegate.class.getName())));
    }

    @Test
    @Order(value=7)
    public void testAfterImport() {
        ImportEventHandler handler = new ImportEventHandler(MyAfterImportDelegate.class, "I_BPartner", event -> new MyAfterImportDelegate((Event)event));
        Core.getEventManager().register((BaseEventHandler)handler);
        ImportProduct ip = new ImportProduct();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)ip, (PO)new X_I_Product(Env.getCtx(), 0, this.getTrxName()), (PO)new MProduct(Env.getCtx(), 0, this.getTrxName()), 40);
        Assertions.assertTrue((boolean)Util.isEmpty((String)Env.getContext((Properties)Env.getCtx(), (String)MyAfterImportDelegate.class.getName())), (String)("MyAfterImportDelegate call for different import table name. context=" + Env.getContext((Properties)Env.getCtx(), (String)MyAfterImportDelegate.class.getName())));
        ImportBPartner ibp = new ImportBPartner();
        ModelValidationEngine.get().fireImportValidate((ImportProcess)ibp, (PO)new X_I_BPartner(Env.getCtx(), 0, this.getTrxName()), (PO)new MBPartner(Env.getCtx(), 0, this.getTrxName()), 40);
        Assertions.assertTrue((boolean)"y".equalsIgnoreCase(Env.getContext((Properties)Env.getCtx(), (String)MyAfterImportDelegate.class.getName())), (String)("MyAfterImportDelegate not call. context=" + Env.getContext((Properties)Env.getCtx(), (String)MyAfterImportDelegate.class.getName())));
    }

    @Test
    @Order(value=8)
    public void testAddressValidationDelegate() {
        int addressValidationSysConfigId = 200033;
        String delegateName = "org.adempiere.base.event.delegate.AddressValidationEventDelegate";
        MSysConfig sysconfig = new MSysConfig(Env.getCtx(), addressValidationSysConfigId, null);
        String currentValue = sysconfig.getValue();
        try {
            sysconfig.setValue("US");
            sysconfig.saveCrossTenantSafeEx();
            CacheMgt.get().reset();
            MLocation location = new MLocation(Env.getCtx(), 0, this.getTrxName());
            location.setC_Country_ID(100);
            AtomicInteger count = new AtomicInteger(0);
            Event event = EventManager.newEvent((String)ModelValidator.tableEventTopics[1], (EventProperty[])new EventProperty[]{new EventProperty("event.data", (Object)location), new EventProperty("tableName", (Object)location.get_TableName()), new EventProperty(delegateName, (Object)count)});
            EventManager.getInstance().sendEvent(event);
            Assertions.assertTrue((count.get() == 1 ? 1 : 0) != 0, (String)"AddressValidationEventDelegate not call for MLocation Before New Event");
            count = new AtomicInteger(0);
            event = EventManager.newEvent((String)ModelValidator.tableEventTopics[2], (EventProperty[])new EventProperty[]{new EventProperty("event.data", (Object)location), new EventProperty("tableName", (Object)location.get_TableName()), new EventProperty(delegateName, (Object)count)});
            EventManager.getInstance().sendEvent(event);
            Assertions.assertTrue((count.get() == 1 ? 1 : 0) != 0, (String)"AddressValidationEventDelegate not call for MLocation Before Change Event");
        }
        finally {
            sysconfig.setValue(currentValue);
            sysconfig.saveCrossTenantSafeEx();
        }
    }

    private static final class MyAfterImportDelegate
    extends ImportEventDelegate {
        public MyAfterImportDelegate(Event event) {
            super(event);
        }

        @AfterImport
        public void afterImport() {
            Env.setContext((Properties)Env.getCtx(), (String)((Object)((Object)this)).getClass().getName(), (boolean)true);
        }
    }

    private static final class MyAfterLoginDelegate
    extends EventDelegate {
        public MyAfterLoginDelegate(Event event) {
            super(event);
        }

        @AfterLogin
        public void afterLogin() {
            Env.setContext((Properties)Env.getCtx(), (String)((Object)((Object)this)).getClass().getName(), (boolean)true);
        }
    }

    private static final class MyAfterProcessDelegate
    extends ProcessEventDelegate {
        public MyAfterProcessDelegate(Event event) {
            super(event);
        }

        @AfterProcess
        public void afterProcess() {
            ProcessInfo pi = this.getProcessInfo();
            pi.setTitle(((Object)((Object)this)).getClass().getName());
        }
    }

    private static final class MyBPBeforeNewDelegate
    extends ModelEventDelegate<MBPartner> {
        public MyBPBeforeNewDelegate(MBPartner bp, Event event) {
            super((PO)bp, event);
        }

        @BeforeNew
        public void beforeNew() {
            Env.setContext((Properties)Env.getCtx(), (String)((Object)((Object)this)).getClass().getName(), (String)((MBPartner)this.getModel()).getName());
        }
    }

    private static final class MyFactValidateDelegate
    extends FactsValidateDelegate<MInOut> {
        public MyFactValidateDelegate(MInOut po, Event event) {
            super((PO)po, event);
        }

        protected void onFactsValidate(FactsEventData data) {
            Env.setContext((Properties)Env.getCtx(), (String)((Object)((Object)this)).getClass().getName(), (boolean)true);
        }
    }

    private static final class MyOrderBeforeCompleteDelegate
    extends ModelEventDelegate<MOrder> {
        public MyOrderBeforeCompleteDelegate(MOrder po, Event event) {
            super((PO)po, event);
        }

        @BeforeComplete
        public void beforeComplete() {
            if (((Object)((Object)this)).getClass().getName().equals(((MOrder)this.getModel()).getDescription())) {
                throw new RuntimeException("Test Runtime Exception");
            }
            Env.setContext((Properties)Env.getCtx(), (String)((Object)((Object)this)).getClass().getName(), (String)((MOrder)this.getModel()).toString());
        }
    }
}

