/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MPInstance;
import org.compiere.print.ReportCtl;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.wf.MWFProcess;

public abstract class AbstractProcessCtl
implements Runnable {
    private int windowno;
    private IProcessUI m_processUI;
    private ProcessInfo m_pi;
    private Trx m_trx;
    private static final CLogger log = CLogger.getCLogger(AbstractProcessCtl.class);

    public AbstractProcessCtl(IProcessUI aProcessUI, int WindowNo, ProcessInfo pi, Trx trx) {
        this.windowno = WindowNo;
        this.m_processUI = aProcessUI;
        this.m_pi = pi;
        this.m_trx = trx;
    }

    public void start() {
        Thread thread = new Thread(this);
        if (this.m_pi != null) {
            thread.setName(this.m_pi.getTitle() + "-" + this.m_pi.getAD_PInstance_ID());
        }
        thread.start();
    }

    @Override
    public void run() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID() + ", Record_ID=" + this.m_pi.getRecord_ID());
        }
        this.lock();
        String ProcedureName = "";
        String JasperReport = "";
        int AD_ReportView_ID = 0;
        int AD_Workflow_ID = 0;
        boolean IsReport = false;
        boolean IsDirectPrint = false;
        boolean isPrintPreview = this.m_pi.isPrintPreview();
        try {
            MPInstance.PInstanceInfo info = MPInstance.getPInstanceInfo((int)this.m_pi.getAD_PInstance_ID());
            if (info != null) {
                this.m_pi.setTitle(info.name);
                this.updateProgressWindowTitle(this.m_pi.getTitle());
                ProcedureName = info.procedureName;
                this.m_pi.setClassName(info.className);
                this.m_pi.setAD_Process_ID(info.AD_Process_ID);
                this.m_pi.setAD_Process_UU(info.AD_Process_UU);
                if (info.isReport) {
                    IsReport = true;
                    if (info.isDirectPrint && !Ini.isPropertyBool((String)"PrintPreview") && !isPrintPreview) {
                        IsDirectPrint = true;
                    }
                }
                AD_ReportView_ID = info.AD_ReportView_ID;
                AD_Workflow_ID = info.AD_Workflow_ID;
                int estimate = info.estimate;
                if (estimate != 0) {
                    this.m_pi.setEstSeconds(estimate + 1);
                    this.updateProgressWindowTimerEstimate(this.m_pi.getEstSeconds());
                }
                JasperReport = info.jasperReport;
            } else {
                log.log(Level.SEVERE, "No AD_PInstance_ID=" + this.m_pi.getAD_PInstance_ID());
            }
        }
        catch (Throwable e) {
            this.m_pi.setSummary(Msg.getMsg((Properties)Env.getCtx(), (String)"ProcessNoProcedure") + " " + e.getLocalizedMessage(), true);
            this.unlock();
            log.log(Level.SEVERE, "run", e);
            return;
        }
        if (ProcedureName == null) {
            ProcedureName = "";
        }
        if (AD_Workflow_ID > 0) {
            MPInstance pinstance = new MPInstance(Env.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
            pinstance.setIsProcessing(true);
            pinstance.saveEx();
            try {
                this.startWorkflow(AD_Workflow_ID);
                String errmsg = this.m_pi.getSummary();
                pinstance.setResult(!this.m_pi.isError());
                pinstance.setErrorMsg(errmsg);
                pinstance.setJsonData(this.m_pi.getJsonData());
                pinstance.saveEx();
                this.unlock();
            }
            finally {
                pinstance.setIsProcessing(false);
                pinstance.saveEx();
            }
            return;
        }
        boolean isJasper = false;
        if (JasperReport != null && JasperReport.trim().length() > 0) {
            isJasper = true;
            if ("org.adempiere.report.jasper.ReportStarter".equals(this.m_pi.getClassName())) {
                this.m_pi.setClassName(null);
            }
        }
        if (this.m_pi.getClassName() != null) {
            if (isJasper) {
                this.m_pi.setReportingProcess(true);
            }
            if (!this.startProcess()) {
                this.unlock();
                return;
            }
            if (!IsReport && ProcedureName.length() == 0) {
                this.unlock();
                return;
            }
            if (IsReport && AD_ReportView_ID == 0 && !isJasper) {
                this.unlock();
                return;
            }
        }
        if (IsReport && ProcedureName.length() > 0) {
            this.m_pi.setReportingProcess(true);
            if (!this.startDBProcess(ProcedureName)) {
                this.unlock();
                return;
            }
        }
        if (isJasper) {
            Object errmsg;
            this.m_pi.setReportingProcess(true);
            this.m_pi.setClassName("org.adempiere.report.jasper.ReportStarter");
            this.startProcess();
            MPInstance pinstance = new MPInstance(Env.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
            if (this.m_pi.getReportType() != null) {
                pinstance.setReportType(this.m_pi.getReportType());
            }
            errmsg = Util.isEmpty((String)(errmsg = pinstance.getErrorMsg()), (boolean)true) ? "Rows=" + String.valueOf(this.m_pi.getRowCount()) : (String)errmsg + " Rows=" + this.m_pi.getRowCount();
            pinstance.setErrorMsg((String)errmsg);
            pinstance.saveEx();
            this.unlock();
            return;
        }
        if (IsReport) {
            this.m_pi.setReportingProcess(true);
            boolean ok = ReportCtl.start(this.m_processUI, this.windowno, this.m_pi, IsDirectPrint);
            this.m_pi.setSummary(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"Report"), !ok);
            MPInstance pinstance = new MPInstance(Env.getCtx(), this.m_pi.getAD_PInstance_ID(), null);
            Object errmsg = pinstance.getErrorMsg();
            errmsg = Util.isEmpty((String)errmsg, (boolean)true) ? "Rows=" + String.valueOf(this.m_pi.getRowCount()) : (String)errmsg + " Rows=" + this.m_pi.getRowCount();
            pinstance.setErrorMsg((String)errmsg);
            pinstance.saveEx();
            this.unlock();
        } else {
            if (!this.startDBProcess(ProcedureName)) {
                this.unlock();
                return;
            }
            ProcessInfoUtil.setSummaryFromDB((ProcessInfo)this.m_pi);
            this.unlock();
        }
    }

    protected abstract void updateProgressWindowTimerEstimate(int var1);

    protected abstract void updateProgressWindowTitle(String var1);

    protected abstract void lock();

    protected abstract void unlock();

    protected int getWindowNo() {
        return this.windowno;
    }

    protected ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    protected IProcessUI getProcessMonitor() {
        return this.m_processUI;
    }

    protected IProcessUI getParent() {
        return this.getProcessMonitor();
    }

    @Deprecated
    protected boolean isServerProcess() {
        return false;
    }

    private boolean startWorkflow(int AD_Workflow_ID) {
        MWFProcess wfProcess;
        if (log.isLoggable(Level.FINE)) {
            log.fine(AD_Workflow_ID + " - " + String.valueOf(this.m_pi));
        }
        boolean started = false;
        if (this.m_trx != null) {
            this.m_pi.setTransactionName(this.m_trx.getTrxName());
        }
        started = (wfProcess = ProcessUtil.startWorkFlow((Properties)Env.getCtx(), (ProcessInfo)this.m_pi, (int)AD_Workflow_ID)) != null;
        return started;
    }

    private boolean startProcess() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.m_pi.toString());
        }
        if (this.m_pi.getClassName().toLowerCase().startsWith("@script:")) {
            this.m_pi.setProcessUI(this.m_processUI);
            return ProcessUtil.startScriptProcess((Properties)Env.getCtx(), (ProcessInfo)this.m_pi, (Trx)this.m_trx);
        }
        return ProcessUtil.startJavaProcess((Properties)Env.getCtx(), (ProcessInfo)this.m_pi, (Trx)this.m_trx, (boolean)true, (IProcessUI)this.m_processUI);
    }

    private boolean startDBProcess(String ProcedureName) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(ProcedureName + "(" + this.m_pi.getAD_PInstance_ID() + ")");
        }
        return ProcessUtil.startDatabaseProcedure((ProcessInfo)this.m_pi, (String)ProcedureName, (Trx)this.m_trx);
    }
}

