/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridField;
import org.compiere.model.MField;
import org.compiere.model.MTab;
import org.compiere.model.MUserDefField;
import org.compiere.model.X_AD_FieldGroup;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class TabEditor {
    public MTab m_tab;
    public static final CLogger log = CLogger.getCLogger(TabEditor.class);
    private List<MField> fields = new ArrayList<MField>();
    private List<GridField> gridFields = new ArrayList<GridField>();
    private MField m_activeField;
    private Map<Integer, MField> mapField = new HashMap<Integer, MField>();
    private Map<Integer, GridField> mapGridField = new HashMap<Integer, GridField>();
    protected boolean isBaseLang = Env.isBaseLanguage((Properties)Env.getCtx(), null);
    protected boolean isSystem = true;
    protected int AD_UserDef_Tab_ID;

    public List<GridField> getGridFields() {
        return this.gridFields;
    }

    public MTab getMTab() {
        return this.m_tab;
    }

    public List<MField> getMFields() {
        return this.fields;
    }

    protected void initMFields(int windowNo, int tabid) {
        GridField[] l_gridFields;
        this.m_tab = new MTab(Env.getCtx(), tabid, null);
        GridField[] gridFieldArray = l_gridFields = GridField.createFields((Properties)Env.getCtx(), (int)windowNo, (int)0, (int)tabid);
        int n = l_gridFields.length;
        int n2 = 0;
        while (n2 < n) {
            GridField gridField = gridFieldArray[n2];
            this.gridFields.add(gridField);
            this.mapGridField.put(gridField.getAD_Field_ID(), gridField);
            MField field = new MField(Env.getCtx(), gridField.getAD_Field_ID(), null);
            if (!this.isBaseLang) {
                field.setName(field.get_Translation("Name", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true));
                field.setDescription(field.get_Translation("Description", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true));
                field.setPlaceholder(field.get_Translation("Placeholder", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true));
                field.setHelp(field.get_Translation("Help", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true));
                gridField.getVO().Header = field.get_Translation("Name", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true);
                gridField.getVO().Description = field.get_Translation("Description", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true);
                gridField.getVO().Placeholder = field.get_Translation("Placeholder", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true);
                gridField.getVO().Help = field.get_Translation("Help", Env.getLanguage((Properties)Env.getCtx()).getAD_Language(), true);
            }
            if (!this.isSystem && (field = this.loadUserDefField(field)) != null) {
                gridField.getVO().Header = field.getName();
                gridField.getVO().Description = field.getDescription();
                gridField.getVO().Placeholder = field.getPlaceholder();
                gridField.getVO().Help = field.getHelp();
                gridField.getVO().NumLines = field.getNumLines();
                gridField.getVO().XPosition = field.getXPosition();
                gridField.getVO().ColumnSpan = field.getColumnSpan();
                gridField.getVO().IsDisplayed = field.isDisplayed();
                gridField.getVO().FieldGroup = this.getFieldGroup(field);
                gridField.getVO().FieldGroupType = this.getFieldGroupType(field);
            }
            this.fields.add(field);
            this.mapField.put(field.getAD_Field_ID(), field);
            gridField.getVO().IsReadOnly = true;
            gridField.getVO().IsMandatory = false;
            gridField.getVO().IsUpdateable = false;
            gridField.getVO().IsAlwaysUpdateable = false;
            ++n2;
        }
        this.resortArrays();
    }

    public boolean cmd_save() {
        for (MField field : this.fields) {
            if (!field.isActive()) continue;
            if (this.isSystem) {
                this.updateTrl(field);
                field.saveEx();
                continue;
            }
            this.saveUserDefField(field);
        }
        return true;
    }

    protected MField getMField(int fieldid) {
        return this.mapField.get(fieldid);
    }

    protected GridField getGridField(MField field) {
        return this.mapGridField.get(field.getAD_Field_ID());
    }

    public MField getActiveMField() {
        return this.m_activeField;
    }

    protected void setActiveMField(MField field) {
        this.m_activeField = field;
    }

    protected void resortArrays() {
        Collections.sort(this.fields, new Comparator<MField>(){

            @Override
            public int compare(MField field1, MField field2) {
                String compare1 = String.format("%s%10d%s", field1.isDisplayed() ? "0" : "1", field1.isDisplayed() ? field1.getSeqNo() : 0, field1.getName());
                String compare2 = String.format("%s%10d%s", field2.isDisplayed() ? "0" : "1", field2.isDisplayed() ? field2.getSeqNo() : 0, field2.getName());
                return compare1.compareTo(compare2);
            }
        });
        if (this.isSystem) {
            int seq = 10;
            for (MField field : this.fields) {
                if (field.isDisplayed()) {
                    field.setSeqNo(seq);
                    seq += 10;
                    continue;
                }
                field.setSeqNo(0);
            }
        }
        Collections.sort(this.gridFields, new Comparator<GridField>(){

            @Override
            public int compare(GridField f1, GridField f2) {
                MField field1 = TabEditor.this.getMField(f1.getAD_Field_ID());
                MField field2 = TabEditor.this.getMField(f2.getAD_Field_ID());
                String compare1 = String.format("%s%10d%s", field1.isDisplayed() ? "0" : "1", field1.isDisplayed() ? field1.getSeqNo() : 0, field1.getName());
                String compare2 = String.format("%s%10d%s", field2.isDisplayed() ? "0" : "1", field2.isDisplayed() ? field2.getSeqNo() : 0, field2.getName());
                return compare1.compareTo(compare2);
            }
        });
    }

    protected MField loadUserDefField(MField field) {
        if (field == null) {
            return null;
        }
        MUserDefField userDefField = MUserDefField.get((Properties)Env.getCtx(), (int)field.getAD_Field_ID(), (int)this.m_tab.getAD_Tab_ID(), (int)this.m_tab.getAD_Window_ID(), (boolean)true);
        if (userDefField != null) {
            if (userDefField.getName() != null) {
                field.setName(userDefField.getName());
            }
            if (userDefField.getDescription() != null) {
                field.setDescription(userDefField.getDescription());
            }
            if (userDefField.getHelp() != null) {
                field.setHelp(userDefField.getHelp());
            }
            if (userDefField.getPlaceholder() != null) {
                field.setPlaceholder(userDefField.getPlaceholder());
            }
            field.setIsActive(userDefField.isActive());
            field.setDisplayLogic(userDefField.getDisplayLogic());
            field.setDisplayLength(userDefField.getDisplayLength());
            field.setIsDisplayed(userDefField.getIsDisplayed() == null ? field.isDisplayed() : "Y".equals(userDefField.getIsDisplayed()));
            field.setIsReadOnly(userDefField.getIsReadOnly() == null ? field.isReadOnly() : "Y".equals(userDefField.getIsReadOnly()));
            field.setSeqNo(userDefField.getSeqNo() != 0 ? userDefField.getSeqNo() : field.getSeqNo());
            field.setXPosition(userDefField.getXPosition() > 0 ? userDefField.getXPosition() : field.getXPosition());
            field.setNumLines(userDefField.getNumLines() > 0 ? userDefField.getNumLines() : field.getNumLines());
            field.setColumnSpan(userDefField.getColumnSpan() > 0 ? userDefField.getColumnSpan() : field.getColumnSpan());
            field.setSortNo(BigDecimal.valueOf(userDefField.getSortNo()));
            field.setReadOnlyLogic(userDefField.getReadOnlyLogic());
            field.setMandatoryLogic(userDefField.getMandatoryLogic());
            if (userDefField.getAD_FieldGroup_ID() > 0) {
                field.setAD_FieldGroup_ID(userDefField.getAD_FieldGroup_ID());
            }
        }
        return field;
    }

    protected void saveUserDefField(MField field) {
        MField defaultField = new MField(Env.getCtx(), field.get_ID(), null);
        if (field.getName() != null && field.getName().equals(defaultField.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()), true))) {
            field.setName(defaultField.getName());
        }
        if (field.getDescription() != null && field.getDescription().equals(defaultField.get_Translation("Description", Env.getAD_Language((Properties)Env.getCtx()), true))) {
            field.setDescription(defaultField.getDescription());
        }
        if (field.getHelp() != null && field.getHelp().equals(defaultField.get_Translation("Help", Env.getAD_Language((Properties)Env.getCtx()), true))) {
            field.setHelp(defaultField.getHelp());
        }
        if (field.getPlaceholder() != null && field.getPlaceholder().equals(defaultField.get_Translation("Placeholder", Env.getAD_Language((Properties)Env.getCtx()), true))) {
            field.setPlaceholder(defaultField.getPlaceholder());
        }
        if (!field.is_Changed()) {
            return;
        }
        MUserDefField udfield = MUserDefField.get((Properties)Env.getCtx(), (int)field.getAD_Field_ID(), (int)this.m_tab.getAD_Tab_ID(), (int)this.m_tab.getAD_Window_ID(), (boolean)true);
        int AD_UserDef_Field_ID = 0;
        if (udfield != null) {
            AD_UserDef_Field_ID = udfield.getAD_UserDef_Field_ID();
        }
        udfield = new MUserDefField(Env.getCtx(), AD_UserDef_Field_ID, null);
        udfield.setAD_Field_ID(field.get_ID());
        udfield.setAD_UserDef_Tab_ID(this.AD_UserDef_Tab_ID);
        udfield.setAD_Org_ID(this.m_tab.getAD_Org_ID());
        if (field.is_ValueChanged("Name")) {
            udfield.setName(field.getName());
        }
        if (field.is_ValueChanged("Description")) {
            udfield.setDescription(field.getDescription());
        }
        if (field.is_ValueChanged("Help")) {
            udfield.setHelp(field.getHelp());
        }
        if (field.is_ValueChanged("Placeholder")) {
            udfield.setPlaceholder(field.getPlaceholder());
        }
        if (field.is_ValueChanged("IsActive")) {
            udfield.setIsActive(field.isActive());
        }
        if (field.is_ValueChanged("DisplayLogic")) {
            udfield.setDisplayLogic(field.getDisplayLogic());
        }
        if (field.is_ValueChanged("DisplayLength")) {
            udfield.setDisplayLength(field.getDisplayLength());
        }
        if (field.is_ValueChanged("IsDisplayed")) {
            udfield.setIsDisplayed(field.isDisplayed() ? "Y" : "N");
        }
        if (field.is_ValueChanged("IsReadOnly")) {
            udfield.setIsReadOnly(field.isReadOnly() ? "Y" : "N");
        }
        if (field.is_ValueChanged("SeqNo")) {
            udfield.setSeqNo(field.getSeqNo());
        }
        if (field.is_ValueChanged("XPosition")) {
            udfield.setXPosition(field.getXPosition());
        }
        if (field.is_ValueChanged("NumLines")) {
            udfield.setNumLines(field.getNumLines());
        }
        if (field.is_ValueChanged("ColumnSpan")) {
            udfield.setColumnSpan(field.getColumnSpan());
        }
        if (field.is_ValueChanged("SortNo")) {
            udfield.setSortNo(field.getSortNo().intValue());
        }
        if (field.is_ValueChanged("MandatoryLogic")) {
            udfield.setMandatoryLogic(field.getMandatoryLogic());
        }
        if (field.is_ValueChanged("ReadOnlyLogic")) {
            udfield.setReadOnlyLogic(field.getReadOnlyLogic());
        }
        if (field.is_ValueChanged("AD_FieldGroup_ID")) {
            if (field.getAD_FieldGroup_ID() > 0) {
                udfield.setAD_FieldGroup_ID(field.getAD_FieldGroup_ID());
            } else {
                udfield.setAD_FieldGroup_ID(0);
            }
        }
        udfield.saveEx();
    }

    private void updateTrl(MField field) {
        if (this.isBaseLang) {
            return;
        }
        String name = field.getName();
        String description = field.getDescription();
        String help = field.getHelp();
        String placeholder = field.getPlaceholder();
        MField dbField = new MField(Env.getCtx(), field.getAD_Field_ID(), null);
        String nameDB = this.isBaseLang ? dbField.getName() : dbField.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()), true);
        String descriptionDB = this.isBaseLang ? dbField.getDescription() : dbField.get_Translation("Description", Env.getAD_Language((Properties)Env.getCtx()), true);
        String helpDB = this.isBaseLang ? dbField.getHelp() : dbField.get_Translation("Help", Env.getAD_Language((Properties)Env.getCtx()), true);
        String placeholderDB = this.isBaseLang ? dbField.getPlaceholder() : dbField.get_Translation("Placeholder", Env.getAD_Language((Properties)Env.getCtx()), true);
        field.setName(dbField.getName());
        field.setDescription(dbField.getDescription());
        field.setHelp(dbField.getHelp());
        field.setPlaceholder(dbField.getPlaceholder());
        if (name != null && name.equals(nameDB)) {
            name = null;
        }
        if (description != null && description.equals(descriptionDB)) {
            description = null;
        }
        if (help != null && help.equals(helpDB)) {
            help = null;
        }
        if (placeholder != null && placeholder.equals(placeholderDB)) {
            placeholder = null;
        }
        if (name == null && description == null && help == null && placeholder == null) {
            return;
        }
        StringBuilder mainSQL = new StringBuilder("UPDATE ").append(field.get_TableName()).append("_Trl SET ");
        StringBuilder setSQL = new StringBuilder();
        if (name != null) {
            setSQL.append("Name").append("='").append(name).append("' ");
        }
        if (description != null) {
            if (setSQL.length() > 0) {
                setSQL.append(",");
            }
            setSQL.append("Description").append("='").append(description).append("' ");
        }
        if (help != null) {
            if (setSQL.length() > 0) {
                setSQL.append(",");
            }
            setSQL.append("Help").append("='").append(help).append("' ");
        }
        if (placeholder != null) {
            if (setSQL.length() > 0) {
                setSQL.append(",");
            }
            setSQL.append("Placeholder").append("='").append(placeholder).append("' ");
        }
        if (setSQL.length() > 0) {
            setSQL.append(",");
        }
        setSQL.append("Updated").append("=").append(DB.TO_DATE((Timestamp)new Timestamp(System.currentTimeMillis()), (boolean)false)).append(", ");
        setSQL.append("UpdatedBy").append("=").append(Env.getAD_User_ID((Properties)Env.getCtx()));
        mainSQL.append(setSQL.toString());
        mainSQL.append(" WHERE ").append("AD_Field_ID").append("=").append(field.getAD_Field_ID()).append(" AND AD_Language ='").append(Env.getAD_Language((Properties)Env.getCtx())).append("'");
        int no = DB.executeUpdate((String)mainSQL.toString(), null);
        if (no == 1) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(mainSQL.toString());
            }
        } else if (no == 0) {
            log.warning("Not Found - " + mainSQL.toString());
        } else {
            log.severe("Update Rows=" + no + " (Should be 1) - " + mainSQL.toString());
        }
    }

    public void updateFieldList(MField field) {
        for (MField lstField : this.fields) {
            if (lstField.getAD_Field_ID() != field.getAD_Field_ID()) continue;
            lstField.setName(field.getName());
            lstField.setDescription(field.getDescription());
            lstField.setHelp(field.getHelp());
            lstField.setPlaceholder(field.getPlaceholder());
            lstField.setIsActive(field.isActive());
            lstField.setDisplayLogic(field.getDisplayLogic());
            lstField.setDisplayLength(field.getDisplayLength());
            lstField.setIsDisplayed(field.isDisplayed());
            lstField.setIsReadOnly(field.isReadOnly());
            lstField.setSeqNo(field.getSeqNo());
            lstField.setXPosition(field.getXPosition());
            lstField.setNumLines(field.getNumLines());
            lstField.setColumnSpan(field.getColumnSpan());
            lstField.setSortNo(field.getSortNo());
            this.mapField.put(lstField.get_ID(), lstField);
        }
    }

    public String getFieldGroup(MField field) {
        if (field.getAD_FieldGroup_ID() > 0) {
            if (this.isBaseLang) {
                return field.getAD_FieldGroup().getName();
            }
            return ((X_AD_FieldGroup)field.getAD_FieldGroup()).get_Translation("Name");
        }
        return "";
    }

    public String getFieldGroupType(MField field) {
        if (field.getAD_FieldGroup_ID() > 0) {
            return field.getAD_FieldGroup().getFieldGroupType();
        }
        return "";
    }
}

