/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.io.File;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.ServerContext;
import org.adempiere.util.ServerContextURLHandler;
import org.adempiere.webui.session.SessionManager;
import org.compiere.Adempiere;
import org.compiere.model.ServerStateChangeEvent;
import org.compiere.model.ServerStateChangeListener;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.compiere.util.WebUtil;

public class LoggedSessionListener
implements HttpSessionListener,
ServletContextListener,
ServerStateChangeListener {
    private static Hashtable<String, HttpSession> AD_SessionList = new Hashtable();
    private static final CLogger logger = CLogger.getCLogger(LoggedSessionListener.class);

    public void sessionCreated(HttpSessionEvent evt) {
        AD_SessionList.put(evt.getSession().getId(), evt.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent evt) {
        HttpSession currSess = evt.getSession();
        if (AD_SessionList.containsKey(currSess.getId())) {
            String serverName = WebUtil.getServerName();
            this.removeADSession(currSess.getId(), serverName);
            AD_SessionList.remove(currSess.getId());
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        this.DestroyAllSession();
    }

    public void contextInitialized(ServletContextEvent arg0) {
        boolean started;
        this.DestroyAllSession();
        Properties serverContext = new Properties();
        serverContext.put("SERVER_CONTEXT_URL_HANDLER", new ServerContextURLHandler(){

            public void showURL(String url) {
                SessionManager.getAppDesktop().showURL(url, true);
            }
        });
        ServerContext.setCurrentInstance((Properties)serverContext);
        String propertyFile = Ini.getFileName((boolean)false);
        File file = new File(propertyFile);
        if (!file.exists()) {
            throw new IllegalStateException("idempiere.properties file missing. Path=" + file.getAbsolutePath());
        }
        if (!Adempiere.isStarted() && !(started = Adempiere.startup((boolean)false))) {
            throw new AdempiereException("Could not start iDempiere");
        }
        logger.log(Level.OFF, "iDempiere context initialized for 10.0.1");
    }

    private void DestroyAllSession() {
        if (!Adempiere.isStarted()) {
            Adempiere.addServerStateChangeListener((ServerStateChangeListener)this);
            return;
        }
        String serverName = WebUtil.getServerName();
        int no = DB.executeUpdate((String)"UPDATE AD_Session SET Processed='Y' WHERE Processed='N' AND ServerName=?", (Object[])new Object[]{serverName}, (boolean)false, null);
        if (no < 0) {
            throw new AdempiereException("UpdateSession: Cannot Destroy All Session");
        }
        int nop = DB.executeUpdate((String)"UPDATE AD_PInstance SET IsProcessing='N' WHERE IsProcessing='Y' AND EXISTS (SELECT 1 FROM AD_Session s WHERE s.AD_Session_ID=AD_PInstance.AD_Session_ID AND s.ServerName=?)", (Object[])new Object[]{serverName}, (boolean)false, null);
        if (nop < 0) {
            throw new AdempiereException("UpdateSession: Cannot Update All Process Instances");
        }
        Adempiere.removeServerStateChangeListener((ServerStateChangeListener)this);
    }

    private void removeADSession(String sessionID, String serverName) {
        String sql = "UPDATE AD_Session SET Processed='Y' WHERE WebSession=? AND ServerName=? AND Processed='N'";
        int no = DB.executeUpdate((String)sql, (Object[])new Object[]{sessionID, serverName}, (boolean)false, null);
        if (no < 0) {
            throw new AdempiereException("UpdateSession: Cannot Destroy Session");
        }
    }

    public void stateChange(ServerStateChangeEvent event) {
        this.DestroyAllSession();
    }
}

