/*
 * Decompiled with CFR 0.152.
 */
package org.eevolution.process;

import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.model.MBPartner;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInvoice;
import org.compiere.model.MPeriod;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

@Process
public class InvoiceCalculateTax
extends SvrProcess {
    public static final String PARAM_C_Invoice_ID = "C_Invoice_ID";
    private int p_C_Invoice_ID = 0;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if (para.getParameter() != null) {
                if (name.equals(PARAM_C_Invoice_ID)) {
                    this.p_C_Invoice_ID = para.getParameterAsInt();
                } else {
                    MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
                }
            }
            ++n2;
        }
        if (this.p_C_Invoice_ID <= 0) {
            throw new FillMandatoryException(new String[]{PARAM_C_Invoice_ID});
        }
    }

    @Override
    protected String doIt() throws Exception {
        MInvoice invoice = new MInvoice(this.getCtx(), this.p_C_Invoice_ID, this.get_TrxName());
        InvoiceCalculateTax.recalculateTax(invoice);
        return "@ProcessOK@";
    }

    public static void recalculateTax(MInvoice invoice) {
        MPeriod.testPeriodOpen(invoice.getCtx(), invoice.getDateAcct(), invoice.getC_DocType_ID(), invoice.getAD_Org_ID());
        MFactAcct.deleteEx(318, invoice.get_ID(), invoice.get_TrxName());
        invoice.calculateTaxTotal();
        invoice.setPosted(false);
        invoice.saveEx();
        MBPartner bp = new MBPartner(invoice.getCtx(), invoice.getC_BPartner_ID(), invoice.get_TrxName());
        bp.setTotalOpenBalance();
        bp.setSOCreditStatus();
        bp.saveEx();
    }
}

