/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.Query;
import org.compiere.model.X_AD_SMTP;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutablePOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MSMTP
extends X_AD_SMTP
implements ImmutablePOSupport {
    private static final long serialVersionUID = -3645639750095013941L;
    private static ImmutablePOCache<String, MSMTP> s_cache = new ImmutablePOCache("AD_SMTP", 20);

    public MSMTP(Properties ctx, String AD_SMTP_UU, String trxName) {
        super(ctx, AD_SMTP_UU, trxName);
    }

    public MSMTP(Properties ctx, int AD_SMTP_ID, String trxName) {
        super(ctx, AD_SMTP_ID, trxName);
    }

    public MSMTP(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSMTP(Properties ctx, MSMTP copy) {
        this(ctx, copy, null);
    }

    public MSMTP(Properties ctx, MSMTP copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    public static MSMTP get(Properties ctx, int clientID, String from) {
        return MSMTP.get(ctx, clientID, from, null);
    }

    public static MSMTP get(Properties ctx, int clientID, String from, String trxName) {
        String key = clientID + "_" + from;
        MSMTP retValue = null;
        if (s_cache.containsKey(key)) {
            retValue = s_cache.get(ctx, key, e -> new MSMTP(ctx, (MSMTP)e));
            return retValue;
        }
        Query query = new Query(ctx, "AD_SMTP", "AD_Client_ID IN (0, ?) AND UPPER(UsedByEmailOrDomain) = UPPER(?)", trxName).setOnlyActiveRecords(true).setOrderBy("AD_Client_ID DESC, AD_SMTP_ID");
        retValue = (MSMTP)query.setParameters(clientID, from).first();
        if (retValue == null) {
            String domain = from.substring(from.indexOf("@") + 1);
            retValue = (MSMTP)query.setParameters(clientID, domain).first();
        }
        if (retValue == null) {
            s_cache.put(key, null);
        } else {
            MSMTP smtp = retValue;
            s_cache.put(key, retValue, e -> new MSMTP(Env.getCtx(), smtp));
        }
        return retValue;
    }

    @Override
    public String toString() {
        return "MSMTP[" + this.get_ID() + " - Name=" + this.getName() + " - Host=" + this.getSMTPHost() + "]";
    }

    @Override
    public MSMTP markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }
}

