/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.annotation.Process;
import org.compiere.db.AdempiereDatabase;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.model.M_Element;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.DB;

@Process
public class TableCreateColumns
extends SvrProcess {
    private String p_EntityType = "C";
    private int p_AD_Table_ID = 0;
    private boolean p_AllTables = false;
    private int m_count = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("EntityType")) {
                    this.p_EntityType = (String)para[i].getParameter();
                } else if (name.equals("AllTables")) {
                    this.p_AllTables = "Y".equals(para[i].getParameter());
                } else {
                    MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
                }
            }
            ++i;
        }
        this.p_AD_Table_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        String string;
        block17: {
            if (this.p_AD_Table_ID == 0) {
                throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_AD_Table_ID);
            }
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("EntityType=" + this.p_EntityType + ", AllTables=" + this.p_AllTables + ", AD_Table_ID=" + this.p_AD_Table_ID);
            }
            Connection conn = null;
            try {
                conn = DB.getConnection();
                AdempiereDatabase db = DB.getDatabase();
                DatabaseMetaData md = conn.getMetaData();
                String catalog = db.getCatalog();
                String schema = db.getSchema();
                if (this.p_AllTables) {
                    this.addTable(md, catalog, schema);
                } else {
                    MTable table = new MTable(this.getCtx(), this.p_AD_Table_ID, this.get_TrxName());
                    if (table == null || table.get_ID() == 0) {
                        throw new AdempiereSystemError("@NotFound@ @AD_Table_ID@ " + this.p_AD_Table_ID);
                    }
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(table.getTableName() + ", EntityType=" + this.p_EntityType);
                    }
                    String tableName = table.getTableName();
                    if (DB.isOracle()) {
                        tableName = tableName.toUpperCase();
                    }
                    if (DB.isPostgreSQL()) {
                        tableName = tableName.toLowerCase();
                    }
                    ResultSet rs = null;
                    try {
                        rs = md.getColumns(catalog, schema, tableName, null);
                        this.addTableColumn(rs, table);
                    }
                    catch (Throwable throwable) {
                        DB.close(rs);
                        throw throwable;
                    }
                    DB.close((ResultSet)rs);
                }
                StringBuilder msgreturn = new StringBuilder("#").append(this.m_count);
                string = msgreturn.toString();
                if (conn == null) break block17;
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        return string;
    }

    private void addTable(DatabaseMetaData md, String catalog, String schema) throws Exception {
        ResultSet rs = null;
        ResultSet rsC = null;
        try {
            rs = DB.isPostgreSQL() ? md.getTables(catalog, schema, null, new String[]{"TABLE", "VIEW"}) : md.getTables(catalog, schema, null, null);
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                String tableType = rs.getString("TABLE_TYPE");
                MTable table = MTable.get((Properties)this.getCtx(), (String)tableName);
                if (table == null) {
                    String tn = tableName.toUpperCase();
                    if (tn.startsWith("T_SELECTION") || tn.endsWith("_VT") || tn.endsWith("_V") || tn.endsWith("_V1") || tn.startsWith("A_A") || tn.startsWith("A_D") || tn.indexOf(36) != -1 || tn.indexOf("EXPLAIN") != -1) {
                        if (!this.log.isLoggable(Level.FINE)) continue;
                        this.log.fine("Ignored: " + tableName + " - " + tableType);
                        continue;
                    }
                    if (this.log.isLoggable(Level.INFO)) {
                        this.log.info(tableName + " - " + tableType);
                    }
                    table = new MTable(this.getCtx(), 0, this.get_TrxName());
                    table.setEntityType(this.p_EntityType);
                    table.setName(tableName);
                    table.setTableName(tableName);
                    table.setIsView("VIEW".equals(tableType));
                    if (!table.save()) continue;
                }
                if (DB.isOracle()) {
                    tableName = tableName.toUpperCase();
                }
                if (DB.isPostgreSQL()) {
                    tableName = tableName.toLowerCase();
                }
                try {
                    rsC = md.getColumns(catalog, schema, tableName, null);
                    this.addTableColumn(rsC, table);
                }
                catch (Throwable throwable) {
                    DB.close(rsC);
                    throw throwable;
                }
                DB.close((ResultSet)rsC);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs);
            rs = null;
            DB.close(rsC);
            rsC = null;
            throw throwable;
        }
        DB.close((ResultSet)rs);
        rs = null;
        DB.close(rsC);
        rsC = null;
    }

    private void addTableColumn(ResultSet rs, MTable table) throws Exception {
        String tableName = table.getTableName();
        while (rs.next()) {
            String columnName;
            MColumn column;
            String tn = rs.getString("TABLE_NAME");
            if (!tableName.equalsIgnoreCase(tn) || (column = table.getColumn(columnName = rs.getString("COLUMN_NAME"))) != null) continue;
            int dataType = rs.getInt("DATA_TYPE");
            String typeName = rs.getString("TYPE_NAME");
            String nullable = rs.getString("IS_NULLABLE");
            int size = rs.getInt("COLUMN_SIZE");
            int digits = rs.getInt("DECIMAL_DIGITS");
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config(columnName + " - DataType=" + dataType + " " + typeName + ", Nullable=" + nullable + ", Size=" + size + ", Digits=" + digits);
            }
            column = new MColumn(table);
            column.set_TrxName(this.get_TrxName());
            column.setEntityType(this.p_EntityType);
            M_Element element = M_Element.get((Properties)this.getCtx(), (String)columnName);
            if (element == null) {
                String uuidColumn;
                element = new M_Element(this.getCtx(), columnName, this.p_EntityType, this.get_TrxName());
                if (columnName.equalsIgnoreCase(table.getTableName() + "_ID")) {
                    element.setColumnName(table.getTableName() + "_ID");
                    element.setName(table.getName());
                    element.setPrintName(table.getName());
                }
                if (columnName.equalsIgnoreCase(uuidColumn = PO.getUUIDColumnName((String)table.getTableName()))) {
                    element.setColumnName(uuidColumn);
                    element.setName(uuidColumn);
                    element.setPrintName(uuidColumn);
                }
                element.saveEx();
            }
            column.setColumnName(element.getColumnName());
            column.setName(element.getName());
            column.setDescription(element.getDescription());
            column.setHelp(element.getHelp());
            column.setAD_Element_ID(element.getAD_Element_ID());
            column.setIsMandatory("NO".equals(nullable));
            if (columnName.toUpperCase().endsWith("_ACCT") && size == 10) {
                column.setAD_Reference_ID(25);
            } else if (columnName.toUpperCase().endsWith("_ID")) {
                column.setAD_Reference_ID(19);
            } else if (dataType == 91 || dataType == 92 || dataType == 93 || columnName.equalsIgnoreCase("Created") || columnName.equalsIgnoreCase("Updated")) {
                column.setAD_Reference_ID(16);
            } else if (dataType == 2005) {
                column.setAD_Reference_ID(36);
            } else if (dataType == 2004) {
                column.setAD_Reference_ID(23);
            } else if (columnName.toUpperCase().indexOf("AMT") != -1) {
                column.setAD_Reference_ID(12);
            } else if (columnName.toUpperCase().indexOf("QTY") != -1) {
                column.setAD_Reference_ID(29);
            } else if (size == 1 && (columnName.toUpperCase().startsWith("IS") || dataType == 1)) {
                column.setAD_Reference_ID(20);
            } else if (size < 4 && dataType == 1) {
                column.setAD_Reference_ID(17);
            } else if (dataType == 1 || dataType == 12 || typeName.startsWith("NVAR") || typeName.startsWith("NCHAR")) {
                if (typeName.startsWith("N")) {
                    size /= 2;
                }
                if (size > 255) {
                    column.setAD_Reference_ID(14);
                } else {
                    column.setAD_Reference_ID(10);
                }
            } else if (dataType == 4 || dataType == 5 || dataType == 3 || dataType == 2) {
                if (size == 10) {
                    column.setAD_Reference_ID(11);
                } else {
                    column.setAD_Reference_ID(22);
                }
            } else {
                column.setAD_Reference_ID(10);
            }
            column.setSmartDefaults();
            column.setFieldLength(size);
            if (column.isUpdateable() && (table.isView() || columnName.equalsIgnoreCase("AD_Client_ID") || columnName.equalsIgnoreCase("AD_Org_ID") || columnName.toUpperCase().startsWith("CREATED") || columnName.toUpperCase().equals("UPDATED"))) {
                column.setIsUpdateable(false);
            }
            if (!column.save()) continue;
            StringBuilder msglog = new StringBuilder().append(table.getTableName()).append(".").append(column.getColumnName());
            this.addLog(0, null, null, msglog.toString());
            ++this.m_count;
        }
    }
}

