/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.adempiere.base.event.EventManager;
import org.adempiere.base.event.ReportSendEMailEventData;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.AttachmentItem;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.Lookup;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.model.MClient;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMailText;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.model.PO;
import org.compiere.model.PrintInfo;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogger;
import org.compiere.util.EMail;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.osgi.service.event.Event;
import org.zkforge.ckez.CKeditor;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class WEMailDialog
extends Window
implements EventListener<org.zkoss.zk.ui.event.Event>,
ValueChangeListener {
    private static final long serialVersionUID = 556391720307848225L;
    private MClient m_client = null;
    private MUser m_from = null;
    private MUser m_user = null;
    private MUser m_ccuser = null;
    private String m_to;
    private String m_cc;
    private String m_subject;
    private String m_message;
    private int m_Record_ID;
    private String m_Record_UU;
    private int m_AD_Table_ID;
    private DataSource m_attachment;
    private List<DataSource> attachments = new ArrayList<DataSource>();
    private static final CLogger log = CLogger.getCLogger(WEMailDialog.class);
    private Textbox fFrom = new Textbox();
    private Textbox fTo = new Textbox();
    private Textbox fCc = new Textbox();
    private WSearchEditor fUser = null;
    private WSearchEditor fCcUser = null;
    private Textbox fSubject = new Textbox();
    private Label lFrom = new Label();
    private Label lTo = new Label();
    private Label lCc = new Label();
    private Label lSubject = new Label();
    private Label lAttachment = new Label();
    private CKeditor fMessage;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Button bAddDefaultMailText;
    private Div attachmentBox;
    private Checkbox isAcknowledgmentReceipt = new Checkbox();
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));

    public WEMailDialog(String title, MUser from, String to, String subject, String message, DataSource attachment) {
        this(title, from, to, subject, message, attachment, -1, -1, -1, null);
    }

    public WEMailDialog(String title, MUser from, String to, String subject, String message, DataSource attachment, int m_WindowNo, int ad_Table_ID, int record_ID, PrintInfo printInfo) {
        this(title, from, to, subject, message, attachment, m_WindowNo, ad_Table_ID, record_ID, null, printInfo);
    }

    public WEMailDialog(String title, MUser from, String to, String subject, String message, DataSource attachment, int m_WindowNo, int ad_Table_ID, int record_ID, String record_UU, PrintInfo printInfo) {
        this.m_AD_Table_ID = ad_Table_ID;
        this.m_Record_ID = record_ID;
        this.m_Record_UU = record_UU;
        this.setTitle(title);
        this.setSclass("popup-dialog email-dialog");
        this.setClosable(true);
        this.setBorder("normal");
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "80%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "80%");
        }
        this.setShadow(true);
        this.setMaximizable(true);
        this.setSizable(true);
        this.fMessage = new CKeditor();
        if (ClientInfo.isMobile()) {
            this.fMessage.setCustomConfigurationsPath("/js/ckeditor/config-min.js");
        } else {
            this.fMessage.setCustomConfigurationsPath("/js/ckeditor/config.js");
        }
        HashMap<String, String> lang = new HashMap<String, String>();
        lang.put("language", Language.getLoginLanguage().getAD_Language());
        this.fMessage.setConfig(lang);
        this.commonInit(from, to, subject, message, attachment);
        this.clearEMailContext(m_WindowNo);
        this.sendEvent(m_WindowNo, this.m_AD_Table_ID, this.m_Record_ID, this.m_Record_UU, null, "");
        this.setValuesFromContext(m_WindowNo);
        if (ClientInfo.maxWidth(700) || ClientInfo.maxWidth(500)) {
            this.setMaximized(true);
            this.setSizable(false);
            this.setMaximizable(false);
        }
    }

    private void commonInit(MUser from, String to, String subject, String message, DataSource attachment) {
        this.m_client = MClient.get((Properties)Env.getCtx());
        try {
            int WindowNo = 0;
            int AD_Column_ID = 0;
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)WindowNo, (int)AD_Column_ID, (int)30, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"AD_User_ID", (int)0, (boolean)false, (String)"EMail IS NOT NULL");
            this.fUser = new WSearchEditor((Lookup)lookup, "AD_User_ID", "", false, false, true);
            this.fUser.addValueChangeListener(this);
            this.fCcUser = new WSearchEditor((Lookup)lookup, "AD_User_ID", "", false, false, true);
            this.fCcUser.addValueChangeListener(this);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "EMailDialog", (Throwable)ex);
        }
        this.set(from, to, subject, message);
        this.setAttachment(attachment);
        this.setAttribute("mode", "highlighted");
        this.addEventListener("onCancel", e -> this.onCancel());
        this.addEventListener("onSize", e -> this.onSize());
        this.addEventListener("onMaximize", e -> this.onSize());
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        try {
            this.render();
        }
        catch (Exception exception) {}
        if (MUser.get((Properties)Env.getCtx()).isAddMailTextAutomatically()) {
            this.addMailText();
        }
        if (newpage != null && ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
            ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            this.invalidate();
        }
    }

    protected void render() throws Exception {
        this.lFrom.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"From") + ":");
        this.lTo.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"To") + ":");
        this.lCc.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Cc") + ":");
        this.lSubject.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Subject") + ":");
        this.lAttachment.setValue(Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment") + ":");
        this.fFrom.setReadonly(true);
        this.isAcknowledgmentReceipt.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"RequestReadReceipt"));
        Grid grid = new Grid();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)grid, "100%");
        grid.setStyle("margin:0; padding:0; align: center; valign: center; border:0");
        grid.makeNoStrip();
        Columns columns = new Columns();
        Column column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "10%");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "90%");
        columns.appendChild((Component)column);
        grid.appendChild((Component)columns);
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lFrom);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fFrom);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fFrom, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lTo);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fUser.getComponent());
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fUser.getComponent(), "100%");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)new Label(""));
        row.appendChild((Component)this.fTo);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fTo, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lCc);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fCcUser.getComponent());
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fCcUser.getComponent(), "100%");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)new Label(""));
        row.appendChild((Component)this.fCc);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fCc, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild((Component)new Label(""));
        row.appendChild((Component)this.isAcknowledgmentReceipt);
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lSubject);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fSubject);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fSubject, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lAttachment);
        Cell cell = new Cell();
        cell.appendChild((Component)this.lAttachment);
        cell.setValign("top");
        cell.setAlign("right");
        row.appendChild((Component)cell);
        this.attachmentBox = new Div();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.attachmentBox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.attachmentBox, "1");
        row.appendChild((Component)this.attachmentBox);
        for (DataSource ds : this.attachments) {
            boolean removable = true;
            if (ds == this.m_attachment) {
                removable = false;
            }
            AttachmentItem item = new AttachmentItem(ds, this.attachments, removable);
            this.attachmentBox.appendChild((Component)item);
        }
        this.fMessage.setWidth("100%");
        this.fMessage.setHeight("100%");
        this.confirmPanel.addActionListener(this);
        Button btn = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            btn.setIconSclass("z-icon-Attachment");
        } else {
            btn.setImage(ThemeManager.getThemeResource("images/Attachment24.png"));
        }
        btn.setUpload(AdempiereWebUI.getUploadSetting());
        btn.addEventListener("onUpload", this);
        btn.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Attachment"));
        this.confirmPanel.addComponentsLeft(btn);
        this.bAddDefaultMailText = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            this.bAddDefaultMailText.setIconSclass("z-icon-GetMail");
        } else {
            this.bAddDefaultMailText.setImage(ThemeManager.getThemeResource("images/DefaultMailText.png"));
        }
        this.bAddDefaultMailText.addEventListener("onClick", this);
        this.bAddDefaultMailText.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AddDefaultMailTextContent"));
        if (new MUser(Env.getCtx(), Env.getAD_User_ID((Properties)Env.getCtx()), null).getR_DefaultMailText_ID() > 0) {
            this.confirmPanel.addComponentsLeft(this.bAddDefaultMailText);
        }
        this.confirmPanel.getButton("Ok").setWidgetListener("onClick", "zAu.cmd0.showBusy(null)");
        Borderlayout borderlayout = new Borderlayout();
        this.appendChild((Component)borderlayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)borderlayout, "100%");
        North northPane = new North();
        northPane.setSclass("dialog-content");
        northPane.setAutoscroll(true);
        borderlayout.appendChild((Component)northPane);
        northPane.appendChild((Component)grid);
        Center centerPane = new Center();
        centerPane.setSclass("dialog-content");
        borderlayout.appendChild((Component)centerPane);
        centerPane.appendChild((Component)this.fMessage);
        South southPane = new South();
        southPane.setSclass("dialog-footer");
        borderlayout.appendChild((Component)southPane);
        southPane.appendChild((Component)this.confirmPanel);
    }

    public void set(MUser from, String to, String subject, String message) {
        this.setFrom(from);
        this.setTo(to);
        this.setSubject(subject);
        this.setMessage(message);
    }

    public void setTo(String newTo) {
        this.m_to = newTo;
        this.fTo.setText(this.m_to);
    }

    public void setCc(String newCc) {
        this.m_cc = newCc;
        this.fCc.setText(this.m_cc);
    }

    public String getTo() {
        this.m_to = this.fTo.getText();
        return this.m_to;
    }

    public String getCc() {
        this.m_cc = this.fCc.getText();
        return this.m_cc;
    }

    public void setFrom(MUser newFrom) {
        this.m_from = newFrom;
        if (newFrom == null || !newFrom.isEMailValid() || !newFrom.isCanSendEMail()) {
            this.fFrom.setText("");
        } else {
            this.fFrom.setText(this.m_from.getEMail());
        }
    }

    public MUser getFrom() {
        return this.m_from;
    }

    public void setSubject(String newSubject) {
        this.m_subject = newSubject;
        this.fSubject.setText(this.m_subject);
    }

    public String getSubject() {
        this.m_subject = this.fSubject.getText();
        return this.m_subject;
    }

    public void setMessage(String newMessage) {
        this.m_message = newMessage;
        this.fMessage.setValue(this.m_message);
    }

    public String getMessage() {
        this.m_message = this.fMessage.getValue();
        return this.m_message;
    }

    public void setAttachment(DataSource attachment) {
        this.m_attachment = attachment;
        if (attachment != null) {
            this.attachments.add(attachment);
        }
    }

    public DataSource getAttachment() {
        return this.m_attachment;
    }

    public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.onCancel();
        } else if (event.getTarget().getId().equals("Ok")) {
            Clients.clearBusy();
            if (this.getTo() == null || this.getTo().length() == 0) {
                return;
            }
            StringTokenizer st = new StringTokenizer(this.getTo(), ",;", false);
            String to = st.nextToken();
            EMail email = this.m_client.createEMail(this.getFrom(), to, this.getSubject(), WEMailDialog.replaceBASE64Img(this.getMessage()), true);
            String status = "Check Setup";
            if (email != null) {
                while (st.hasMoreTokens()) {
                    email.addTo(st.nextToken());
                }
                StringTokenizer stcc = new StringTokenizer(this.getCc(), ",;", false);
                while (stcc.hasMoreTokens()) {
                    String cc = stcc.nextToken();
                    if (cc == null || cc.length() <= 0) continue;
                    email.addCc(cc);
                }
                for (DataSource ds : this.attachments) {
                    email.addAttachment(ds);
                }
                email.setAcknoledgmentReceipt(this.isAcknowledgmentReceipt.isChecked());
                status = email.send();
                if (this.m_user != null) {
                    new MUserMail((PO)this.m_user, this.m_user.getAD_User_ID(), email).saveEx();
                } else {
                    new MUserMail(Env.getCtx(), email).saveEx();
                }
                if (email.isSentOK()) {
                    Dialog.info(0, "MessageSent");
                    this.onClose();
                } else {
                    Dialog.error(0, "MessageNotSent", status);
                }
            } else {
                Dialog.error(0, "MessageNotSent", status);
            }
        } else if (event instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)event;
            Media media = ue.getMedia();
            if (media != null) {
                byte[] data = this.getMediaData(media);
                ByteArrayDataSource dataSource = new ByteArrayDataSource(data, media.getContentType());
                dataSource.setName(media.getName());
                this.addAttachment((DataSource)dataSource, true);
            }
        } else if (event.getTarget() == this.bAddDefaultMailText) {
            this.addMailText();
        }
    }

    private void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.onClose();
    }

    private void onSize() {
        this.fMessage.invalidate();
    }

    public void addAttachment(DataSource dataSource, boolean removeable) {
        this.attachments.add(dataSource);
        AttachmentItem item = new AttachmentItem(dataSource, this.attachments, removeable);
        this.attachmentBox.appendChild((Component)item);
        this.getFirstChild().invalidate();
    }

    private byte[] getMediaData(Media media) {
        byte[] bytes;
        block8: {
            bytes = null;
            try {
                if (media.inMemory()) {
                    bytes = media.isBinary() ? media.getByteData() : media.getStringData().getBytes(this.getCharset(media.getContentType()));
                    break block8;
                }
                try (InputStream is = null;){
                    is = media.getStreamData();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[1000];
                    int byteread = 0;
                    while ((byteread = is.read(buf)) != -1) {
                        baos.write(buf, 0, byteread);
                    }
                    bytes = baos.toByteArray();
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                throw new IllegalStateException(e.getLocalizedMessage());
            }
        }
        return bytes;
    }

    private String getCharset(String contentType) {
        String cs;
        int j;
        if (contentType != null && (j = contentType.indexOf("charset=")) >= 0 && (cs = contentType.substring(j + 8).trim()).length() > 0) {
            return cs;
        }
        return "UTF-8";
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        WSearchEditor source = (WSearchEditor)evt.getSource();
        Object value = evt.getNewValue();
        if (log.isLoggable(Level.INFO)) {
            log.info("Value=" + String.valueOf(value));
        }
        if (value == null) {
            return;
        }
        if (source.equals(this.fUser)) {
            if (value instanceof Integer) {
                int AD_User_ID = (Integer)value;
                this.m_user = MUser.get((Properties)Env.getCtx(), (int)AD_User_ID);
                if (Util.isEmpty((String)this.m_user.getEMail())) {
                    Dialog.error(0, Msg.getMsg((Properties)Env.getCtx(), (String)"UserNoEmailAddress"));
                } else {
                    this.addTo(this.m_user.getEMail(), true);
                }
            }
        } else if (value instanceof Integer) {
            int AD_User_ID = (Integer)value;
            this.m_ccuser = MUser.get((Properties)Env.getCtx(), (int)AD_User_ID);
            if (Util.isEmpty((String)this.m_ccuser.getEMail())) {
                Dialog.error(0, Msg.getMsg((Properties)Env.getCtx(), (String)"UserNoEmailAddress"));
            } else {
                this.addCC(this.m_ccuser.getEMail(), true);
            }
        }
    }

    public void addTo(String email, boolean first) {
        if (Util.isEmpty((String)email)) {
            return;
        }
        String to = this.fTo.getValue();
        if (!Util.isEmpty((String)to)) {
            this.fTo.setValue(first ? email + "," + to : to + "," + email);
        } else {
            this.fTo.setValue(email);
        }
    }

    public void addCC(String email, boolean first) {
        if (Util.isEmpty((String)email)) {
            return;
        }
        String to = this.fCc.getValue();
        if (!Util.isEmpty((String)to)) {
            this.fCc.setValue(first ? email + "," + to : to + "," + email);
        } else {
            this.fCc.setValue(email);
        }
    }

    public static String embedImgToEmail(MMailText mt, MAttachment attachment) {
        String startString;
        String origonSign = mt.getMailText(true);
        Pattern imgPattern = Pattern.compile("\\s+src\\s*=\\s*\"cid:(.*?)\"");
        Matcher imgMatcher = imgPattern.matcher(origonSign);
        ArrayList<String> lsPart = new ArrayList<String>();
        ArrayList<String> lsImgSrc = new ArrayList<String>();
        int startIndex = 0;
        int startIndexMatch = 0;
        int endIndexMatch = 0;
        while (imgMatcher.find()) {
            startIndexMatch = imgMatcher.start();
            endIndexMatch = imgMatcher.end();
            startString = origonSign.substring(startIndex, startIndexMatch);
            lsPart.add(startString);
            lsImgSrc.add(imgMatcher.group(1).trim());
            startIndex = endIndexMatch;
        }
        startString = origonSign.substring(startIndex);
        lsPart.add(startString);
        if (lsPart.size() == 0 || lsImgSrc.size() == 0) {
            return origonSign;
        }
        StringBuilder reconstructSign = new StringBuilder();
        if (attachment == null) {
            for (String strPart : lsPart) {
                reconstructSign.append(strPart);
            }
            return reconstructSign.toString();
        }
        int i = 0;
        while (i < lsImgSrc.size()) {
            if (i == 0) {
                reconstructSign.append((String)lsPart.get(0));
            }
            MAttachmentEntry[] entries = attachment.getEntries();
            String imageBase64 = null;
            MAttachmentEntry[] mAttachmentEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                MAttachmentEntry entry = mAttachmentEntryArray[n2];
                if (entry.getName().equalsIgnoreCase((String)lsImgSrc.get(i))) {
                    imageBase64 = DatatypeConverter.printBase64Binary((byte[])entry.getData());
                    break;
                }
                ++n2;
            }
            if (imageBase64 != null) {
                reconstructSign.append(" alt=\"inline_image_").append((String)lsImgSrc.get(i)).append("\" src=\"data:image/jpeg;base64,").append(imageBase64).append("\"");
            }
            reconstructSign.append((String)lsPart.get(i + 1));
            ++i;
        }
        return reconstructSign.toString();
    }

    public static String replaceBASE64Img(String base64) {
        Pattern imgPattern = Pattern.compile(" alt=\"inline_image_(.*?)\" src=\"data:image/jpeg;base64,.*?\"");
        Matcher imgMatcher = imgPattern.matcher(base64);
        StringBuffer result = new StringBuffer();
        while (imgMatcher.find()) {
            imgMatcher.appendReplacement(result, " src=\"cid:$1\"");
        }
        if (result.length() > 0) {
            imgMatcher.appendTail(result);
            return result.toString();
        }
        return base64;
    }

    private void addMailText() {
        MMailText mt = (MMailText)MUser.get((Properties)Env.getCtx()).getR_DefaultMailText();
        if (mt.get_ID() > 0) {
            mt.setPO((PO)MUser.get((Properties)Env.getCtx()));
            MAttachment attachment = MAttachment.get((Properties)Env.getCtx(), (int)416, (int)mt.get_ID(), null, null);
            if (attachment != null) {
                MAttachmentEntry[] entries;
                MAttachmentEntry[] mAttachmentEntryArray = entries = attachment.getEntries();
                int n = entries.length;
                int n2 = 0;
                while (n2 < n) {
                    MAttachmentEntry entry = mAttachmentEntryArray[n2];
                    boolean alreadyAdded = false;
                    for (DataSource attach : this.attachments) {
                        if (!attach.getName().equals(entry.getName())) continue;
                        alreadyAdded = true;
                    }
                    if (!alreadyAdded) {
                        byte[] data = entry.getData();
                        ByteArrayDataSource dataSource = new ByteArrayDataSource(data, entry.getContentType());
                        dataSource.setName(entry.getName());
                        this.addAttachment((DataSource)dataSource, true);
                    }
                    ++n2;
                }
            }
            this.fMessage.setValue(this.getMessage() + "\n" + WEMailDialog.embedImgToEmail(mt, attachment));
        }
    }

    public void focus() {
        super.focus();
        if (this.fUser != null) {
            this.fUser.getComponent().focus();
        }
    }

    public void setUserTo(int newUserTo) {
        ValueChangeEvent vce = new ValueChangeEvent(this.fUser, this.fUser.getColumnName(), this.fUser.getValue(), newUserTo);
        this.fUser.valueChange(vce);
    }

    public void setUserCc(int newUserCc) {
        ValueChangeEvent vce = new ValueChangeEvent(this.fCcUser, this.fCcUser.getColumnName(), this.fCcUser.getValue(), newUserCc);
        this.fCcUser.valueChange(vce);
    }

    private void clearEMailContext(int m_WindowNo) {
        Env.setContext((Properties)Env.getCtx(), (int)m_WindowNo, (String)"_EMAIL_TO_", (String)"");
        Env.setContext((Properties)Env.getCtx(), (int)m_WindowNo, (String)"_EMAIL_USER_TO_", (String)"");
        Env.setContext((Properties)Env.getCtx(), (int)m_WindowNo, (String)"_EMAIL_CC_", (String)"");
        Env.setContext((Properties)Env.getCtx(), (int)m_WindowNo, (String)"_EMAIL_USER_CC_", (String)"");
        Env.setContext((Properties)Env.getCtx(), (int)m_WindowNo, (String)"_EMAIL_SUBJECT_", (String)"");
        Env.setContext((Properties)Env.getCtx(), (int)m_WindowNo, (String)"_EMAIL_MESSAGE_", (String)"");
    }

    private void sendEvent(int windowNo, int tableId, int recordId, String recordUU, PrintInfo printInfo, String subject) {
        ReportSendEMailEventData eventData = new ReportSendEMailEventData(windowNo, tableId, recordId, recordUU, printInfo, subject);
        Event event = EventManager.newEvent((String)"idempiere/reportSendEMail", (Object)eventData);
        EventManager.getInstance().sendEvent(event);
    }

    private void setValuesFromContext(int windowNo) {
        String newMessage;
        String newSubject;
        int newUserCc;
        String newCc;
        int newUserTo;
        String newTo = Env.getContext((Properties)Env.getCtx(), (int)windowNo, (String)"_EMAIL_TO_");
        if (!Util.isEmpty((String)newTo)) {
            this.setTo(newTo);
        }
        if ((newUserTo = Env.getContextAsInt((Properties)Env.getCtx(), (int)windowNo, (String)"_EMAIL_USER_TO_")) > 0) {
            this.setUserTo(newUserTo);
        }
        if (!Util.isEmpty((String)(newCc = Env.getContext((Properties)Env.getCtx(), (int)windowNo, (String)"_EMAIL_CC_")))) {
            this.setCc(newCc);
        }
        if ((newUserCc = Env.getContextAsInt((Properties)Env.getCtx(), (int)windowNo, (String)"_EMAIL_USER_CC_")) > 0) {
            this.setUserCc(newUserCc);
        }
        if (!Util.isEmpty((String)(newSubject = Env.getContext((Properties)Env.getCtx(), (int)windowNo, (String)"_EMAIL_SUBJECT_")))) {
            this.setSubject(newSubject);
        }
        if (!Util.isEmpty((String)(newMessage = Env.getContext((Properties)Env.getCtx(), (int)windowNo, (String)"_EMAIL_MESSAGE_")))) {
            this.setMessage(newMessage);
        }
    }
}

