/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.IInfoColumn;
import org.adempiere.model.MInfoProcess;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.ProcessModalDialog;
import org.adempiere.webui.apps.WProcessCtl;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Mask;
import org.adempiere.webui.component.ProcessInfoDialog;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.factory.InfoManager;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.InfoGeneralPanel;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.part.ITabOnSelectHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.UUIDColumn;
import org.compiere.model.AccessSqlParser;
import org.compiere.model.GridField;
import org.compiere.model.InfoColumnVO;
import org.compiere.model.InfoRelatedVO;
import org.compiere.model.MInfoColumn;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.MRefTable;
import org.compiere.model.MRole;
import org.compiere.model.MStatusLine;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Paging;
import org.zkoss.zul.Window;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Sortable;

public abstract class InfoPanel
extends Window
implements EventListener<Event>,
WTableModelListener,
Sortable<Object>,
IHelpContext {
    private static final long serialVersionUID = 8253708190979803268L;
    protected static final String ON_USER_QUERY_ATTR = "ON_USER_QUERY";
    protected static final String INFO_QUERY_TIME_OUT_ERROR = "InfoQueryTimeOutError";
    protected static final String COLUMN_VISIBLE_ORIGINAL = "column.visible.original";
    protected static final String ROW_CTX_VARIABLE_PREFIX = "_IWInfo_";
    protected static final String ROW_ID_CTX_VARIABLE_NAME = "_IWInfoIDs_Selected";
    private static final int DEFAULT_PAGE_SIZE = 100;
    private static final int DEFAULT_PAGE_PRELOAD = 4;
    protected List<Button> btProcessList = new ArrayList<Button>();
    protected Map<String, WEditor> editorMap = new HashMap<String, WEditor>();
    protected static final String PROCESS_ID_KEY = "processId";
    protected static final String ON_RUN_PROCESS = "onRunProcess";
    protected static final String ON_SELECT_ALL_RECORDS = "onSelectAllRecords";
    protected static final String ATT_INFO_PROCESS_KEY = "INFO_PROCESS";
    protected int pageSize;
    public LinkedHashMap<NamePair, LinkedHashMap<String, Object>> m_values = null;
    protected InfoRelatedVO[] relatedInfoList;
    protected boolean isIgnoreCacheAll = true;
    protected int numPagePreLoad = MSysConfig.getIntValue((String)"ZK_INFO_NUM_PAGE_PRELOAD", (int)4);
    protected int extra_max_row = 1;
    protected MInfoColumn keyColumnOfView = null;
    protected int indexKeyOfView = -1;
    protected boolean isIDColumnKeyOfView = false;
    protected boolean hasRightQuickEntry = true;
    protected boolean isHasNextPage = false;
    protected Map<Object, List<Object>> recordSelectedData = new HashMap<Object, List<Object>>();
    protected boolean isRequeryByRunSuccessProcess = false;
    static final int INFO_WIDTH = 800;
    protected boolean m_lookup;
    protected int m_infoWindowID;
    private boolean m_closeAfterExecutionOfProcess = false;
    private Button btnSelectAll;
    private Button btnDeSelectAll;
    private boolean registerWindowNo = false;
    protected ConfirmPanel confirmPanel;
    protected int p_WindowNo;
    protected String p_tableName;
    protected String p_keyColumn;
    protected boolean p_multipleSelection;
    protected String p_whereClause = "";
    protected StatusBarPanel statusBar = new StatusBarPanel();
    private List<Object> line;
    private boolean m_ok = false;
    private boolean m_cancel = false;
    private ArrayList<Object> m_results = new ArrayList(3);
    private ListModelTable model;
    protected ColumnInfo[] p_layout;
    protected String m_sqlMain;
    protected String m_sqlCount;
    protected String m_sqlOrder;
    private String m_sqlUserOrder;
    protected int indexOrderColumn = -1;
    protected String sqlOrderColumn;
    protected Boolean isColumnSortAscending = null;
    private ArrayList<ValueChangeListener> listeners = new ArrayList();
    protected boolean p_loadedOK = false;
    private int m_SO_Window_ID = -1;
    private int m_PO_Window_ID = -1;
    protected MInfoWindow infoWindow;
    protected transient CLogger log = CLogger.getCLogger(this.getClass());
    protected WListbox contentPanel = new WListbox();
    protected Paging paging;
    protected int pageNo;
    protected int m_count;
    private int cacheStart;
    private int cacheEnd;
    private boolean m_useDatabasePaging = false;
    private int m_lastSelectedIndex = -1;
    protected GridField m_gridfield;
    protected boolean isQueryByUser = false;
    protected boolean isAutoComplete = false;
    protected int queryTimeout = 0;
    protected boolean useQueryTimeoutFromSysConfig = true;
    protected String autoCompleteSearchColumn = null;
    protected String queryValue;
    protected String prevWhereClause = null;
    protected List<Object> prevParameterValues = null;
    protected List<String> prevQueryOperators = null;
    protected List<WEditor> prevRefParmeterEditor = null;
    private static final String[] lISTENER_EVENTS = new String[0];
    protected MInfoProcess[] infoProcessList;
    protected boolean haveProcess = false;
    protected List<MInfoProcess> infoProcessBtList;
    protected List<MInfoProcess> infoProcessDropList;
    protected List<MInfoProcess> infoProcessMenuList;
    protected Collection<NamePair> m_viewIDMap = new ArrayList<NamePair>();
    protected Map<Integer, Integer> columnDataIndex = new HashMap<Integer, Integer>();
    protected boolean isMustUpdateColumnIndex = true;
    protected int indexColumnCount = 0;
    protected List<Integer> lsReadedColumn = new ArrayList<Integer>();
    protected Button btCbbProcess;
    protected Combobox cbbProcess;
    protected Button btMenuProcess;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    protected ArrayList<Object> m_rowSelectionOrder = new ArrayList();
    protected int m_selectedCount = 0;
    protected HashMap<String, Object> paraCtxValues = new HashMap();
    public static final int VK_ENTER = 13;
    public static final int VK_ESCAPE = 27;

    public static InfoPanel create(int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause) {
        return InfoManager.create(WindowNo, tableName, keyColumn, value, multiSelection, whereClause, true);
    }

    public static void showPanel(String tableName) {
        InfoPanel info = InfoManager.create(0, tableName, tableName + "_ID", "", false, "", false);
        info.setAttribute("mode", "embedded");
        AEnv.showWindow(info);
        info.setFocus(true);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause) {
        this(WindowNo, tableName, keyColumn, multipleSelection, whereClause, true);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause, boolean lookup) {
        this(WindowNo, tableName, keyColumn, multipleSelection, whereClause, lookup, 0);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause, boolean lookup, int ADInfoWindowID) {
        this(WindowNo, tableName, keyColumn, multipleSelection, whereClause, lookup, ADInfoWindowID, null);
    }

    protected InfoPanel(int WindowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause, boolean lookup, int ADInfoWindowID, String queryValue) {
        if (WindowNo <= 0) {
            this.p_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
            this.registerWindowNo = true;
        } else {
            this.p_WindowNo = WindowNo;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info("WinNo=" + WindowNo + " " + whereClause);
        }
        this.p_tableName = tableName;
        this.m_infoWindowID = ADInfoWindowID;
        this.p_keyColumn = keyColumn;
        this.queryValue = queryValue;
        if (queryValue != null && queryValue.trim().length() > 0) {
            this.parseQueryValue();
        }
        this.setMultipleSelection(multipleSelection);
        this.m_lookup = lookup;
        this.loadInfoWindowData();
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.p_whereClause = whereClause == null ? "" : whereClause;
        } else {
            this.p_whereClause = Env.parseContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)whereClause, (boolean)false, (boolean)false);
            if (this.p_whereClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
        }
        this.pageSize = MSysConfig.getIntValue((String)"ZK_PAGING_SIZE", (int)100, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (this.infoWindow != null && this.infoWindow.getPagingSize() > 0) {
            this.pageSize = this.infoWindow.getPagingSize();
        }
        this.init();
        this.setAttribute("TabOnSelectHandler", new ITabOnSelectHandler(){

            @Override
            public void onSelect() {
                InfoPanel.this.scrollToSelectedRow();
            }
        });
        this.setClientAttribute("instanceName", "infopanel");
        this.addEventListener("onWindowContainerSelectionChanged", this);
        this.addEventListener(ON_RUN_PROCESS, this);
        this.addEventListener(ON_SELECT_ALL_RECORDS, this);
        this.addEventListener("onClose", this);
        this.setAttribute("desktop.windowno", this.p_WindowNo);
    }

    protected void parseQueryValue() {
        if (Util.isEmpty((String)this.queryValue, (boolean)true)) {
            return;
        }
        int start = this.queryValue.indexOf("?autocomplete={");
        if (start > 0 && this.queryValue.endsWith("}")) {
            String[] options;
            this.isAutoComplete = true;
            this.numPagePreLoad = 1;
            String optionInput = this.queryValue.substring(start + "?autocomplete={".length(), this.queryValue.length() - 1);
            this.queryValue = this.queryValue.substring(0, start);
            String[] stringArray = options = optionInput.split("[,]");
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                String option = stringArray[n2];
                String[] pair = option.trim().split("[:]");
                if (pair.length == 2) {
                    if (pair[0].equalsIgnoreCase("timeout")) {
                        try {
                            t = Integer.parseInt(pair[1]);
                            if (t > 0) {
                                this.setFixedQueryTimeout(t);
                            }
                        }
                        catch (Exception exception) {}
                    } else if (pair[0].equalsIgnoreCase("pagesize")) {
                        try {
                            t = Integer.parseInt(pair[1]);
                            if (t > 0) {
                                this.pageSize = t;
                            }
                        }
                        catch (Exception exception) {}
                    } else if (pair[0].equalsIgnoreCase("searchcolumn")) {
                        this.autoCompleteSearchColumn = pair[1];
                    }
                }
                ++n2;
            }
        }
    }

    public void setFixedQueryTimeout(int timeout) {
        this.queryTimeout = timeout;
        this.useQueryTimeoutFromSysConfig = false;
    }

    private void init() {
        if (this.isLookup()) {
            this.setAttribute("mode", "highlighted");
            this.setBorder("normal");
            this.setClosable(true);
            int height = ClientInfo.get().desktopHeight;
            int width = ClientInfo.get().desktopWidth;
            if (width <= 1000) {
                ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
                ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
            } else {
                height = height * 85 / 100;
                width = width * 80 / 100;
                ZKUpdateUtil.setWidth((HtmlBasedComponent)this, width + "px");
                ZKUpdateUtil.setHeight((HtmlBasedComponent)this, height + "px");
            }
            this.setContentStyle("overflow: auto");
        } else {
            this.setAttribute("mode", "embedded");
            this.setBorder("none");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        }
        this.confirmPanel = new ConfirmPanel(true, true, true, true, true, true);
        this.confirmPanel.addComponentsLeft(this.confirmPanel.createButton("New"));
        this.btnSelectAll = this.confirmPanel.createButton("SelectAll");
        this.confirmPanel.addComponentsLeft(this.btnSelectAll);
        this.btnSelectAll.setEnabled(false);
        this.btnSelectAll.setVisible(this.p_multipleSelection);
        this.btnDeSelectAll = this.confirmPanel.createButton("DeSelectAll");
        this.confirmPanel.addComponentsLeft(this.btnDeSelectAll);
        this.btnDeSelectAll.setEnabled(false);
        this.btnDeSelectAll.setVisible(this.p_multipleSelection);
        this.confirmPanel.addActionListener("onClick", this);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.confirmPanel, "1");
        if (ClientInfo.isMobile() && (ClientInfo.maxWidth(700) || ClientInfo.maxHeight(500))) {
            this.confirmPanel.useSmallButtonClassForSmallScreen();
        }
        this.confirmPanel.getButton("Customize").setVisible(this.hasCustomize());
        this.confirmPanel.getButton("History").setVisible(this.hasHistory());
        this.confirmPanel.getButton("Zoom").setVisible(this.hasZoom());
        this.confirmPanel.getButton("New").setVisible(this.hasNew());
        if (!this.isLookup()) {
            this.confirmPanel.getButton("Ok").setVisible(false);
        }
        this.setSizable(true);
        this.setMaximizable(true);
        this.addEventListener("onOK", this);
        if (this.isLookup()) {
            this.addEventListener("onCancel", this);
        }
        this.contentPanel.setOddRowSclass(null);
        this.contentPanel.setClientAttribute("instanceName", "infoListbox");
        this.contentPanel.addEventListener("onAfterRender", this);
        this.contentPanel.setSclass("z-word-nowrap");
        this.setSclass("info-panel");
    }

    public boolean loadedOK() {
        return this.p_loadedOK;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    public void setStatusSelected() {
        int selectedCount = this.p_multipleSelection ? this.recordSelectedData.size() : 0;
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Object keyCandidate = this.getColumnValue(rowIndex);
            List candidateRecord = (List)this.contentPanel.getModel().get(rowIndex);
            if (this.contentPanel.getModel().isSelected(candidateRecord)) {
                if (!this.p_multipleSelection) {
                    ++selectedCount;
                    break;
                }
                if (!this.recordSelectedData.containsKey(keyCandidate)) {
                    ++selectedCount;
                }
            } else if (this.p_multipleSelection && this.recordSelectedData.containsKey(keyCandidate)) {
                --selectedCount;
            }
            ++rowIndex;
        }
        this.m_selectedCount = selectedCount;
        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"IWStatusSelected", (Object[])new Object[]{String.valueOf(selectedCount)});
        this.statusBar.setSelectedRowNumber(msg);
        this.btnSelectAll.setEnabled(this.m_count > 0 && selectedCount != this.m_count);
        this.btnDeSelectAll.setEnabled(selectedCount > 0);
    }

    protected void prepareTable(ColumnInfo[] layout, String from, String where, String orderBy) {
        String sql = this.contentPanel.prepareTable(layout, from, where, this.p_multipleSelection, this.getTableName(), false);
        if (this.infoWindow != null) {
            this.contentPanel.setwListBoxName("AD_InfoWindow_UU|" + this.infoWindow.getAD_InfoWindow_UU());
        } else {
            this.contentPanel.setwListBoxName("AD_InfoPanel|" + from);
        }
        this.p_layout = this.contentPanel.getLayout();
        this.m_sqlMain = sql;
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + where;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.trim().length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
    }

    protected boolean isLoadPageNumber() {
        return this.infoWindow == null || this.infoWindow.isLoadPageNum();
    }

    protected void executeQuery() {
        this.saveWlistBoxColumnWidth(this.getFirstChild());
        this.line = new ArrayList<Object>();
        this.setCacheStart(-1);
        this.cacheEnd = -1;
        if (this.isLoadPageNumber()) {
            this.testCount();
        } else {
            this.m_count = Integer.MAX_VALUE;
        }
        if (this.m_count > 0) {
            boolean bl = this.m_useDatabasePaging = this.isIgnoreCacheAll || this.m_count > 1000;
            if (this.m_useDatabasePaging) {
                return;
            }
            this.readLine(0, -1);
        }
    }

    private void readData(ResultSet rs) throws SQLException {
        int colOffset = 1;
        ArrayList<Object> data = new ArrayList<Object>();
        int col = 0;
        while (col < this.p_layout.length) {
            Object value = null;
            Class c = this.p_layout[col].getColClass();
            int colIndex = col + colOffset;
            if (c == IDColumn.class) {
                value = new IDColumn(rs.getInt(colIndex));
            } else if (c == UUIDColumn.class) {
                value = new UUIDColumn(rs.getString(colIndex));
            } else if (c == Boolean.class) {
                value = "Y".equals(rs.getString(colIndex));
            } else if (c == Timestamp.class) {
                value = rs.getTimestamp(colIndex);
            } else if (c == BigDecimal.class) {
                value = rs.getBigDecimal(colIndex);
            } else if (c == Double.class) {
                value = rs.getDouble(colIndex);
            } else if (c == Integer.class) {
                value = rs.getInt(colIndex);
            } else if (c == KeyNamePair.class) {
                if (this.p_layout[col].isKeyPairCol()) {
                    String display = rs.getString(colIndex);
                    int key = rs.getInt(colIndex + 1);
                    if (!rs.wasNull()) {
                        value = new KeyNamePair(key, display);
                    }
                    ++colOffset;
                } else {
                    int key = rs.getInt(colIndex);
                    if (!rs.wasNull()) {
                        WEditor editor = this.editorMap.get(this.p_layout[col].getColSQL());
                        if (editor != null) {
                            editor.setValue(key);
                            value = new KeyNamePair(key, editor.getDisplayTextForGridView(key));
                        } else {
                            value = new KeyNamePair(key, Integer.toString(key));
                        }
                    }
                }
            } else if (c == ValueNamePair.class) {
                String key = rs.getString(colIndex);
                WEditor editor = this.editorMap.get(this.p_layout[col].getColSQL());
                value = editor != null ? new ValueNamePair(key, editor.getDisplayTextForGridView(key)) : new ValueNamePair(key, key);
            } else {
                WEditor editor;
                value = rs.getString(colIndex);
                if (!rs.wasNull() && (editor = this.editorMap.get(this.p_layout[col].getColSQL())) != null && editor.getGridField() != null && editor.getGridField().isLookup()) {
                    editor.setValue(value);
                    value = editor.getDisplay();
                }
            }
            data.add(value);
            ++col;
        }
        this.line.add(data);
        this.appendDataForViewID(rs, data, this.lsReadedColumn);
        this.appendDataForParentLink(rs, data, this.lsReadedColumn);
        this.appendDataForKeyView(rs, data, this.lsReadedColumn);
    }

    protected void appendDataForViewID(ResultSet rs, List<Object> data, List<Integer> listReadedColumn) throws SQLException {
        this.appendInfoColumnData(rs, data, (IInfoColumn[])this.infoProcessList, listReadedColumn);
    }

    protected void appendDataForParentLink(ResultSet rs, List<Object> data, List<Integer> listReadedColumn) throws SQLException {
        this.appendInfoColumnData(rs, data, (IInfoColumn[])this.relatedInfoList, listReadedColumn);
    }

    protected void appendDataForKeyView(ResultSet rs, List<Object> data, List<Integer> listReadedColumn) throws SQLException {
        if (this.isNeedAppendKeyViewData()) {
            this.appendInfoColumnData(rs, data, new IInfoColumn[]{this.keyColumnOfView}, listReadedColumn);
        }
    }

    protected void appendInfoColumnData(ResultSet rs, List<Object> data, IInfoColumn[] listModelHasInfoColumn, List<Integer> listReadedColumn) throws SQLException {
        if (listModelHasInfoColumn == null || listModelHasInfoColumn.length == 0) {
            return;
        }
        IInfoColumn[] iInfoColumnArray = listModelHasInfoColumn;
        int n = listModelHasInfoColumn.length;
        int n2 = 0;
        while (n2 < n) {
            IInfoColumn modelHasInfoColumn = iInfoColumnArray[n2];
            if (modelHasInfoColumn.getInfoColumnID() > 0 && !listReadedColumn.contains(modelHasInfoColumn.getInfoColumnID())) {
                MInfoColumn infoColumnApp = modelHasInfoColumn.getAD_InfoColumn();
                InfoColumnVO infoColumnAppend = new InfoColumnVO(Env.getCtx(), infoColumnApp);
                Object appendData = null;
                try {
                    appendData = DisplayType.isID((int)infoColumnAppend.getAD_Reference_ID()) ? Integer.valueOf(rs.getInt(infoColumnAppend.getColumnName())) : (DisplayType.isDate((int)infoColumnAppend.getAD_Reference_ID()) ? rs.getTimestamp(infoColumnAppend.getColumnName()) : (DisplayType.isNumeric((int)infoColumnAppend.getAD_Reference_ID()) ? rs.getBigDecimal(infoColumnAppend.getColumnName()) : rs.getString(infoColumnAppend.getColumnName())));
                }
                catch (SQLException sQLException) {
                    appendData = null;
                }
                if (rs.wasNull()) {
                    appendData = null;
                }
                data.add(appendData);
                if (this.isMustUpdateColumnIndex && !this.columnDataIndex.containsKey(modelHasInfoColumn.getInfoColumnID())) {
                    this.columnDataIndex.put(modelHasInfoColumn.getInfoColumnID(), this.indexColumnCount);
                    ++this.indexColumnCount;
                }
                listReadedColumn.add(modelHasInfoColumn.getInfoColumnID());
            }
            ++n2;
        }
    }

    protected void renderItems() {
        Mask mask;
        if (this.m_count > 0) {
            if (this.m_count > this.pageSize) {
                if (this.paging == null) {
                    this.paging = new Paging();
                    this.paging.setPageSize(this.pageSize);
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setDetailed(true);
                    this.paging.addEventListener("onPaging", (EventListener)this);
                } else {
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setActivePage(0);
                    this.paging.setVisible(true);
                }
                List<Object> subList = this.readLine(0, this.pageSize);
                this.model = new ListModelTable(subList);
                this.model.setSorter(this);
                this.model.addTableModelListener(this);
                this.model.setMultiple(this.p_multipleSelection);
                this.contentPanel.setData(this.model, null);
                this.pageNo = 0;
            } else {
                if (this.paging != null) {
                    this.paging.setTotalSize(this.m_count);
                    this.paging.setActivePage(0);
                    this.pageNo = 0;
                }
                this.model = new ListModelTable(this.readLine(0, -1));
                this.model.setSorter(this);
                this.model.addTableModelListener(this);
                this.model.setMultiple(this.p_multipleSelection);
                this.contentPanel.setData(this.model, null);
            }
        } else {
            if (this.paging != null) {
                this.paging.setTotalSize(this.m_count);
                this.paging.setActivePage(0);
                this.pageNo = 0;
            }
            this.model = new ListModelTable(new ArrayList());
            this.model.setSorter(this);
            this.model.addTableModelListener(this);
            this.model.setMultiple(this.p_multipleSelection);
            this.contentPanel.setData(this.model, null);
            this.contentPanel.renderCustomHeaderWidth();
        }
        this.autoHideEmptyColumns();
        this.restoreSelectedInPage();
        this.updateStatusBar(this.m_count);
        this.setStatusSelected();
        this.setFocusToContentPanel();
        this.addDoubleClickListener();
        if (this.paging != null && this.paging.getParent() == null) {
            this.insertPagingComponent();
        }
        if ((mask = this.getMaskObj()) == null || mask.getParent() == null) {
            this.invalidate();
        }
    }

    protected void autoHideEmptyColumns() {
        String attr = this.contentPanel.getUuid() + ".autoHideEmptyColumns";
        if (Executions.getCurrent().getAttribute(attr) != null) {
            return;
        }
        Executions.getCurrent().setAttribute(attr, (Object)Boolean.TRUE);
        Listhead columns = this.contentPanel.getListhead();
        List columnList = columns.getChildren();
        int rowCount = this.model.getSize();
        for (Listheader column : columnList) {
            Boolean b;
            Object attrValue;
            if (!this.isAutoHideEmptyColumns()) {
                Boolean b2;
                Object attrValue2;
                if (column.isVisible() || (attrValue2 = column.getAttribute(COLUMN_VISIBLE_ORIGINAL)) == null || !(attrValue2 instanceof Boolean) || !(b2 = (Boolean)attrValue2).booleanValue()) continue;
                column.setVisible(true);
                continue;
            }
            boolean hideColumn = false;
            if (rowCount > 0) {
                hideColumn = true;
                int i = 0;
                while (i < rowCount) {
                    String display;
                    Object value = this.model.getDataAt(i, column.getColumnIndex());
                    String string = display = value != null ? value.toString() : "";
                    if (!Util.isEmpty((String)display, (boolean)true)) {
                        hideColumn = false;
                        break;
                    }
                    ++i;
                }
            }
            if (hideColumn && column.isVisible()) {
                column.setVisible(false);
                column.setAttribute(COLUMN_VISIBLE_ORIGINAL, (Object)Boolean.TRUE);
                continue;
            }
            if (hideColumn || column.isVisible() || (attrValue = column.getAttribute(COLUMN_VISIBLE_ORIGINAL)) == null || !(attrValue instanceof Boolean) || !(b = (Boolean)attrValue).booleanValue()) continue;
            column.setVisible(true);
        }
    }

    protected boolean isAutoHideEmptyColumns() {
        return MSysConfig.getBooleanValue((String)"ZK_INFO_AUTO_HIDE_EMPTY_COLUMNS", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    }

    protected void updateStatusBar(int no) {
        this.setStatusLine((no == Integer.MAX_VALUE ? "?" : Integer.toString(no)) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(no == Integer.MAX_VALUE ? "?" : Integer.toString(no));
    }

    private List<Object> readLine(int start, int end) {
        block27: {
            if (this.useQueryTimeoutFromSysConfig) {
                this.queryTimeout = MSysConfig.getIntValue((String)"ZK_INFO_QUERY_TIME_OUT", (int)0, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            }
            if (this.getCacheStart() >= 1 && this.cacheEnd > this.getCacheStart()) {
                if (this.m_useDatabasePaging) {
                    if (start + 1 >= this.getCacheStart() && end + 1 <= this.cacheEnd) {
                        return end == -1 ? this.line : this.getSubList(start - this.getCacheStart() + 1, end - this.getCacheStart() + 1, this.line);
                    }
                } else {
                    if (end > this.cacheEnd || end <= 0) {
                        end = this.cacheEnd;
                    }
                    return this.getSubList(start, end, this.line);
                }
            }
            this.setCacheStart(this.getOverIntValue((long)start + 1L - (long)(this.pageSize * this.numPagePreLoad)));
            if (this.getCacheStart() <= 0) {
                this.setCacheStart(1);
            }
            if (end == -1) {
                this.cacheEnd = this.m_count;
            } else {
                this.cacheEnd = this.getOverIntValue(end + 1 + this.pageSize * this.numPagePreLoad);
                if (this.cacheEnd > this.m_count) {
                    this.cacheEnd = this.m_count;
                }
            }
            this.line = new ArrayList<Object>();
            CPreparedStatement m_pstmt = null;
            ResultSet m_rs = null;
            String dataSql = null;
            long startTime = System.currentTimeMillis();
            dataSql = this.buildDataSQL(start, end);
            this.isHasNextPage = false;
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(dataSql);
            }
            Trx trx = null;
            try {
                try {
                    String trxName = Trx.createTrxName((String)"InfoPanelLoad:");
                    trx = Trx.get((String)trxName, (boolean)true);
                    trx.setDisplayName(this.getClass().getName() + "_readLine");
                    m_pstmt = DB.prepareStatement((String)dataSql, (String)trxName);
                    if (this.queryTimeout > 0) {
                        m_pstmt.setQueryTimeout(this.queryTimeout);
                    }
                    this.setParameters((PreparedStatement)m_pstmt, false);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Start query - " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    m_pstmt.setFetchSize(100);
                    m_rs = m_pstmt.executeQuery();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("End query - " + (System.currentTimeMillis() - startTime) + "ms");
                    }
                    if (end > start && this.m_useDatabasePaging && !DB.getDatabase().isPagingSupported()) {
                        int i = 0;
                        while (i < this.getCacheStart() - 1) {
                            if (!m_rs.next()) break;
                            ++i;
                        }
                    }
                    int rowPointer = this.getCacheStart() - 1;
                    while (m_rs.next()) {
                        this.lsReadedColumn.clear();
                        this.readData(m_rs);
                        this.isMustUpdateColumnIndex = false;
                        if (!this.m_useDatabasePaging || ++rowPointer < this.cacheEnd) continue;
                        this.isHasNextPage = true;
                        break;
                    }
                }
                catch (SQLException e) {
                    if (DB.getDatabase().isQueryTimeout(e)) {
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.log(Level.INFO, dataSql, (Throwable)e);
                        }
                        Dialog.error(this.p_WindowNo, INFO_QUERY_TIME_OUT_ERROR);
                    } else {
                        this.log.log(Level.SEVERE, dataSql, (Throwable)e);
                        Dialog.error(this.p_WindowNo, "DBExecuteError", e.getMessage());
                    }
                    DB.close(m_rs, (Statement)m_pstmt);
                    trx.close();
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DB.close(m_rs, m_pstmt);
                trx.close();
                throw throwable;
            }
            DB.close((ResultSet)m_rs, (Statement)m_pstmt);
            trx.close();
        }
        if (end > this.cacheEnd || end <= 0) {
            end = this.cacheEnd;
        }
        this.validateEndPage();
        if (end == -1) {
            return this.line;
        }
        int fromIndex = start - this.getCacheStart() + 1;
        int toIndex = end - this.getCacheStart() + 1;
        return this.getSubList(fromIndex, toIndex, this.line);
    }

    protected void validateEndPage() {
        if (this.paging == null || this.isLoadPageNumber()) {
            return;
        }
        if (!this.isHasNextPage) {
            int extraPage = this.line.size() % this.pageSize > 0 ? 1 : 0;
            int pageInCache = this.line.size() / this.pageSize + extraPage;
            if (pageInCache == 0 || pageInCache <= this.numPagePreLoad) {
                this.testCount();
                extraPage = this.m_count % this.pageSize > 0 ? 1 : 0;
                pageInCache = this.m_count / this.pageSize + extraPage;
                this.paging.setTotalSize(this.m_count);
                PagingEvent pagingEvent = new PagingEvent("onPaging", (Component)this.paging, this.paging.getPageCount() - 1);
                Events.postEvent((Event)pagingEvent);
            } else if (pageInCache > this.numPagePreLoad) {
                int prePage = this.pageNo - this.numPagePreLoad;
                int readTotalRecord = (prePage > 0 ? prePage : 0) * this.pageSize + this.line.size();
                this.paging.setTotalSize(readTotalRecord);
                this.m_count = readTotalRecord;
            }
            this.updateStatusBar(this.m_count);
        }
    }

    protected List<Object> getSubList(int fromIndex, int toIndex, List<Object> line) {
        if (toIndex > line.size()) {
            toIndex = line.size();
        }
        if (fromIndex >= line.size()) {
            fromIndex = line.size();
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        return line.subList(fromIndex, toIndex);
    }

    protected int getOverIntValue(long value) {
        return this.getOverIntValue(value, 0);
    }

    protected int getOverIntValue(long value, int extra) {
        if (value >= Integer.MAX_VALUE) {
            value = Integer.MAX_VALUE - extra;
        }
        return (int)value;
    }

    protected String buildDataSQL(int start, int end) {
        String dynWhere = this.getSQLWhere();
        StringBuilder sql = new StringBuilder(this.m_sqlMain);
        if (dynWhere.length() > 0) {
            if (sql.toString().trim().endsWith("WHERE")) {
                dynWhere = dynWhere.replaceFirst("AND", " ");
            }
            sql.append(dynWhere);
        }
        if (sql.toString().trim().endsWith("WHERE")) {
            int index = sql.lastIndexOf(" WHERE");
            sql.delete(index, sql.length());
        }
        sql.append(this.getUserOrderClause());
        String dataSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString());
        dataSql = MRole.getDefault().addAccessSQL(dataSql, this.getTableName(), true, false);
        if (end > start && this.m_useDatabasePaging && DB.getDatabase().isPagingSupported()) {
            dataSql = DB.getDatabase().addPagingSQL(dataSql, this.getCacheStart(), this.cacheEnd);
        }
        return dataSql;
    }

    protected void validateOrderIndex() {
        if (!(this.indexOrderColumn <= 0 || this.indexOrderColumn + 1 <= this.p_layout.length && this.p_layout[this.indexOrderColumn].getColSQL().trim().equals(this.sqlOrderColumn))) {
            int testIndex = 0;
            while (testIndex < this.p_layout.length) {
                if (this.p_layout[testIndex].getColSQL().trim().equals(this.sqlOrderColumn) || this.p_layout[testIndex].getDisplayColumn().equals(this.sqlOrderColumn)) {
                    this.indexOrderColumn = testIndex;
                    break;
                }
                ++testIndex;
            }
            if (this.indexOrderColumn > 0 && (this.indexOrderColumn + 1 > this.p_layout.length || !this.p_layout[this.indexOrderColumn].getColSQL().trim().equals(this.sqlOrderColumn) && !this.p_layout[this.indexOrderColumn].getDisplayColumn().equals(this.sqlOrderColumn))) {
                this.indexOrderColumn = -1;
                this.sqlOrderColumn = null;
                this.m_sqlUserOrder = null;
            }
        }
    }

    protected String getUserOrderClause() {
        this.validateOrderIndex();
        if (this.indexOrderColumn < 0) {
            return this.m_sqlOrder;
        }
        if (this.m_sqlUserOrder == null) {
            this.m_sqlUserOrder = this.getUserOrderClause(this.indexOrderColumn);
        }
        return this.m_sqlUserOrder;
    }

    protected String getUserOrderClause(int col) {
        ColumnInfo orderColumnInfo = this.p_layout[col];
        String displayColumn = orderColumnInfo.getDisplayColumn();
        String colsql = !Util.isEmpty((String)displayColumn) ? displayColumn : this.p_layout[col].getColSQL().trim();
        colsql = this.getSelectForOrderBy(colsql);
        if (!Util.isEmpty((String)displayColumn) && (DisplayType.isLookup((int)orderColumnInfo.getAD_Reference_ID()) || DisplayType.isChosenMultipleSelection((int)orderColumnInfo.getAD_Reference_ID()))) {
            String from = this.getFromForOrderBy(orderColumnInfo, displayColumn);
            String where = this.getWhereForOrderBy(orderColumnInfo);
            return String.format(" ORDER BY (SELECT %s FROM %s WHERE %s) %s ", colsql, from, where, this.isColumnSortAscending != false ? "" : "DESC");
        }
        return String.format(" ORDER BY %s %s ", colsql, this.isColumnSortAscending != false ? "" : "DESC");
    }

    private String getSelectForOrderBy(String colsql) {
        int lastSpaceIdx = colsql.lastIndexOf(" ");
        if (lastSpaceIdx > 0) {
            String tmp = colsql.substring(0, lastSpaceIdx).trim();
            char last = tmp.charAt(tmp.length() - 1);
            String alias = colsql.substring(lastSpaceIdx).trim();
            boolean hasAlias = alias.matches("^[a-zA-Z_][a-zA-Z0-9_]*$");
            if (tmp.toLowerCase().endsWith("as") && hasAlias) {
                colsql = alias;
            } else if (last != '*' && last != '-' && last != '+' && last != '/' && last != '>' && last != '<' && last != '=') {
                if (alias.startsWith("\"") && alias.endsWith("\"")) {
                    colsql = alias;
                } else if (hasAlias) {
                    colsql = alias;
                }
            }
        }
        return colsql;
    }

    private String getFromForOrderBy(ColumnInfo orderColumnInfo, String displayColumn) {
        Object fromClause = "";
        MTable table = this.getTable(orderColumnInfo.getAD_Reference_Value_ID(), orderColumnInfo.getColumnName());
        String tableName = table.getTableName();
        if (table != null) {
            fromClause = (String)fromClause + tableName;
        }
        if (displayColumn.contains(table.getTableName() + "_Trl")) {
            String tableNameTrl = tableName + "_Trl";
            MTable tableTrl = MTable.get((Properties)Env.getCtx(), (String)tableNameTrl);
            String sqlSelect = orderColumnInfo.getSelectClause();
            String[] keyCols = tableTrl.getKeyColumns();
            fromClause = (String)fromClause + " JOIN " + tableNameTrl + " ON (";
            int i = 0;
            while (i < keyCols.length) {
                String keyCol = keyCols[i];
                if (i > 0) {
                    fromClause = (String)fromClause + " AND ";
                }
                fromClause = (String)fromClause + tableNameTrl + "." + keyCol + " = ";
                fromClause = "AD_Language".equalsIgnoreCase(keyCol) ? (String)fromClause + " '" + Env.getAD_Language((Properties)Env.getCtx()) + "' " : (String)fromClause + sqlSelect;
                ++i;
            }
            fromClause = (String)fromClause + ") ";
        }
        return fromClause;
    }

    private String getWhereForOrderBy(ColumnInfo orderColumnInfo) {
        MTable table = this.getTable(orderColumnInfo.getAD_Reference_Value_ID(), orderColumnInfo.getColumnName());
        String tableName = table.getTableName();
        String keyCol = table.getKeyColumns()[0];
        String sqlSelect = orderColumnInfo.getSelectClause();
        Object whereClause = "";
        whereClause = (String)whereClause + tableName + "." + keyCol + " = " + sqlSelect;
        return whereClause;
    }

    private void addDoubleClickListener() {
        Iterator i = this.contentPanel.getEventListeners("onDoubleClick").iterator();
        while (i.hasNext()) {
            if (i.next() != this) continue;
            return;
        }
        this.contentPanel.addEventListener("onDoubleClick", this);
        this.contentPanel.addEventListener("onSelect", this);
    }

    public String getAlias(String tableName) {
        if (Util.isEmpty((String)tableName)) {
            return "";
        }
        String alias = tableName;
        AccessSqlParser.TableInfo[] tableInfoArray = this.infoWindow.getTableInfos();
        int n = tableInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessSqlParser.TableInfo tableInfo = tableInfoArray[n2];
            if (tableName.equalsIgnoreCase(tableInfo.getTableName())) {
                alias = !Util.isEmpty((String)tableInfo.getSynonym()) ? tableInfo.getSynonym() : tableName;
            }
            ++n2;
        }
        return alias;
    }

    protected void insertPagingComponent() {
        this.contentPanel.getParent().insertBefore((Component)this.paging, this.contentPanel.getNextSibling());
    }

    public Vector<String> getColumnHeader(ColumnInfo[] p_layout) {
        Vector<String> columnHeader = new Vector<String>();
        ColumnInfo[] columnInfoArray = p_layout;
        int n = p_layout.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnInfo info = columnInfoArray[n2];
            columnHeader.add(info.getColHeader());
            ++n2;
        }
        return columnHeader;
    }

    protected boolean testCount() {
        long start;
        block16: {
            String countSql;
            if (this.useQueryTimeoutFromSysConfig) {
                this.queryTimeout = MSysConfig.getIntValue((String)"ZK_INFO_QUERY_TIME_OUT", (int)0, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            }
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere();
            StringBuilder sql = new StringBuilder(this.m_sqlCount);
            if (dynWhere.length() > 0) {
                if (sql.toString().trim().endsWith("WHERE")) {
                    dynWhere = dynWhere.replaceFirst("AND", " ");
                }
                sql.append(dynWhere);
            }
            if ((countSql = Msg.parseTranslation((Properties)Env.getCtx(), (String)sql.toString())).trim().endsWith("WHERE")) {
                countSql = countSql.trim();
                countSql = countSql.substring(0, countSql.length() - 5);
            }
            countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(countSql);
            }
            this.m_count = -1;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)countSql, null);
                    if (this.queryTimeout > 0) {
                        pstmt.setQueryTimeout(this.queryTimeout);
                    }
                    this.setParameters((PreparedStatement)pstmt, true);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        this.m_count = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SQLException && DB.getDatabase().isQueryTimeout((SQLException)e)) {
                        if (this.log.isLoggable(Level.INFO)) {
                            this.log.log(Level.INFO, countSql, (Throwable)e);
                        }
                        Dialog.error(this.p_WindowNo, INFO_QUERY_TIME_OUT_ERROR);
                    } else {
                        this.log.log(Level.SEVERE, countSql, (Throwable)e);
                        Dialog.error(this.p_WindowNo, "DBExecuteError", e.getMessage());
                    }
                    this.m_count = -2;
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("#" + this.m_count + " - " + (System.currentTimeMillis() - start) + "ms");
        }
        return true;
    }

    protected void saveSelection() {
        if (this.contentPanel == null) {
            return;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + this.m_ok);
        }
        this.m_results.clear();
        if (!this.m_ok) {
            this.contentPanel = null;
            return;
        }
        if (this.p_multipleSelection) {
            this.m_results.addAll(this.getSelectedRowKeys());
        } else {
            Object data = this.getSelectedRowKey();
            if (data != null) {
                this.m_results.add(data);
            }
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(this.getSelectedSQL());
        }
        this.saveSelectionDetail();
    }

    protected <T extends Serializable> T getSelectedRowKey() {
        Object key = this.contentPanel.getSelectedRowKey();
        return key;
    }

    protected Integer getIntSelectedRowKey(int tableId) {
        Object key = this.getSelectedRowKey();
        if (key == null) {
            return -1;
        }
        if (key instanceof Integer) {
            return (Integer)key;
        }
        MTable table = MTable.get((int)tableId);
        table.getPOByUU((String)key, null);
        return table.get_ID();
    }

    protected <T extends Serializable> List<T> getSelectedRowKeys() {
        ArrayList<Object> selectedDataList = new ArrayList<Object>();
        for (Map.Entry<Object, List<Object>> rowInfo : this.getSelectedRowInfo().entrySet()) {
            Object object = rowInfo.getValue().get(0);
            if (object instanceof IDColumn) {
                IDColumn idColumn = (IDColumn)object;
                selectedDataList.add(idColumn.getRecord_ID());
                continue;
            }
            Object object2 = rowInfo.getValue().get(0);
            if (!(object2 instanceof UUIDColumn)) continue;
            UUIDColumn uuidColumn = (UUIDColumn)object2;
            selectedDataList.add(uuidColumn.getRecord_UU());
        }
        return selectedDataList;
    }

    public Collection<Object> getSelectedKeysCollection() {
        this.m_ok = true;
        this.saveSelection();
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results;
    }

    public Collection<NamePair> getSaveKeys(int infoColumnId) {
        this.m_viewIDMap.clear();
        if (this.p_multipleSelection) {
            Map<Object, List<Object>> selectedRow = this.getSelectedRowInfo();
            for (Map.Entry<Object, List<Object>> selectedInfo : selectedRow.entrySet()) {
                Object keyData = selectedInfo.getKey();
                if (infoColumnId > 0) {
                    int dataIndex = this.columnDataIndex.get(infoColumnId) + this.p_layout.length;
                    Object viewIDValue = selectedInfo.getValue().get(dataIndex);
                    if (keyData instanceof String) {
                        this.m_viewIDMap.add((NamePair)new ValueNamePair((String)keyData, viewIDValue == null ? null : viewIDValue.toString()));
                        continue;
                    }
                    this.m_viewIDMap.add((NamePair)new KeyNamePair(((Integer)keyData).intValue(), viewIDValue == null ? null : viewIDValue.toString()));
                    continue;
                }
                if (keyData instanceof String) {
                    this.m_viewIDMap.add((NamePair)new ValueNamePair((String)keyData, null));
                    continue;
                }
                this.m_viewIDMap.add((NamePair)new KeyNamePair(((Integer)keyData).intValue(), null));
            }
            return this.m_viewIDMap;
        }
        return null;
    }

    protected boolean isNeedAppendKeyViewData() {
        return false;
    }

    protected boolean isIDColumn(Object keyData, boolean isCheckNull) {
        if (isCheckNull && keyData == null) {
            AdempiereException ex = this.getKeyNullException();
            this.log.severe(ex.getMessage());
            throw ex;
        }
        return keyData != null && keyData instanceof IDColumn;
    }

    protected boolean isIDColumn(Object keyData) {
        return this.isIDColumn(keyData, false);
    }

    protected void updateListSelected() {
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Object keyCandidate = this.getColumnValue(rowIndex);
            List candidateRecord = (List)this.contentPanel.getModel().get(rowIndex);
            int ri = rowIndex;
            if (this.contentPanel.getModel().isSelected(candidateRecord) || Arrays.stream(this.contentPanel.getSelectedIndices()).anyMatch(si -> si == ri)) {
                this.recordSelectedData.put(keyCandidate, candidateRecord);
            } else if (this.recordSelectedData.containsKey(keyCandidate)) {
                List<Object> recordSelected = this.recordSelectedData.get(keyCandidate);
                IDColumn idcSel = null;
                UUIDColumn uucSel = null;
                if (recordSelected.get(0) instanceof IDColumn) {
                    idcSel = (IDColumn)recordSelected.get(0);
                } else if (recordSelected.get(0) instanceof UUIDColumn) {
                    uucSel = (UUIDColumn)recordSelected.get(0);
                }
                IDColumn idcCan = null;
                UUIDColumn uucCan = null;
                if (candidateRecord.get(0) instanceof IDColumn) {
                    idcCan = (IDColumn)candidateRecord.get(0);
                } else if (candidateRecord.get(0) instanceof UUIDColumn) {
                    uucCan = (UUIDColumn)candidateRecord.get(0);
                }
                if (idcSel != null && idcCan != null && idcSel.getRecord_ID().equals(idcCan.getRecord_ID()) || uucSel != null && uucCan != null && uucSel.getRecord_UU().equals(uucCan.getRecord_UU())) {
                    recordSelected.set(0, candidateRecord.get(0));
                }
                if (recordSelected.equals(candidateRecord)) {
                    this.recordSelectedData.remove(keyCandidate);
                }
            }
            ++rowIndex;
        }
    }

    protected int getIndexKeyColumnOfView() {
        if (this.keyColumnOfView == null) {
            return this.contentPanel.getKeyColumnIndex();
        }
        if (this.isNeedAppendKeyViewData()) {
            return this.columnDataIndex.get(this.keyColumnOfView.getInfoColumnID()) + this.p_layout.length;
        }
        return this.indexKeyOfView;
    }

    protected void restoreSelectedInPage() {
        if (!this.p_multipleSelection) {
            return;
        }
        ArrayList<Object> lsSelectionRecord = new ArrayList<Object>();
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Object row;
            Object keyViewValue = this.getColumnValue(rowIndex);
            if (this.recordSelectedData.containsKey(keyViewValue) && this.onRestoreSelectedItemIndexInPage(keyViewValue, rowIndex, row = this.contentPanel.getModel().get(rowIndex))) {
                lsSelectionRecord.add(row);
            }
            ++rowIndex;
        }
        this.contentPanel.getModel().setSelection(lsSelectionRecord);
    }

    public boolean onRestoreSelectedItemIndexInPage(Object keyViewValue, int rowIndex, Object row) {
        return true;
    }

    protected AdempiereException getKeyNullException() {
        String errorMessage = String.format("has null value at column %1$s use as key of view in info window %2$s", this.keyColumnOfView == null ? this.p_keyColumn : this.keyColumnOfView, this.infoWindow.getName());
        return new AdempiereException(errorMessage);
    }

    protected Object getColumnValue(int rowIndex) {
        int keyIndex = this.getIndexKeyColumnOfView();
        Object keyValue = null;
        Object keyColumValue = this.contentPanel.getModel().getDataAt(rowIndex, keyIndex);
        if (keyColumValue == null) {
            AdempiereException ex = this.getKeyNullException();
            this.log.severe(ex.getMessage());
            throw ex;
        }
        if (keyColumValue != null) {
            if (keyColumValue instanceof IDColumn) {
                keyColumValue = ((IDColumn)keyColumValue).getRecord_ID();
            } else if (keyColumValue instanceof UUIDColumn) {
                keyColumValue = ((UUIDColumn)keyColumValue).getRecord_UU();
            }
        }
        if (keyColumValue instanceof Integer) {
            keyValue = (Integer)keyColumValue;
        } else if (keyColumValue instanceof String) {
            keyValue = (String)keyColumValue;
        } else {
            String msg = "keyView column must be integer or string";
            AdempiereException ex = new AdempiereException(msg);
            this.log.severe(msg);
            throw ex;
        }
        return keyValue;
    }

    protected void syncSelectedAfterRequery() {
        if (this.isRequeryByRunSuccessProcess) {
            this.isRequeryByRunSuccessProcess = false;
        }
    }

    public Map<Object, List<Object>> getSelectedRowInfo() {
        this.updateListSelected();
        return this.recordSelectedData;
    }

    public Object[] getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.toArray(new Object[0]);
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public String getSelectedSQL() {
        Object[] keys = this.getSelectedKeys();
        if (keys == null || keys.length == 0) {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            }
            return "";
        }
        StringBuilder sb = new StringBuilder(this.getKeyColumn());
        if (keys.length > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        int i = 0;
        while (i < keys.length) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(keys[i].toString()).append(",");
            } else {
                sb.append("'").append(keys[i].toString()).append("',");
            }
            ++i;
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    protected void loadInfoWindowData() {
    }

    protected String getTableName() {
        return this.p_tableName;
    }

    protected String getKeyColumn() {
        return this.p_keyColumn;
    }

    public String[] getEvents() {
        return lISTENER_EVENTS;
    }

    protected void enableButtons() {
        boolean enable = this.contentPanel.getSelectedCount() > 0 || this.getSelectedRowInfo().size() > 0;
        this.enableButtons(enable);
    }

    protected void enableButtons(boolean enable) {
        this.confirmPanel.getOKButton().setEnabled(enable);
        if (this.hasHistory()) {
            this.confirmPanel.getButton("History").setEnabled(enable);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getButton("Zoom").setEnabled(!enable ? enable : this.contentPanel.getSelectedCount() == 1);
        }
        if (this.hasProcess()) {
            this.confirmPanel.getButton("Process").setEnabled(enable);
        }
        for (Button btProcess : this.btProcessList) {
            btProcess.setEnabled(enable);
        }
        if (this.btCbbProcess != null) {
            this.btCbbProcess.setEnabled(enable);
        }
        if (this.btMenuProcess != null) {
            this.btMenuProcess.setEnabled(enable);
        }
        if (this.cbbProcess != null) {
            this.cbbProcess.setEnabled(enable);
        }
    }

    protected abstract String getSQLWhere();

    protected abstract void setParameters(PreparedStatement var1, boolean var2) throws SQLException;

    protected void showHistory() {
    }

    protected boolean hasHistory() {
        return false;
    }

    protected boolean hasProcess() {
        return false;
    }

    protected void customize() {
    }

    protected boolean hasCustomize() {
        return false;
    }

    protected boolean hasZoom() {
        return false;
    }

    protected boolean hasNew() {
        return false;
    }

    protected void saveSelectionDetail() {
    }

    protected int getAD_Window_ID(String tableName, boolean isSOTrx) {
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        if (this.m_SO_Window_ID > 0) {
            return this.m_SO_Window_ID;
        }
        MTable table = MTable.get((Properties)Env.getCtx(), (String)tableName);
        if (table != null) {
            this.m_SO_Window_ID = table.getAD_Window_ID();
            this.m_PO_Window_ID = table.getPO_Window_ID();
        }
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        return this.m_SO_Window_ID;
    }

    public void onEvent(Event event) {
        if (event == null) {
            return;
        }
        if (event.getTarget().equals((Object)this.confirmPanel.getButton("Ok"))) {
            this.onOk();
        } else if (event.getTarget() == this.contentPanel && event.getName().equals("onSelect")) {
            this.setStatusSelected();
            SelectEvent selectEvent = (SelectEvent)event;
            if (selectEvent.getReference() != null && selectEvent.getReference() instanceof Listitem) {
                Listitem m_lastOnSelectItem = (Listitem)selectEvent.getReference();
                this.m_lastSelectedIndex = m_lastOnSelectItem.getIndex();
            }
            this.enableButtons();
            if (!this.isLookup()) {
                this.updateRowSelectionOrder();
                this.updateContext(false);
            }
        } else if (event.getTarget() == this.contentPanel && event.getName().equals("onAfterRender")) {
            this.enableButtons();
            this.setFocusToContentPanel();
        } else if (event.getTarget() == this.contentPanel && event.getName().equals("onDoubleClick")) {
            if (event.getClass().equals(MouseEvent.class)) {
                return;
            }
            if (this.contentPanel.isMultiple() && this.m_lastSelectedIndex >= 0 && this.isLookup()) {
                this.contentPanel.setSelectedIndex(this.m_lastSelectedIndex);
                this.model.clearSelection();
                ArrayList<Object> lsSelectedItem = new ArrayList<Object>();
                lsSelectedItem.add(this.model.getElementAt(this.m_lastSelectedIndex));
                this.model.setSelection(lsSelectedItem);
                int m_keyColumnIndex = this.contentPanel.getKeyColumnIndex();
                int i = 0;
                while (i < this.contentPanel.getRowCount()) {
                    Object data = this.contentPanel.getModel().getValueAt(i, m_keyColumnIndex);
                    if (data instanceof IDColumn) {
                        IDColumn dataColumn = (IDColumn)data;
                        if (i == this.m_lastSelectedIndex) {
                            dataColumn.setSelected(true);
                        } else {
                            dataColumn.setSelected(false);
                        }
                    }
                    ++i;
                }
            }
            if (this.isLookup() || this.hasZoom()) {
                this.onDoubleClick();
                this.contentPanel.repaint();
                this.m_lastSelectedIndex = -1;
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Refresh"))) {
            this.recordSelectedData.clear();
            this.setStatusSelected();
            this.onUserQuery();
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Cancel"))) {
            this.onCancel();
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Reset"))) {
            this.recordSelectedData.clear();
            this.resetParameters();
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("History"))) {
            if (!this.contentPanel.getChildren().isEmpty() && this.contentPanel.getSelectedRowKey() != null) {
                this.showHistory();
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Customize"))) {
            if (!this.contentPanel.getChildren().isEmpty() && this.contentPanel.getSelectedRowKey() != null) {
                this.customize();
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("Zoom"))) {
            if (!this.contentPanel.getChildren().isEmpty() && this.contentPanel.getSelectedRowKey() != null) {
                this.zoom();
                if (this.isLookup()) {
                    this.detach();
                }
            }
        } else if (event.getTarget().equals((Object)this.confirmPanel.getButton("New"))) {
            this.newRecordAction();
        } else if (event.getTarget().equals((Object)this.btnSelectAll)) {
            Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
            Events.echoEvent((String)ON_SELECT_ALL_RECORDS, (Component)this, null);
        } else if (ON_SELECT_ALL_RECORDS.equals(event.getName())) {
            this.selectAllRecords();
            if (!this.isLookup()) {
                this.updateRowSelectionOrder();
                this.updateContext(false);
            }
        } else if (event.getTarget().equals((Object)this.btnDeSelectAll)) {
            this.deSelectAllRecords();
            if (!this.isLookup()) {
                this.updateRowSelectionOrder();
                this.updateContext(false);
            }
        } else if (ON_RUN_PROCESS.equals(event.getName())) {
            this.runProcess((Integer)event.getData());
        } else if ("onClick".equals(event.getName()) && event.getTarget() != null && event.getTarget() instanceof Menuitem && event.getTarget().getAttribute(PROCESS_ID_KEY) != null) {
            this.preRunProcess((Integer)event.getTarget().getAttribute(PROCESS_ID_KEY));
        } else if (event.getTarget().equals((Object)this.btCbbProcess)) {
            Comboitem cbbSelectedItem = this.cbbProcess.getSelectedItem();
            if (cbbSelectedItem == null || cbbSelectedItem.getValue() == null) {
                return;
            }
            MProcess selectedProcess = (MProcess)cbbSelectedItem.getValue();
            this.preRunProcess(selectedProcess.getAD_Process_ID());
        } else if (this.btProcessList.contains(event.getTarget())) {
            Button btProcess = (Button)event.getTarget();
            Integer processId = (Integer)btProcess.getAttribute(PROCESS_ID_KEY);
            this.preRunProcess(processId);
        } else if (event.getTarget() == this.paging) {
            this.updateListSelected();
            int pgNo = this.paging.getActivePage();
            if (pgNo == this.paging.getPageCount() - 1 && !this.isLoadPageNumber()) {
                this.testCount();
                this.paging.setTotalSize(this.m_count);
                pgNo = this.paging.getActivePage();
            }
            if (this.pageNo != pgNo) {
                this.contentPanel.clearSelection();
                this.pageNo = pgNo;
                int start = this.pageNo * this.pageSize;
                int end = this.getOverIntValue((long)start + (long)this.pageSize, this.extra_max_row);
                if (end >= this.m_count) {
                    end = this.m_count;
                }
                List<Object> subList = this.readLine(start, end);
                this.model = new ListModelTable(subList);
                this.model.setSorter(this);
                this.model.addTableModelListener(this);
                this.model.setMultiple(this.p_multipleSelection);
                this.contentPanel.setData(this.model, null);
                this.restoreSelectedInPage();
            }
            this.autoHideEmptyColumns();
        } else if (!event.getName().equals("onChange")) {
            if (event.getName().equals("onWindowContainerSelectionChanged")) {
                if (this.infoWindow != null) {
                    SessionManager.getAppDesktop().updateHelpContext("I", this.infoWindow.getAD_InfoWindow_ID(), this);
                } else {
                    SessionManager.getAppDesktop().updateHelpContext("H", 0);
                }
            } else if (event.getName().equals("onCtrlKey")) {
                KeyEvent keyEvent = (KeyEvent)event;
                if (LayoutUtils.isReallyVisible((Component)this)) {
                    this.onCtrlKeyEvent(keyEvent);
                }
            } else if (event.getName().equals("onOK")) {
                if (this.m_lookup && this.contentPanel.getSelectedIndex() >= 0) {
                    this.onOk();
                } else if (this.m_infoWindowID == 0 && event.getTarget() instanceof InfoGeneralPanel) {
                    this.onUserQuery();
                }
            } else if (event.getName().equals("onCancel") || event.getTarget().equals(this) && event.getName().equals("onClose")) {
                this.onCancel();
            } else if ("onCloseWindowShortcut".equals(event.getName())) {
                IDesktop desktop = SessionManager.getAppDesktop();
                if (this.p_WindowNo > 0 && desktop.isCloseTabWithShortcut()) {
                    desktop.closeWindow(this.p_WindowNo);
                } else {
                    desktop.setCloseTabWithShortcut(true);
                }
            }
        }
    }

    protected void onCancel() {
        if (this.isUseEscForTabClosing) {
            SessionManager.getAppDesktop().setCloseTabWithShortcut(false);
        }
        this.m_cancel = true;
        this.dispose(false);
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && !keyEvent.isCtrlKey() && keyEvent.isShiftKey()) {
            if (keyEvent.getKeyCode() == 40 && this.contentPanel.getRowCount() > 0) {
                this.contentPanel.setFocus(true);
                this.contentPanel.setSelectedIndex(0);
            }
        } else if (keyEvent.getKeyCode() != 13 && (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 27 && this.isUseEscForTabClosing)) {
            keyEvent.stopPropagation();
            Events.echoEvent((Event)new Event("onCloseWindowShortcut", (Component)this));
        }
    }

    public void onUserQuery() {
        this.recordSelectedData.clear();
        if (Executions.getCurrent().getAttribute(ON_USER_QUERY_ATTR) != null) {
            return;
        }
        Executions.getCurrent().setAttribute(ON_USER_QUERY_ATTR, (Object)Boolean.TRUE);
        if (this.validateParameters()) {
            this.showBusyDialog();
            this.isQueryByUser = true;
            Clients.response((AuResponse)new AuEcho((Component)this, "onQueryCallback", null));
        }
    }

    public boolean validateParameters() {
        return true;
    }

    protected void initParameters() {
    }

    protected void updateSubcontent() {
        this.updateSubcontent(-1);
    }

    protected void updateSubcontent(int targetRow) {
    }

    protected void resetParameters() {
    }

    protected void preRunProcess(Integer processId) {
        this.enableButtons(false);
        Events.echoEvent((String)ON_RUN_PROCESS, (Component)this, (Object)processId);
    }

    protected void runProcess(Object processIdObj) {
        Integer processId = (Integer)processIdObj;
        MProcess m_process = MProcess.get((Properties)Env.getCtx(), (int)processId);
        final ProcessInfo m_pi = new ProcessInfo(m_process.getName(), processId.intValue());
        m_pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        m_pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        MPInstance instance = new MPInstance(Env.getCtx(), processId.intValue(), 0, 0, null);
        instance.saveEx();
        final int pInstanceID = instance.getAD_PInstance_ID();
        m_pi.setAD_PInstance_ID(pInstanceID);
        int adFormID = m_process.getAD_Form_ID();
        if (adFormID != 0) {
            String title = m_process.getName();
            if (title == null || title.length() == 0) {
                title = m_process.getValue();
            }
            DB.createT_SelectionNewNP((int)pInstanceID, this.getSaveKeys(this.getInfoColumnIDFromProcess(processId)), null);
            ADForm form = ADForm.openForm(adFormID, null, m_pi);
            Window.Mode mode = form.getWindowMode();
            form.setAttribute("mode", form.getWindowMode());
            form.setAttribute("insertPosition", "insertNext");
            if (mode == Window.Mode.HIGHLIGHTED || mode == Window.Mode.MODAL) {
                form.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                    }
                });
                form.doHighlighted();
                form.focus();
            } else {
                form.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        InfoPanel.this.updateListSelected();
                        InfoPanel.this.recordSelectedData.clear();
                        Clients.response((AuResponse)new AuEcho((Component)InfoPanel.this, "onQueryCallback", null));
                        InfoPanel.this.onUserQuery();
                    }
                });
                SessionManager.getAppDesktop().showWindow(form);
            }
            return;
        }
        m_pi.setAD_PInstance_ID(pInstanceID);
        m_pi.setAD_InfoWindow_ID(this.infoWindow.getAD_InfoWindow_ID());
        WProcessCtl.process(this.p_WindowNo, m_pi, null, new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                ProcessModalDialog processModalDialog = (ProcessModalDialog)event.getTarget();
                if ("onBeforeRunProcess".equals(event.getName())) {
                    InfoPanel.this.updateListSelected();
                    DB.createT_SelectionNewNP((int)pInstanceID, InfoPanel.this.getSaveKeys(InfoPanel.this.getInfoColumnIDFromProcess(processModalDialog.getAD_Process_ID())), null);
                    InfoPanel.this.saveResultSelection(InfoPanel.this.getInfoColumnIDFromProcess(processModalDialog.getAD_Process_ID()));
                    InfoPanel.this.createT_Selection_InfoWindow(pInstanceID);
                    InfoPanel.this.recordSelectedData.clear();
                } else if ("onWindowClose".equals(event.getName())) {
                    if (InfoPanel.this.getDesktop() == null) {
                        return;
                    }
                    if (processModalDialog.isCancel()) {
                        InfoPanel.this.m_results.clear();
                        InfoPanel.this.enableButtons();
                    } else if (m_pi.isError()) {
                        ProcessInfoDialog.showProcessInfo(m_pi, InfoPanel.this.p_WindowNo, (Component)InfoPanel.this, true);
                        InfoPanel.this.enableButtons();
                    } else if (!m_pi.isError()) {
                        if (InfoPanel.this.isCloseAfterExecutionOfProcess()) {
                            ProcessInfoUtil.setLogFromDB((ProcessInfo)m_pi);
                            ProcessInfoLog[] logs = m_pi.getLogs();
                            if (logs != null && logs.length > 0) {
                                ProcessInfoDialog dialog = ProcessInfoDialog.showProcessInfo(m_pi, InfoPanel.this.p_WindowNo, (Component)InfoPanel.this, false);
                                dialog.addEventListener("onWindowClose", e -> InfoPanel.this.detach());
                            } else {
                                InfoPanel.this.detach();
                            }
                        } else {
                            ProcessInfoDialog.showProcessInfo(m_pi, InfoPanel.this.p_WindowNo, (Component)InfoPanel.this, true);
                            InfoPanel.this.isRequeryByRunSuccessProcess = true;
                            Clients.response((AuResponse)new AuEcho((Component)InfoPanel.this, "onQueryCallback", null));
                        }
                    }
                    InfoPanel.this.recordSelectedData.clear();
                }
            }
        });
    }

    protected void saveResultSelection(int infoColumnId) {
        int m_keyColumnIndex = this.contentPanel.getKeyColumnIndex();
        if (m_keyColumnIndex == -1) {
            return;
        }
        this.m_values = new LinkedHashMap();
        if (this.p_multipleSelection) {
            Map<Object, List<Object>> selectedRow = this.getSelectedRowInfo();
            for (Map.Entry<Object, List<Object>> selectedInfo : selectedRow.entrySet()) {
                Object keyData = selectedInfo.getKey();
                Object kp = null;
                if (infoColumnId > 0) {
                    int dataIndex = this.columnDataIndex.get(infoColumnId) + this.p_layout.length;
                    Object viewIDValue = selectedInfo.getValue().get(dataIndex);
                    kp = keyData instanceof String ? new ValueNamePair((String)keyData, viewIDValue == null ? null : viewIDValue.toString()) : new KeyNamePair(((Integer)keyData).intValue(), viewIDValue == null ? null : viewIDValue.toString());
                } else {
                    kp = keyData instanceof String ? new ValueNamePair((String)keyData, null) : new KeyNamePair(((Integer)keyData).intValue(), null);
                }
                LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
                int col = 0;
                while (col < this.p_layout.length) {
                    values.put(this.p_layout[col].getColumnName(), selectedInfo.getValue().get(col));
                    ++col;
                }
                if (values.size() <= 0) continue;
                this.m_values.put((NamePair)kp, values);
            }
        }
    }

    public void createT_Selection_InfoWindow(int AD_PInstance_ID) {
        MTable table = MTable.get((int)this.infoWindow.getAD_Table_ID());
        StringBuilder insert = new StringBuilder();
        insert.append("INSERT INTO T_Selection_InfoWindow (AD_PINSTANCE_ID, ");
        if (table != null && table.isUUIDKeyTable()) {
            insert.append("T_SELECTION_UU");
        } else {
            insert.append("T_SELECTION_ID");
        }
        insert.append(", COLUMNNAME , VALUE_STRING, VALUE_NUMBER , VALUE_DATE ) VALUES(?,?,?,?,?,?) ");
        for (Map.Entry<NamePair, LinkedHashMap<String, Object>> records : this.m_values.entrySet()) {
            LinkedHashMap<String, Object> fields = records.getValue();
            for (Map.Entry<String, Object> field : fields.entrySet()) {
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(AD_PInstance_ID);
                NamePair key = records.getKey();
                if (key instanceof KeyNamePair) {
                    KeyNamePair knp = (KeyNamePair)key;
                    parameters.add(knp.getKey());
                } else if (key instanceof ValueNamePair) {
                    ValueNamePair vnp = (ValueNamePair)key;
                    parameters.add(vnp.getValue());
                } else {
                    parameters.add(key);
                }
                parameters.add(field.getKey());
                Object data = field.getValue();
                if (data instanceof IDColumn) {
                    id = (IDColumn)data;
                    parameters.add(null);
                    parameters.add(id.getRecord_ID());
                    parameters.add(null);
                } else if (data instanceof UUIDColumn) {
                    id = (UUIDColumn)data;
                    parameters.add(id.getRecord_UU());
                    parameters.add(null);
                    parameters.add(null);
                } else if (data instanceof String) {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                } else if (data instanceof BigDecimal || data instanceof Integer || data instanceof Double) {
                    parameters.add(null);
                    if (data instanceof Double) {
                        value = BigDecimal.valueOf((Double)data);
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                    parameters.add(null);
                } else if (data instanceof Integer) {
                    parameters.add(null);
                    parameters.add((Integer)data);
                    parameters.add(null);
                } else if (data instanceof Timestamp || data instanceof Date) {
                    parameters.add(null);
                    parameters.add(null);
                    if (data instanceof Date) {
                        value = new Timestamp(((Date)data).getTime());
                        parameters.add(value);
                    } else {
                        parameters.add(data);
                    }
                } else if (data instanceof KeyNamePair) {
                    KeyNamePair knpData = (KeyNamePair)data;
                    parameters.add(null);
                    parameters.add(knpData.getKey());
                    parameters.add(null);
                } else if (data instanceof ValueNamePair) {
                    ValueNamePair vnp = (ValueNamePair)data;
                    parameters.add(vnp.getValue());
                    parameters.add(null);
                    parameters.add(null);
                } else {
                    parameters.add(data);
                    parameters.add(null);
                    parameters.add(null);
                }
                DB.executeUpdateEx((String)insert.toString(), (Object[])parameters.toArray(), null);
            }
        }
    }

    protected int getInfoColumnIDFromProcess(int processId) {
        int i = 0;
        while (i < this.infoProcessList.length) {
            if (this.infoProcessList[i].getAD_Process_ID() == processId) {
                return this.infoProcessList[i].getAD_InfoColumn_ID();
            }
            ++i;
        }
        return -1;
    }

    private void showBusyDialog() {
        Clients.showBusy((Component)this, (String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
    }

    private void hideBusyDialog() {
        Clients.clearBusy((Component)this);
    }

    protected void correctHeaderOrderIndicator() {
        ListHead listHead = this.contentPanel.getListHead();
        if (listHead != null) {
            List headers = listHead.getChildren();
            for (Object obj : headers) {
                Listheader header = (Listheader)obj;
                if (header.getColumnIndex() == this.indexOrderColumn) {
                    header.setSortDirection(this.isColumnSortAscending != false ? "ascending" : "descending");
                    continue;
                }
                header.setSortDirection("natural");
            }
        }
    }

    public void onQueryCallback(Event event) {
        try {
            if (event == null) {
                this.m_count = 0;
            } else {
                this.executeQuery();
            }
            this.renderItems();
            this.correctHeaderOrderIndicator();
            if (this.isQueryByUser) {
                this.bindInfoProcess();
                this.recordSelectedData.clear();
                this.isRequeryByRunSuccessProcess = false;
            }
            if (this.isRequeryByRunSuccessProcess) {
                this.syncSelectedAfterRequery();
                this.restoreSelectedInPage();
            }
            this.updateSubcontent();
        }
        finally {
            this.isQueryByUser = false;
            this.hideBusyDialog();
        }
        if (!this.isLookup()) {
            this.updateRowSelectionOrder();
            this.updateContext(true);
        }
    }

    protected void bindInfoProcess() {
    }

    protected void onOk() {
        if (!this.contentPanel.getChildren().isEmpty() && this.getSelectedRowInfo().size() > 0) {
            this.dispose(true);
        }
    }

    protected void onDoubleClick() {
        if (this.isLookup()) {
            this.dispose(true);
        } else {
            this.zoom();
        }
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
        this.enableButtons();
    }

    public void zoom() {
        Object recordId = this.contentPanel.getSelectedRowKey();
        if (recordId == null) {
            return;
        }
        if (this.listeners != null && this.listeners.size() > 0) {
            ValueChangeEvent event = new ValueChangeEvent(this, "zoom", this.contentPanel.getSelectedRowKey(), this.contentPanel.getSelectedRowKey());
            this.fireValueChange(event);
        } else {
            int AD_Table_ID;
            int n = AD_Table_ID = this.infoWindow != null ? this.infoWindow.getAD_Table_ID() : -1;
            if (AD_Table_ID <= 0 && (this.p_keyColumn.endsWith("_ID") || this.p_keyColumn.endsWith("_UU"))) {
                AD_Table_ID = MTable.getTable_ID((String)this.p_keyColumn.substring(0, this.p_keyColumn.length() - 3));
            }
            if (AD_Table_ID > 0) {
                if (recordId instanceof String) {
                    AEnv.zoomUU(AD_Table_ID, (String)recordId);
                } else {
                    AEnv.zoom(AD_Table_ID, (Integer)recordId);
                }
            }
        }
    }

    private void selectAllRecords() {
        try {
            if (this.paging != null) {
                int currentPage = this.paging.getActivePage();
                int pgCnt = this.paging.getPageCount();
                int pgNo = 0;
                while (pgNo <= pgCnt - 1) {
                    if (pgNo != currentPage) {
                        this.setAndLoadActivePage(pgNo);
                    }
                    ++pgNo;
                }
                this.setAndLoadActivePage(currentPage);
            } else {
                this.addAllCurrentContentPanelToSelected();
            }
            this.restoreSelectedInPage();
            this.setStatusSelected();
            this.btnSelectAll.setEnabled(false);
            this.btnDeSelectAll.setEnabled(true);
        }
        finally {
            Clients.clearBusy();
        }
    }

    private void setAndLoadActivePage(int pgNo) {
        this.paging.setActivePage(pgNo);
        this.contentPanel.clearSelection();
        this.pageNo = pgNo;
        int start = this.pageNo * this.pageSize;
        int end = this.getOverIntValue((long)start + (long)this.pageSize, this.extra_max_row);
        if (end >= this.m_count) {
            end = this.m_count;
        }
        List<Object> subList = this.readLine(start, end);
        this.model = new ListModelTable(subList);
        this.model.setSorter(this);
        this.model.addTableModelListener(this);
        this.model.setMultiple(this.p_multipleSelection);
        this.contentPanel.setData(this.model, null);
        this.addAllCurrentContentPanelToSelected();
    }

    private void addAllCurrentContentPanelToSelected() {
        int rowIndex = 0;
        while (rowIndex < this.contentPanel.getModel().getRowCount()) {
            Object keyCandidate = this.getColumnValue(rowIndex);
            List candidateRecord = (List)this.contentPanel.getModel().get(rowIndex);
            if (!this.recordSelectedData.containsKey(keyCandidate)) {
                this.recordSelectedData.put(keyCandidate, candidateRecord);
            }
            ++rowIndex;
        }
    }

    private void deSelectAllRecords() {
        this.recordSelectedData.clear();
        this.restoreSelectedInPage();
        this.setStatusSelected();
        this.btnSelectAll.setEnabled(true);
        this.btnDeSelectAll.setEnabled(false);
    }

    protected void newRecordAction() {
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public void fireValueChange(ValueChangeEvent event) {
        for (ValueChangeListener listener : this.listeners) {
            listener.valueChange(event);
        }
    }

    public void dispose(boolean ok) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("OK=" + ok);
        }
        this.m_ok = ok;
        if (this.isLookup()) {
            this.saveSelection();
        }
        if ("embedded".equals(this.getAttribute("mode"))) {
            SessionManager.getAppDesktop().closeActiveWindow();
        } else if (this.getDesktop() != null) {
            if (this.getChildren().size() > 0) {
                Component[] childs;
                Component[] componentArray = childs = this.getChildren().toArray(new Component[0]);
                int n = childs.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    AEnv.detachInputElement(c);
                    ++n2;
                }
            }
            Executions.schedule((Desktop)this.getDesktop(), e -> this.detach(), (Event)new Event("onAsyncDetach"));
        }
    }

    private void saveWlistBoxColumnWidth(Component comp) {
        if (comp instanceof WListbox) {
            ((WListbox)comp).saveColumnWidth();
        }
        List list = comp.getChildren();
        for (Component child : list) {
            this.saveWlistBoxColumnWidth(child);
        }
    }

    public void sort(Comparator<Object> cmpr, boolean ascending) {
        int col;
        this.updateListSelected();
        WListItemRenderer.ColumnComparator lsc = (WListItemRenderer.ColumnComparator)cmpr;
        this.indexOrderColumn = col = lsc.getColumnIndex();
        this.isColumnSortAscending = ascending;
        String displayColumn = this.p_layout[col].getDisplayColumn();
        this.sqlOrderColumn = !Util.isEmpty((String)displayColumn) ? displayColumn : this.p_layout[col].getColSQL().trim();
        this.m_sqlUserOrder = null;
        if (this.m_useDatabasePaging) {
            this.executeQuery();
        } else {
            Collections.sort(this.line, lsc);
        }
        this.renderItems();
    }

    private MTable getTable(int refValID, String columnName) {
        if (refValID > 0) {
            return MTable.get((Properties)Env.getCtx(), (int)MRefTable.get((Properties)Env.getCtx(), (int)refValID).getAD_Table_ID());
        }
        if (columnName.endsWith("_ID") || columnName.endsWith("_UU")) {
            return MTable.get((Properties)Env.getCtx(), (String)columnName.substring(0, columnName.length() - 3));
        }
        return null;
    }

    public boolean isLookup() {
        return this.m_lookup;
    }

    public void scrollToSelectedRow() {
        ListItem selected;
        if (this.contentPanel != null && this.contentPanel.getSelectedIndex() >= 0 && (selected = this.contentPanel.getItemAtIndex(this.contentPanel.getSelectedIndex())) != null) {
            selected.focus();
        }
    }

    public String getSortDirection(Comparator<Object> cmpr) {
        return "natural";
    }

    public int getWindowNo() {
        return this.p_WindowNo;
    }

    public int getRowCount() {
        return this.contentPanel.getRowCount();
    }

    public Object getFirstRowKey() {
        return this.contentPanel.getFirstRowKey();
    }

    public Object getRowKeyAt(int row) {
        return this.contentPanel.getRowKeyAt(row);
    }

    protected int getCacheStart() {
        return this.cacheStart;
    }

    private void setCacheStart(int cacheStart) {
        this.cacheStart = cacheStart;
    }

    protected int getCacheEnd() {
        return this.cacheEnd;
    }

    protected boolean isUseDatabasePaging() {
        return this.m_useDatabasePaging;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null && !this.isLookup()) {
            if (this.infoWindow != null) {
                SessionManager.getAppDesktop().updateHelpContext("I", this.infoWindow.getAD_InfoWindow_ID(), this);
            } else {
                SessionManager.getAppDesktop().updateHelpContext("H", 0, this);
            }
        }
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        this.addEventListener("onCloseWindowShortcut", this);
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        try {
            this.removeEventListener("onCloseWindowShortcut", this);
            if (SessionManager.getSessionApplication() != null && SessionManager.getSessionApplication().getKeylistener() != null) {
                SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this);
            }
            if (this.getFirstChild() != null) {
                this.saveWlistBoxColumnWidth(this.getFirstChild());
            }
            if (this.registerWindowNo && SessionManager.getAppDesktop() != null) {
                SessionManager.getAppDesktop().unregisterWindow(this.p_WindowNo);
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, e.getMessage(), (Throwable)e);
        }
    }

    public GridField getGridfield() {
        return this.m_gridfield;
    }

    public void setGridfield(GridField m_gridfield) {
        this.m_gridfield = m_gridfield;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public boolean isCloseAfterExecutionOfProcess() {
        return this.m_closeAfterExecutionOfProcess;
    }

    public void setCloseAfterExecutionOfProcess(boolean closeAfterExecutionOfProcess) {
        this.m_closeAfterExecutionOfProcess = closeAfterExecutionOfProcess;
    }

    public void setMultipleSelection(boolean multipleSelection) {
        this.p_multipleSelection = multipleSelection;
        if (this.btnSelectAll != null) {
            this.btnSelectAll.setVisible(multipleSelection);
        }
        if (this.btnDeSelectAll != null) {
            this.btnDeSelectAll.setVisible(multipleSelection);
        }
    }

    public String getStatusLinesWidget() {
        if (this.infoWindow == null) {
            return null;
        }
        MStatusLine[] wls = MStatusLine.getStatusLinesWidget((int)0, (int)0, (int)0, (int)this.infoWindow.getAD_InfoWindow_ID());
        if (wls != null && wls.length > 0) {
            StringBuilder lines = new StringBuilder();
            MStatusLine[] mStatusLineArray = wls;
            int n = wls.length;
            int n2 = 0;
            while (n2 < n) {
                MStatusLine wl = mStatusLineArray[n2];
                String line = wl.parseLine(this.getWindowNo());
                if (line != null) {
                    lines.append(line).append("<br>");
                }
                ++n2;
            }
            if (lines.length() > 0) {
                return lines.toString();
            }
        }
        return null;
    }

    protected void updateRowSelectionOrder() {
        if (this.contentPanel.getModel().size() <= 0) {
            this.m_rowSelectionOrder.clear();
            return;
        }
        if (!this.p_multipleSelection && this.m_lastSelectedIndex >= 0) {
            this.m_rowSelectionOrder.clear();
            List lastSelectedRecord = (List)this.contentPanel.getModel().get(this.m_lastSelectedIndex);
            Object key = lastSelectedRecord.get(0);
            if (key instanceof IDColumn) {
                key = ((IDColumn)key).getRecord_ID();
            }
            this.m_rowSelectionOrder.add(key);
        } else {
            for (Map.Entry<Object, List<Object>> entry : this.getSelectedRowInfo().entrySet()) {
                List<Object> candidateRecord = entry.getValue();
                Object key = candidateRecord.get(0);
                if (key instanceof IDColumn) {
                    key = ((IDColumn)key).getRecord_ID();
                }
                if (this.m_rowSelectionOrder.contains(key)) continue;
                this.m_rowSelectionOrder.add(key);
            }
            Iterator<Object> it = this.m_rowSelectionOrder.iterator();
            while (it.hasNext()) {
                if (this.getSelectedRowInfo().containsKey(it.next())) continue;
                it.remove();
            }
        }
    }

    protected void updateContext(boolean checkQueryCriteria) {
        List<Object> lastSelectedRow = this.getLastSelectedRow();
        if (checkQueryCriteria) {
            for (Map.Entry<String, Object> e : this.paraCtxValues.entrySet()) {
                String columnName = e.getKey();
                Object value = e.getValue();
                this.setContext(columnName, value);
            }
        }
        int i = 0;
        while (i < this.p_layout.length) {
            String columnName = this.p_layout[i].getColumnName();
            Object value = lastSelectedRow != null ? lastSelectedRow.get(i) : null;
            this.setContext(ROW_CTX_VARIABLE_PREFIX + columnName, value);
            ++i;
        }
        this.setContext(ROW_ID_CTX_VARIABLE_NAME, this.getSelectedIDsForCtx());
        if (this.infoWindow != null) {
            SessionManager.getAppDesktop().updateHelpContext("I", this.infoWindow.getAD_InfoWindow_ID(), this);
        } else {
            SessionManager.getAppDesktop().updateHelpContext("H", 0, this);
        }
    }

    protected void setContext(String columnName, Object value) {
        if (value instanceof KeyNamePair) {
            value = ((KeyNamePair)value).getKey();
        } else if (value instanceof IDColumn) {
            value = ((IDColumn)value).getRecord_ID();
        }
        if (value == null) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)columnName, (String)"");
        } else if (value instanceof Boolean) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)columnName, (boolean)((Boolean)value));
        } else if (value instanceof Timestamp) {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)columnName, (Timestamp)((Timestamp)value));
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)columnName, (String)value.toString());
        }
    }

    protected String getSelectedIDsForCtx() {
        Object returnVal = null;
        for (Object key : this.m_rowSelectionOrder) {
            String selectedID = Objects.toString(key);
            returnVal = returnVal == null ? selectedID : (String)returnVal + "," + selectedID;
        }
        return returnVal;
    }

    protected List<Object> getLastSelectedRow() {
        int index = this.m_rowSelectionOrder.size() - 1;
        List<Object> lastSelectedRow = this.m_rowSelectionOrder.size() > 0 ? this.getSelectedRowInfo().get(this.m_rowSelectionOrder.get(index)) : null;
        return lastSelectedRow;
    }

    private void setFocusToContentPanel() {
        if (this.contentPanel.getRowCount() > 0) {
            if (this.p_multipleSelection) {
                ((HtmlBasedComponent)this.contentPanel.getItems().get(0)).focus();
            } else {
                if (this.contentPanel.getSelectedItem() == null) {
                    this.contentPanel.setSelectedIndex(0);
                }
                this.contentPanel.getSelectedItem().focus();
                this.contentPanel.getSelectedItem().setSelected(true);
                LinkedHashSet<ListItem> selectionList = new LinkedHashSet<ListItem>();
                selectionList.add(this.contentPanel.getSelectedItem());
                Events.postEvent((Event)new SelectEvent("onSelect", (Component)this.contentPanel, selectionList));
            }
            this.setStatusSelected();
            this.m_lastSelectedIndex = 0;
        }
    }
}

