/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.jaxrs.provider.xmlbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.jaxrs.provider.xmlbeans.XMLBeanStreamSerializer;
import org.apache.cxf.jaxrs.provider.xmlbeans.XMLBeansElementProvider;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;
import org.idempiere.jettison.mapped.CustomMappedNamespaceConvention;
import org.idempiere.jettison.mapped.MappedXMLInputFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class XMLBeansJSONProvider
extends XMLBeansElementProvider {
    private static final String AD_INTERFACE_1_0_NAMESPACE = "http://idempiere.org/ADInterface/1_0";

    public XmlObject readFrom(Class<XmlObject> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        XmlObject result = null;
        try {
            HashMap<String, String> nstojns = new HashMap<String, String>();
            nstojns.put(AD_INTERFACE_1_0_NAMESPACE, "");
            Configuration conf = new Configuration(nstojns);
            conf.setIgnoreNamespaces(false);
            CustomMappedNamespaceConvention convention = new CustomMappedNamespaceConvention(conf);
            convention.addNamespacePrefix("i", AD_INTERFACE_1_0_NAMESPACE);
            MappedXMLInputFactory factory = new MappedXMLInputFactory(convention);
            XMLStreamReader xsr = factory.createXMLStreamReader(is);
            result = this.parseXmlBean(type, xsr);
            xsr.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebApplicationException(500);
        }
        return result;
    }

    protected XmlObject parseXmlBean(Class<?> type, XMLStreamReader xsr) {
        XmlObject result = null;
        Class<?> factory = this.getFactory(type);
        try {
            Method m = factory.getMethod("parse", XMLStreamReader.class);
            Object[] args = new Object[]{xsr};
            Object obj = m.invoke(type, args);
            if (obj instanceof XmlObject) {
                result = (XmlObject)obj;
            }
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return result;
    }

    private Class<?> getFactory(Class<?> type) {
        Class<?>[] declared;
        Class<?> result = null;
        Class<?>[] classArray = declared = type.getDeclaredClasses();
        int n = declared.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c.getSimpleName().equals("Factory")) {
                result = c;
            }
            ++n2;
        }
        if (result == null) {
            Class<?>[] interfaces;
            Class<?>[] classArray2 = interfaces = type.getInterfaces();
            int n3 = interfaces.length;
            n = 0;
            while (n < n3) {
                Class<?> inter = classArray2[n];
                Class<?>[] classArray3 = declared = inter.getDeclaredClasses();
                int n4 = declared.length;
                int n5 = 0;
                while (n5 < n4) {
                    Class<?> c = classArray3[n5];
                    if (c.getSimpleName().equals("Factory")) {
                        result = c;
                    }
                    ++n5;
                }
                ++n;
            }
        }
        return result;
    }

    public void writeTo(XmlObject obj, Class<?> cls, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) {
        try {
            HashMap nstojns = new HashMap();
            Configuration conf = new Configuration(nstojns);
            conf.setIgnoreNamespaces(true);
            MappedXMLOutputFactory factory = new MappedXMLOutputFactory(conf);
            XMLStreamWriter xsw = factory.createXMLStreamWriter(os);
            xsw.writeStartDocument();
            if (obj instanceof XmlObject) {
                XmlObject xObj = obj;
                XMLBeanStreamSerializer ser = new XMLBeanStreamSerializer();
                ser.serialize(xObj, xsw);
            }
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebApplicationException(500);
        }
        catch (IOException iOException) {
            throw new WebApplicationException(500);
        }
    }
}

