/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.Vector;
import org.compiere.grid.CreateFromRMA;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTableImpl;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateFromRMAFormTest
extends AbstractTestCase {
    @Test
    public void testCreateFromShipmentLine() {
        MOrder order = new MOrder(Env.getCtx(), 0, this.getTrxName());
        order.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.PATIO.id));
        order.setC_DocTypeTarget_ID(DictionaryIDs.C_DocType.PURCHASE_ORDER.id);
        order.setIsSOTrx(false);
        order.setSalesRep_ID(DictionaryIDs.AD_User.GARDEN_ADMIN.id);
        order.setDocStatus("DR");
        order.setDocAction("CO");
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        order.setDateOrdered(today);
        order.setDatePromised(today);
        order.saveEx();
        MOrderLine orderLine = new MOrderLine(order);
        orderLine.setLine(10);
        orderLine.setProduct(MProduct.get((Properties)Env.getCtx(), (int)DictionaryIDs.M_Product.HOLLY_BUSH.id));
        orderLine.setQty(new BigDecimal("1"));
        orderLine.setDatePromised(today);
        orderLine.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)order, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        order.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)order.getDocStatus());
        MInOut receipt = new MInOut(order, DictionaryIDs.C_DocType.MM_RECEIPT.id, order.getDateOrdered());
        receipt.setDocStatus("DR");
        receipt.setDocAction("CO");
        receipt.saveEx();
        MInOutLine receiptLine = new MInOutLine(receipt);
        receiptLine.setOrderLine(orderLine, 0, new BigDecimal("1"));
        receiptLine.setQty(new BigDecimal("1"));
        receiptLine.saveEx();
        info = MWorkflow.runDocumentActionWorkflow((PO)receipt, (String)"CO");
        Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        receipt.load(this.getTrxName(), new String[0]);
        Assertions.assertEquals((Object)"CO", (Object)receipt.getDocStatus());
        MRMA rma = new MRMA(Env.getCtx(), 0, this.getTrxName());
        rma.setM_InOut_ID(receipt.getM_InOut_ID());
        rma.setC_BPartner_ID(receipt.getC_BPartner_ID());
        rma.setC_Currency_ID(order.getC_Currency_ID());
        rma.setIsSOTrx(false);
        rma.setName("testVendorRMA");
        rma.setC_DocType_ID(DictionaryIDs.C_DocType.VENDOR_RETURN_MATERIAL.id);
        rma.setSalesRep_ID(order.getSalesRep_ID());
        rma.setM_RMAType_ID(DictionaryIDs.M_RMAType.DAMAGE_ON_ARRIVAL.id);
        rma.saveEx();
        GridWindow gridWindow = GridWindow.get((Properties)Env.getCtx(), (int)1, (int)53099);
        Assertions.assertNotNull((Object)gridWindow, (String)"Failed to load grid window of Vendor RMA");
        gridWindow.initTab(0);
        GridTab gridTab = gridWindow.getTab(0);
        MQuery query = new MQuery("M_RMA");
        query.addRestriction("M_RMA_ID", "=", rma.get_ID());
        gridTab.setQuery(query);
        gridTab.getTableModel().setImportingMode(false, this.getTrxName());
        gridTab.query(false);
        Assertions.assertEquals((int)1, (int)gridTab.getRowCount(), (String)"Unexpected number of row retrieve from DB");
        Assertions.assertEquals((int)rma.get_ID(), (int)gridTab.getRecord_ID(), (String)"Wrong RMA record id");
        CreateFromRMAImpl form = new CreateFromRMAImpl(gridTab);
        form.setTrxName(this.getTrxName());
        form.loadShipmentLines();
        Assertions.assertTrue((form.minitable.getRowCount() > 0 ? 1 : 0) != 0, (String)"Failed to load data from DB");
        form.minitable.setSelectedRow(-1);
        int i = 0;
        while (i < form.minitable.getRowCount()) {
            KeyNamePair pp = (KeyNamePair)form.minitable.getValueAt(i, 1);
            if (pp.getKey() == receiptLine.get_ID()) {
                form.minitable.setValueAt((Object)Boolean.TRUE, i, 0);
                form.minitable.setSelectedRow(i);
                break;
            }
            ++i;
        }
        Assertions.assertTrue((form.minitable.getSelectedRow() >= 0 ? 1 : 0) != 0, (String)"Failed to find receipt line record");
        Assertions.assertTrue((boolean)form.save((IMiniTable)form.minitable, this.getTrxName()), (String)"Failed to save changes");
        rma.load(this.getTrxName(), new String[0]);
        MRMALine[] rmaLines = rma.getLines(true);
        Assertions.assertEquals((int)1, (int)rmaLines.length, (String)"Unexpected number of RMA Line records");
        Assertions.assertEquals((int)receiptLine.get_ID(), (int)rmaLines[0].getM_InOutLine_ID(), (String)"Materia receipt line not match to RMA line");
    }

    private static class CreateFromRMAImpl
    extends CreateFromRMA {
        private MiniTableImpl minitable = null;

        public CreateFromRMAImpl(GridTab mTab) {
            super(mTab);
            try {
                this.dynInit();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        public Object getWindow() {
            return null;
        }

        protected boolean dynInit() throws Exception {
            super.dynInit();
            this.minitable = new MiniTableImpl();
            for (String column : this.getOISColumnNames()) {
                this.minitable.addColumn(column);
            }
            this.configureMiniTable((IMiniTable)this.minitable);
            return true;
        }

        public void loadShipmentLines() {
            Vector datas = super.getRMAData();
            int i = 0;
            while (i < datas.size()) {
                this.minitable.setRowCount(i + 1);
                Vector data = (Vector)datas.get(i);
                int j = 0;
                while (j < data.size()) {
                    this.minitable.setValueAt(data.get(j), i, j);
                    ++j;
                }
                ++i;
            }
        }
    }
}

