/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.zkoss.math.BigDecimals;
import org.zkoss.zk.ui.ArithmeticWrongValueException;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.ObjectPropertyAccess;
import org.zkoss.zk.ui.sys.PropertyAccess;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Decimalbox
extends NumberInputElement {
    public static final int AUTO = -1000000000;
    private int _scale = -1000000000;
    private static Map<String, PropertyAccess> _properties = new HashMap<String, PropertyAccess>(1);

    public Decimalbox() {
        this.setCols(11);
    }

    public Decimalbox(BigDecimal value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public BigDecimal getValue() throws WrongValueException {
        return (BigDecimal)this.getTargetValue();
    }

    public double doubleValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.doubleValue() : 0.0;
    }

    public int intValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.intValue() : 0;
    }

    public long longValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.longValue() : 0L;
    }

    public short shortValue() throws WrongValueException {
        BigDecimal val = this.getValue();
        return val != null ? val.shortValue() : (short)0;
    }

    public void setValue(BigDecimal value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setValue(String str) {
        this.setValue(str == null ? null : new BigDecimal(str));
    }

    public int getScale() {
        return this._scale;
    }

    public void setScale(int scale) {
        if (this._scale != scale) {
            BigDecimal v;
            this._scale = scale;
            this.smartUpdate("scale", scale);
            if (scale != -1000000000 && (v = (BigDecimal)this._value) != null) {
                this.setValue(v);
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-decimalbox" : this._zclass;
    }

    @Override
    protected Object marshall(Object value) {
        return value != null ? ((BigDecimal)value).toPlainString() : value;
    }

    @Override
    protected Object unmarshall(Object value) {
        return value != null ? new BigDecimal((String)value) : value;
    }

    @Override
    public void setRawValue(Object value) {
        if (this._scale != -1000000000 && value != null) {
            value = ((BigDecimal)value).setScale(this._scale, this.getRoundingMode());
        }
        super.setRawValue(value);
    }

    @Override
    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int divscale;
            BigDecimal v = new BigDecimal(val);
            if (this._scale != -1000000000) {
                v = v.setScale(this._scale, this.getRoundingMode());
            }
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            if (divscale > 0) {
                BigDecimal ten = new BigDecimal(10);
                do {
                    v = v.divide(ten, this._scale == -1000000000 ? v.scale() + 1 : this._scale, this.getRoundingMode());
                } while (--divscale > 0);
            }
            return v;
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    @Override
    protected String coerceToString(Object value) {
        try {
            return value != null && this.getFormat() == null ? (value instanceof BigDecimal ? BigDecimals.toLocaleString((BigDecimal)((BigDecimal)value), (Locale)this.getDefaultLocale()) : value.toString()) : this.formatNumber(value, null);
        }
        catch (ArithmeticException ex) {
            throw new ArithmeticWrongValueException((Component)this, ex.getMessage(), (Throwable)ex, value);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._scale != -1000000000) {
            renderer.render("scale", this._scale);
        }
    }

    @Override
    public PropertyAccess getPropertyAccess(String prop) {
        PropertyAccess pa = _properties.get(prop);
        if (pa != null) {
            return pa;
        }
        return super.getPropertyAccess(prop);
    }

    static {
        _properties.put("value", (PropertyAccess)new ObjectPropertyAccess(){

            public void setValue(Component cmp, Object value) {
                if (value instanceof BigDecimal) {
                    ((Decimalbox)cmp).setValue((BigDecimal)value);
                } else if (value instanceof String || value == null) {
                    ((Decimalbox)cmp).setValue((String)value);
                }
            }

            public BigDecimal getValue(Component cmp) {
                return ((Decimalbox)cmp).getValue();
            }
        });
    }
}

