/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Include;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Tabbox;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.impl.LabelImageElement;

public class Tab
extends LabelImageElement {
    private static final Logger log = LoggerFactory.getLogger(Tab.class);
    private boolean _selected;
    private boolean _closable;
    private boolean _disabled;
    private transient Caption _caption;
    private transient Object _value;
    private transient Label _tmpLabel;

    public Tab() {
    }

    public Tab(String label) {
        super(label);
    }

    public Tab(String label, String image) {
        super(label, image);
    }

    public <T> T getValue() {
        return (T)this._value;
    }

    public <T> void setValue(T value) {
        if (!Objects.equals((Object)this._value, value)) {
            this._value = value;
        }
    }

    public Caption getCaption() {
        return this._caption;
    }

    public void setWidth(String width) {
        Tabbox tb = this.getTabbox();
        if (tb != null && tb.isVertical()) {
            throw new UnsupportedOperationException("Set Tabs' width instead");
        }
        super.setWidth(width);
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", this._closable);
        }
    }

    public void onClose() {
        this.close();
    }

    public void close() {
        Tabbox tabbox;
        Tab tab;
        if (this._selected && (tab = this.selectNextTab()) != null) {
            HashSet<Tab> selItems = new HashSet<Tab>(2);
            selItems.add(tab);
            Events.postEvent((Event)new SelectEvent("onSelect", (Component)tab, selItems));
        }
        if ((tabbox = this.getTabbox()) != null && tabbox.getModel() != null) {
            return;
        }
        Tabpanel panel = this.getLinkedPanel();
        this.detach();
        if (panel != null) {
            Component include = panel.getFirstChild();
            if (include instanceof Include) {
                include.detach();
            }
            panel.detach();
        }
    }

    private Tab selectNextTab() {
        Tab tab;
        for (tab = (Tab)this.getNextSibling(); tab != null; tab = (Tab)tab.getNextSibling()) {
            if (tab.isDisabled()) continue;
            tab.setSelected(true);
            return tab;
        }
        for (tab = (Tab)this.getPreviousSibling(); tab != null; tab = (Tab)tab.getPreviousSibling()) {
            if (tab.isDisabled()) continue;
            tab.setSelected(true);
            return tab;
        }
        return null;
    }

    public Tabbox getTabbox() {
        Tabs tabs = (Tabs)this.getParent();
        return tabs != null ? tabs.getTabbox() : null;
    }

    public Tabpanel getLinkedPanel() {
        Tabpanels tabpanels;
        Tabbox tabbox;
        int j = this.getIndex();
        if (j >= 0 && (tabbox = this.getTabbox()) != null && (tabpanels = tabbox.getTabpanels()) != null && tabpanels.getChildren().size() > j) {
            return (Tabpanel)((Object)tabpanels.getChildren().get(j));
        }
        return null;
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        Tabbox tabbox = this.getTabbox();
        if (tabbox != null) {
            if (selected) {
                tabbox.setSelectedTab(this);
            } else if (tabbox.getSelectedTab() == this) {
                tabbox.clearSelectedTab();
                this._selected = false;
            }
        } else if (this._selected != selected) {
            this._selected = selected;
            this.smartUpdate("selected", this._selected);
        }
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public int getIndex() {
        Tabs tabs = (Tabs)this.getParent();
        if (tabs == null) {
            return -1;
        }
        int j = 0;
        Iterator it = tabs.getChildren().iterator();
        while (it.next() != this) {
            ++j;
        }
        return j;
    }

    public String getZclass() {
        return this._zclass == null ? "z-tab" : this._zclass;
    }

    protected boolean isChildable() {
        return true;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + (Object)((Object)this));
            }
            super.beforeChildAdded(child, refChild);
        } else if (child instanceof Label) {
            super.beforeChildAdded(child, refChild);
        } else {
            throw new UiException("Only caption is allowed: " + (Object)((Object)this));
        }
    }

    public void onCreate(Event evt) {
        if (this._tmpLabel != null) {
            this.setLabel(this._tmpLabel.getValue());
            this.removeChild((Component)this._tmpLabel);
        }
        this._tmpLabel = null;
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof Caption) {
            refChild = this.getFirstChild();
            if (super.insertBefore(child, refChild)) {
                this._caption = (Caption)child;
                this.invalidate();
                return true;
            }
            return false;
        }
        if (child instanceof Label) {
            this._tmpLabel = (Label)child;
            log.warn("Please use Tab#setLabel(msg) instead! [" + (Object)((Object)this) + "]");
        }
        return super.insertBefore(child, refChild);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Caption) {
            this._caption = null;
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Tabs)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }

    @Override
    public Object clone() {
        Tab clone = (Tab)((Object)super.clone());
        if (clone._caption != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        for (Object child : this.getChildren()) {
            if (!(child instanceof Caption)) continue;
            this._caption = (Caption)((Object)child);
            break;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            SelectEvent evt;
            Set selItems;
            final Tabbox tabbox = this.getTabbox();
            final LinkedHashSet<Tab> prevSeldItems = new LinkedHashSet<Tab>();
            if (tabbox.getSelectedTab() != null) {
                prevSeldItems.add(tabbox.getSelectedTab());
            }
            if ((selItems = (evt = SelectEvent.getSelectEvent((AuRequest)request, (SelectEvent.SelectedObjectHandler)new SelectEvent.SelectedObjectHandler<Tab>(){

                public Set<Object> getObjects(Set<Tab> items) {
                    if (items == null || items.isEmpty() || tabbox.getModel() == null) {
                        return null;
                    }
                    LinkedHashSet<Object> objs = new LinkedHashSet<Object>();
                    ListModel model = tabbox.getModel();
                    for (Tab i : items) {
                        objs.add(model.getElementAt(i.getIndex()));
                    }
                    return objs;
                }

                public Set<Tab> getPreviousSelectedItems() {
                    return prevSeldItems;
                }

                public Set<Tab> getUnselectedItems() {
                    return this.getPreviousSelectedItems();
                }

                public Set<Object> getPreviousSelectedObjects() {
                    ListModel model = tabbox.getModel();
                    Set<Tab> items = this.getPreviousSelectedItems();
                    if (model == null || items.size() < 1) {
                        return null;
                    }
                    LinkedHashSet<Object> s = new LinkedHashSet<Object>();
                    s.add(model.getElementAt(items.iterator().next().getIndex()));
                    return s;
                }

                public Set<Object> getUnselectedObjects() {
                    return this.getPreviousSelectedObjects();
                }
            })).getSelectedItems()) == null || selItems.size() != 1) {
                throw new UiException("Exactly one selected tab is required: " + selItems);
            }
            if (tabbox != null) {
                tabbox.selectTabDirectly((Tab)((Object)selItems.iterator().next()), true);
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._disabled) {
            this.render(renderer, "disabled", this._disabled);
        }
        if (this._selected) {
            this.render(renderer, "selected", this._selected);
        }
        if (this._closable) {
            this.render(renderer, "closable", this._closable);
        }
    }

    static {
        Tab.addClientEvent(Tab.class, (String)"onClose", (int)0);
        Tab.addClientEvent(Tab.class, (String)"onSelect", (int)1);
    }
}

