/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Map;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.MouseEvent;

public class DropEvent
extends MouseEvent {
    private final Component _dragged;

    public static DropEvent getDropEvent(AuRequest request) {
        Map<String, Object> data = request.getData();
        int keys = AuRequests.parseKeys(data);
        String draggedUuid = (String)data.get("dragged");
        Desktop desktop = request.getDesktop();
        Component dragged = "true".equals(Library.getProperty((String)"org.zkoss.zul.drop.allowNullDragged")) ? desktop.getComponentByUuidIfAny(draggedUuid) : desktop.getComponentByUuid(draggedUuid);
        return new DropEvent(request.getCommand(), request.getComponent(), dragged, AuRequests.getInt(data, "x", 0), AuRequests.getInt(data, "y", 0), AuRequests.getInt(data, "pageX", 0), AuRequests.getInt(data, "pageY", 0), keys);
    }

    public DropEvent(String name, Component target, Component dragged, int x, int y, int pageX, int pageY, int keys) {
        super(name, target, x, y, pageX, pageY, keys);
        this._dragged = dragged;
    }

    public final Component getDragged() {
        return this._dragged;
    }

    @Override
    public String getArea() {
        return null;
    }
}

