/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Files;
import org.zkoss.util.Cleanups;
import org.zkoss.util.Utils;
import org.zkoss.zk.au.AuDecoder;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.SimpleSessionCache;
import org.zkoss.zk.ui.http.SimpleUiFactory;
import org.zkoss.zk.ui.impl.SessionDesktopCacheProvider;
import org.zkoss.zk.ui.impl.UiEngineImpl;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCacheProvider;
import org.zkoss.zk.ui.sys.FailoverManager;
import org.zkoss.zk.ui.sys.IdGenerator;
import org.zkoss.zk.ui.sys.SessionCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;

public abstract class AbstractWebApp
implements WebApp,
WebAppCtrl {
    private static final Logger log = LoggerFactory.getLogger(AbstractWebApp.class);
    private String _appnm;
    private Configuration _config;
    private UiEngine _engine;
    private DesktopCacheProvider _provider;
    private UiFactory _factory;
    private FailoverManager _failover;
    private IdGenerator _idgen;
    private SessionCache _sesscache;
    private AuDecoder _audec;
    private static String _build;

    protected AbstractWebApp() {
    }

    @Override
    public String getAppName() {
        return this._appnm != null ? this._appnm : "ZK";
    }

    @Override
    public void setAppName(String name) {
        this._appnm = name != null ? name : "";
    }

    @Override
    public final String getVersion() {
        return "9.6.4";
    }

    @Override
    public String getBuild() {
        return AbstractWebApp.getBuildStamp();
    }

    public static final String getBuildStamp() {
        return _build == null ? AbstractWebApp.loadBuild() : _build;
    }

    @Override
    public int getSubversion(int portion) {
        return Utils.getSubversion((String)this.getVersion(), (int)portion);
    }

    @Override
    public final Configuration getConfiguration() {
        return this._config;
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        return this.getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        return this.hasAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        return this.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        return this.removeAttribute(name);
    }

    @Override
    public void init(Object context, Configuration config) {
        if (this._config != null) {
            throw new IllegalStateException("Cannot be initialized twice");
        }
        if (config == null) {
            throw new IllegalArgumentException("null");
        }
        WebApp oldwapp = config.getWebApp();
        if (oldwapp != null && oldwapp != this) {
            throw new IllegalArgumentException("config already belongs to other Web app, " + oldwapp);
        }
        this._config = config;
        if (this._appnm == null) {
            this._appnm = this._config.getPreference("org.zkoss.zk.ui.WebApp.name", "ZK");
        }
        this._config.setWebApp(this);
        Class<?> cls = this._config.getUiEngineClass();
        if (cls == null) {
            this._engine = new UiEngineImpl();
        } else {
            try {
                this._engine = (UiEngine)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getDesktopCacheProviderClass();
        if (cls == null) {
            this._provider = new SessionDesktopCacheProvider();
        } else {
            try {
                this._provider = (DesktopCacheProvider)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getUiFactoryClass();
        if (cls == null) {
            this._factory = new SimpleUiFactory();
        } else {
            try {
                this._factory = (UiFactory)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getFailoverManagerClass();
        if (cls != null) {
            try {
                this._failover = (FailoverManager)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        if ((cls = this._config.getIdGeneratorClass()) != null) {
            try {
                this._idgen = (IdGenerator)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        if ((cls = this._config.getSessionCacheClass()) == null) {
            this._sesscache = new SimpleSessionCache();
        } else {
            try {
                this._sesscache = (SessionCache)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        cls = this._config.getAuDecoderClass();
        if (cls != null) {
            try {
                this._audec = (AuDecoder)cls.newInstance();
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        }
        this._engine.start(this);
        this._provider.start(this);
        this._factory.start(this);
        if (this._failover != null) {
            this._failover.start(this);
        }
        this._sesscache.init(this);
        this._config.invokeWebAppInits();
    }

    @Override
    public void destroy() {
        try {
            this._config.invokeWebAppCleanups();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this._config.detroyRichlets();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this._sesscache.destroy(this);
        }
        catch (NoClassDefFoundError ex) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this._factory.stop(this);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this._provider.stop(this);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            this._engine.stop(this);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        if (this._failover != null) {
            try {
                this._failover.stop(this);
            }
            catch (NoClassDefFoundError ex) {
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this._failover = null;
        }
        this._factory = null;
        this._engine = null;
        this._sesscache = null;
        try {
            Cleanups.cleanup();
        }
        catch (NoClassDefFoundError ex) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public final UiEngine getUiEngine() {
        return this._engine;
    }

    @Override
    public void setUiEngine(UiEngine engine) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this._engine.stop(this);
        this._engine = engine;
        this._engine.start(this);
    }

    @Override
    public DesktopCache getDesktopCache(Session sess) {
        return this._provider.getDesktopCache(sess);
    }

    @Override
    public DesktopCacheProvider getDesktopCacheProvider() {
        return this._provider;
    }

    @Override
    public void setDesktopCacheProvider(DesktopCacheProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        this._provider.stop(this);
        this._provider = provider;
        this._provider.start(this);
    }

    @Override
    public UiFactory getUiFactory() {
        return this._factory;
    }

    @Override
    public void setUiFactory(UiFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException();
        }
        this._factory.stop(this);
        this._factory = factory;
        this._factory.start(this);
    }

    @Override
    public FailoverManager getFailoverManager() {
        return this._failover;
    }

    @Override
    public void setFailoverManager(FailoverManager failover) {
        if (this._failover != null) {
            this._failover.stop(this);
        }
        this._failover = failover;
        if (this._failover != null) {
            this._failover.start(this);
        }
    }

    @Override
    public IdGenerator getIdGenerator() {
        return this._idgen;
    }

    @Override
    public void setIdGenerator(IdGenerator idgen) {
        this._idgen = idgen;
    }

    @Override
    public SessionCache getSessionCache() {
        return this._sesscache;
    }

    @Override
    public void setSessionCache(SessionCache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        this._sesscache.destroy(this);
        this._sesscache = cache;
        this._sesscache.init(this);
    }

    @Override
    public AuDecoder getAuDecoder() {
        return this._audec;
    }

    @Override
    public void setAuDecoder(AuDecoder audec) {
        this._audec = audec;
    }

    @Override
    public void sessionWillPassivate(Session sess) {
        if (this._provider != null) {
            this._provider.sessionWillPassivate(sess);
        }
    }

    @Override
    public void sessionDidActivate(Session sess) {
        this._provider.sessionDidActivate(sess);
    }

    @Override
    public void sessionDestroyed(Session sess) {
        try {
            this.getDesktopCacheProvider().sessionDestroyed(sess);
        }
        catch (Throwable ex) {
            log.warn("Failed to cleanup session", ex);
        }
        try {
            this.getSessionCache().remove(sess);
        }
        catch (Throwable ex) {
            log.warn("Failed to cleanup session", ex);
        }
        try {
            ((SessionCtrl)((Object)sess)).onDestroyed();
        }
        catch (Throwable ex) {
            log.warn("Failed to cleanup session", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String loadBuild() {
        if (_build == null) {
            String FILE = "/metainfo/zk/build";
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = null;
            try {
                Enumeration<URL> en = cl.getResources("/metainfo/zk/build".substring(1));
                while (en.hasMoreElements()) {
                    URL url = en.nextElement();
                    String path = url.getPath();
                    if (path == null || !path.matches(".*/zk(-\\d[^/]*?)?\\.jar\\!?/metainfo/zk/build$")) continue;
                    is = url.openStream();
                    break;
                }
            }
            catch (IOException en) {
                // empty catch block
            }
            if (is == null && (is = AbstractWebApp.class.getResourceAsStream("/metainfo/zk/build")) == null) {
                _build = "";
                return "";
            }
            try {
                _build = new String(Files.readAll((InputStream)is)).trim();
            }
            catch (Exception ex) {
                _build = "error";
            }
            finally {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return _build;
    }
}

