/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zsoup.select;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.zkoss.zsoup.helper.Validate;
import org.zkoss.zsoup.nodes.Element;
import org.zkoss.zsoup.nodes.FormElement;
import org.zkoss.zsoup.select.NodeTraversor;
import org.zkoss.zsoup.select.NodeVisitor;
import org.zkoss.zsoup.select.Selector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elements
implements List<Element>,
Cloneable {
    private List<Element> contents;

    public Elements() {
        this.contents = new ArrayList<Element>();
    }

    public Elements(int initialCapacity) {
        this.contents = new ArrayList<Element>(initialCapacity);
    }

    public Elements(Collection<Element> elements) {
        this.contents = new ArrayList<Element>(elements);
    }

    public Elements(List<Element> elements) {
        this.contents = elements;
    }

    public Elements(Element ... elements) {
        this(Arrays.asList(elements));
    }

    public Elements clone() {
        Elements clone;
        try {
            clone = (Elements)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Element> elements = new ArrayList<Element>();
        clone.contents = elements;
        for (Element e : this.contents) {
            elements.add(e.clone());
        }
        return clone;
    }

    public String attr(String attributeKey) {
        for (Element element : this.contents) {
            if (!element.hasAttr(attributeKey)) continue;
            return element.attr(attributeKey);
        }
        return "";
    }

    public boolean hasAttr(String attributeKey) {
        for (Element element : this.contents) {
            if (!element.hasAttr(attributeKey)) continue;
            return true;
        }
        return false;
    }

    public Elements attr(String attributeKey, String attributeValue) {
        for (Element element : this.contents) {
            element.attr(attributeKey, attributeValue);
        }
        return this;
    }

    public Elements removeAttr(String attributeKey) {
        for (Element element : this.contents) {
            element.removeAttr(attributeKey);
        }
        return this;
    }

    public Elements addClass(String className) {
        for (Element element : this.contents) {
            element.addClass(className);
        }
        return this;
    }

    public Elements removeClass(String className) {
        for (Element element : this.contents) {
            element.removeClass(className);
        }
        return this;
    }

    public Elements toggleClass(String className) {
        for (Element element : this.contents) {
            element.toggleClass(className);
        }
        return this;
    }

    public boolean hasClass(String className) {
        for (Element element : this.contents) {
            if (!element.hasClass(className)) continue;
            return true;
        }
        return false;
    }

    public String val() {
        if (this.size() > 0) {
            return this.first().val();
        }
        return "";
    }

    public Elements val(String value) {
        for (Element element : this.contents) {
            element.val(value);
        }
        return this;
    }

    public String text() {
        StringBuilder sb = new StringBuilder();
        for (Element element : this.contents) {
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(element.text());
        }
        return sb.toString();
    }

    public boolean hasText() {
        for (Element element : this.contents) {
            if (!element.hasText()) continue;
            return true;
        }
        return false;
    }

    public String html() {
        StringBuilder sb = new StringBuilder();
        for (Element element : this.contents) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element.html());
        }
        return sb.toString();
    }

    public String outerHtml() {
        StringBuilder sb = new StringBuilder();
        for (Element element : this.contents) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element.outerHtml());
        }
        return sb.toString();
    }

    public String toString() {
        return this.outerHtml();
    }

    public Elements tagName(String tagName) {
        for (Element element : this.contents) {
            element.tagName(tagName);
        }
        return this;
    }

    public Elements html(String html) {
        for (Element element : this.contents) {
            element.html(html);
        }
        return this;
    }

    public Elements prepend(String html) {
        for (Element element : this.contents) {
            element.prepend(html);
        }
        return this;
    }

    public Elements append(String html) {
        for (Element element : this.contents) {
            element.append(html);
        }
        return this;
    }

    public Elements before(String html) {
        for (Element element : this.contents) {
            element.before(html);
        }
        return this;
    }

    public Elements after(String html) {
        for (Element element : this.contents) {
            element.after(html);
        }
        return this;
    }

    public Elements wrap(String html) {
        Validate.notEmpty(html);
        for (Element element : this.contents) {
            element.wrap(html);
        }
        return this;
    }

    public Elements unwrap() {
        for (Element element : this.contents) {
            element.unwrap();
        }
        return this;
    }

    public Elements empty() {
        for (Element element : this.contents) {
            element.empty();
        }
        return this;
    }

    public Elements remove() {
        for (Element element : this.contents) {
            element.remove();
        }
        return this;
    }

    public Elements select(String query) {
        return Selector.select(query, this);
    }

    public Elements not(String query) {
        Elements out = Selector.select(query, this);
        return Selector.filterOut(this, out);
    }

    public Elements eq(int index) {
        return this.contents.size() > index ? new Elements(this.get(index)) : new Elements();
    }

    public boolean is(String query) {
        Elements children = this.select(query);
        return !children.isEmpty();
    }

    public Elements parents() {
        LinkedHashSet<Element> combo = new LinkedHashSet<Element>();
        for (Element e : this.contents) {
            combo.addAll(e.parents());
        }
        return new Elements(combo);
    }

    public Element first() {
        return this.contents.isEmpty() ? null : this.contents.get(0);
    }

    public Element last() {
        return this.contents.isEmpty() ? null : this.contents.get(this.contents.size() - 1);
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        Validate.notNull(nodeVisitor);
        NodeTraversor traversor = new NodeTraversor(nodeVisitor);
        for (Element el : this.contents) {
            traversor.traverse(el);
        }
        return this;
    }

    public List<FormElement> forms() {
        ArrayList<FormElement> forms = new ArrayList<FormElement>();
        for (Element el : this.contents) {
            if (!(el instanceof FormElement)) continue;
            forms.add((FormElement)el);
        }
        return forms;
    }

    @Override
    public int size() {
        return this.contents.size();
    }

    @Override
    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    @Override
    public Iterator<Element> iterator() {
        return this.contents.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.contents.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.contents.toArray(a);
    }

    @Override
    public boolean add(Element element) {
        return this.contents.add(element);
    }

    @Override
    public boolean remove(Object o) {
        return this.contents.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.contents.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Element> c) {
        return this.contents.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Element> c) {
        return this.contents.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.contents.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.contents.retainAll(c);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.contents.equals(o);
    }

    @Override
    public int hashCode() {
        return this.contents.hashCode();
    }

    @Override
    public Element get(int index) {
        return this.contents.get(index);
    }

    @Override
    public Element set(int index, Element element) {
        return this.contents.set(index, element);
    }

    @Override
    public void add(int index, Element element) {
        this.contents.add(index, element);
    }

    @Override
    public Element remove(int index) {
        return this.contents.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.contents.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.contents.lastIndexOf(o);
    }

    @Override
    public ListIterator<Element> listIterator() {
        return this.contents.listIterator();
    }

    @Override
    public ListIterator<Element> listIterator(int index) {
        return this.contents.listIterator(index);
    }

    @Override
    public List<Element> subList(int fromIndex, int toIndex) {
        return this.contents.subList(fromIndex, toIndex);
    }
}

