/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.util;

import javax.activation.DataSource;
import org.adempiere.base.IServiceReferenceHolder;
import org.adempiere.base.Service;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.factory.IFeedbackService;
import org.adempiere.webui.session.SessionManager;
import org.compiere.util.ByteArrayDataSource;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.Env;

public class FeedbackManager {
    private static IServiceReferenceHolder<IFeedbackService> s_feedbackServiceReference = null;

    public static DataSource getLogAttachment(boolean errorOnly) {
        String context = CLogErrorBuffer.get((boolean)true).getErrorInfo(Env.getCtx(), errorOnly);
        ClientInfo browserInfo = SessionManager.getAppDesktop().getClientInfo();
        StringBuilder info = new StringBuilder(browserInfo.toString());
        info.append("\r\n").append(context);
        ByteArrayDataSource ds = new ByteArrayDataSource(info.toString(), "UTF-8", "text/plain");
        ds.setName("idempiere-log.txt");
        return ds;
    }

    public static void emailSupport(boolean errorOnly) {
        IFeedbackService service = FeedbackManager.getFeedbackService();
        if (service != null) {
            service.emailSupport(errorOnly);
        }
    }

    public static synchronized IFeedbackService getFeedbackService() {
        IFeedbackService service = null;
        if (s_feedbackServiceReference != null && (service = (IFeedbackService)s_feedbackServiceReference.getService()) != null) {
            return service;
        }
        IServiceReferenceHolder serviceReference = Service.locator().locate(IFeedbackService.class).getServiceReference();
        if (serviceReference != null) {
            service = (IFeedbackService)serviceReference.getService();
            s_feedbackServiceReference = serviceReference;
        }
        return service;
    }

    public static void createNewRequest() {
        IFeedbackService service = FeedbackManager.getFeedbackService();
        if (service != null) {
            service.createNewRequest();
        }
    }
}

