/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.panel.InfoPanel;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.UUIDColumn;
import org.compiere.model.GridField;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MReference;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

public class InfoGeneralPanel
extends InfoPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 624139753237845647L;
    private Textbox txt1;
    private Textbox txt2;
    private Textbox txt3;
    private Textbox txt4;
    private Label lbl1;
    private Label lbl2;
    private Label lbl3;
    private Label lbl4;
    private ColumnInfo[] m_generalLayout;
    private ArrayList<String> m_queryColumns = new ArrayList();
    private ArrayList<String> m_queryColumnsSql = new ArrayList();
    private Borderlayout layout;
    private Vbox southBody;
    private int noOfParameterColumn;

    public InfoGeneralPanel(String queryValue, int windowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause) {
        this(queryValue, windowNo, tableName, keyColumn, multipleSelection, whereClause, true, null);
    }

    public InfoGeneralPanel(String queryValue, int windowNo, String tableName, String keyColumn, boolean multipleSelection, String whereClause, boolean lookup, GridField field) {
        super(windowNo, tableName, keyColumn, multipleSelection, whereClause, lookup, 0, queryValue);
        this.setGridfield(field);
        this.setTitle(Msg.getMsg((Properties)Env.getCtx(), (String)"Info"));
        try {
            this.init();
            this.initComponents();
            this.p_loadedOK = this.initInfo();
            this.processQueryValue();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
            return;
        }
        int no = this.contentPanel.getRowCount();
        this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg((Properties)Env.getCtx(), (String)"SearchRows_EnterQuery"), false);
        this.setStatusDB(Integer.toString(no));
        if (queryValue != null && queryValue.length() > 0) {
            MTable table;
            if (!this.isAutoComplete && (table = MTable.get((Properties)Env.getCtx(), (String)this.p_tableName)).getIdentifierColumns().length > 1 && !this.p_tableName.startsWith("AD_")) {
                String[] values;
                String separator;
                String string = separator = "C_ElementValue".equalsIgnoreCase(this.p_tableName) ? "-" : "_";
                if (this.txt2.isVisible() && (values = queryValue.split("[" + separator + "]")) != null && values.length == 2) {
                    this.txt1.setValue(values[0]);
                    this.txt2.setValue(values[1]);
                }
            }
            this.executeQuery();
            this.renderItems();
        }
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this, this::onClientInfo);
        }
    }

    private void processQueryValue() {
        if (this.queryValue != null && this.queryValue.length() > 0) {
            Textbox[] txts = new Textbox[]{this.txt1, this.txt2, this.txt3, this.txt4};
            int i = 0;
            Textbox[] textboxArray = txts;
            int n = txts.length;
            int n2 = 0;
            while (n2 < n) {
                Textbox t = textboxArray[n2];
                if (t != null && t.isVisible()) {
                    if (!this.isAutoComplete || Util.isEmpty((String)this.autoCompleteSearchColumn) || this.autoCompleteSearchColumn.equals(this.m_queryColumns.get(i))) {
                        t.setValue(this.queryValue);
                        this.testCount();
                        if (this.m_count > 0) break;
                        t.setValue(null);
                        if (this.isAutoComplete) break;
                    }
                } else {
                    ++i;
                }
                ++n2;
            }
            if (this.m_count <= 0 && !this.isAutoComplete) {
                this.txt1.setValue(this.queryValue);
            }
        }
    }

    private void initComponents() {
        Grid grid = GridFactory.newGridLayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)grid, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, "min");
        this.layoutParameterGrid(grid);
        this.layout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.layout, "100%");
        this.layout.setStyle("position: relative");
        this.appendChild((Component)this.layout);
        North north = new North();
        this.layout.appendChild((Component)north);
        north.appendChild((Component)grid);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "min");
        Center center = new Center();
        this.layout.appendChild((Component)center);
        Div div = new Div();
        div.appendChild((Component)this.contentPanel);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.contentPanel, "100%");
        ZKUpdateUtil.setVflex(this.contentPanel, true);
        this.contentPanel.setSizedByContent(true);
        center.appendChild((Component)div);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)center, "1");
        South south = new South();
        this.layout.appendChild((Component)south);
        this.southBody = new Vbox();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.southBody, "100%");
        south.appendChild((Component)this.southBody);
        this.southBody.appendChild((Component)new Separator());
        this.southBody.appendChild((Component)this.confirmPanel);
        this.southBody.appendChild((Component)this.statusBar);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)south, "min");
    }

    protected void layoutParameterGrid(Grid grid) {
        this.noOfParameterColumn = this.getNoOfParameterColumn();
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.lbl1.rightAlign());
        row.appendChild((Component)this.txt1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txt1, "1");
        if (row.getChildren().size() % this.noOfParameterColumn == 0) {
            row = rows.newRow();
        }
        row.appendChild(this.lbl2.rightAlign());
        row.appendChild((Component)this.txt2);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txt2, "1");
        if (row.getChildren().size() % this.noOfParameterColumn == 0) {
            row = rows.newRow();
        }
        Cell cell = new Cell();
        cell.setAlign("right");
        cell.setValign("middle");
        Div ldiv = new Div();
        ldiv.appendChild((Component)this.lbl3);
        cell.appendChild((Component)ldiv);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setValign("middle");
        cell.appendChild((Component)this.txt3);
        row.appendChild((Component)cell);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txt3, "1");
        if (row.getChildren().size() % this.noOfParameterColumn == 0) {
            row = rows.newRow();
        }
        cell = new Cell();
        cell.setAlign("right");
        cell.setValign("middle");
        ldiv = new Div();
        ldiv.appendChild((Component)this.lbl4);
        cell.appendChild((Component)ldiv);
        row.appendChild((Component)cell);
        cell = new Cell();
        cell.setValign("middle");
        cell.appendChild((Component)this.txt4);
        row.appendChild((Component)cell);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.txt4, "1");
    }

    private int getNoOfParameterColumn() {
        if (ClientInfo.maxWidth(499)) {
            return 2;
        }
        if (ClientInfo.maxWidth(699)) {
            return 4;
        }
        if (ClientInfo.maxWidth(999)) {
            return 6;
        }
        return 8;
    }

    private void init() {
        this.txt1 = new Textbox();
        this.txt2 = new Textbox();
        this.txt3 = new Textbox();
        this.txt4 = new Textbox();
        this.txt1.setWidgetAttribute("instanceName", "textbox1");
        this.txt2.setWidgetAttribute("instanceName", "textbox2");
        this.txt3.setWidgetAttribute("instanceName", "textbox3");
        this.txt4.setWidgetAttribute("instanceName", "textbox4");
        this.lbl1 = new Label();
        this.lbl2 = new Label();
        this.lbl3 = new Label();
        this.lbl4 = new Label();
    }

    private boolean initInfo() {
        if (!this.initInfoTable()) {
            return false;
        }
        StringBuilder where = new StringBuilder();
        if (this.m_gridfield != null) {
            MReference ref;
            MReference mReference = ref = this.m_gridfield.getAD_Reference_Value_ID() > 0 ? MReference.get((Properties)Env.getCtx(), (int)this.m_gridfield.getAD_Reference_Value_ID()) : null;
            if (ref == null || !ref.isShowInactiveRecords()) {
                where = new StringBuilder(this.p_tableName).append(".").append("IsActive='Y'");
            }
        }
        if (this.p_whereClause.length() > 0) {
            if (where.length() > 0) {
                where.append(" AND ");
            }
            where.append(" (").append(this.p_whereClause).append(")");
        }
        this.prepareTable(this.m_generalLayout, this.p_tableName, where.toString(), "2");
        this.contentPanel.repaint();
        this.lbl1.setValue(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(0).toString())));
        if (this.m_queryColumns.size() > 1) {
            this.lbl2.setValue(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(1).toString()));
        } else {
            this.lbl2.setVisible(false);
            this.txt2.setVisible(false);
        }
        if (this.m_queryColumns.size() > 2) {
            this.lbl3.setValue(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(2).toString()));
        } else {
            this.lbl3.setVisible(false);
            this.txt3.setVisible(false);
            this.hideCell((Component)this.lbl3);
            this.hideCell((Component)this.txt3);
        }
        if (this.m_queryColumns.size() > 3) {
            this.lbl4.setValue(Msg.translate((Properties)Env.getCtx(), (String)this.m_queryColumns.get(3).toString()));
        } else {
            this.lbl4.setVisible(false);
            this.txt4.setVisible(false);
            this.hideCell((Component)this.lbl4);
            this.hideCell((Component)this.txt4);
        }
        return true;
    }

    private void hideCell(Component comp) {
        Component p = comp.getParent();
        while (p != null) {
            if (p instanceof Cell) {
                p.setVisible(false);
                break;
            }
            p = p.getParent();
        }
    }

    private boolean initInfoTable() {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)this.p_tableName);
        String uucolName = PO.getUUIDColumnName((String)this.p_tableName);
        boolean hasWindowAndTab = new Query(Env.getCtx(), "AD_Tab", " AD_Table_ID = ? ", null).setParameters(new Object[]{table.getAD_Table_ID()}).match();
        Object sqlqc = "SELECT c.ColumnName, t.AD_Table_ID, t.TableName, c.ColumnSql FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID)WHERE c.AD_Reference_ID IN (10,14) AND t.TableName=? ";
        if (hasWindowAndTab) {
            sqlqc = (String)sqlqc + " AND EXISTS (SELECT * FROM AD_Field f  WHERE f.AD_Column_ID=c.AD_Column_ID  AND f.IsDisplayed='Y' AND f.IsEncrypted='N' AND f.ObscureType IS NULL) ";
        }
        sqlqc = (String)sqlqc + " ORDER BY c.IsIdentifier DESC, c.IsSelectionColumn Desc, c.AD_Reference_ID, c.SeqNoSelection, c.SeqNo";
        int AD_Table_ID = 0;
        String tableName = null;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlqc, null);
                pstmt.setString(1, this.p_tableName);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.m_queryColumns.add(rs.getString(1));
                    String columnSql = rs.getString(4);
                    if (columnSql != null && columnSql.length() > 0 && columnSql.contains("@")) {
                        columnSql = "NULL";
                    }
                    if (columnSql != null && columnSql.contains("@")) {
                        columnSql = Env.parseContext((Properties)Env.getCtx(), (int)-1, (String)columnSql, (boolean)false, (boolean)true);
                    }
                    String qualified = this.p_tableName + "." + rs.getString(1);
                    if (columnSql != null && columnSql.length() > 0) {
                        this.m_queryColumnsSql.add(columnSql);
                    } else {
                        this.m_queryColumnsSql.add(qualified);
                    }
                    if (AD_Table_ID != 0) continue;
                    AD_Table_ID = rs.getInt(2);
                    tableName = rs.getString(3);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, (String)sqlqc, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        if (this.m_queryColumns.size() == 0) {
            Dialog.error(this.p_WindowNo, "Error", Msg.getMsg((Properties)Env.getCtx(), (String)"NoQueryColumnsFound"));
            this.log.log(Level.SEVERE, "No query columns found");
            return false;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Table " + tableName + ", ID=" + AD_Table_ID + ", QueryColumns #" + this.m_queryColumns.size());
        }
        while (this.m_queryColumns.size() > 4) {
            this.m_queryColumns.remove(this.m_queryColumns.size() - 1);
            this.m_queryColumnsSql.remove(this.m_queryColumnsSql.size() - 1);
        }
        String title = null;
        if (table.isUUIDKeyTable()) {
            title = Msg.translate((Properties)Env.getCtx(), (String)uucolName);
        } else {
            title = Msg.translate((Properties)Env.getCtx(), (String)(tableName + "_ID"));
            if (title.endsWith("_ID")) {
                title = Msg.translate((Properties)Env.getCtx(), tableName);
            }
        }
        this.setTitle(this.getTitle() + " " + title);
        int AD_Window_ID = 0;
        AD_Window_ID = table.getAD_Window_ID() > 0 ? table.getAD_Window_ID() : table.getWindowIDFromMenu();
        ArrayList<ColumnInfo> list = new ArrayList<ColumnInfo>();
        StringBuilder sqlc = new StringBuilder().append("SELECT c.ColumnName, c.AD_Reference_ID, c.IsKey, ");
        if (hasWindowAndTab) {
            sqlc.append(" f.IsDisplayed, ");
        } else {
            sqlc.append(" 'Y', ");
        }
        sqlc.append(" c.AD_Reference_Value_ID, c.ColumnSql, c.AD_Column_ID FROM AD_Column c INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID)");
        if (hasWindowAndTab) {
            sqlc.append(" INNER JOIN AD_Tab tab ON (t.AD_Table_ID=tab.AD_Table_ID) INNER JOIN AD_Field f ON (tab.AD_Tab_ID=f.AD_Tab_ID AND f.AD_Column_ID=c.AD_Column_ID) ");
        }
        sqlc.append("WHERE t.AD_Table_ID=? ");
        if (hasWindowAndTab) {
            sqlc.append(" AND tab.IsSortTab='N'  AND tab.Ad_Tab_ID=(SELECT MIN(mt.AD_Tab_ID) FROM AD_tab mt WHERE mt.AD_Window_ID=? AND mt.AD_Table_ID=t.AD_Table_ID AND mt.IsActive='Y') AND (c.IsKey='Y' OR \t\t(f.IsEncrypted='N' AND f.ObscureType IS NULL))");
        } else {
            sqlc.append(" AND (c.IsKey='Y' \t\t\tOR c.IsIdentifier='Y' \t\t\tOR c.IsParent='Y' \t\t\tOR c.IsSelectionColumn='Y' \t\t\tOR Upper(c.ColumnName) IN ('NAME','VALUE','DESCRIPTION','DOCUMENTNO') \t\t\tOR Upper(c.ColumnName) Like '%_NAME' \t\t\tOR Upper(c.ColumnName) Like '%_Value') ");
        }
        sqlc.append(" AND c.IsActive = 'Y' ORDER BY ");
        if (table.isUUIDKeyTable() || this.p_keyColumn.endsWith("_UU")) {
            sqlc.append("CASE WHEN c.columnname=").append(DB.TO_STRING((String)uucolName)).append("THEN 0 ELSE 1 END");
        } else {
            sqlc.append("c.IsKey DESC");
        }
        if (hasWindowAndTab) {
            sqlc.append(", f.SeqNo");
        }
        try {
            try {
                pstmt = DB.prepareStatement((String)sqlc.toString(), null);
                pstmt.setInt(1, AD_Table_ID);
                if (hasWindowAndTab) {
                    pstmt.setInt(2, AD_Window_ID);
                }
                rs = pstmt.executeQuery();
                boolean keyDefined = false;
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    int displayType = rs.getInt(2);
                    boolean isKey = rs.getString(3).equals("Y");
                    boolean isDisplayed = rs.getString(4).equals("Y");
                    int AD_Reference_Value_ID = rs.getInt(5);
                    Object columnSql = rs.getString(6);
                    if (columnSql != null && ((String)columnSql).length() > 0 && (((String)columnSql).startsWith("@SQL=") || ((String)columnSql).startsWith("@SQLFIND="))) {
                        columnSql = "NULL";
                    }
                    if (columnSql != null && ((String)columnSql).contains("@")) {
                        columnSql = Env.parseContext((Properties)Env.getCtx(), (int)-1, (String)columnSql, (boolean)false, (boolean)true);
                    }
                    if (columnSql == null || ((String)columnSql).length() == 0) {
                        columnSql = tableName + "." + columnName;
                    }
                    int AD_Column_ID = rs.getInt(7);
                    StringBuffer colSql = new StringBuffer((String)columnSql);
                    Class colClass = null;
                    if (isKey && !keyDefined) {
                        colClass = IDColumn.class;
                    } else if (uucolName.equals(columnName) && (table.isUUIDKeyTable() || this.p_keyColumn.endsWith("_UU"))) {
                        colClass = UUIDColumn.class;
                        keyDefined = true;
                    } else if (isDisplayed) {
                        if (displayType == 20) {
                            colClass = Boolean.class;
                        } else if (displayType == 12) {
                            colClass = BigDecimal.class;
                        } else if (displayType == 22 || displayType == 29) {
                            colClass = Double.class;
                        } else if (displayType == 11) {
                            colClass = Integer.class;
                        } else if (displayType == 10 || displayType == 14 || displayType == 34) {
                            colClass = String.class;
                        } else if (DisplayType.isDate((int)displayType)) {
                            colClass = Timestamp.class;
                        } else if (displayType == 17) {
                            colSql = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Ref_List") ? new StringBuffer("(SELECT l.Name FROM AD_Ref_List l WHERE l.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND l.Value=").append((String)columnSql).append(") AS ").append(columnName) : new StringBuffer("(SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND l.AD_Reference_ID=").append(AD_Reference_Value_ID).append(" AND l.Value=").append((String)columnSql).append(" AND t.AD_Language='").append(Env.getAD_Language((Properties)Env.getCtx())).append("') AS ").append(columnName);
                            colClass = String.class;
                        }
                    }
                    if (colClass != null) {
                        list.add(new ColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)columnName), colSql.toString(), colClass, true, columnName));
                        if (!this.log.isLoggable(Level.FINEST)) continue;
                        this.log.finest("Added Column=" + columnName);
                        continue;
                    }
                    if (isDisplayed && DisplayType.isLookup((int)displayType)) {
                        ColumnInfo colInfo = this.createLookupColumnInfo(Msg.translate((Properties)Env.getCtx(), (String)columnName), columnName, displayType, AD_Reference_Value_ID, AD_Column_ID, colSql.toString());
                        if (colInfo != null) {
                            list.add(colInfo);
                            continue;
                        }
                        if (!this.log.isLoggable(Level.FINEST)) continue;
                        this.log.finest("Not Added Column=" + columnName);
                        continue;
                    }
                    if (!this.log.isLoggable(Level.FINEST)) continue;
                    this.log.finest("Not Added Column=" + columnName);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sqlc.toString(), (Throwable)e);
                DB.close((ResultSet)rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return false;
            }
        }
        finally {
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        if (list.size() == 0) {
            Dialog.error(this.p_WindowNo, "Error", "No Info Columns");
            this.log.log(Level.SEVERE, "No Info for AD_Table_ID=" + AD_Table_ID + " - " + sqlc.toString());
            return false;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("InfoColumns #" + list.size());
        }
        this.m_generalLayout = new ColumnInfo[list.size()];
        list.toArray(this.m_generalLayout);
        return true;
    }

    @Override
    public String getSQLWhere() {
        StringBuffer sql = new StringBuffer();
        this.addSQLWhere(sql, 0, this.txt1.getText().toUpperCase());
        this.addSQLWhere(sql, 1, this.txt2.getText().toUpperCase());
        this.addSQLWhere(sql, 2, this.txt3.getText().toUpperCase());
        this.addSQLWhere(sql, 3, this.txt4.getText().toUpperCase());
        return sql.toString();
    }

    private void addSQLWhere(StringBuffer sql, int index, String value) {
        if (!value.equals("") && index < this.m_queryColumns.size()) {
            sql.append(" AND UPPER(").append(this.m_queryColumnsSql.get(index).toString()).append(") LIKE ?");
        }
    }

    private String getSQLText(Textbox f) {
        Object s = f.getText().toUpperCase();
        if (!((String)s).endsWith("%")) {
            s = (String)s + "%";
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("String=" + (String)s);
        }
        return s;
    }

    @Override
    protected void resetParameters() {
        this.txt1.setValue("");
        this.txt2.setValue("");
        this.txt3.setValue("");
        this.txt4.setValue("");
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.txt1.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.txt1));
        }
        if (this.txt2.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.txt2));
        }
        if (this.txt3.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.txt3));
        }
        if (this.txt4.getText().length() > 0) {
            pstmt.setString(index++, this.getSQLText(this.txt4));
        }
    }

    @Override
    protected void insertPagingComponent() {
        this.southBody.insertBefore((Component)this.paging, this.southBody.getFirstChild());
        this.layout.invalidate();
    }

    protected void onClientInfo() {
        int t;
        if (this.layout != null && this.layout.getNorth() != null && this.layout.getNorth().getFirstChild() instanceof Grid && (t = this.getNoOfParameterColumn()) > 0 && this.noOfParameterColumn > 0 && t != this.noOfParameterColumn) {
            Grid grid = (Grid)this.layout.getNorth().getFirstChild();
            grid.getRows().detach();
            this.layoutParameterGrid(grid);
            this.invalidate();
        }
    }

    protected ColumnInfo createLookupColumnInfo(String name, String columnName, int AD_Reference_ID, int AD_Reference_Value_ID, int AD_Column_ID, String columnSql) {
        MTable table = MTable.get((Properties)Env.getCtx(), (String)this.p_tableName);
        MColumn column = table.getColumn(columnName);
        Object embedded = AD_Reference_Value_ID > 0 ? MLookupFactory.getLookup_TableEmbed((Language)Env.getLanguage((Properties)Env.getCtx()), (String)columnName, (String)this.p_tableName, (int)AD_Reference_Value_ID) : (column.isVirtualColumn() ? MLookupFactory.getLookup_TableDirEmbed((Language)Env.getLanguage((Properties)Env.getCtx()), (String)columnName, (String)this.p_tableName, (String)column.getColumnSQL()) : MLookupFactory.getLookup_TableDirEmbed((Language)Env.getLanguage((Properties)Env.getCtx()), (String)columnName, (String)this.p_tableName, (String)columnName));
        if (((String)(embedded = "(" + (String)embedded + ")")).contains("@")) {
            embedded = "NULL";
        }
        ColumnInfo columnInfo = null;
        columnInfo = columnName.endsWith("_ID") && !column.isVirtualColumn() ? new ColumnInfo(name, (String)embedded, KeyNamePair.class, true, false, this.p_tableName + "." + columnName, columnName) : new ColumnInfo(name, (String)embedded, String.class, true, false, null, columnName);
        return columnInfo;
    }
}

