/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.X_AD_ClientInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MClientInfo
extends X_AD_ClientInfo
implements ImmutablePOSupport {
    private static final long serialVersionUID = 4707948832203223893L;
    private static ImmutableIntPOCache<Integer, MClientInfo> s_cache = new ImmutableIntPOCache("AD_ClientInfo", 2, 0, false, 0);
    private static CLogger s_log = CLogger.getCLogger(MClientInfo.class);
    private MAcctSchema m_acctSchema = null;
    private boolean m_createNew = false;

    public static MClientInfo get(int AD_Client_ID) {
        return MClientInfo.get(Env.getCtx(), AD_Client_ID);
    }

    public static MClientInfo get(Properties ctx, int AD_Client_ID) {
        return MClientInfo.get(ctx, AD_Client_ID, null);
    }

    public static MClientInfo get(Properties ctx, int AD_Client_ID, String trxName) {
        MClientInfo info;
        block7: {
            Integer key = AD_Client_ID;
            info = s_cache.get(ctx, key, e -> new MClientInfo(ctx, (MClientInfo)e));
            if (info != null) {
                return info;
            }
            String sql = "SELECT * FROM AD_ClientInfo WHERE AD_Client_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, trxName);
                    pstmt.setInt(1, AD_Client_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        info = new MClientInfo(ctx, rs, trxName);
                        s_cache.put(key, info, e -> new MClientInfo(Env.getCtx(), (MClientInfo)e));
                    }
                }
                catch (SQLException ex) {
                    s_log.log(Level.SEVERE, sql, ex);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return info;
    }

    public static MClientInfo get() {
        return MClientInfo.get(Env.getCtx());
    }

    public static MClientInfo get(Properties ctx) {
        return MClientInfo.get(ctx, Env.getAD_Client_ID(ctx), null);
    }

    public static MClientInfo getCopy(Properties ctx, int AD_Client_ID, String trxName) {
        MClientInfo ci = MClientInfo.get(ctx, AD_Client_ID, trxName);
        if (ci != null) {
            ci = new MClientInfo(ctx, ci, trxName);
        }
        return ci;
    }

    public MClientInfo(Properties ctx, String AD_ClientInfo_UU, String trxName) {
        super(ctx, AD_ClientInfo_UU, trxName);
    }

    public MClientInfo(Properties ctx, int ignored, String trxName) {
        super(ctx, ignored, trxName);
        if (ignored != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MClientInfo(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MClientInfo(MClient client, int AD_Tree_Org_ID, int AD_Tree_BPartner_ID, int AD_Tree_Project_ID, int AD_Tree_SalesRegion_ID, int AD_Tree_Product_ID, int AD_Tree_Campaign_ID, int AD_Tree_Activity_ID, String trxName) {
        super(client.getCtx(), 0, trxName);
        this.setAD_Client_ID(client.getAD_Client_ID());
        this.setAD_Org_ID(0);
        this.setIsDiscountLineAmt(false);
        this.setAD_Tree_Menu_ID(10);
        this.setAD_Tree_Org_ID(AD_Tree_Org_ID);
        this.setAD_Tree_BPartner_ID(AD_Tree_BPartner_ID);
        this.setAD_Tree_Project_ID(AD_Tree_Project_ID);
        this.setAD_Tree_SalesRegion_ID(AD_Tree_SalesRegion_ID);
        this.setAD_Tree_Product_ID(AD_Tree_Product_ID);
        this.setAD_Tree_Campaign_ID(AD_Tree_Campaign_ID);
        this.setAD_Tree_Activity_ID(AD_Tree_Activity_ID);
        this.m_createNew = true;
    }

    public MClientInfo(MClientInfo copy) {
        this(Env.getCtx(), copy);
    }

    public MClientInfo(Properties ctx, MClientInfo copy) {
        this(ctx, copy, null);
    }

    public MClientInfo(Properties ctx, MClientInfo copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
        this.m_acctSchema = copy.m_acctSchema != null ? new MAcctSchema(ctx, copy.m_acctSchema, trxName) : null;
    }

    public MAcctSchema getMAcctSchema1() {
        if (this.m_acctSchema == null && this.getC_AcctSchema1_ID() != 0) {
            this.m_acctSchema = new MAcctSchema(this.getCtx(), this.getC_AcctSchema1_ID(), this.get_TrxName());
            if (this.is_Immutable()) {
                this.m_acctSchema.markImmutable();
            }
        }
        return this.m_acctSchema;
    }

    public int getC_Currency_ID() {
        if (this.m_acctSchema == null) {
            this.getMAcctSchema1();
        }
        if (this.m_acctSchema != null) {
            return this.m_acctSchema.getC_Currency_ID();
        }
        return 0;
    }

    @Override
    public boolean save() {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (this.m_createNew) {
            return super.save();
        }
        return this.saveUpdate();
    }

    @Override
    public MClientInfo markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        if (this.m_acctSchema != null) {
            this.m_acctSchema.markImmutable();
        }
        return this;
    }
}

