/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.io.Repeatable;
import org.zkoss.lang.Library;

public class RepeatableInputStream
extends InputStream
implements Repeatable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(RepeatableInputStream.class);
    static final String BUFFER_LIMIT_SIZE = "org.zkoss.io.bufferLimitSize";
    static final String MEMORY_LIMIT_SIZE = "org.zkoss.io.memoryLimitSize";
    private transient InputStream _org;
    private transient OutputStream _out;
    private transient InputStream _in;
    private transient File _f;
    private int _cntsz;
    private final int _bufmaxsz;
    private final int _memmaxsz;
    private boolean _nobuf;

    private RepeatableInputStream(InputStream is) {
        this._org = is;
        this._bufmaxsz = Library.getIntProperty(BUFFER_LIMIT_SIZE, 0x1400000);
        this._memmaxsz = Library.getIntProperty(MEMORY_LIMIT_SIZE, 524288);
    }

    public static InputStream getInstance(InputStream is) {
        if (is instanceof ByteArrayInputStream) {
            return new ResetableInputStream(is);
        }
        if (is != null && !(is instanceof Repeatable)) {
            return new RepeatableInputStream(is);
        }
        return is;
    }

    public static InputStream getInstance(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return new RepeatableFileInputStream(file);
    }

    public static InputStream getInstance(String filename) throws FileNotFoundException {
        return RepeatableInputStream.getInstance(new File(filename));
    }

    public static InputStream getInstance(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("null");
        }
        return new RepeatableURLInputStream(url);
    }

    private OutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            OutputStream outputStream;
            if (this._nobuf) {
                outputStream = null;
            } else {
                this._out = new ByteArrayOutputStream();
                outputStream = this._out;
            }
            return outputStream;
        }
        if (this._cntsz >= this._bufmaxsz) {
            this.disableBuffering();
            return null;
        }
        if (this._f == null && this._cntsz >= this._memmaxsz) {
            try {
                File f = new File(System.getProperty("java.io.tmpdir"), "zk");
                if (!f.isDirectory()) {
                    f.mkdir();
                }
                this._f = File.createTempFile("zk.io", ".zk.io", f);
                byte[] bs = ((ByteArrayOutputStream)this._out).toByteArray();
                this._out = new BufferedOutputStream(new FileOutputStream(this._f));
                this._out.write(bs);
            }
            catch (Throwable ex) {
                log.warn("Ignored: failed to buffer to a file, " + this._f + "\nCause: " + ex.getMessage());
                this.disableBuffering();
            }
        }
        return this._out;
    }

    private void disableBuffering() {
        this._nobuf = true;
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._out = null;
        }
        if (this._f != null) {
            try {
                this._f.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._f = null;
        }
    }

    @Override
    public int read() throws IOException {
        if (this._org != null) {
            int b = this._org.read();
            if (!this._nobuf && b >= 0) {
                OutputStream out = this.getOutputStream();
                if (out != null) {
                    out.write(b);
                }
                ++this._cntsz;
            }
            return b;
        }
        if (this._in == null) {
            this._in = new BufferedInputStream(new FileInputStream(this._f));
        }
        return this._in.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this._org != null) {
            int realLen = this._org.read(b, off, len);
            if (!this._nobuf && realLen >= 0) {
                OutputStream out = this.getOutputStream();
                if (out != null) {
                    out.write(b, off, realLen);
                }
                this._cntsz += realLen;
            }
            return realLen;
        }
        if (this._in == null) {
            this._in = new BufferedInputStream(new FileInputStream(this._f));
        }
        return this._in.read(b, off, len);
    }

    @Override
    public void close() throws IOException {
        this._cntsz = 0;
        if (this._org != null) {
            this._org.close();
            if (this._out != null) {
                try {
                    this._out.close();
                }
                catch (Throwable ex) {
                    log.warn("Ignored: failed to close the buffer.\nCause: " + ex.getMessage());
                    this.disableBuffering();
                    return;
                }
                if (this._f == null) {
                    this._in = new ByteArrayInputStream(((ByteArrayOutputStream)this._out).toByteArray());
                }
                this._out = null;
                this._org = null;
            }
        } else if (this._in != null) {
            if (this._f != null) {
                this._in.close();
                this._in = null;
            } else {
                this._in.reset();
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        int read;
        s.defaultWriteObject();
        if (this._org != null) {
            while (this.read() != -1) {
            }
        }
        this.close();
        byte[] data = new byte[this._memmaxsz];
        while ((read = this.read(data)) > 0) {
            s.writeInt(read);
            s.write(data, 0, read);
        }
        s.writeInt(0);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int readInt = s.readInt();
        byte[] data = new byte[this._memmaxsz];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while (readInt > 0) {
            int read = s.read(data, 0, readInt);
            out.write(data, 0, read);
            if ((readInt -= read) != 0) continue;
            readInt = s.readInt();
        }
        this._in = new ByteArrayInputStream(out.toByteArray());
    }

    protected void finalize() throws Throwable {
        this.disableBuffering();
        if (this._org != null) {
            this._org.close();
        }
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
        super.finalize();
    }

    private static class RepeatableURLInputStream
    extends InputStream
    implements Repeatable,
    Serializable {
        private final URL _url;
        private InputStream _in;

        RepeatableURLInputStream(URL url) {
            this._url = url;
        }

        @Override
        public int read() throws IOException {
            if (this._in == null) {
                this._in = this._url.openStream();
                if (this._in == null) {
                    throw new FileNotFoundException(this._url.toExternalForm());
                }
                this._in = new BufferedInputStream(this._in);
            }
            return this._in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this._in == null) {
                this._in = this._url.openStream();
                if (this._in == null) {
                    throw new FileNotFoundException(this._url.toExternalForm());
                }
                this._in = new BufferedInputStream(this._in);
            }
            return this._in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this._in != null) {
                this._in.close();
                this._in = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private static class RepeatableFileInputStream
    extends InputStream
    implements Repeatable,
    Serializable {
        private final File _file;
        private InputStream _in;

        RepeatableFileInputStream(File file) {
            this._file = file;
        }

        @Override
        public int read() throws IOException {
            if (this._in == null) {
                this._in = new BufferedInputStream(new FileInputStream(this._file));
            }
            return this._in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this._in == null) {
                this._in = new BufferedInputStream(new FileInputStream(this._file));
            }
            return this._in.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            if (this._in != null) {
                this._in.close();
                this._in = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }

    private static class ResetableInputStream
    extends InputStream
    implements Repeatable,
    Serializable {
        private final InputStream _org;

        ResetableInputStream(InputStream bais) {
            this._org = bais;
        }

        @Override
        public int read() throws IOException {
            return this._org.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this._org.read(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this._org.reset();
        }

        protected void finalize() throws Throwable {
            this._org.close();
            super.finalize();
        }
    }
}

