/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui;

import io.keikai.ui.impl.Focus;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class FriendFocusHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int _focusid;
    private transient WeakHashMap<Object, String> _focusMap = new WeakHashMap(20);
    private Map<String, String> _focusColors = new HashMap<String, String>(20);
    private static final String[] FOCUS_COLORS = new String[]{"#FFC000", "#92D050", "#00B050", "#00B0F0", "#0070C0", "#002060", "#7030A0", "#FFFF00", "#4F81BD", "#F29436", "#9BBB59", "#8064A2", "#4BACC6", "#F79646", "#C00000", "#FF0000", "#0000FF", "#008000", "#9900CC", "#800080", "#800000", "#FF6600", "#CC0099", "#00FFFF"};
    private int _colorIndex = 0;

    public synchronized String nextFocusId() {
        return Integer.toString(++this._focusid & Integer.MAX_VALUE, 32);
    }

    private synchronized String nextFocusColor() {
        String color = FOCUS_COLORS[this._colorIndex++ % FOCUS_COLORS.length];
        return color;
    }

    public synchronized void addFocus(Object focus) {
        if (focus instanceof Focus) {
            String id = ((Focus)focus).getId();
            if (!this._focusMap.containsKey(focus)) {
                String color = this._focusColors.get(id);
                if (color == null) {
                    color = this.nextFocusColor();
                    this._focusColors.put(id, color);
                }
                ((Focus)focus).setColor(color);
            }
            this._focusMap.put(focus, ((Focus)focus).getId());
        } else {
            this._focusMap.put(focus, focus.toString());
        }
    }

    public synchronized void removeFocus(Object focus) {
        this._focusMap.remove(focus);
    }

    public synchronized boolean containsFocus(Object focus) {
        this.syncFocus();
        return this._focusMap.containsKey(focus);
    }

    public synchronized Set<Object> getAllFocus() {
        this.syncFocus();
        return new HashSet<Object>(this._focusMap.keySet());
    }

    private synchronized void syncFocus() {
        Iterator<Object> it = this._focusMap.keySet().iterator();
        while (it.hasNext()) {
            Object focus = it.next();
            if (!(focus instanceof Focus) || !((Focus)focus).isDetached()) continue;
            it.remove();
            this._focusColors.remove(((Focus)focus).getId());
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(new HashMap<Object, String>(this._focusMap));
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Map focusMap = (Map)s.readObject();
        if (focusMap != null) {
            this._focusMap = new WeakHashMap(focusMap);
        }
    }
}

