/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.exception.DatabaseAccessException;
import org.adempiere.pipo2.exception.POSaveFailedException;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.adempiere.pipo2.handler.FieldElementHandler;
import org.compiere.model.MTab;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.model.X_AD_Tab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TabElementHandler
extends AbstractElementHandler {
    private FieldElementHandler fieldHandler = new FieldElementHandler();

    /*
     * Enabled aggressive block sorting
     */
    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        PoFiller filler;
        List notfounds;
        List excludes = this.defaultExcludeList("AD_Tab");
        String entitytype = this.getStringValue(element, "EntityType");
        if (!this.isProcessElement(ctx.ctx, entitytype)) {
            element.skip = true;
            return;
        }
        if (this.isParentDefer(element, "AD_Window")) {
            element.defer = true;
            return;
        }
        MTab mTab = (MTab)this.findPO(ctx, element);
        if (mTab == null) {
            mTab = new MTab(ctx.ctx, 0, this.getTrxName(ctx));
        }
        if ((notfounds = (filler = new PoFiller(ctx, (PO)mTab, element, (AbstractElementHandler)this)).autoFill(excludes)).size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        element.recordId = mTab.get_ID();
        if (!mTab.is_new()) {
            if (!mTab.is_Changed()) return;
        }
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, "AD_Tab", 106);
        String action = null;
        if (!mTab.is_new()) {
            this.backupRecord(ctx, impDetail.getAD_Package_Imp_Detail_ID(), "AD_Tab", (PO)mTab);
            action = "Update";
        } else {
            action = "New";
        }
        if (mTab.save(this.getTrxName(ctx))) {
            this.logImportDetail(ctx, impDetail, 1, mTab.getName(), mTab.get_ID(), action);
            element.recordId = mTab.get_ID();
            return;
        }
        this.logImportDetail(ctx, impDetail, 0, mTab.getName(), mTab.get_ID(), action);
        throw new POSaveFailedException("Failed to save Tab " + mTab.getName());
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        boolean createElement;
        X_AD_Tab m_Tab;
        int AD_Tab_ID;
        PackOut packOut;
        block13: {
            packOut = ctx.packOut;
            AD_Tab_ID = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Tab_ID");
            if (ctx.packOut.isExported("AD_Tab_ID|" + AD_Tab_ID)) {
                return;
            }
            m_Tab = new X_AD_Tab(ctx.ctx, AD_Tab_ID, this.getTrxName(ctx));
            createElement = this.isPackOutElement(ctx, (PO)m_Tab);
            if (createElement) {
                this.verifyPackOutRequirement((PO)m_Tab);
                AttributesImpl atts = new AttributesImpl();
                this.addTypeName(atts, "table");
                document.startElement("", "", "AD_Tab", atts);
                this.createTabBinding(ctx, document, m_Tab);
                packOut.getCtx().ctx.put("Table_Name", "AD_Tab");
                try {
                    new CommonTranslationHandler().packOut(packOut, document, null, m_Tab.get_ID());
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.INFO)) break block13;
                    this.log.info(e.toString());
                }
            }
        }
        String sql = "SELECT AD_Field_ID FROM AD_FIELD WHERE AD_TAB_ID = " + AD_Tab_ID + " ORDER BY SEQNO asc";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName(ctx));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    this.createField(ctx, document, rs.getInt("AD_Field_ID"));
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                throw new DatabaseAccessException("Failed to export window tab", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        if (createElement) {
            document.endElement("", "", "AD_Tab");
        }
        if (m_Tab.getAD_Process_ID() > 0) {
            try {
                ElementHandler handler = packOut.getHandler("AD_Process");
                handler.packOut(packOut, document, null, m_Tab.getAD_Process_ID());
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
    }

    private void createField(PIPOContext ctx, TransformerHandler document, int AD_Field_ID) throws SAXException {
        Env.setContext((Properties)ctx.ctx, (String)"AD_Field_ID", (int)AD_Field_ID);
        this.fieldHandler.create(ctx, document);
        ctx.ctx.remove("AD_Field_ID");
    }

    private void createTabBinding(PIPOContext ctx, TransformerHandler document, X_AD_Tab m_Tab) {
        PoExporter filler = new PoExporter(ctx, document, (PO)m_Tab);
        List excludes = this.defaultExcludeList("AD_Tab");
        if (m_Tab.getAD_Tab_ID() <= 999999) {
            filler.add("AD_Tab_ID", new AttributesImpl());
        }
        filler.export(excludes);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        Env.setContext((Properties)packout.getCtx().ctx, (String)"AD_Tab_ID", (int)recordId);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Tab_ID");
    }
}

