/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.DBException;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PoExporter;
import org.compiere.model.MColumn;
import org.compiere.model.MLanguage;
import org.compiere.model.MTable;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CommonTranslationHandler
extends AbstractElementHandler
implements ElementHandler {
    public static final String CONTEXT_KEY_PARENT_TABLE = "currentParentTableForTranslation";
    public static final String CONTEXT_KEY_PARENT_RECORD_ID = "currentParentTableRecordID_ForTranslation";
    public static final String CONTEXT_KEY_PARENT_RECORD_UU = "currentParentTableRecordUU_ForTranslation";
    private HashMap<String, ArrayList<String>> cacheColumns = new HashMap();

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        if (!this.isHandleTranslations(ctx.ctx)) {
            return;
        }
        if (this.isParentSkip(element, null)) {
            return;
        }
        if (this.isParentDefer(element, null)) {
            element.defer = true;
            return;
        }
        String elementValue = element.getElementValue();
        Object parentID = element.parent.recordId;
        if (parentID instanceof Integer && (Integer)parentID == 0 || parentID instanceof String && Util.isEmpty((String)((String)parentID))) {
            throw new SAXException();
        }
        String language = this.getStringValue(element, "AD_Language");
        MLanguage lang = MLanguage.get((Properties)ctx.ctx, (String)language);
        if (lang == null || !lang.isSystemLanguage()) {
            return;
        }
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(elementValue + " " + this.getStringValue(element, "Name"));
        }
        if (this.isRecordExists(elementValue, parentID, language, ctx)) {
            this.updateTranslation(elementValue, parentID, ctx, element);
        } else {
            this.insertTranslation(elementValue, parentID, ctx, element);
        }
    }

    private boolean isRecordExists(String tableName, Object parentID, String language, PIPOContext ctx) {
        String parentTableName = tableName.substring(0, tableName.length() - 4);
        MTable parentTable = MTable.get((Properties)ctx.ctx, (String)parentTableName);
        StringBuilder sql = new StringBuilder().append("SELECT AD_Client_ID FROM ").append(tableName).append(" WHERE ").append(parentTable.getKeyColumns()[0]).append(" = ? AND AD_Language = ?");
        return DB.getSQLValue((String)this.getTrxName(ctx), (String)sql.toString(), (Object[])new Object[]{parentID, language}) != -1;
    }

    private void insertTranslation(String tableName, Object parentID, PIPOContext ctx, Element element) throws SAXException {
        String parentTableName = tableName.substring(0, tableName.length() - 4);
        MTable parentTable = MTable.get((Properties)ctx.ctx, (String)parentTableName);
        ArrayList<String> columns = this.getTranslatedColumns(ctx, parentTableName);
        StringBuilder sql = new StringBuilder("INSERT INTO ").append(tableName).append(" (").append(parentTable.getKeyColumns()[0]).append(", ").append(" AD_Client_ID, AD_Org_ID, CreatedBy, UpdatedBy, ").append(this.cast(columns)).append(") VALUES ( ?, ?, ?, ?, ? ");
        int i = 0;
        while (i < columns.size()) {
            sql.append(",?");
            ++i;
        }
        sql.append(")");
        CPreparedStatement pstm = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName(ctx));
                pstm.setObject(1, parentID);
                pstm.setInt(2, 0);
                pstm.setInt(3, 0);
                pstm.setInt(4, 0);
                pstm.setInt(5, 0);
                int i2 = 5;
                for (String columnName : columns) {
                    ++i2;
                    String value = this.getStringValue(element, columnName);
                    if (columnName.equalsIgnoreCase("IsActive") || columnName.equalsIgnoreCase("IsTranslated")) {
                        value = "true".equals(value) || "Y".equals(value) ? "Y" : "N";
                    }
                    pstm.setString(i2, value);
                }
                if (pstm.executeUpdate() < 0) {
                    throw new SAXException();
                }
            }
            catch (SQLException e) {
                throw new DBException((Exception)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(pstm);
            throw throwable;
        }
        DB.close((Statement)pstm);
    }

    private void updateTranslation(String tableName, Object parentID, PIPOContext ctx, Element element) throws SAXException {
        String parentTableName = tableName.substring(0, tableName.length() - 4);
        MTable parentTable = MTable.get((Properties)ctx.ctx, (String)parentTableName);
        ArrayList<String> columns = this.getTranslatedColumns(ctx, parentTableName);
        StringBuilder sql = new StringBuilder("UPDATE ").append(tableName).append(" SET ");
        for (String columnName : columns) {
            sql.append(columnName).append("=?,");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" WHERE AD_Language=").append(DB.TO_STRING((String)this.getStringValue(element, "AD_Language"))).append(" AND ").append(parentTable.getKeyColumns()[0]).append("=");
        if (parentID instanceof Integer) {
            sql.append((Integer)parentID);
        } else {
            sql.append(DB.TO_STRING((String)parentID.toString()));
        }
        CPreparedStatement pstm = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName(ctx));
                int i = 0;
                for (String columnName : columns) {
                    String value = this.getStringValue(element, columnName);
                    ++i;
                    if (columnName.equalsIgnoreCase("IsActive") || columnName.equalsIgnoreCase("IsTranslated")) {
                        value = "true".equals(value) || "Y".equals(value) ? "Y" : "N";
                    }
                    pstm.setString(i, value);
                }
                if (pstm.executeUpdate() < 0) {
                    throw new SAXException();
                }
            }
            catch (Exception e) {
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(pstm);
            throw throwable;
        }
        DB.close((Statement)pstm);
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        String parenTableName = Env.getContext((Properties)ctx.ctx, (String)CONTEXT_KEY_PARENT_TABLE);
        int parentRecordID = Env.getContextAsInt((Properties)ctx.ctx, (String)CONTEXT_KEY_PARENT_RECORD_ID);
        String parentRecordUU = Env.getContext((Properties)ctx.ctx, (String)CONTEXT_KEY_PARENT_RECORD_UU);
        this.createTranslationTags(ctx, parenTableName, parentRecordID, parentRecordUU, document);
    }

    private void createTranslationTags(PIPOContext ctx, String parentTableName, int parentRecordID, String parentRecordUU, TransformerHandler document) throws SAXException {
        ArrayList<String> translatedColumns = this.getTranslatedColumns(ctx, parentTableName);
        MTable parentTable = MTable.get((Properties)ctx.ctx, (String)parentTableName);
        StringBuilder sql = new StringBuilder().append("SELECT ").append(this.cast(translatedColumns)).append(" FROM ").append(parentTableName).append("_Trl WHERE ").append(parentTable.getKeyColumns()[0]).append("=?");
        CPreparedStatement pstm = null;
        ResultSet rs = null;
        try {
            try {
                pstm = DB.prepareStatement((String)sql.toString(), (String)this.getTrxName(ctx));
                if (parentTable.isUUIDKeyTable()) {
                    pstm.setString(1, parentRecordUU);
                } else {
                    pstm.setInt(1, parentRecordID);
                }
                rs = pstm.executeQuery();
                String elementName = parentTableName + "_Trl";
                while (rs.next()) {
                    AttributesImpl atts = new AttributesImpl();
                    this.addTypeName(atts, "translation");
                    document.startElement("", "", elementName, atts);
                    this.exportRow(ctx, document, translatedColumns, rs);
                    document.endElement("", "", elementName);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException();
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstm);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstm);
    }

    private void exportRow(PIPOContext ctx, TransformerHandler document, ArrayList<String> columns, ResultSet rs) throws Exception {
        PoExporter af = new PoExporter(ctx, document, null);
        for (String columnName : columns) {
            if (columnName.equalsIgnoreCase("IsActive") || columnName.equalsIgnoreCase("IsTranslated")) {
                af.addBoolean(columnName, rs.getString(columnName).equalsIgnoreCase("Y"), new AttributesImpl());
                continue;
            }
            af.addString(columnName, rs.getString(columnName), new AttributesImpl());
        }
    }

    private ArrayList<String> getTranslatedColumns(PIPOContext ctx, String parentTable) throws SAXException {
        MColumn[] cols;
        ArrayList<String> pipolColumns = this.cacheColumns.get(parentTable);
        if (pipolColumns != null) {
            return pipolColumns;
        }
        ArrayList<String> columns = new ArrayList<String>();
        MTable table = MTable.get((Properties)ctx.ctx, (String)parentTable);
        MColumn[] mColumnArray = cols = table.getColumns(false);
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            MColumn col = mColumnArray[n2];
            if (col.isTranslated()) {
                columns.add(col.getColumnName());
            }
            ++n2;
        }
        columns.add("AD_Language");
        columns.add("IsActive");
        columns.add("IsTranslated");
        this.cacheColumns.put(parentTable, columns);
        return columns;
    }

    private String cast(ArrayList<String> arg) {
        String str = arg.toString();
        return str.substring(1, str.length() - 1);
    }

    private boolean existTranslated(String Name) {
        return MTable.getTable_ID((String)(Name + "_Trl")) > 0;
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        this.packOut(packout, packoutHandler, docHandler, recordId, null);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId, String recordUU) throws Exception {
        if ("Y".equals(packout.getCtx().ctx.getProperty("isHandleTranslations")) && this.existTranslated(packout.getCtx().ctx.getProperty("Table_Name"))) {
            Env.setContext((Properties)packout.getCtx().ctx, (String)CONTEXT_KEY_PARENT_TABLE, (String)packout.getCtx().ctx.getProperty("Table_Name"));
            Env.setContext((Properties)packout.getCtx().ctx, (String)CONTEXT_KEY_PARENT_RECORD_ID, (int)recordId);
            Env.setContext((Properties)packout.getCtx().ctx, (String)CONTEXT_KEY_PARENT_RECORD_UU, (String)recordUU);
            this.create(packout.getCtx(), packoutHandler);
            packout.getCtx().ctx.remove(CONTEXT_KEY_PARENT_TABLE);
            packout.getCtx().ctx.remove(CONTEXT_KEY_PARENT_RECORD_ID);
            packout.getCtx().ctx.remove(CONTEXT_KEY_PARENT_RECORD_UU);
        }
    }
}

