/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2.handler;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.GenericPO;
import org.adempiere.pipo2.AbstractElementHandler;
import org.adempiere.pipo2.Element;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackOut;
import org.adempiere.pipo2.PackoutItem;
import org.adempiere.pipo2.PoExporter;
import org.adempiere.pipo2.PoFiller;
import org.adempiere.pipo2.handler.CommonTranslationHandler;
import org.compiere.model.MColumn;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.X_AD_Package_Imp_Detail;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GenericPOElementHandler
extends AbstractElementHandler {
    private String m_tableName;

    public GenericPOElementHandler() {
    }

    public GenericPOElementHandler(String tableName) {
        this.m_tableName = tableName;
    }

    public void startElement(PIPOContext ctx, Element element) throws SAXException {
        String entityType;
        String tableName = element.getElementValue();
        MTable table = MTable.get((Properties)ctx.ctx, (String)tableName);
        PO po = this.findPO(ctx, element);
        if (po == null) {
            po = table.getPO(0, this.getTrxName(ctx));
        }
        PoFiller filler = new PoFiller(ctx, po, element, (AbstractElementHandler)this);
        List excludes = this.defaultExcludeList(tableName);
        List notfounds = filler.autoFill(excludes);
        int idxet = po.get_ColumnIndex("EntityType");
        if (idxet >= 0 && !this.isProcessElement(ctx.ctx, entityType = (String)po.get_Value(idxet))) {
            if (this.log.isLoggable(Level.INFO)) {
                this.log.info("Generic PO not processed as it's official " + po.toString());
            }
            element.skip = true;
            return;
        }
        if (notfounds.size() > 0) {
            element.defer = true;
            element.unresolved = notfounds.toString();
            return;
        }
        String action = po.is_new() ? "New" : "Update";
        po.saveEx();
        boolean isMultiKey = po.get_KeyColumns().length > 1;
        element.recordId = table.isUUIDKeyTable() || isMultiKey ? po.get_UUID() : Integer.valueOf(po.get_ID());
        X_AD_Package_Imp_Detail impDetail = this.createImportDetail(ctx, element.qName, po.get_TableName(), po.get_Table_ID());
        if (element.recordId instanceof Integer) {
            this.logImportDetail(ctx, impDetail, 1, po.toString(), (Integer)element.recordId, null, action);
        } else if (element.recordId instanceof String) {
            this.logImportDetail(ctx, impDetail, 1, po.toString(), 0, (String)element.recordId, action);
        }
        if ("AD_Window".equals(tableName) || "AD_Process".equals(tableName) || "AD_Role".equals(tableName) || "AD_Form".equals(tableName) || "C_DocType".equals(tableName) || "AD_InfoWindow".equals(tableName)) {
            element.requireRoleAccessUpdate = true;
        }
    }

    public void endElement(PIPOContext ctx, Element element) throws SAXException {
    }

    public void create(PIPOContext ctx, TransformerHandler document) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String sql = Env.getContext((Properties)ctx.ctx, (String)"SQLStatement");
        String[] components = null;
        if (sql.indexOf(";") > 0) {
            components = sql.split("[;]");
            sql = components[0];
        } else {
            components = new String[]{sql};
        }
        int tableId = Env.getContextAsInt((Properties)ctx.ctx, (String)"AD_Table_ID");
        String tableName = MTable.getTableName((Properties)ctx.ctx, (int)tableId);
        List excludes = this.defaultExcludeList(tableName);
        boolean checkExcluded = !sql.toLowerCase().startsWith("select *");
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (Statement stmt = DB.createStatement();){
                sql = MRole.getDefault().addAccessSQL(sql, tableName, true, true);
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    boolean createElement;
                    GenericPO po;
                    block31: {
                        po = new GenericPO(tableName, ctx.ctx, rs, this.getTrxName(ctx));
                        int AD_Client_ID = po.getAD_Client_ID();
                        if (AD_Client_ID != Env.getAD_Client_ID((Properties)ctx.ctx)) continue;
                        createElement = this.isPackOutElement(ctx, (PO)po);
                        if (checkExcluded) {
                            MTable table = MTable.get((Properties)ctx.ctx, (int)tableId);
                            Object[] objectArray = table.getColumns(false);
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                block30: {
                                    MColumn column = objectArray[n2];
                                    try {
                                        rs.findColumn(column.getColumnName());
                                    }
                                    catch (SQLException sQLException) {
                                        if (column.getColumnName().equals("AD_Client_ID") || column.getColumnName().equals("AD_Org_ID")) {
                                            throw new Exception("SQL Statement must include AD_Client_ID and AD_Org_ID");
                                        }
                                        if (excludes.contains(column.getColumnName().toLowerCase())) break block30;
                                        excludes.add(column.getColumnName().toLowerCase());
                                    }
                                }
                                ++n2;
                            }
                            objectArray = po.get_KeyColumns();
                            n = objectArray.length;
                            n2 = 0;
                            while (n2 < n) {
                                MColumn keycol = objectArray[n2];
                                if (excludes.contains(keycol.toLowerCase())) {
                                    throw new Exception("SQL Statement must include key columns");
                                }
                                ++n2;
                            }
                            if (excludes.contains(po.getUUIDColumnName().toLowerCase())) {
                                throw new Exception("SQL Statement must include UUID column");
                            }
                            checkExcluded = false;
                        }
                        if (createElement) {
                            ElementHandler handler;
                            if (!(po.get_KeyColumns() == null || po.get_KeyColumns().length != 1 || po.get_ID() <= 0 && po.get_UUID() == null || "table.genericSingleHandler".equals(ctx.packOut.getCurrentPackoutItem().getType()) || (handler = ctx.packOut.getHandler(po.get_TableName())) == null || handler.getClass().equals(((Object)((Object)this)).getClass()))) {
                                handler.packOut(ctx.packOut, document, ctx.logDocument, po.get_ID(), po.get_UUID());
                                createElement = false;
                            }
                            if (createElement) {
                                this.verifyPackOutRequirement((PO)po);
                                this.addTypeName(atts, "table");
                                document.startElement("", "", tableName, atts);
                                PoExporter filler = new PoExporter(ctx, document, (PO)po);
                                if ("AD_Column".equals(po.get_TableName())) {
                                    filler.addString("IsSyncDatabase", "Y", new AttributesImpl());
                                    excludes.add("IsSyncDatabase");
                                }
                                filler.export(excludes, true);
                                ctx.packOut.getCtx().ctx.put("Table_Name", tableName);
                                try {
                                    new CommonTranslationHandler().packOut(ctx.packOut, document, null, po.get_ID(), po.get_UUID());
                                }
                                catch (Exception e) {
                                    if (!this.log.isLoggable(Level.INFO)) break block31;
                                    this.log.info(e.toString());
                                }
                            }
                        }
                    }
                    int i = 1;
                    while (i < components.length) {
                        String[] tables = components[i].split("[>]");
                        int nameIndex = 0;
                        while (nameIndex < tables.length) {
                            tables[nameIndex] = tables[nameIndex].trim();
                            ++nameIndex;
                        }
                        this.exportDetail(ctx, document, po, tables);
                        ++i;
                    }
                    if (!createElement) continue;
                    document.endElement("", "", tableName);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    private void exportDetail(PIPOContext ctx, TransformerHandler document, GenericPO parent, String[] tables) {
        String mainTable = tables[0];
        AttributesImpl atts = new AttributesImpl();
        MTable table = MTable.get((Properties)ctx.ctx, (String)parent.get_TableName());
        Object keyColumn = table.isUUIDKeyTable() ? PO.getUUIDColumnName((String)parent.get_TableName()) : parent.get_TableName() + "_ID";
        Object sql = "SELECT * FROM " + mainTable + " WHERE " + (String)keyColumn + " = ?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                sql = MRole.getDefault().addAccessSQL((String)sql, mainTable, true, true);
                pstmt = DB.prepareStatement((String)sql, null);
                if (table.isUUIDKeyTable()) {
                    pstmt.setString(1, parent.get_UUID());
                } else {
                    pstmt.setInt(1, parent.get_ID());
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    boolean createElement;
                    GenericPO po;
                    block20: {
                        po = new GenericPO(mainTable, ctx.ctx, rs, this.getTrxName(ctx));
                        int AD_Client_ID = po.getAD_Client_ID();
                        if (AD_Client_ID != Env.getAD_Client_ID((Properties)ctx.ctx)) continue;
                        createElement = this.isPackOutElement(ctx, (PO)po);
                        if (createElement) {
                            ElementHandler handler = ctx.packOut.getHandler(po.get_TableName());
                            if (handler != null && !handler.getClass().equals(((Object)((Object)this)).getClass())) {
                                if (po.get_ID() > 0 && po.get_KeyColumns().length == 1) {
                                    handler.packOut(ctx.packOut, document, ctx.logDocument, po.get_ID(), po.get_UUID());
                                    createElement = false;
                                } else {
                                    String uuid = po.get_ValueAsString(po.getUUIDColumnName());
                                    if (!Util.isEmpty((String)uuid, (boolean)true)) {
                                        handler.packOut(ctx.packOut, document, ctx.logDocument, -1, uuid);
                                        createElement = false;
                                    }
                                }
                            }
                            if (createElement) {
                                this.verifyPackOutRequirement((PO)po);
                                List excludes = this.defaultExcludeList(mainTable);
                                this.addTypeName(atts, "table");
                                document.startElement("", "", mainTable, atts);
                                PoExporter filler = new PoExporter(ctx, document, (PO)po);
                                filler.export(excludes, true);
                                ctx.packOut.getCtx().ctx.put("Table_Name", mainTable);
                                try {
                                    new CommonTranslationHandler().packOut(ctx.packOut, document, null, po.get_ID(), po.get_UUID());
                                }
                                catch (Exception e) {
                                    if (!this.log.isLoggable(Level.INFO)) break block20;
                                    this.log.info(e.toString());
                                }
                            }
                        }
                    }
                    int i = 1;
                    while (i < tables.length) {
                        if (!tables[i].startsWith("+")) {
                            ArrayList<String> detTablesArr = new ArrayList<String>();
                            int j = i;
                            while (j < tables.length) {
                                if (j == i) {
                                    detTablesArr.add(tables[j]);
                                } else {
                                    if (!tables[j].startsWith("+")) break;
                                    detTablesArr.add(tables[j].substring(1));
                                }
                                ++j;
                            }
                            String[] detTables = detTablesArr.toArray(new String[0]);
                            this.exportDetail(ctx, document, po, detTables);
                        }
                        ++i;
                    }
                    if (!createElement) continue;
                    document.endElement("", "", mainTable);
                }
            }
            catch (Exception e) {
                throw new AdempiereException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
    }

    public void packOut(PackOut packout, TransformerHandler packoutHandler, TransformerHandler docHandler, int recordId) throws Exception {
        PackoutItem detail = packout.getCurrentPackoutItem();
        int tableId = 0;
        Object sql = null;
        if (detail.getProperty("AD_Table_ID") != null) {
            tableId = (Integer)detail.getProperty("AD_Table_ID");
            sql = (String)detail.getProperty("SQLStatement");
            if (sql == null) {
                this.m_tableName = MTable.get((Properties)packout.getCtx().ctx, (int)tableId).getTableName();
                sql = "SELECT * FROM " + this.m_tableName;
            }
        } else {
            tableId = MTable.get((Properties)packout.getCtx().ctx, (String)this.m_tableName).getAD_Table_ID();
            sql = "SELECT * FROM " + this.m_tableName + " WHERE " + this.m_tableName + "_ID=" + recordId;
        }
        packout.getCtx().ctx.put("AD_Table_ID", Integer.toString(tableId));
        packout.getCtx().ctx.put("SQLStatement", sql);
        this.create(packout.getCtx(), packoutHandler);
        packout.getCtx().ctx.remove("AD_Table_ID");
        packout.getCtx().ctx.remove("SQLStatement");
    }
}

